/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Period;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.DaysOfWeekEditor;
import com.tridium.eas.ui.widgets.PeriodEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class ReportPeriodEditor
extends PeriodEditor
implements ActionListener {
    protected XpComboBox periodSelector;
    protected DateEditor startEditor;
    protected DateEditor endEditor;
    protected DaysOfWeekEditor daysOfWeek;
    protected boolean editable = true;
    protected Lexicon lex;
    protected GridBagConstraints gbc;

    public ReportPeriodEditor() {
    }

    public ReportPeriodEditor(Lexicon lexicon) {
        this(true, lexicon);
    }

    public ReportPeriodEditor(boolean bl, Lexicon lexicon) {
        this.lex = lexicon;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(gridBagLayout);
        Font font = UIManager.getFont("Table.font");
        font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
        this.periodSelector = new XpComboBox();
        this.periodSelector.setFont(font);
        for (int i = 0; i <= 10; ++i) {
            this.periodSelector.addItem(ReportPeriod.getCustomPeriodName(i, this.lex));
        }
        this.periodSelector.addActionListener(this);
        this.add(this.periodSelector);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.setConstraints(gridBagLayout, 100, 100, 3, 1, 0, 0, this.periodSelector);
        this.startEditor = new DateEditor(this.lex);
        this.startEditor.setAllowFuture(true);
        this.startEditor.setFont(font);
        this.startEditor.addActionListener(this);
        this.add(this.startEditor);
        this.setConstraints(gridBagLayout, 0, 100, 1, 1, 0, 1, this.startEditor);
        JLabel jLabel = new JLabel(this.lex.getText("to"));
        jLabel.setFont(font);
        this.add(jLabel);
        this.setConstraints(gridBagLayout, 0, 100, 1, 1, 1, 1, jLabel);
        this.endEditor = new DateEditor(this.lex);
        this.endEditor.setAllowFuture(true);
        this.endEditor.setFont(font);
        this.endEditor.addActionListener(this);
        this.add(this.endEditor);
        this.setConstraints(gridBagLayout, 100, 100, 1, 1, 2, 1, this.endEditor);
        if (bl) {
            this.gbc.anchor = 10;
            this.gbc.fill = 0;
            this.daysOfWeek = new DaysOfWeekEditor(this.lex);
            this.add(this.daysOfWeek);
            this.setConstraints(gridBagLayout, 100, 100, 3, 1, 0, 2, this.daysOfWeek);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        this.periodSelector.setEnabled(this.editable);
        if (!this.editable) {
            this.periodSelector.setBackground(Color.white);
        }
        this.startEditor.setEditable(this.editable);
        this.endEditor.setEditable(this.editable);
        if (this.daysOfWeek != null) {
            this.daysOfWeek.setEditable(this.editable);
        }
    }

    public Period getValue(boolean bl) {
        int n = this.periodSelector.getSelectedIndex();
        if (n == 0) {
            if (bl) {
                this.validateRange();
            }
            return new ReportPeriod(this.startEditor.getValue(), this.endEditor.getEndValue(), this.getDaysOfWeek(), this.lex);
        }
        if (n == 10 || n == 9) {
            return new ReportPeriod(n, this.startEditor.getValue(), this.endEditor.getValue(), this.getDaysOfWeek(), this.lex);
        }
        return new ReportPeriod(n, this.startEditor.getValue(), this.endEditor.getEndValue(), this.getDaysOfWeek(), this.lex);
    }

    public int getDaysOfWeek() {
        if (this.daysOfWeek == null) {
            return -1;
        }
        return this.daysOfWeek.getValue();
    }

    public void setValue(Period period) {
        ((ReportPeriod)period).applyCustomPeriod(System.currentTimeMillis());
        this.startEditor.setValue(period.getStartTime());
        this.endEditor.setValue(period.getEndTime());
        if (this.daysOfWeek != null) {
            this.daysOfWeek.setValue(period.getDaysOfWeek());
        }
        this.periodSelector.setSelectedIndex(((ReportPeriod)period).getCustomPeriod());
    }

    protected void validateRange() {
        EasLocalTime easLocalTime = this.startEditor.getValue();
        EasLocalTime easLocalTime2 = this.endEditor.getValue();
        EasLocalTime easLocalTime3 = EasLocalTime.getCurrentTime();
        EasLocalTime easLocalTime4 = new EasLocalTime(easLocalTime3.getYear(), easLocalTime3.getMonth(), easLocalTime3.getDay(), 24, 0, 0, 0);
        String string = null;
        if (easLocalTime2.isAfter(easLocalTime3)) {
            if (easLocalTime2.isAfter(easLocalTime4)) {
                string = this.lex.getText("futureEndTime");
            }
            this.endEditor.setValue(easLocalTime3);
            easLocalTime2 = easLocalTime3;
        }
        if (easLocalTime.isAfter(easLocalTime2)) {
            this.startEditor.setValue(easLocalTime2);
            string = this.lex.getText("startAfterEnd");
        }
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(this.lex.getText("dateRangeInvalid"));
            stringBuffer.append(string);
            stringBuffer.append("\n" + this.lex.getText("reportWithPeriod") + " ");
            stringBuffer.append(this.lex.getText("validRange"));
            JOptionPane.showMessageDialog(null, stringBuffer.toString(), this.lex.getText("invalidReportPeriod"), 2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.periodSelector) {
            if (this.periodSelector.getSelectedIndex() == 0) {
                return;
            }
            ReportPeriod reportPeriod = (ReportPeriod)this.getValue();
            reportPeriod.applyCustomPeriod(System.currentTimeMillis());
            this.startEditor.setValue(reportPeriod.getStartTime());
            this.endEditor.setValue(reportPeriod.getEndTime());
        } else if (object instanceof DateEditor) {
            this.periodSelector.setSelectedIndex(0);
            this.startEditor.clearTime();
            this.endEditor.clearTime();
        }
        this.fireActionPerformed();
    }

    public void setConstraints(GridBagLayout gridBagLayout, int n, int n2, int n3, int n4, int n5, int n6, Component component) {
        this.gbc.weightx = n;
        this.gbc.weighty = n2;
        this.gbc.gridwidth = n3;
        this.gbc.gridheight = n4;
        this.gbc.gridx = n5;
        this.gbc.gridy = n6;
        gridBagLayout.setConstraints(component, this.gbc);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        ReportPeriodEditor reportPeriodEditor = new ReportPeriodEditor(null);
        reportPeriodEditor.setBorder(BorderFactory.createTitledBorder("Period"));
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setLayout(new FlowLayout());
        jComponent.add(reportPeriodEditor);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setBounds(300, 300, 300, 300);
        jFrame.setVisible(true);
    }
}

