/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.RcSubtypeComboBox;
import com.tridium.eas.ui.widgets.RcSubtypeTreeComboBox;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.util.Lexicon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RcSubtypeWidget
extends JPanel
implements ActionListener {
    private ArrayList listeners;
    private String actionCommand;
    private RcSubtypeTreeComboBox treeCombo;
    private RcSubtypeComboBox subtypeCombo;
    private CardLayout cards;
    private JPanel panel;
    private JLabel label;
    private CardLayout panelLayout;
    private boolean constrained = false;
    private boolean holdEvents = false;
    protected Lexicon lex;

    public RcSubtypeWidget(ResourceManager resourceManager) {
        this(resourceManager, false);
    }

    public RcSubtypeWidget(ResourceManager resourceManager, Lexicon lexicon) {
        super(false);
        this.lex = lexicon;
        this.cards = new CardLayout();
        this.setLayout(this.cards);
        this.treeCombo = new RcSubtypeTreeComboBox(resourceManager, false, lexicon);
        this.treeCombo.addActionListener(this);
        this.add("tree", this.treeCombo);
        this.subtypeCombo = new RcSubtypeComboBox(false, lexicon);
        this.subtypeCombo.addActionListener(this);
        this.add("combo", this.subtypeCombo);
        this.cards.show(this, "tree");
        this.listeners = new ArrayList();
        this.actionCommand = this.toString();
        this.holdEvents = false;
    }

    public RcSubtypeWidget(ResourceManager resourceManager, boolean bl) {
        super(false);
        this.cards = new CardLayout();
        this.setLayout(this.cards);
        this.treeCombo = new RcSubtypeTreeComboBox(resourceManager, bl, this.lex);
        this.treeCombo.addActionListener(this);
        this.add("tree", this.treeCombo);
        this.subtypeCombo = new RcSubtypeComboBox(bl, this.lex);
        this.subtypeCombo.addActionListener(this);
        this.add("combo", this.subtypeCombo);
        this.cards.show(this, "tree");
        this.listeners = new ArrayList();
        this.actionCommand = this.toString();
        this.holdEvents = false;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    private void fireActionEvent() {
        this.fireActionEvent(new ActionEvent(this, 0, this.actionCommand));
    }

    private void fireActionEvent(ActionEvent actionEvent) {
        if (this.holdEvents) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.holdEvents) {
            return;
        }
        if (!this.constrained && actionEvent.getSource() == this.treeCombo) {
            this.subtypeCombo.setSelectedSubtype(this.treeCombo.getSelectedRcSubtype());
            this.fireActionEvent();
        } else if (this.constrained && actionEvent.getSource() == this.subtypeCombo) {
            this.treeCombo.setSelectedItem(this.subtypeCombo.getSelectedRcSubtype());
            this.fireActionEvent();
        }
        if (this.label != null) {
            this.label.setText(this.getSelectedRcSubtype() == null ? "" : this.getSelectedRcSubtype().toString());
        }
    }

    public void constrainRcType(RcType rcType) {
        boolean bl = this.holdEvents;
        this.holdEvents = true;
        if (rcType != null) {
            this.constrained = true;
            if (this.subtypeCombo.getItemCount() == 0 || rcType != this.subtypeCombo.getRcType()) {
                this.subtypeCombo.setRcType(rcType);
                this.treeCombo.clearSelection();
            }
            this.cards.show(this, "combo");
        }
        this.holdEvents = bl;
    }

    public void setRcSubtypes(RcSubtype[] rcSubtypeArray) {
        if (rcSubtypeArray != null) {
            this.constrained = true;
            this.subtypeCombo.setRcSubtypes(rcSubtypeArray);
            this.cards.show(this, "combo");
        }
    }

    public void setSelection(RcType rcType, RcSubtype rcSubtype) {
        this.treeCombo.setSelection(rcType, rcSubtype);
        this.subtypeCombo.setSelectedSubtype(rcSubtype);
    }

    public void setSelectedRcSubtype(RcSubtype rcSubtype) {
        if (!this.constrained) {
            throw new IllegalStateException("cannot set selected RcSubtype by itself unless type is first constrained using setRcType");
        }
        this.subtypeCombo.setSelectedSubtype(rcSubtype);
    }

    public RcType getSelectedRcType() {
        if (this.constrained) {
            return this.subtypeCombo.getRcType();
        }
        return this.treeCombo.getSelectedRcType();
    }

    public RcSubtype getSelectedRcSubtype() {
        if (this.constrained) {
            return this.subtypeCombo.getSelectedRcSubtype();
        }
        return this.treeCombo.getSelectedRcSubtype();
    }

    public void removeConstraints() {
        if (this.constrained) {
            RcType rcType = this.subtypeCombo.getRcType();
            RcSubtype rcSubtype = this.subtypeCombo.getSelectedRcSubtype();
            this.treeCombo.setSelection(rcType, rcSubtype);
        }
        this.constrained = false;
        this.cards.show(this, "tree");
    }

    public JPanel getPanel() {
        this.panelLayout = new CardLayout();
        this.panel = new JPanel(this.panelLayout, false);
        this.panel.add("enabled", this);
        this.label = new JLabel();
        if (this.getSelectedRcSubtype() != null) {
            this.label.setText(this.getSelectedRcSubtype().toString());
        }
        this.panel.add("disabled", this.label);
        return this.panel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.panel != null) {
            this.panelLayout.show(this.panel, bl ? "enabled" : "disabled");
        }
    }
}

