/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.TreeComboBox;
import com.tridium.eas.ui.widgets.TreeComboBoxRenderer;
import javax.baja.util.Lexicon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RcSubtypeTreeComboBox
extends TreeComboBox {
    public RcSubtypeTreeComboBox(ResourceManager resourceManager) {
        this(resourceManager, false);
    }

    public RcSubtypeTreeComboBox(ResourceManager resourceManager, boolean bl) {
        super(resourceManager);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Type");
        RcType[] rcTypeArray = RcType.getAll();
        for (int i = 0; i < rcTypeArray.length; ++i) {
            RcSubtype[] rcSubtypeArray = rcTypeArray[i].getValidSubtypes();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(rcTypeArray[i]);
            if (rcSubtypeArray.length > 1) {
                for (int j = 0; j < rcSubtypeArray.length; ++j) {
                    if (bl && rcSubtypeArray[j] == RcSubtype.OTHER) continue;
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rcSubtypeArray[j]));
                }
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        this.setTree(new JTree(defaultMutableTreeNode));
    }

    public RcSubtypeTreeComboBox(ResourceManager resourceManager, boolean bl, Lexicon lexicon) {
        super(resourceManager, lexicon);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Type");
        RcType[] rcTypeArray = RcType.getAll();
        for (int i = 0; i < rcTypeArray.length; ++i) {
            RcSubtype[] rcSubtypeArray = rcTypeArray[i].getValidSubtypes();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(rcTypeArray[i]);
            if (rcSubtypeArray.length > 1) {
                for (int j = 0; j < rcSubtypeArray.length; ++j) {
                    if (bl && rcSubtypeArray[j] == RcSubtype.OTHER) continue;
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rcSubtypeArray[j]));
                }
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.setCellRenderer(new TreeComboBoxRenderer(jTree.getCellRenderer(), lexicon));
        this.setTree(jTree);
    }

    public RcSubtype getSelectedRcSubtype() {
        if (this.getSelectedItem() instanceof RcSubtype) {
            return (RcSubtype)this.getSelectedItem();
        }
        if (this.getSelectedItem() instanceof RcType) {
            RcSubtype[] rcSubtypeArray = ((RcType)this.getSelectedItem()).getValidSubtypes();
            if (rcSubtypeArray != null && rcSubtypeArray.length > 0 && rcSubtypeArray[0] != null) {
                return rcSubtypeArray[0];
            }
            return RcSubtype.OTHER;
        }
        return RcSubtype.OTHER;
    }

    protected String getLabelText() {
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath == null) {
            return "";
        }
        if (this.getSelectedItem() instanceof RcType) {
            if (this.lex != null) {
                return this.lex.getText(this.getSelectedItem().toString());
            }
            return this.getSelectedItem().toString();
        }
        RcSubtype rcSubtype = (RcSubtype)this.getSelectedItem();
        RcType rcType = (RcType)((DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 2)).getUserObject();
        if (rcType == RcType.OTHER) {
            if (this.lex != null) {
                return this.lex.getText(rcSubtype.toString());
            }
            return rcSubtype.toString();
        }
        if (this.lex != null) {
            return this.lex.getText(rcType.toString()) + " " + this.lex.getText(rcSubtype.toString());
        }
        return rcType.toString() + " " + rcSubtype.toString();
    }

    public RcType getSelectedRcType() {
        if (this.getSelectedItem() instanceof RcType) {
            return (RcType)this.getSelectedItem();
        }
        if (this.getSelectedItem() instanceof RcSubtype) {
            return (RcType)((DefaultMutableTreeNode)this.getTree().getSelectionPath().getParentPath().getLastPathComponent()).getUserObject();
        }
        return RcType.OTHER;
    }

    public void clearSelection() {
        this.getTree().clearSelection();
    }

    public void setSelection(RcType rcType, RcSubtype rcSubtype) {
        if (rcType == null) {
            this.getTree().clearSelection();
        } else {
            TreePath treePath = this.getUserObjectTreePath(rcType);
            if (treePath == null) {
                this.getTree().clearSelection();
            } else if (rcSubtype == null || rcType.getValidSubtypes().length == 1) {
                this.getTree().setSelectionPath(treePath);
            } else if ((treePath = this.getUserObjectTreePath(treePath, rcSubtype)) == null) {
                this.getTree().clearSelection();
            } else {
                this.getTree().setSelectionPath(treePath);
            }
        }
    }
}

