/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasComboBoxRenderer;
import javax.baja.util.Lexicon;
import javax.swing.DefaultComboBoxModel;

public class RcSubtypeComboBox
extends EasComboBox {
    private RcType type = null;
    private boolean excludeOther;

    public RcSubtypeComboBox() {
        this(false);
    }

    public RcSubtypeComboBox(boolean bl) {
        this.excludeOther = bl;
    }

    public RcSubtypeComboBox(boolean bl, Lexicon lexicon) {
        this.excludeOther = bl;
        this.lex = lexicon;
        this.setRenderer(new EasComboBoxRenderer(this.getRenderer(), lexicon));
    }

    public RcSubtypeComboBox(RcType rcType) {
        this();
        this.setRcType(rcType);
    }

    public RcSubtypeComboBox(int n) {
        this();
        this.setRcType(n);
    }

    public RcSubtypeComboBox(RcSubtype[] rcSubtypeArray) {
        this();
        this.setRcSubtypes(rcSubtypeArray);
    }

    public void setRcType(int n) {
        this.setRcType(RcType.getByCode(n));
    }

    public void setRcType(RcType rcType) {
        if (rcType == null || !rcType.equals(this.type) || this.getItemCount() == 0) {
            this.type = rcType;
            RcSubtype[] rcSubtypeArray = this.type.getValidSubtypes();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
            defaultComboBoxModel.removeAllElements();
            for (int i = 0; i < rcSubtypeArray.length; ++i) {
                if (this.excludeOther && rcSubtypeArray[i] == RcSubtype.OTHER && rcSubtypeArray.length != 1) continue;
                defaultComboBoxModel.addElement(rcSubtypeArray[i]);
            }
        }
    }

    public RcType getRcType() {
        return this.type == null ? RcType.OTHER : this.type;
    }

    public void setRcSubtypes(RcSubtype[] rcSubtypeArray) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
        defaultComboBoxModel.removeAllElements();
        for (int i = 0; i < rcSubtypeArray.length; ++i) {
            defaultComboBoxModel.addElement(rcSubtypeArray[i]);
        }
    }

    public void setSelectedSubtype(RcSubtype rcSubtype) {
        super.setSelectedItem(rcSubtype);
    }

    public void setSelectedItem(Object object) {
        this.setSelectedSubtype((RcSubtype)object);
    }

    public RcSubtype getSelectedRcSubtype() {
        return this.getSelectedItem() == null ? RcSubtype.OTHER : (RcSubtype)this.getSelectedItem();
    }

    public int getSelectedRcSubtypeCode() {
        return this.getSelectedRcSubtype().getCode();
    }
}

