/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.TreeNodeIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MatchingUserObjectTreeNodeIterator
implements Iterator {
    private TreePath nextPath = null;
    private Object userObject = null;
    private TreeNodeIterator iterator = null;
    private boolean nextHasBeenChecked = false;

    public MatchingUserObjectTreeNodeIterator(Object object, FilterTree filterTree) {
        this(object, (FilterTreeNode)filterTree.getModel().getRoot());
    }

    public MatchingUserObjectTreeNodeIterator(Object object, FilterTreeModel filterTreeModel) {
        this(object, (FilterTreeNode)filterTreeModel.getRoot());
    }

    public MatchingUserObjectTreeNodeIterator(Object object, FilterTreeNode filterTreeNode) {
        this(object, new TreeNodeIterator(filterTreeNode));
    }

    public MatchingUserObjectTreeNodeIterator(Object object, TreeNodeIterator treeNodeIterator) {
        this.iterator = treeNodeIterator;
        this.userObject = object;
        this.nextPath = null;
    }

    public static void selectUserObject(FilterTree filterTree, Object object) {
        MatchingUserObjectTreeNodeIterator matchingUserObjectTreeNodeIterator = new MatchingUserObjectTreeNodeIterator(object, filterTree);
        if (matchingUserObjectTreeNodeIterator.hasNext()) {
            filterTree.setSelectionPath(((FilterTreeNode)matchingUserObjectTreeNodeIterator.next()).getPath());
        }
        while (matchingUserObjectTreeNodeIterator.hasNext()) {
            filterTree.addSelectionPath(((FilterTreeNode)matchingUserObjectTreeNodeIterator.next()).getPath());
        }
    }

    public static void refreshUserObject(FilterTree filterTree, Object object) {
        MatchingUserObjectTreeNodeIterator matchingUserObjectTreeNodeIterator = new MatchingUserObjectTreeNodeIterator(object, filterTree.getFilterTreeModel());
        while (matchingUserObjectTreeNodeIterator.hasNext()) {
            TreePath treePath = matchingUserObjectTreeNodeIterator.nextTreePath();
            filterTree.getModel().valueForPathChanged(treePath, treePath.getLastPathComponent());
        }
    }

    public boolean hasNext() {
        this.nextHasBeenChecked = true;
        while (this.iterator.hasNext()) {
            this.nextPath = this.iterator.nextTreePath();
            Object object = this.getUserObject((TreeNode)this.nextPath.getLastPathComponent());
            if (this.userObject instanceof Class) {
                if (((Class)this.userObject).isAssignableFrom(object.getClass())) {
                    return true;
                }
                this.nextPath = null;
                continue;
            }
            if (this.userObject.equals(object)) {
                return true;
            }
            this.nextPath = null;
        }
        return false;
    }

    public Object next() {
        return this.nextTreePath().getLastPathComponent();
    }

    public TreeNode nextTreeNode() {
        return (TreeNode)this.next();
    }

    public TreePath nextTreePath() {
        if (!this.nextHasBeenChecked && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextHasBeenChecked = false;
        if (this.nextPath == null) {
            throw new NoSuchElementException();
        }
        return this.nextPath;
    }

    public void remove() {
    }

    private Object getUserObject(TreeNode treeNode) {
        if (treeNode instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)treeNode).getUserObject();
        }
        if (treeNode instanceof FilterTreeNode) {
            return ((FilterTreeNode)treeNode).getUserObject();
        }
        return null;
    }
}

