/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.LoadedTreeNodeIterator;
import com.tridium.eas.ui.widgets.MatchingUserObjectTreeNodeIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FilterTreeModel
extends DefaultTreeModel {
    public FilterTreeModel(FilterTreeNode filterTreeNode) {
        super(filterTreeNode, true);
    }

    public void reload() {
        ((FilterRootNode)this.getRoot()).reload();
        super.reload();
    }

    public FilterRootNode getFilterRootNode() {
        return (FilterRootNode)this.getRoot();
    }

    public TreePath[] findUserObjectTreePaths(Object object) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        TreePath[] treePathArray = new MatchingUserObjectTreeNodeIterator(object, new LoadedTreeNodeIterator(this));
        while (treePathArray.hasNext()) {
            FilterTreeNode filterTreeNode = (FilterTreeNode)treePathArray.next();
            arrayList.add(filterTreeNode.getPath());
        }
        treePathArray = new TreePath[arrayList.size()];
        arrayList.toArray(treePathArray);
        return treePathArray;
    }

    public void removeData(Object object) {
        TreePath[] treePathArray = this.findUserObjectTreePaths(object);
        for (int i = 0; i < treePathArray.length; ++i) {
            FilterTreeNode filterTreeNode = (FilterTreeNode)treePathArray[i].getLastPathComponent();
            FilterTreeNode filterTreeNode2 = (FilterTreeNode)filterTreeNode.getParent();
            int n = filterTreeNode2.removeChild(filterTreeNode);
            if (n < 0) continue;
            filterTreeNode2.reload();
            this.fireTreeNodesRemoved(this, filterTreeNode2.getPath().getPath(), new int[]{n}, new Object[]{filterTreeNode});
        }
    }

    public void dump(String string) {
        this.dumpNode(this.getFilterRootNode(), string);
    }

    public void dumpNode(FilterTreeNode filterTreeNode, String string) {
        System.out.println(string + filterTreeNode.getUserObject());
        Enumeration enumeration = filterTreeNode.children();
        while (enumeration.hasMoreElements()) {
            FilterTreeNode filterTreeNode2 = (FilterTreeNode)enumeration.nextElement();
            this.dumpNode(filterTreeNode2, string + "-->");
        }
    }

    public void refreshData(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.refreshData(objectArray[i]);
        }
    }

    public void refreshData(Object object) {
        int n;
        if (object == null) {
            return;
        }
        TreePath[] treePathArray = this.findUserObjectTreePaths(object);
        for (n = 0; n < treePathArray.length; ++n) {
            FilterTreeNode filterTreeNode = (FilterTreeNode)treePathArray[n].getLastPathComponent();
            if (!filterTreeNode.getValidator().allowLoadUserObject(object.getClass()) || !filterTreeNode.getValidator().allowShowUserObject(object)) {
                FilterTreeNode filterTreeNode2 = (FilterTreeNode)filterTreeNode.getParent();
                int n2 = filterTreeNode2.removeChild(filterTreeNode);
                if (n2 < 0) continue;
                filterTreeNode2.reload();
                this.fireTreeNodesRemoved(this, filterTreeNode2.getPath().getPath(), new int[]{n2}, new Object[]{filterTreeNode});
                continue;
            }
            if (filterTreeNode.isLoaded()) {
                filterTreeNode.reload();
                this.fireTreeStructureChanged(this, filterTreeNode.getPath().getPath(), null, null);
                continue;
            }
            this.fireTreeNodesChanged(this, filterTreeNode.getPath().getPath(), null, null);
        }
        n = this.getFilterRootNode().addChild(object);
        if (n >= 0) {
            this.fireTreeNodesInserted(this, this.getFilterRootNode().getPath().getPath(), new int[]{n}, new Object[]{this.getFilterRootNode().getChildAt(n)});
        }
    }
}

