/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasDialog;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeSelectionModel;

public class FilterTreeDialog
extends EasDialog
implements ActionListener {
    private FilterTree tree;
    private FilterTreeModel model;
    private JButton okButton;
    private JButton cancelButton;
    private Object selection;
    private Object initialSelection;
    private Lexicon lex;

    private FilterTreeDialog(Component component, Object object, String string, String string2, FilterRootNode filterRootNode, TreeSelectionModel treeSelectionModel, ResourceManager resourceManager, Lexicon lexicon) {
        super(FilterTreeDialog.getParentFrame(component), component);
        this.lex = lexicon;
        this.setTitle(string);
        this.initialSelection = object;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        if (string2 != null && string2.trim().length() > 0) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            container.add((Component)new JLabel(string2), gridBagConstraints);
        }
        this.tree = new FilterTree(resourceManager);
        this.model = new FilterTreeModel(filterRootNode);
        this.tree.setModel(this.model);
        if (treeSelectionModel != null) {
            this.tree.setSelectionModel(treeSelectionModel);
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.getViewport().setPreferredSize(new Dimension(250, 200));
        container.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(1), false);
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(this.tree.getRowCount() > 0);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        container.add((Component)jPanel, gridBagConstraints);
        if (object != null) {
            this.tree.setSelectedUserObject(object);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FilterTreeDialog.this.doCancel();
                super.windowClosing(windowEvent);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok")) {
            this.selection = this.tree.getSelectedUserObject();
            this.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            this.doCancel();
        }
    }

    private void doCancel() {
        this.selection = this.initialSelection;
        this.setVisible(false);
    }

    protected Object getSelection() {
        return this.selection;
    }

    public static Object getSelection(Component component, Object object, String string, String string2, FilterRootNode filterRootNode, ResourceManager resourceManager, Lexicon lexicon) {
        return FilterTreeDialog.getSelection(component, object, string, string2, filterRootNode, null, resourceManager, lexicon);
    }

    public static Object getSelection(Component component, Object object, String string, String string2, FilterRootNode filterRootNode, TreeSelectionModel treeSelectionModel, ResourceManager resourceManager, Lexicon lexicon) {
        FilterTreeDialog filterTreeDialog = new FilterTreeDialog(component, object, string, string2, filterRootNode, treeSelectionModel, resourceManager, lexicon);
        filterTreeDialog.setVisible(true);
        return filterTreeDialog.getSelection();
    }
}

