/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.DisabledImageGenerator;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.LayeredIcon;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EasTreeCellRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon groupIcon = null;
    private ImageIcon siteIcon = null;
    private ImageIcon dataPointIcon = null;
    private ImageIcon stationIcon = null;
    private ImageIcon disabledGroupIcon = null;
    private ImageIcon disabledSiteIcon = null;
    private ImageIcon disabledDataPointIcon = null;
    private ImageIcon disabledStationIcon = null;
    private ImageIcon meterIcon = null;
    private ImageIcon disabledMeterIcon = null;
    private Icon linkedDataPointIcon = null;
    private Icon disabledLinkedDataPointIcon = null;

    public EasTreeCellRenderer(ResourceManager resourceManager) {
        DisabledImageGenerator disabledImageGenerator = new DisabledImageGenerator();
        this.groupIcon = new ImageIcon(resourceManager.getIconImage(4));
        this.disabledGroupIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(4)));
        this.siteIcon = new ImageIcon(resourceManager.getIconImage(7));
        this.disabledSiteIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(7)));
        this.dataPointIcon = new ImageIcon(resourceManager.getIconImage(10));
        this.disabledDataPointIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(10)));
        this.stationIcon = new ImageIcon(resourceManager.getIconImage(1));
        this.disabledStationIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(1)));
        this.meterIcon = new ImageIcon(resourceManager.getIconImage(26));
        this.disabledMeterIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(26)));
        ImageIcon imageIcon = new ImageIcon(resourceManager.getIconImage(14));
        ImageIcon imageIcon2 = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(14)));
        this.linkedDataPointIcon = new LayeredIcon(new ImageIcon[]{this.dataPointIcon, imageIcon});
        this.disabledLinkedDataPointIcon = new LayeredIcon(new ImageIcon[]{this.disabledDataPointIcon, imageIcon2});
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        Object object2 = this.getUserObject(object);
        if (object2 == null) {
            return jLabel;
        }
        try {
            if (object2 instanceof DynGroup) {
                jLabel.setIcon(this.groupIcon);
                jLabel.setDisabledIcon(this.disabledGroupIcon);
            } else if (object2 instanceof Group) {
                Group group = (Group)object2;
                jLabel.setText(group.getName());
                if (group.getType() == 83) {
                    jLabel.setIcon(this.groupIcon);
                    jLabel.setDisabledIcon(this.disabledGroupIcon);
                } else if (group.getType() == 80) {
                    jLabel.setIcon(this.siteIcon);
                    jLabel.setDisabledIcon(this.disabledSiteIcon);
                }
            } else if (object2 instanceof Meter) {
                Object object3;
                Meter meter = (Meter)object2;
                Object object4 = null;
                if (object instanceof TreeNode) {
                    object3 = ((TreeNode)object).getParent();
                    if (object3 != null) {
                        object4 = this.getUserObject(object3);
                    }
                } else {
                    object3 = jTree.getPathForRow(n).getParentPath();
                    if (object3 != null) {
                        object4 = this.getUserObject(((TreePath)object3).getLastPathComponent());
                    }
                }
                object3 = meter.getName();
                if (object4 == null || !(object4 instanceof Site)) {
                    jLabel.setText((String)object3 + " (" + meter.getSite().getName() + ")");
                } else {
                    jLabel.setText((String)object3);
                }
                jLabel.setIcon(this.meterIcon);
                jLabel.setDisabledIcon(this.disabledMeterIcon);
            } else if (object2 instanceof DataPoint) {
                Object object5;
                DataPoint dataPoint = (DataPoint)object2;
                Site site = dataPoint.getSite();
                Site site2 = null;
                Object object6 = null;
                if (object instanceof TreeNode) {
                    object5 = ((TreeNode)object).getParent();
                    if (object5 != null) {
                        object6 = this.getUserObject(object5);
                    }
                } else {
                    object5 = jTree.getPathForRow(n).getParentPath();
                    if (object5 != null) {
                        object6 = this.getUserObject(((TreePath)object5).getLastPathComponent());
                    }
                }
                if (object6 instanceof Meter) {
                    site2 = ((Meter)object6).getSite();
                } else if (object6 instanceof Site) {
                    site2 = (Site)object6;
                }
                object5 = dataPoint.getDescr();
                if (dataPoint.getMeter() != null && !(object6 instanceof Meter)) {
                    object5 = dataPoint.getMeter().getName() + " " + (String)object5;
                }
                if (object6 == null || !(object6 instanceof Site) && !(object6 instanceof Meter)) {
                    jLabel.setText((String)object5 + " (" + dataPoint.getSite().getName() + ")");
                } else {
                    jLabel.setText((String)object5);
                }
                if (site2 == null || site.equals(site2)) {
                    jLabel.setIcon(this.dataPointIcon);
                    jLabel.setDisabledIcon(this.disabledDataPointIcon);
                } else {
                    jLabel.setIcon(this.linkedDataPointIcon);
                    jLabel.setDisabledIcon(this.disabledLinkedDataPointIcon);
                }
            } else if (!bl3) {
                jLabel.setIcon(this.groupIcon);
                jLabel.setDisabledIcon(this.disabledGroupIcon);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return jLabel;
    }

    private Object getUserObject(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)object).getUserObject();
        }
        if (object instanceof FilterTreeNode) {
            return ((FilterTreeNode)object).getUserObject();
        }
        return null;
    }
}

