/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.widgets.TextCellEvent;
import com.tridium.eas.ui.widgets.TextCellListener;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.baja.timezone.BTimeZone;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class EasTimeEditor
extends JComponent
implements TextCellListener,
ActionListener,
FocusListener,
KeyListener {
    private static final int HOUR_INDEX = 0;
    private static final int MINUTE_INDEX = 1;
    private int AMPM_INDEX;
    private static final String AM_STRING = "AM";
    private static final String PM_STRING = "PM";
    protected static final int AM = 0;
    protected static final int PM = 1;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int millisecond = 0;
    private boolean timeType = true;
    private Icon startIcon = null;
    private Icon endIcon = null;
    private DividedTextField divField;
    private JPanel spinPanel;
    private JButton upButton;
    private JButton downButton;
    private JPanel quickPickPanel;
    private JButton startButton;
    private JButton endButton;
    private Vector listeners;

    public EasTimeEditor(boolean bl, int n, int n2, int n3, int n4, Icon icon, Icon icon2) {
        this.timeType = bl;
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.millisecond = n4;
        this.startIcon = icon;
        this.endIcon = icon2;
        this.doInit(n, n2, n3, n4);
    }

    public void doInit(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        this.AMPM_INDEX = 2;
        int n8 = 2;
        if (!this.timeType) {
            ++n8;
        }
        int[] nArray = new int[n8];
        String[] stringArray = new String[n8 - 1];
        for (n7 = 0; n7 < nArray.length; ++n7) {
            nArray[n7] = 2;
        }
        n7 = n8;
        if (!this.timeType) {
            --n7;
            stringArray[stringArray.length - 1] = " ";
        }
        for (n6 = 0; n6 < n7 - 1; ++n6) {
            stringArray[n6] = ":";
        }
        this.divField = new DividedTextField(nArray, stringArray);
        this.divField.setWidthChar('0');
        n6 = 10;
        char[] cArray = new char[n6];
        for (n5 = 0; n5 < 10; ++n5) {
            cArray[n5] = (char)(48 + n5);
        }
        for (n5 = 0; n5 < n7; ++n5) {
            this.divField.allow(n5, cArray);
            if (n5 != 0 || this.timeType) {
                this.divField.setPadChar(n5, '0');
                continue;
            }
            this.divField.setRightJustify(n5, true);
        }
        if (!this.timeType) {
            cArray = new char[]{'A', 'P', 'M'};
            this.divField.allow(this.AMPM_INDEX, cArray);
        }
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.divField);
        this.spinPanel = this.buildSpinPanel(this.divField.getPreferredSize().height);
        this.add(this.spinPanel);
        if (this.timeType && this.startIcon != null && this.endIcon != null) {
            this.add(new JLabel("  "));
            this.quickPickPanel = this.buildQuickPickPanel(this.divField.getPreferredSize().height);
            this.add(this.quickPickPanel);
        }
        this.setValues(n, n2, n3, n4);
        this.upButton.addActionListener(this);
        this.upButton.addFocusListener(this);
        this.downButton.addActionListener(this);
        this.downButton.addFocusListener(this);
        if (this.timeType && this.startIcon != null && this.endIcon != null) {
            this.startButton.addActionListener(this);
            this.startButton.addFocusListener(this);
            this.endButton.addActionListener(this);
            this.endButton.addFocusListener(this);
        }
        this.divField.addActionListener(this);
        this.divField.addTextCellListener(this);
        this.divField.addKeyListener(this);
    }

    private JPanel buildSpinPanel(int n) {
        int n2 = n / 2 - 4;
        JPanel jPanel = new JPanel(false);
        this.upButton = new JButton(new ArrowIcon(4, 3, true));
        this.upButton.addFocusListener(this);
        this.upButton.addKeyListener(this);
        this.upButton.setPreferredSize(new Dimension(15, n / 2));
        this.downButton = new JButton(new ArrowIcon(4, 3, false));
        this.downButton.addFocusListener(this);
        this.downButton.addKeyListener(this);
        this.downButton.setPreferredSize(new Dimension(15, n / 2));
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.upButton);
        jPanel.add(this.downButton);
        return jPanel;
    }

    private JPanel buildQuickPickPanel(int n) {
        JPanel jPanel = new JPanel(false);
        this.startButton = new JButton(this.startIcon);
        this.startButton.addFocusListener(this);
        this.startButton.addKeyListener(this);
        this.startButton.setPreferredSize(new Dimension(20, n));
        this.endButton = new JButton(this.endIcon);
        this.endButton.addFocusListener(this);
        this.endButton.addKeyListener(this);
        this.endButton.setPreferredSize(new Dimension(20, n));
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.startButton);
        jPanel.add(this.endButton);
        return jPanel;
    }

    public void setEditable(boolean bl) {
        this.spinPanel.setVisible(bl);
        this.quickPickPanel.setVisible(bl);
        this.divField.setEditable(bl);
        this.revalidate();
    }

    public int getHour() {
        int n = this.hour;
        if (!this.timeType) {
            boolean bl = this.divField.getValueAt(this.AMPM_INDEX).equals(AM_STRING);
            if (bl && n == 12) {
                n = 0;
            } else if (!bl && n != 12) {
                n += 12;
            }
        }
        return n;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public void setValues(int n, int n2, int n3, int n4) {
        if (!this.timeType) {
            if (n < 12) {
                this.divField.setValueAt(this.AMPM_INDEX, AM_STRING);
            } else {
                this.divField.setValueAt(this.AMPM_INDEX, PM_STRING);
            }
            if (n == 0) {
                n = 12;
            } else if (n > 12) {
                n -= 12;
            }
        }
        this.divField.setValueAt(0, Integer.toString(n));
        this.divField.setValueAt(1, Integer.toString(n2));
        this.millisecond = n4;
        this.hour = n;
        this.minute = n2;
        this.second = n3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.upButton || object == this.downButton) {
            int n = this.divField.getFocus();
            if (n == -1) {
                n = 0;
            }
            if (n == 0) {
                this.changeHour(object == this.upButton);
            } else if (n == 1) {
                this.changeMinute(object == this.upButton);
            } else if (n == this.AMPM_INDEX) {
                this.changeAmPm();
            }
            this.second = 0;
            this.millisecond = 0;
            this.fireActionEvent();
        } else if (object == this.divField) {
            this.fireActionEvent();
        } else if (this.timeType && this.startButton != null && object == this.startButton) {
            this.hour = 0;
            this.divField.setValueAt(0, Integer.toString(this.hour));
            this.minute = 0;
            this.divField.setValueAt(1, Integer.toString(this.minute));
            this.second = 0;
            this.millisecond = 0;
            this.fireActionEvent();
        } else if (this.timeType && this.endButton != null && object == this.endButton) {
            this.hour = 23;
            this.divField.setValueAt(0, Integer.toString(this.hour));
            this.minute = 59;
            this.divField.setValueAt(1, Integer.toString(this.minute));
            this.second = 59;
            Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
            this.millisecond = calendar.getMaximum(14);
            this.fireActionEvent();
        }
    }

    private void changeHour(boolean bl) {
        this.hour = bl ? ++this.hour : --this.hour;
        if (this.timeType) {
            if (this.hour == 24 && this.endButton == null) {
                this.setValues(this.hour, 0, 0, 0);
            } else if (this.hour >= 24) {
                this.hour = 0;
            } else if (this.hour == -1) {
                if (this.endButton == null) {
                    this.hour = 24;
                    this.setValues(this.hour, 0, 0, 0);
                } else {
                    this.hour = 23;
                }
            }
        } else if (this.hour == 13) {
            this.hour = 1;
        } else if (this.hour == 0) {
            this.hour = 12;
        }
        this.divField.setValueAt(0, Integer.toString(this.hour));
    }

    private void changeMinute(boolean bl) {
        if (this.hour >= 24) {
            return;
        }
        this.minute = bl ? ++this.minute : --this.minute;
        if (this.minute == 60) {
            this.minute = 0;
        } else if (this.minute < 0) {
            this.minute = 59;
        }
        this.divField.setValueAt(1, Integer.toString(this.minute));
    }

    private void changeAmPm() {
        if (this.timeType) {
            return;
        }
        String string = this.divField.getValueAt(this.AMPM_INDEX);
        if (string.equals(AM_STRING)) {
            this.divField.setValueAt(this.AMPM_INDEX, PM_STRING);
        } else {
            this.divField.setValueAt(this.AMPM_INDEX, AM_STRING);
        }
    }

    public void textCellChanged(TextCellEvent textCellEvent) {
        int n;
        int n2 = textCellEvent.getCellIndex();
        String string = textCellEvent.getValue();
        if (string.length() == 0) {
            string = this.timeType || n2 != this.AMPM_INDEX ? (!this.timeType && n2 == 0 ? "12" : "0") : AM_STRING;
            this.divField.setValueAt(n2, string);
        }
        if (!this.timeType && n2 == this.AMPM_INDEX) {
            char c = string.charAt(string.length() - 1);
            if (c == 'A') {
                this.divField.setValueAt(this.AMPM_INDEX, AM_STRING);
            } else {
                this.divField.setValueAt(this.AMPM_INDEX, PM_STRING);
            }
            return;
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 == 0) {
            this.hour = n3;
        } else if (n2 == 1) {
            this.minute = n3;
        }
        int n4 = n = !this.timeType ? 12 : 23;
        if (this.hour >= 24 && this.endButton == null) {
            this.hour = 24;
            this.setValues(this.hour, 0, 0, 0);
        } else if (this.hour > n) {
            this.hour -= this.hour / 10 * 10;
            this.divField.setValueAt(0, Integer.toString(this.hour));
        }
        if (this.minute > 59) {
            this.minute -= this.minute / 10 * 10;
            this.divField.setValueAt(1, Integer.toString(this.minute));
        }
        this.second = 0;
        this.millisecond = 0;
        this.fireActionEvent();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.divField.showFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!(this.upButton.hasFocus() || this.downButton.hasFocus() || this.startButton != null && this.startButton.hasFocus() || this.endButton != null && this.endButton.hasFocus())) {
            this.divField.hideFocus();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 38 && n != 40) {
            return;
        }
        int n2 = this.divField.getFocus();
        if (n2 == -1) {
            n2 = 0;
        }
        if (n2 == 0) {
            this.changeHour(n == 38);
        } else if (n2 == 1) {
            this.changeMinute(n == 38);
        } else if (n2 == this.AMPM_INDEX) {
            this.changeAmPm();
        }
        this.second = 0;
        this.millisecond = 0;
        this.fireActionEvent();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(actionListener);
    }

    void fireActionEvent() {
        if (this.listeners == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(actionEvent);
        }
    }

    private class DividedTextField
    extends JComponent
    implements ComponentListener,
    MouseListener,
    KeyListener,
    FocusListener,
    Accessible {
        private Dimension prefSize;
        private FontMetrics fm;
        private TextCell[] cells;
        private boolean boundsSet = false;
        private Color selBg;
        private Color selFg;
        private int charWidth;
        private boolean showFocus = false;
        private int focus = 0;
        private int selection = -1;
        private boolean hasFocus = false;
        private Vector actionListeners;
        private Vector cellListeners;
        private boolean readOnly = false;
        private boolean shiftDown = false;

        public DividedTextField(int[] nArray) {
            this(nArray, new String[0]);
        }

        public DividedTextField(int[] nArray, String[] stringArray) {
            this.setOpaque(true);
            this.setBorder(UIManager.getDefaults().getBorder("TextField.border"));
            Font font = UIManager.getDefaults().getFont("TextField.font");
            this.setFont(new Font(Theme.widget().getTextFont().getName(), font.getStyle(), font.getSize()));
            this.setForeground(UIManager.getDefaults().getColor("TextField.foreground"));
            this.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            this.selBg = UIManager.getDefaults().getColor("TextField.selectionBackground");
            this.selFg = UIManager.getDefaults().getColor("TextField.selectionForeground");
            int n = nArray.length * 2 - 1;
            this.cells = new TextCell[n];
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (!bl) {
                    this.cells[i] = new VariableTextCell(nArray[n2++]);
                } else {
                    this.cells[i] = n3 < stringArray.length ? new TextCell(stringArray[n3]) : new TextCell(null);
                    ++n3;
                }
                bl = !bl;
            }
            this.charWidth = this.fm().stringWidth("W");
            this.addComponentListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.addFocusListener(this);
        }

        public void setEditable(boolean bl) {
            if (!bl) {
                this.setBackground(UIManager.getDefaults().getColor("control"));
                this.removeMouseListener(this);
                this.removeKeyListener(this);
                this.removeFocusListener(this);
            } else {
                this.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                this.addMouseListener(this);
                this.addKeyListener(this);
                this.addFocusListener(this);
            }
        }

        public void setWidthChar(char c) {
            this.charWidth = this.fm().stringWidth("" + c);
        }

        public String getValue() {
            StringBuffer stringBuffer = new StringBuffer(20);
            for (int i = 0; i < this.cells.length; ++i) {
                String string = this.cells[i].getValue();
                if (string == null) continue;
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }

        public String[] getValues() {
            String[] stringArray = new String[this.cells.length / 2 + 1];
            int n = 0;
            for (int i = 0; i < this.cells.length; i += 2) {
                stringArray[n++] = this.cells[i].getValue();
            }
            return stringArray;
        }

        public void setValueAt(int n, String string) {
            this.cells[n *= 2].setValue(string);
            this.repaint();
        }

        public String getValueAt(int n) {
            return this.cells[n *= 2].getValue();
        }

        public void setPadChar(int n, char c) {
            this.cells[n *= 2].setPadChar(c);
        }

        public void allowKeyboardInput(int n, boolean bl) {
            this.cells[n *= 2].keyIn = bl;
        }

        public void setRightJustify(int n, boolean bl) {
            this.cells[n *= 2].justifyRight = bl;
        }

        public void disallow(int n, char[] cArray) {
            this.cells[n *= 2].charSet = cArray;
            this.cells[n].allow = false;
        }

        public void allow(int n, char[] cArray) {
            this.cells[n *= 2].charSet = cArray;
            this.cells[n].allow = true;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public boolean isManagingFocus() {
            return false;
        }

        public Component getNextFocusableComponent() {
            if (this.selection == -1) {
                return null;
            }
            if (!this.shiftDown) {
                if (this.selection == this.cells.length - 1) {
                    return null;
                }
                this.selection += 2;
                this.focus = this.selection;
                this.cells[this.selection].newFocus = true;
                this.repaint();
                return this;
            }
            if (this.selection == 0) {
                return null;
            }
            this.selection -= 2;
            this.focus = this.selection;
            this.cells[this.selection].newFocus = true;
            this.repaint();
            return this;
        }

        public void hideFocus() {
            if (!this.showFocus) {
                return;
            }
            this.showFocus = false;
            this.repaint();
        }

        public void showFocus() {
            if (this.showFocus) {
                return;
            }
            this.showFocus = true;
            this.repaint();
        }

        public void changeSelection(boolean bl) {
            if (this.selection == -1) {
                this.focus = 0;
                this.selection = 0;
            } else if (bl) {
                this.selection += 2;
                this.focus = this.selection;
            } else {
                this.selection -= 2;
                this.focus = this.selection;
            }
            if (this.selection < 0) {
                this.selection = this.focus = this.cells.length - 1;
            } else if (this.selection > this.cells.length - 1) {
                this.selection = 0;
            }
            this.cells[this.selection].newFocus = true;
            this.repaint();
        }

        public void setFont(Font font) {
            this.fm = null;
            this.prefSize = null;
            super.setFont(font);
        }

        protected FontMetrics fm() {
            if (this.fm == null) {
                this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            }
            return this.fm;
        }

        public Dimension getPreferredSize() {
            if (this.prefSize == null) {
                Insets insets = this.getInsets();
                int n = 0;
                for (int i = 0; i < this.cells.length; ++i) {
                    n += this.cells[i].getWidthInPixels();
                }
                this.prefSize = new Dimension(n + insets.left + insets.right + 4, this.fm.getHeight() + insets.top + insets.bottom);
            }
            return this.prefSize;
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            graphics.setColor(this.getBackground());
            graphics.fillRect(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            graphics.setColor(this.getForeground());
            int n = insets.top + this.fm().getHeight() - this.fm().getDescent();
            int n2 = insets.left + 1;
            for (int i = 0; i < this.cells.length; ++i) {
                int n3 = this.cells[i].getWidthInPixels();
                if (!this.boundsSet) {
                    this.cells[i].setBounds(n2, insets.top, n3, dimension.height - insets.top - insets.bottom);
                }
                this.cells[i].paint(graphics, n2, n, i == this.selection, i == this.focus);
                n2 += n3;
            }
            this.boundsSet = true;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.hasFocus) {
                this.requestFocus();
            }
            int n = this.selection;
            for (int i = 0; i < this.cells.length; i += 2) {
                if (!this.cells[i].contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                this.selection = this.focus = i;
                break;
            }
            if (this.selection != n) {
                if (this.selection != -1) {
                    this.cells[this.selection].newFocus = true;
                }
                this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                this.fireActionEvent(keyEvent.getModifiers());
                return;
            }
            if (n == 39 || n == 37) {
                this.changeSelection(n == 39);
                return;
            }
            if (n == 16) {
                this.shiftDown = true;
            }
            if (!this.cells[this.selection].keyIn) {
                return;
            }
            boolean bl = false;
            if (n == 8) {
                bl = this.cells[this.selection].backspace();
            } else if (this.selection != -1) {
                bl = this.cells[this.selection].append(keyEvent.getKeyChar());
            }
            if (bl) {
                this.fireChangeEvent(this.selection / 2, this.cells[this.selection].getValue());
                this.repaint();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 16) {
                this.shiftDown = false;
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            this.showFocus = true;
            this.focus = 0;
            this.selection = 0;
            this.cells[this.selection].newFocus = true;
            this.repaint();
            this.hasFocus = true;
        }

        public void focusLost(FocusEvent focusEvent) {
            this.shiftDown = false;
            this.showFocus = false;
            this.selection = -1;
            this.repaint();
            this.hasFocus = false;
        }

        public int getFocus() {
            return this.focus / 2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.boundsSet = false;
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void addActionListener(ActionListener actionListener) {
            if (this.actionListeners == null) {
                this.actionListeners = new Vector(1);
            }
            this.actionListeners.addElement(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            if (this.actionListeners == null) {
                return;
            }
            this.actionListeners.removeElement(actionListener);
        }

        protected void fireActionEvent(int n) {
            if (this.actionListeners == null) {
                return;
            }
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.getValue(), n);
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ((ActionListener)this.actionListeners.elementAt(i)).actionPerformed(actionEvent);
            }
        }

        public void addTextCellListener(TextCellListener textCellListener) {
            if (this.cellListeners == null) {
                this.cellListeners = new Vector(1);
            }
            this.cellListeners.addElement(textCellListener);
        }

        public void removeTextCellListener(TextCellListener textCellListener) {
            if (this.cellListeners == null) {
                return;
            }
            this.cellListeners.removeElement(textCellListener);
        }

        protected void fireChangeEvent(int n, String string) {
            if (this.cellListeners == null) {
                return;
            }
            TextCellEvent textCellEvent = new TextCellEvent(this, n, string);
            for (int i = 0; i < this.cellListeners.size(); ++i) {
                ((TextCellListener)this.cellListeners.elementAt(i)).textCellChanged(textCellEvent);
            }
        }

        private class VariableTextCell
        extends TextCell {
            public int fieldWidth;
            private int swidth;

            public VariableTextCell(int n) {
                this.fieldWidth = n;
            }

            public void setPadChar(int n) {
                super.setPadChar(n);
                if (this.padChar != -1) {
                    if (this.value == null) {
                        this.value = "";
                    }
                    if (this.value.length() < this.fieldWidth) {
                        StringBuffer stringBuffer = new StringBuffer(this.fieldWidth);
                        for (int i = 0; i < this.fieldWidth - this.value.length(); ++i) {
                            stringBuffer.append((char)this.padChar);
                        }
                        stringBuffer.append(this.value);
                        this.value = stringBuffer.toString();
                    }
                }
                this.swidth = DividedTextField.this.fm().stringWidth(this.value);
            }

            public boolean append(char c) {
                if (!this.isAllowed(c)) {
                    return false;
                }
                if (this.newFocus) {
                    this.value = this.padChar != -1 ? "" + (char)this.padChar : null;
                    this.newFocus = false;
                }
                this.value = this.value == null || this.value.length() == 0 ? "" + c : (this.value.length() == this.fieldWidth ? this.value.substring(1) + c : this.value + c);
                this.swidth = DividedTextField.this.fm().stringWidth(this.value);
                return true;
            }

            public boolean backspace() {
                if (this.value == null || this.value.length() == 0) {
                    return false;
                }
                this.value = this.value.substring(1);
                this.swidth = DividedTextField.this.fm().stringWidth(this.value);
                return true;
            }

            public void setValue(String string) {
                this.value = null;
                for (int i = 0; i < string.length(); ++i) {
                    this.append(string.charAt(i));
                }
                if (this.value == null) {
                    this.value = "";
                }
                this.newFocus = false;
                this.setPadChar(this.padChar);
            }

            public int getWidthInPixels() {
                return this.fieldWidth * DividedTextField.this.charWidth;
            }

            public void paint(Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
                boolean bl3 = DividedTextField.this.isEnabled();
                int n3 = Math.max(this.bounds.width, this.swidth);
                if (bl3 && bl2 && DividedTextField.this.showFocus) {
                    graphics.drawLine(this.bounds.x, n2 + 1, this.bounds.x + n3 - 1, n2 + 1);
                }
                if (bl3 && bl) {
                    graphics.setColor(DividedTextField.this.selBg);
                    graphics.fillRect(this.bounds.x, this.bounds.y, n3, this.bounds.height);
                    graphics.setColor(DividedTextField.this.selFg);
                }
                if (this.value != null) {
                    if (this.justifyRight) {
                        graphics.drawString(this.value, n + this.bounds.width - this.swidth, n2);
                    } else {
                        graphics.drawString(this.value, n, n2);
                    }
                }
                if (bl3 && bl) {
                    graphics.setColor(DividedTextField.this.getForeground());
                }
            }
        }

        private class TextCell {
            public String value;
            protected int padChar = -1;
            public char[] charSet;
            public boolean allow;
            protected Rectangle bounds;
            protected int pixelWidth;
            public boolean newFocus = false;
            public boolean justifyRight = false;
            public boolean keyIn = true;

            public TextCell() {
            }

            public TextCell(String string) {
                this.value = string;
                this.pixelWidth = this.value == null ? 0 : DividedTextField.this.fm().stringWidth(this.value);
            }

            public int getWidthInPixels() {
                return this.pixelWidth;
            }

            public void setPadChar(int n) {
                this.padChar = n;
            }

            public void paint(Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
                if (this.value == null) {
                    return;
                }
                graphics.drawString(this.value, n, n2);
            }

            public boolean append(char c) {
                return false;
            }

            public boolean backspace() {
                return false;
            }

            public void setValue(String string) {
            }

            public String getValue() {
                return this.value;
            }

            public void setBounds(int n, int n2, int n3, int n4) {
                this.bounds = new Rectangle(n, n2, n3, n4);
            }

            public boolean contains(int n, int n2) {
                return this.bounds.contains(n, n2);
            }

            protected boolean isAllowed(char c) {
                if (this.charSet == null) {
                    return true;
                }
                if (this.allow) {
                    for (int i = 0; i < this.charSet.length; ++i) {
                        if (this.charSet[i] != c) continue;
                        return this.allow;
                    }
                }
                return false;
            }
        }
    }

    private class ArrowIcon
    implements Icon {
        private boolean up = true;
        private int width;
        private int height;

        public ArrowIcon(boolean bl) {
            this(3, 2, bl);
        }

        public ArrowIcon(int n, int n2, boolean bl) {
            this.width = n;
            this.height = n2;
            this.up = bl;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.getForeground());
            if (this.up) {
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 + 1, n + 2, n2 + 1);
            } else {
                graphics.drawLine(n, n2, n + 2, n2);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            }
        }
    }
}

