/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.ui.NavigationManager;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.RowMappedTableModel;
import com.tridium.eas.ui.widgets.RowModel;
import com.tridium.eas.ui.widgets.SortedHeaderRenderer;
import com.tridium.eas.ui.widgets.SortedRowModel;
import com.tridium.eas.ui.widgets.TreeComboBoxTableEditor;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.ui.widgets.UnitTreeComboBox;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EasTable
extends JTable
implements MouseListener {
    private Font cellFont = null;
    private Font headerFont = null;
    private Font titleFont = null;
    private Font subtitleFont = null;
    private FontMetrics cellFontMetrics;
    private FontMetrics headerFontMetrics;
    private FontMetrics titleFontMetrics;
    private FontMetrics subtitleFontMetrics;
    private UnitComboBox euComboBox = null;
    private DefaultCellEditor stringEditor = null;
    private DefaultCellEditor numberEditor = null;
    private TableCellEditor unitEditor = null;
    private TableCellEditor typeEditor = null;
    private TableCellEditor measureEditor = null;
    private TableCellEditor unitAndTypeEditor = null;
    private TableCellEditor unitAndMeasureEditor = null;
    private ListPopupHandler popupHandler = null;
    private DefaultPopup defaultPopup = null;
    private JScrollPane sp;
    private String title = null;
    private String subtitle = null;
    protected Lexicon lex;
    static /* synthetic */ Class class$java$lang$Object;

    public EasTable(TableModel tableModel, boolean bl, Lexicon lexicon) {
        this(null, tableModel, bl, lexicon);
    }

    public EasTable(ResourceManager resourceManager, TableModel tableModel, Lexicon lexicon) {
        this(resourceManager, tableModel, true, lexicon);
    }

    public EasTable(ResourceManager resourceManager, TableModel tableModel, boolean bl, Lexicon lexicon) {
        super(tableModel);
        this.lex = lexicon;
        if (bl) {
            this.euComboBox = new UnitComboBox(lexicon);
            this.stringEditor = new DefaultCellEditor(new EasTextField());
            this.numberEditor = new DefaultCellEditor(new NumberTextField());
            this.unitEditor = new DefaultCellEditor(this.euComboBox);
            this.typeEditor = new DefaultCellEditor(new XpComboBox(UnitDatabase.getDefault().getQuantities()));
            this.measureEditor = new DefaultCellEditor(new XpComboBox(UnitDatabase.getDefault().getQuantities()));
            if (resourceManager != null) {
                this.unitAndTypeEditor = new TreeComboBoxTableEditor(new UnitTreeComboBox(resourceManager, true, lexicon));
                this.unitAndMeasureEditor = new TreeComboBoxTableEditor(new UnitTreeComboBox(resourceManager, false, lexicon));
            }
        } else {
            this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = EasTable.class$("java.lang.Object")) : class$java$lang$Object, new NoFocusCellRenderer());
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!EasTable.this.isEnabled()) {
                    return;
                }
                boolean bl = (mouseEvent.getModifiers() & 4) != 0;
                boolean bl2 = mouseEvent.isControlDown();
                int n = EasTable.this.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                if (bl) {
                    if (bl2) {
                        EasTable.this.addRowSelectionInterval(n, n);
                    } else {
                        EasTable.this.setRowSelectionInterval(n, n);
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                boolean bl;
                if (EasTable.this.popupHandler == null) {
                    return;
                }
                boolean bl2 = bl = (mouseEvent.getModifiers() & 4) != 0;
                if (!bl) {
                    return;
                }
                int n = EasTable.this.rowAtPoint(mouseEvent.getPoint());
                if (EasTable.this.isEnabled()) {
                    EasTable.this.popupHandler.openPopup(EasTable.this, n, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.setTableHeader(new EasTableHeader(this.getColumnModel()));
        this.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (EasTable.this.defaultPopup == null) {
                    EasTable.this.defaultPopup = new DefaultPopup();
                }
                EasTable.this.defaultPopup.show(EasTable.this, n2, n3);
            }
        });
    }

    public void resetSorting() {
        TableModel tableModel = this.getModel();
        if (tableModel != null && tableModel instanceof AbstractRowMappedTableModel) {
            ((AbstractRowMappedTableModel)tableModel).resetSorting();
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        TableCellRenderer tableCellRenderer = new TableColumn().getHeaderRenderer();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setHeaderRenderer(tableCellRenderer);
        }
        this.getTableHeader().repaint();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Component component;
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 >= 0 && (component = this.getCellRenderer(n, n2).getTableCellRendererComponent(this, this.getValueAt(n, n2), false, false, n, n2)).getPreferredSize().getWidth() > this.getCellRect(n, n2, true).getWidth()) {
            return this.getText(n, n2);
        }
        return null;
    }

    public String getColumnToolTipText(int n) {
        String string = this.getModel().getColumnName(this.convertColumnIndexToModel(n));
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return this.getModel().getColumnName(this.convertColumnIndexToModel(n));
    }

    public int getColumnMaxLength(int n) {
        return -1;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String string) {
        this.subtitle = string;
    }

    protected TableCellEditor getTypeEditor() {
        return this.typeEditor;
    }

    protected TableCellEditor getMeasureEditor() {
        return this.measureEditor;
    }

    protected TableCellEditor getUnitAndTypeEditor() {
        return this.unitAndTypeEditor;
    }

    protected TableCellEditor getUnitAndMeasureEditor() {
        return this.unitAndMeasureEditor;
    }

    protected TableCellEditor getStringEditor() {
        return this.getStringEditor(-1);
    }

    protected TableCellEditor getStringEditor(int n) {
        EasTextField easTextField = (EasTextField)this.stringEditor.getComponent();
        if (n == -1) {
            easTextField.setMaxLength(-1);
        } else {
            easTextField.setMaxLength(this.getColumnMaxLength(n));
        }
        return this.stringEditor;
    }

    protected TableCellEditor getNumberEditor() {
        return this.getNumberEditor(-1);
    }

    protected TableCellEditor getNumberEditor(int n) {
        EasTextField easTextField = (EasTextField)this.numberEditor.getComponent();
        if (n == -1) {
            easTextField.setMaxLength(-1);
        } else {
            easTextField.setMaxLength(this.getColumnMaxLength(n));
        }
        return this.numberEditor;
    }

    public void setPopupHandler(ListPopupHandler listPopupHandler) {
        this.popupHandler = listPopupHandler;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.popupHandler == null) {
            return;
        }
        if ((mouseEvent.getModifiers() & 4) == 0) {
            return;
        }
        if (this.isEnabled() && this.popupHandler != null) {
            this.popupHandler.openPopup(this, -1, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public JScrollPane getScrollPane() {
        if (this.sp != null) {
            return this.sp;
        }
        EasTableViewport easTableViewport = new EasTableViewport(this.getBackground());
        easTableViewport.addMouseListener(this);
        easTableViewport.add(this);
        this.sp = new JScrollPane();
        this.sp.setViewport(easTableViewport);
        return this.sp;
    }

    protected int getColumnWeight(int n) {
        return 0;
    }

    public void doLayout() {
        int n;
        double d;
        double d2 = 0.0;
        double[] dArray = new double[this.getModel().getColumnCount()];
        int n2 = 0;
        boolean bl = true;
        double d3 = 2.0;
        int n3 = this.getSize().width;
        for (int i = 0; i < dArray.length; ++i) {
            double d4 = this.calculatePreferredColumnWidth(i);
            dArray[i] = d4 + d3 + d3 + (double)bl;
            d2 += dArray[i];
            n2 += this.getColumnWeight(i);
        }
        if ((d2 += (double)bl) >= (double)n3) {
            d = d2 - (double)n3;
            for (n = 0; n < dArray.length; ++n) {
                if (this.getColumnWeight(n) == 0) {
                    if (n <= 0) continue;
                    dArray[n] = dArray[n] - d * dArray[n] / (d2 - dArray[0]);
                    continue;
                }
                dArray[n] = dArray[n] - d * (double)this.getColumnWeight(n) / (double)n2;
            }
        } else {
            d = (double)n3 - d2;
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = this.getColumnWeight(n) == 0 ? dArray[n] + d * dArray[n] / d2 : dArray[n] + d * (double)this.getColumnWeight(n) / (double)n2;
            }
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth((int)dArray[i]);
        }
        super.doLayout();
    }

    public List getPagePrinters(PageFormat pageFormat) {
        double d;
        double d2;
        ArrayList<EasTablePage> arrayList = new ArrayList<EasTablePage>();
        double d3 = 0.0;
        double[] dArray = new double[this.getModel().getColumnCount()];
        int n = 0;
        double d4 = 3.0;
        double d5 = 1.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d6 = this.calculatePreferredColumnWidth(i);
            dArray[i] = d6 + d4 + d4 + d5;
            d3 += dArray[i];
            n += this.getColumnWeight(i);
        }
        if ((d3 += 1.0) >= pageFormat.getImageableWidth()) {
            d2 = d3 - pageFormat.getImageableWidth();
            d = d2 / d3;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = dArray[i] - dArray[i] * d;
                if (!(dArray[i] <= 7.0)) continue;
                dArray[i] = 8.0;
            }
        } else {
            d2 = pageFormat.getImageableWidth() - d3;
            for (int i = 0; i < dArray.length; ++i) {
                if (this.getColumnWeight(i) == 0) {
                    if (n != 0) continue;
                    dArray[i] = dArray[i] + d2 * dArray[i] / d3;
                    continue;
                }
                dArray[i] = dArray[i] + d2 * (double)this.getColumnWeight(i) / (double)n;
            }
        }
        EasTablePage easTablePage = new EasTablePage(pageFormat, dArray);
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            d = easTablePage.addRow(i);
            if (!(d > 0.0)) continue;
            arrayList.add(easTablePage);
            easTablePage = easTablePage.nextPage(d);
        }
        arrayList.add(easTablePage);
        return arrayList;
    }

    protected Font getCellFont() {
        if (this.cellFont == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, Theme.widget().getTextFont().getName());
            hashMap.put(TextAttribute.SIZE, new Float(12.0f));
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            this.cellFont = new Font(hashMap);
        }
        return this.cellFont;
    }

    protected Font getHeaderFont() {
        if (this.headerFont == null) {
            this.headerFont = this.getCellFont().deriveFont(1);
        }
        return this.headerFont;
    }

    protected Font getTitleFont() {
        if (this.titleFont == null) {
            this.titleFont = this.getCellFont().deriveFont(1, 16.0f);
        }
        return this.titleFont;
    }

    protected Font getSubtitleFont() {
        if (this.subtitleFont == null) {
            this.subtitleFont = this.getCellFont().deriveFont(14.0f);
        }
        return this.subtitleFont;
    }

    protected FontMetrics getCellFontMetrics() {
        if (this.cellFontMetrics == null) {
            this.cellFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getCellFont());
        }
        return this.cellFontMetrics;
    }

    protected FontMetrics getHeaderFontMetrics() {
        if (this.headerFontMetrics == null) {
            this.headerFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getHeaderFont());
        }
        return this.headerFontMetrics;
    }

    protected FontMetrics getTitleFontMetrics() {
        if (this.titleFontMetrics == null) {
            this.titleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getTitleFont());
        }
        return this.titleFontMetrics;
    }

    protected FontMetrics getSubtitleFontMetrics() {
        if (this.subtitleFontMetrics == null) {
            this.subtitleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getSubtitleFont());
        }
        return this.subtitleFontMetrics;
    }

    protected double calculatePreferredColumnWidth(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        int n3 = this.getHeaderFontMetrics().stringWidth(this.getModel().getColumnName(n2));
        for (int i = 0; i < this.getModel().getRowCount(); ++i) {
            JLabel jLabel = (JLabel)this.getCellRenderer(i, n).getTableCellRendererComponent(this, this.getModel().getValueAt(i, n2), false, false, i, n);
            n3 = Math.max(n3, this.getCellFontMetrics().stringWidth(jLabel.getText()));
        }
        return n3;
    }

    public String getText(int n, int n2) {
        Component component = this.getCellRenderer(n, n2).getTableCellRendererComponent(this, this.getValueAt(n, n2), false, false, n, n2);
        String string = null;
        if (component instanceof JLabel) {
            string = ((JLabel)component).getText();
        } else {
            Object object = this.getValueAt(n, n2);
            if (object != null) {
                string = object.toString();
            }
        }
        return string == null ? "" : string;
    }

    public byte[] getCSV() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(byteArrayOutputStream));
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        for (n = 0; n < n3; ++n) {
            printWriter.print(this.getColumnName(n));
            printWriter.print(',');
        }
        printWriter.println();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    printWriter.print(',');
                }
                printWriter.print(this.csvEscape(this.getText(n, i)));
            }
            printWriter.println();
        }
        printWriter.flush();
        printWriter.close();
        return byteArrayOutputStream.toByteArray();
    }

    public String csvEscape(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    stringBuffer.append('\"');
                }
                case '\n': 
                case ',': {
                    bl = true;
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        if (bl) {
            stringBuffer.append('\"');
            stringBuffer.insert(0, '\"');
        }
        return stringBuffer.toString();
    }

    protected NavigationManager getNavigationManager() {
        Container container = this;
        while (!(container instanceof NavigationManager)) {
            if ((container = container.getParent()) != null) continue;
            return null;
        }
        return (NavigationManager)((Object)container);
    }

    protected void downloadCSV() {
        this.getNavigationManager().open(this.getCSV(), "text/comma-separated-values", "csv", "_new");
    }

    protected void copyCSVToClipboard() {
        StringSelection stringSelection = new StringSelection(new String(this.getCSV()));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    public void setRowModel(RowModel rowModel) {
        if (!(this.getModel() instanceof RowMappedTableModel)) {
            throw new IllegalStateException("Cannot apply a row model to a table model that isn't a RowMappedTableModel");
        }
        ((RowMappedTableModel)this.getModel()).setRowModel(rowModel);
    }

    public RowModel getRowModel() {
        if (this.getModel() instanceof RowMappedTableModel) {
            return ((RowMappedTableModel)this.getModel()).getRowModel();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DefaultPopup
    extends EasPopupMenu {
        public DefaultPopup() {
            this.add(new EasPopupMenu.EasPopupMenuItem(EasTable.this.lex.getText("exportNewWindow"), 0, null));
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    EasTable.this.downloadCSV();
                    break;
                }
                case 1: {
                    EasTable.this.copyCSVToClipboard();
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private class EasTablePage
    implements Printable {
        private double titleHeight;
        private double headerHeight;
        private ArrayList headers;
        private PageFormat pageFormat;
        private double[] columnWidth;
        private double[] columnPosition;
        private double totalHeight;
        private ArrayList rowIndexes;
        private int remainingRowIndex;

        public EasTablePage(PageFormat pageFormat, double[] dArray) {
            this.columnWidth = dArray;
            this.pageFormat = pageFormat;
            this.initHeaders();
            this.initColumnPosition();
            this.totalHeight = this.headerHeight + this.titleHeight;
            this.rowIndexes = new ArrayList();
        }

        private EasTablePage(PageFormat pageFormat, double[] dArray, double d, double d2, ArrayList arrayList, double d3, int n) {
            this.columnWidth = dArray;
            this.initColumnPosition();
            this.pageFormat = pageFormat;
            this.headerHeight = d;
            this.titleHeight = d2;
            this.totalHeight = d3;
            this.headers = arrayList;
            this.rowIndexes = new ArrayList();
            if (n >= 0) {
                this.rowIndexes.add(new Integer(n));
            }
        }

        private void initColumnPosition() {
            double d = 0.0;
            this.columnPosition = new double[this.columnWidth.length];
            for (int i = 0; i < this.columnWidth.length; ++i) {
                this.columnPosition[i] = d;
                d += this.columnWidth[i];
            }
        }

        public EasTablePage nextPage(double d) {
            EasTablePage easTablePage = new EasTablePage(this.pageFormat, this.columnWidth, this.headerHeight, this.titleHeight, this.headers, d, this.remainingRowIndex);
            return easTablePage;
        }

        public double addRow(int n) {
            double d = 0.0;
            double d2 = 3.0;
            double d3 = 1.0;
            for (int i = 0; i < EasTable.this.getModel().getColumnCount(); ++i) {
                JLabel jLabel = (JLabel)EasTable.this.getCellRenderer(n, i).getTableCellRendererComponent(EasTable.this, EasTable.this.getModel().getValueAt(n, i), false, false, n, i);
                double d4 = this.columnWidth[i] - d2 - d2 - d3;
                ArrayList arrayList = this.getCellLines(jLabel.getText(), EasTable.this.getCellFontMetrics(), d4);
                d = Math.max(d, d2 + d2 + d3 + (double)(arrayList.size() * EasTable.this.getCellFontMetrics().getHeight()));
            }
            this.rowIndexes.add(new Integer(n));
            if (this.totalHeight + d + d3 > this.pageFormat.getImageableHeight()) {
                this.remainingRowIndex = n;
                return this.headerHeight + this.titleHeight;
            }
            this.totalHeight += d;
            return 0.0;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            String string;
            Iterator iterator;
            ArrayList arrayList;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            int n7 = 3;
            int n8 = 1;
            int n9 = 0;
            int n10 = (int)(this.columnPosition[this.columnPosition.length - 1] + this.columnWidth[this.columnPosition.length - 1] + 1.0);
            if (EasTable.this.getTitle() != null) {
                graphics2D.setColor(Color.black);
                graphics2D.setFont(EasTable.this.getTitleFont());
                arrayList = this.getCellLines(EasTable.this.getTitle(), EasTable.this.getTitleFontMetrics(), n10);
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    n6 = EasTable.this.getTitleFontMetrics().stringWidth(string);
                    n5 = n10 / 2 - n6 / 2;
                    n4 = n9 + n7 + EasTable.this.getTitleFontMetrics().getHeight() - EasTable.this.getTitleFontMetrics().getDescent();
                    graphics2D.drawString(string, n5, n4);
                    n9 += n7 + EasTable.this.getTitleFontMetrics().getHeight();
                }
            }
            if (EasTable.this.getSubtitle() != null) {
                graphics2D.setColor(Color.black);
                graphics2D.setFont(EasTable.this.getSubtitleFont());
                arrayList = this.getCellLines(EasTable.this.getSubtitle(), EasTable.this.getSubtitleFontMetrics(), n10);
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    n6 = EasTable.this.getSubtitleFontMetrics().stringWidth(string);
                    n5 = n10 / 2 - n6 / 2;
                    n4 = n9 + EasTable.this.getSubtitleFontMetrics().getHeight() - EasTable.this.getSubtitleFontMetrics().getDescent();
                    graphics2D.drawString(string, n5, n4);
                    n9 += n7 + EasTable.this.getSubtitleFontMetrics().getHeight();
                }
            }
            int n11 = n9;
            graphics2D.setFont(EasTable.this.getHeaderFont());
            iterator = new Color(153, 153, 153);
            for (n3 = 0; n3 < EasTable.this.getModel().getColumnCount(); ++n3) {
                graphics2D.setColor(Color.black);
                graphics2D.drawLine((int)this.columnPosition[n3], n11, (int)this.columnPosition[n3], n11 + (int)this.headerHeight);
                graphics2D.setColor((Color)((Object)iterator));
                graphics2D.fillRect((int)this.columnPosition[n3], n11, (int)this.columnWidth[n3], (int)this.headerHeight);
                ArrayList arrayList2 = (ArrayList)this.headers.get(n3);
                for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                    String string2 = (String)arrayList2.get(n5);
                    int n12 = EasTable.this.getHeaderFontMetrics().stringWidth(string2);
                    n2 = (int)(this.columnPosition[n3] + this.columnWidth[n3] / 2.0 - (double)(n12 / 2));
                    int n13 = n9 + n7 + (n5 + 1) * EasTable.this.getHeaderFontMetrics().getHeight() - EasTable.this.getHeaderFontMetrics().getDescent();
                    graphics2D.setColor(Color.white);
                    graphics2D.drawString(string2, n2, n13);
                }
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(0, n11, n10, n11);
            graphics2D.drawLine(n10, n11, n10, n9 += (int)this.headerHeight);
            graphics2D.setFont(EasTable.this.getCellFont());
            for (n3 = 0; n3 < this.rowIndexes.size(); ++n3) {
                int n14 = (Integer)this.rowIndexes.get(n3);
                n5 = 0;
                for (int i = 0; i < EasTable.this.getModel().getColumnCount(); ++i) {
                    int n15;
                    JLabel jLabel = (JLabel)EasTable.this.getCellRenderer(n14, i).getTableCellRendererComponent(EasTable.this, EasTable.this.getModel().getValueAt(n14, i), false, false, n14, i);
                    n2 = (int)(this.columnWidth[i] - (double)n7 - (double)n7 - (double)n8);
                    ArrayList arrayList3 = this.getCellLines(jLabel.getText(), EasTable.this.getCellFontMetrics(), n2);
                    for (n15 = 0; n15 < arrayList3.size(); ++n15) {
                        String string3 = (String)arrayList3.get(n15);
                        int n16 = EasTable.this.getCellFontMetrics().stringWidth(string3);
                        int n17 = jLabel.getHorizontalAlignment() == 4 ? (int)(this.columnPosition[i] + this.columnWidth[i] - (double)n7 - (double)n16) : (jLabel.getHorizontalAlignment() == 0 ? (int)(this.columnPosition[i] + this.columnWidth[i] / 2.0 - (double)(n16 / 2)) : (int)(this.columnPosition[i] + (double)n7));
                        int n18 = n9 + n7 + (n15 + 1) * EasTable.this.getCellFontMetrics().getHeight() - EasTable.this.getCellFontMetrics().getDescent();
                        graphics2D.drawString(string3, n17, n18);
                    }
                    n15 = EasTable.this.getCellFontMetrics().getHeight() * arrayList3.size() + n7 + n7 + n8;
                    n5 = Math.max(n15, n5);
                }
                graphics2D.drawLine(0, n9, n10, n9);
                graphics2D.drawLine(n10, n9, n10, n9 + n5);
                n9 += n5;
            }
            for (n3 = 0; n3 < EasTable.this.getModel().getColumnCount(); ++n3) {
                graphics2D.drawLine((int)this.columnPosition[n3], n11, (int)this.columnPosition[n3], n9);
            }
            graphics2D.drawLine(n10 + 1, n11, n10 + 1, n9 + 1);
            graphics2D.drawLine(0, n9 + 1, n10 + 1, n9 + 1);
            return 0;
        }

        protected void initHeaders() {
            this.headerHeight = 0.0;
            this.titleHeight = 0.0;
            double d = 3.0;
            double d2 = 1.0;
            this.headers = new ArrayList();
            for (int i = 0; i < EasTable.this.getModel().getColumnCount(); ++i) {
                double d3 = this.columnWidth[i] - d - d - d2;
                ArrayList arrayList = this.getCellLines(EasTable.this.getModel().getColumnName(i), EasTable.this.getHeaderFontMetrics(), d3);
                this.headers.add(arrayList);
                this.headerHeight = Math.max(this.headerHeight, d + d + d2 + (double)(arrayList.size() * EasTable.this.getHeaderFontMetrics().getHeight()));
            }
            if (EasTable.this.getTitle() != null) {
                ArrayList arrayList = this.getCellLines(EasTable.this.getTitle(), EasTable.this.getHeaderFontMetrics(), this.pageFormat.getImageableWidth());
                this.titleHeight += (double)arrayList.size() * ((double)EasTable.this.getTitleFontMetrics().getHeight() + d);
            }
            if (EasTable.this.getSubtitle() != null) {
                ArrayList arrayList = this.getCellLines(EasTable.this.getTitle(), EasTable.this.getHeaderFontMetrics(), this.pageFormat.getImageableWidth());
                this.titleHeight += (double)arrayList.size() * ((double)EasTable.this.getTitleFontMetrics().getHeight() + d);
            }
        }

        private ArrayList getCellLines(String string, FontMetrics fontMetrics, double d) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((double)fontMetrics.stringWidth(string) <= d) {
                arrayList.add(string);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    StringBuffer stringBuffer2 = new StringBuffer().append(stringBuffer.toString());
                    String string3 = stringBuffer.length() == 0 ? "" : " ";
                    if ((double)fontMetrics.stringWidth(stringBuffer2.append(string3).append(string2).toString()) > d) {
                        if (stringBuffer.length() == 0) {
                            stringBuffer = new StringBuffer(string2);
                            while ((double)fontMetrics.stringWidth(stringBuffer.toString()) > d) {
                                StringBuffer stringBuffer3 = new StringBuffer();
                                while ((double)fontMetrics.stringWidth(stringBuffer3.toString()) <= d) {
                                    stringBuffer3.append(stringBuffer.charAt(0));
                                    stringBuffer.deleteCharAt(0);
                                }
                                arrayList.add(stringBuffer3.toString());
                            }
                            continue;
                        }
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer(string2);
                        continue;
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string2);
                }
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                }
            }
            return arrayList;
        }
    }

    public class EasTableHeader
    extends JTableHeader {
        private long whenClicked = -1L;

        public EasTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    EasTableHeader.this.whenClicked = mouseEvent.getWhen();
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 0x10) > 0 && EasTable.this.getModel() instanceof RowMappedTableModel && mouseEvent.getWhen() - EasTableHeader.this.whenClicked < 200L) {
                        int n = EasTableHeader.this.columnAtPoint(mouseEvent.getPoint());
                        int n2 = EasTable.this.convertColumnIndexToModel(n);
                        RowModel rowModel = EasTable.this.getRowModel();
                        int n3 = 1;
                        TableColumn tableColumn = EasTable.this.getColumnModel().getColumn(n);
                        if (rowModel != null && rowModel instanceof SortedRowModel) {
                            SortedRowModel sortedRowModel = (SortedRowModel)rowModel;
                            if (sortedRowModel.getSortColumn() != n2) {
                                TableColumn tableColumn2 = EasTable.this.getColumnModel().getColumn(sortedRowModel.getSortViewColumn());
                                tableColumn2.setHeaderRenderer(tableColumn.getHeaderRenderer());
                            } else {
                                n3 = -1 * sortedRowModel.getDirection();
                            }
                        }
                        EasTable.this.setRowModel(new SortedRowModel(EasTable.this, n2, n3));
                        tableColumn.setHeaderRenderer(new SortedHeaderRenderer(n3));
                    }
                }
            });
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.columnAtPoint(mouseEvent.getPoint());
            if (n >= 0) {
                return EasTable.this.getColumnToolTipText(n);
            }
            return null;
        }
    }

    static class EasTableViewport
    extends JViewport {
        private Color color;

        public EasTableViewport(Color color) {
            this.color = color;
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public static class NoFocusCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }
}

