/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.ResourceManager;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class EasListCellRenderer
extends DefaultListCellRenderer {
    private Icon groupIcon = null;
    private Icon siteIcon = null;
    private Icon dataPointIcon = null;
    private Icon stationIcon = null;
    private Icon meterIcon = null;

    public EasListCellRenderer(ResourceManager resourceManager) {
        this.groupIcon = new ImageIcon(resourceManager.getIconImage(4));
        this.siteIcon = new ImageIcon(resourceManager.getIconImage(7));
        this.dataPointIcon = new ImageIcon(resourceManager.getIconImage(10));
        this.stationIcon = new ImageIcon(resourceManager.getIconImage(1));
        this.meterIcon = new ImageIcon(resourceManager.getIconImage(26));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        try {
            if (object instanceof Group) {
                Group group = (Group)object;
                jLabel.setText(group.getName());
                if (group instanceof Site) {
                    jLabel.setIcon(this.siteIcon);
                } else {
                    jLabel.setIcon(this.groupIcon);
                }
            } else if (object instanceof DataPoint) {
                DataPoint dataPoint = (DataPoint)object;
                jLabel.setIcon(this.dataPointIcon);
                String string = dataPoint.getDescr();
                if (dataPoint.getMeter() != null) {
                    string = dataPoint.getMeter().getName() + " " + string;
                }
                jLabel.setText(string + " (" + dataPoint.getSite().getName() + ")");
            } else if (object instanceof Meter) {
                Meter meter = (Meter)object;
                jLabel.setIcon(this.meterIcon);
                jLabel.setText(meter.getName() + " (" + meter.getSite().getName() + ")");
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return jLabel;
    }
}

