/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class DaysOfWeekEditor
extends JComponent
implements MouseListener {
    private static final int MARGIN = 2;
    private static final String[] tags = new String[]{"sunday.short", "monday.short", "tuesday.short", "wednesday.short", "thursday.short", "friday.short", "saturday.short"};
    private int value;
    private int buttonWidth;
    private int buttonHeight;
    private int baseline;
    private int maxTag = -1;
    private int[] tagLens;
    private FontMetrics fm;
    private Font font;
    private Color fg;
    private Color bg;
    private Color selFg;
    private Color selBg;
    private boolean editable = true;
    public Lexicon lex;

    public DaysOfWeekEditor(Lexicon lexicon) {
        this(127, lexicon);
    }

    public DaysOfWeekEditor(int n, Lexicon lexicon) {
        this.lex = lexicon;
        this.setValue(n);
        this.addMouseListener(this);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        if (this.editable) {
            this.addMouseListener(this);
        } else {
            this.removeMouseListener(this);
        }
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    private void updateUiData() {
        if (this.fm == null) {
            this.font = UIManager.getFont("Table.font");
            this.font = new Font(Theme.widget().getTextFont().getName(), this.font.getStyle(), 10);
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.fg = UIManager.getColor("Table.foreground");
            this.bg = UIManager.getColor("Table.background");
            this.selFg = UIManager.getColor("Table.selectionForeground");
            this.selBg = UIManager.getColor("Table.selectionBackground");
        }
    }

    public Dimension getPreferredSize() {
        this.updateUiData();
        this.updateTagData();
        int n = (this.maxTag + 4) * tags.length + 1;
        int n2 = this.fm.getAscent() + 4;
        return new Dimension(n, n2);
    }

    public void doLayout() {
        this.updateUiData();
        this.updateTagData();
        this.buttonWidth = this.maxTag + 4;
        this.buttonHeight = this.fm.getAscent() + 4;
        this.baseline = this.fm.getAscent();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.updateUiData();
        this.updateTagData();
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setFont(this.font);
        graphics2D.setColor(this.bg);
        graphics2D.fillRect(0, 0, n, n2);
        int n3 = 0;
        int n4 = tags.length;
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            bl = (this.value & 1 << i) != 0;
            graphics2D.setColor(this.fg);
            graphics2D.drawRect(n3, 0, this.buttonWidth, this.buttonHeight - 1);
            if (bl) {
                graphics2D.setColor(this.selBg);
                graphics2D.fillRect(n3 + 1, 1, this.buttonWidth - 1, this.buttonHeight - 2);
                graphics2D.setColor(this.selFg);
            }
            graphics2D.drawString(this.lex.getText(tags[i]), n3 + (this.buttonWidth - this.tagLens[i]) / 2, this.baseline);
            if (!bl) {
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.red);
                graphics2D.drawLine(n3 + 1, 1, n3 + this.buttonWidth - 1, this.buttonHeight - 2);
                graphics2D.drawLine(n3 + 1, this.buttonHeight - 2, n3 + this.buttonWidth - 1, 1);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
            n3 += this.buttonWidth;
        }
    }

    private void updateTagData() {
        if (this.tagLens == null) {
            this.updateUiData();
            this.maxTag = 0;
            this.tagLens = new int[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                this.tagLens[i] = this.fm.stringWidth(this.lex.getText(tags[i]));
                this.maxTag = Math.max(this.tagLens[i], this.maxTag);
            }
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = mouseEvent.getX();
        int n2 = n / this.buttonWidth;
        if (n2 >= 0 && n2 < tags.length) {
            this.value ^= 1 << n2;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        DaysOfWeekEditor daysOfWeekEditor = new DaysOfWeekEditor(null);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setLayout(new FlowLayout());
        jComponent.add(daysOfWeekEditor);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setBounds(300, 300, 300, 300);
        jFrame.setVisible(true);
    }
}

