/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DateEditor
extends JComponent
implements MouseListener,
ActionListener,
FocusListener,
KeyListener {
    private static final int MARGIN = 2;
    private static final int DAY = 0;
    private static final int MONTH = 1;
    private static final int YEAR = 2;
    private static final int INIT_DELAY = 3;
    private static final String[] monthNames = new String[]{"january.short", "february.short", "march.short", "april.short", "may.short", "june.short", "july.short", "august.short", "september.short", "october.short", "november.short", "december.short"};
    private DateField dateField = new DateField();
    private JButton upButton;
    private JButton downButton;
    private JButton activeButton;
    private Timer timer;
    private int pulseDelay = 0;
    private Vector listeners;
    private boolean editable = true;
    public Lexicon lex;

    public DateEditor(Lexicon lexicon) {
        this.add((Component)this.dateField, "Center");
        this.upButton = new JButton(new ArrowIcon(4, 3, true));
        this.upButton.addMouseListener(this);
        this.upButton.addFocusListener(this);
        this.upButton.addKeyListener(this);
        this.add(this.upButton);
        this.downButton = new JButton(new ArrowIcon(4, 3, false));
        this.downButton.addMouseListener(this);
        this.downButton.addFocusListener(this);
        this.downButton.addKeyListener(this);
        this.add(this.downButton);
        this.lex = lexicon;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        if (bl == this.editable) {
            return;
        }
        this.editable = bl;
        this.dateField.setEditable(this.editable);
        this.upButton.setVisible(this.editable);
        this.downButton.setVisible(this.editable);
        this.upButton.setEnabled(this.editable);
        this.downButton.setEnabled(this.editable);
    }

    public boolean getAllowFuture() {
        return this.dateField.getAllowFuture();
    }

    public void setAllowFuture(boolean bl) {
        this.dateField.setAllowFuture(bl);
    }

    public EasLocalTime getValue() {
        return this.dateField.getValue();
    }

    public EasLocalTime getEndValue() {
        return this.dateField.getEndValue();
    }

    public void setValue(EasLocalTime easLocalTime) {
        this.dateField.setValue(easLocalTime);
    }

    public void clearTime() {
        this.dateField.clearTime();
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(actionListener);
    }

    void fireActionEvent() {
        if (this.listeners == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(actionEvent);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.dateField.getPreferredSize();
        int n = dimension.width + dimension.height;
        int n2 = dimension.height;
        return new Dimension(n, n2);
    }

    public void doLayout() {
        Dimension dimension = this.dateField.getPreferredSize();
        this.dateField.setBounds(0, 0, dimension.width, dimension.height);
        int n = dimension.height / 2;
        int n2 = dimension.height;
        this.upButton.setBounds(dimension.width, 0, n2, n);
        this.downButton.setBounds(dimension.width, n, n2, this.getHeight() - n);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.dateField.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.dateField.repaint();
    }

    public boolean containsFocus() {
        return this.dateField.hasFocus() || this.upButton.hasFocus() || this.downButton.hasFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (!this.editable) {
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer(50, this);
            this.timer.setRepeats(true);
            this.timer.setCoalesce(true);
        }
        if ((object = mouseEvent.getSource()) == this.upButton) {
            this.dateField.incrementSelection();
            this.activeButton = this.upButton;
            this.pulseDelay = 3;
            this.timer.start();
        } else if (object == this.downButton) {
            this.dateField.decrementSelection();
            this.activeButton = this.downButton;
            this.pulseDelay = 3;
            this.timer.start();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.editable) {
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.activeButton = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            if (this.pulseDelay != 0) {
                --this.pulseDelay;
                return;
            }
            if (this.activeButton == this.upButton) {
                this.dateField.incrementSelection();
            } else if (this.activeButton == this.downButton) {
                this.dateField.decrementSelection();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 32) {
            Object object;
            if (this.timer == null) {
                this.timer = new Timer(50, this);
                this.timer.setRepeats(true);
                this.timer.setCoalesce(true);
            }
            if ((object = keyEvent.getSource()) == this.upButton) {
                this.dateField.incrementSelection();
                this.activeButton = this.upButton;
                this.pulseDelay = 3;
                this.timer.start();
            } else if (object == this.downButton) {
                this.dateField.decrementSelection();
                this.activeButton = this.downButton;
                this.pulseDelay = 3;
                this.timer.start();
            }
        } else {
            this.dateField.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.activeButton != null) {
            this.activeButton = null;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        DateEditor dateEditor = new DateEditor(null);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setLayout(new FlowLayout());
        jComponent.add(dateEditor);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setBounds(300, 300, 300, 300);
        jFrame.setVisible(true);
    }

    public class ArrowIcon
    implements Icon {
        private boolean up = true;
        private int width;
        private int height;

        public ArrowIcon(boolean bl) {
            this(3, 2, bl);
        }

        public ArrowIcon(int n, int n2, boolean bl) {
            this.width = n;
            this.height = n2;
            this.up = bl;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(component.getForeground());
            if (this.up) {
                graphics.drawLine(n + 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 + 1, n + 2, n2 + 1);
            } else {
                graphics.drawLine(n, n2, n + 2, n2);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            }
        }
    }

    public class DateField
    extends JComponent
    implements KeyListener,
    FocusListener,
    MouseListener {
        private int day;
        private int month;
        private int year;
        private int hr = 0;
        private int min = 0;
        private int sec = 0;
        private int millis = 0;
        private int thisDay;
        private int thisMonth;
        private int thisYear;
        private int maxDay;
        private int maxMonth;
        private int maxYear;
        private boolean allowFuture = false;
        private Font font;
        private FontMetrics fm;
        private int digitWidth;
        private Border border;
        private Insets borderInsets;
        private Color fg;
        private Color bg;
        private Color selFg;
        private Color selBg;
        private int baseline;
        private int[] fieldLocs;
        private int[] fieldWidths;
        private int fieldHeight;
        private int selection = -1;
        private boolean newSelection = false;

        public DateField() {
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.addMouseListener(this);
            Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
            calendar.setTime(new Date(System.currentTimeMillis()));
            this.thisDay = calendar.get(5);
            this.thisMonth = calendar.get(2) - 0;
            this.thisYear = calendar.get(1);
            this.setValue(new EasLocalTime(this.thisYear, this.thisMonth, this.thisDay));
        }

        public void setEditable(boolean bl) {
            if (!bl) {
                this.removeKeyListener(this);
                this.removeFocusListener(this);
                this.removeMouseListener(this);
            } else {
                this.addKeyListener(this);
                this.addFocusListener(this);
                this.addMouseListener(this);
            }
        }

        public EasLocalTime getValue() {
            return new EasLocalTime(this.year, this.month, this.day, this.hr, this.min, this.sec, this.millis);
        }

        public EasLocalTime getEndValue() {
            return new EasLocalTime(this.year, this.month, this.day, 24, 0, 0, 0);
        }

        public void setValue(EasLocalTime easLocalTime) {
            this.year = easLocalTime.getYear();
            this.month = easLocalTime.getMonth();
            this.day = easLocalTime.getDay();
            this.updateValidRange();
            this.hr = easLocalTime.getHour();
            this.min = easLocalTime.getMinute();
            this.sec = easLocalTime.getSecond();
            this.millis = easLocalTime.getMillisecond();
            this.repaint();
        }

        public void clearTime() {
            this.hr = 0;
            this.min = 0;
            this.sec = 0;
            this.millis = 0;
        }

        public void setFont(Font font) {
            this.font = font;
            this.fm = null;
        }

        public void setAllowFuture(boolean bl) {
            this.allowFuture = bl;
            this.updateValidRange();
        }

        public boolean getAllowFuture() {
            return this.allowFuture;
        }

        private void updateValidRange() {
            this.maxYear = !this.allowFuture ? this.thisYear : 9999;
            this.maxMonth = !this.allowFuture ? (this.year == this.thisYear ? this.thisMonth : 11) : 11;
            this.maxDay = !this.allowFuture ? (this.year == this.thisYear && this.month == this.thisMonth ? this.thisDay : ReportPeriod.getDaysInMonth(this.month, this.year)) : ReportPeriod.getDaysInMonth(this.month, this.year);
            if (this.year >= this.maxYear) {
                this.year = this.maxYear;
                this.repaint();
            }
            if (this.day > this.maxDay) {
                this.day = this.maxDay;
                this.repaint();
            }
            if (this.month > this.maxMonth) {
                this.month = this.maxMonth;
                this.repaint();
            }
        }

        private void updateUiData() {
            if (this.fm == null) {
                if (this.font == null) {
                    this.font = new Font(Theme.widget().getLargeFont().getName(), 0, 10);
                }
                this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
                this.border = UIManager.getBorder("TextField.border");
                this.borderInsets = this.border.getBorderInsets(this);
                this.setBorder(this.border);
                this.fg = UIManager.getColor("TextField.foreground");
                this.bg = UIManager.getColor("TextField.background");
                this.selFg = UIManager.getColor("TextField.selectionForeground");
                this.selBg = UIManager.getColor("TextField.selectionBackground");
                this.digitWidth = this.fm.stringWidth("0");
            }
        }

        public Dimension getPreferredSize() {
            this.updateUiData();
            int n = 0;
            int n2 = 0;
            n = this.fm.stringWidth("00 JAN 0000") + 4 + this.borderInsets.left + this.borderInsets.right;
            n2 = this.fm.getAscent() + 4 + this.borderInsets.top + this.borderInsets.bottom;
            if (n2 % 2 != 0) {
                ++n2;
            }
            return new Dimension(n, n2);
        }

        public void doLayout() {
            this.updateUiData();
            this.baseline = this.fm.getAscent() + this.borderInsets.top;
            if (this.fieldLocs == null) {
                this.layoutFields();
            }
        }

        private void layoutFields() {
            int n;
            this.fieldHeight = this.getHeight() - this.borderInsets.top - this.borderInsets.bottom;
            this.fieldWidths = new int[3];
            this.fieldWidths[0] = this.fm.stringWidth("00");
            this.fieldWidths[2] = this.fm.stringWidth("0000");
            int n2 = 0;
            for (n = 0; n < monthNames.length; ++n) {
                n2 = Math.max(n2, this.fm.stringWidth(DateEditor.this.lex.getText(monthNames[n])));
            }
            this.fieldWidths[1] = n2;
            n = this.fm.stringWidth(" ");
            this.fieldLocs = new int[3];
            this.fieldLocs[0] = this.border.getBorderInsets((Component)this).left;
            this.fieldLocs[1] = this.fieldLocs[0] + this.fieldWidths[0] + n;
            this.fieldLocs[2] = this.fieldLocs[1] + this.fieldWidths[1] + n;
        }

        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(this.bg);
            graphics.fillRect(0, 0, n, n2);
            graphics.setFont(this.font);
            int n3 = 0;
            if (DateEditor.this.containsFocus() && this.selection == 0) {
                graphics.setColor(this.selBg);
                graphics.fillRect(this.fieldLocs[0] - 1, this.borderInsets.top, this.fieldWidths[0] + 3, this.fieldHeight - 1);
                graphics.setColor(this.selFg);
            } else {
                graphics.setColor(this.fg);
            }
            n3 = this.day < 10 ? this.digitWidth : 0;
            graphics.drawString(Integer.toString(this.day), this.fieldLocs[0] + n3, this.baseline);
            if (DateEditor.this.containsFocus() && this.selection == 1) {
                graphics.setColor(this.selBg);
                graphics.fillRect(this.fieldLocs[1] - 1, this.borderInsets.top, this.fieldWidths[1] + 2, this.fieldHeight - 1);
                graphics.setColor(this.selFg);
            } else {
                graphics.setColor(this.fg);
            }
            graphics.drawString(DateEditor.this.lex.getText(monthNames[this.month]), this.fieldLocs[1], this.baseline);
            if (DateEditor.this.containsFocus() && this.selection == 2) {
                graphics.setColor(this.selBg);
                graphics.fillRect(this.fieldLocs[2] - 1, this.borderInsets.top, this.fieldWidths[2] + 2, this.fieldHeight - 1);
                graphics.setColor(this.selFg);
            } else {
                graphics.setColor(this.fg);
            }
            graphics.drawString(Integer.toString(this.year), this.fieldLocs[2], this.baseline);
        }

        public void incrementSelection() {
            if (this.selection == -1) {
                this.selection = 0;
                this.repaint();
                return;
            }
            if (this.selection == 0) {
                ++this.day;
                this.hr = 0;
                this.min = 0;
                this.sec = 0;
                this.millis = 0;
                if (this.day > this.maxDay) {
                    this.day = 1;
                }
            } else if (this.selection == 1) {
                ++this.month;
                this.hr = 0;
                this.min = 0;
                this.sec = 0;
                this.millis = 0;
                if (this.month > this.maxMonth) {
                    this.month = 0;
                }
            } else if (this.selection == 2) {
                ++this.year;
                this.hr = 0;
                this.min = 0;
                this.sec = 0;
                this.millis = 0;
                if (this.year > this.maxYear) {
                    this.year = 1;
                }
            }
            this.updateValidRange();
            this.repaint();
            DateEditor.this.fireActionEvent();
        }

        public void decrementSelection() {
            if (this.selection == -1) {
                this.selection = 0;
                this.repaint();
                return;
            }
            if (this.selection == 0) {
                --this.day;
                this.hr = 0;
                this.min = 0;
                this.sec = 0;
                this.millis = 0;
                if (this.day == 0) {
                    this.day = this.maxDay;
                }
            } else if (this.selection == 1) {
                --this.month;
                this.hr = 0;
                this.min = 0;
                this.sec = 0;
                this.millis = 0;
                if (this.month == -1) {
                    this.month = this.maxMonth;
                }
            } else if (this.selection == 2) {
                --this.year;
                this.hr = 0;
                this.min = 0;
                this.sec = 0;
                this.millis = 0;
                if (this.year == 0) {
                    this.year = this.maxYear;
                }
            }
            this.updateValidRange();
            this.repaint();
            DateEditor.this.fireActionEvent();
        }

        public void modifySelection(char c) {
            if (this.selection == -1) {
                return;
            }
            if (Character.isDigit(c)) {
                if (this.selection == 1) {
                    return;
                }
                if (this.selection == 0) {
                    int n = this.newSelection ? c - 48 : this.day * 10 + c - 48;
                    this.newSelection = false;
                    if (n > this.maxDay) {
                        n = c - 48;
                    }
                    if (n != 0) {
                        this.day = n;
                        this.hr = 0;
                        this.min = 0;
                        this.sec = 0;
                        this.millis = 0;
                    }
                    this.updateValidRange();
                    this.repaint();
                    DateEditor.this.fireActionEvent();
                } else if (this.selection == 2) {
                    int n = this.newSelection ? c - 48 : this.year * 10 + c - 48;
                    this.newSelection = false;
                    if (n > this.maxYear) {
                        n = c - 48;
                    }
                    if (n != 0) {
                        this.year = n;
                        this.hr = 0;
                        this.min = 0;
                        this.sec = 0;
                        this.millis = 0;
                    }
                    this.updateValidRange();
                    this.repaint();
                    DateEditor.this.fireActionEvent();
                }
            } else if (Character.isLetter(c)) {
                if (this.selection != 1) {
                    return;
                }
                char c2 = Character.toUpperCase(c);
                int n = this.month;
                int n2 = (this.month + 1) % (this.maxMonth + 1);
                while (n2 != this.month) {
                    if (DateEditor.this.lex.getText(monthNames[n2]).charAt(0) == c2) {
                        n = n2;
                        break;
                    }
                    n2 = (n2 + 1) % (this.maxMonth + 1);
                }
                if (n != this.month) {
                    this.month = n;
                    this.hr = 0;
                    this.min = 0;
                    this.sec = 0;
                    this.millis = 0;
                    this.updateValidRange();
                    this.repaint();
                    DateEditor.this.fireActionEvent();
                }
            }
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.selection == -1) {
                this.selection = 0;
            }
            this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaint();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 38: {
                    this.incrementSelection();
                    break;
                }
                case 40: {
                    this.decrementSelection();
                    break;
                }
                case 39: {
                    this.selection = this.selection == -1 ? 0 : (this.selection + 1) % 3;
                    this.newSelection = true;
                    this.repaint();
                    break;
                }
                case 37: {
                    if (this.selection == -1) {
                        this.selection = 0;
                    } else {
                        --this.selection;
                        if (this.selection < 0) {
                            this.selection = 2;
                        }
                    }
                    this.newSelection = true;
                    this.repaint();
                    break;
                }
                default: {
                    this.modifySelection(keyEvent.getKeyChar());
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            int n = mouseEvent.getX();
            for (int i = 0; i < 3; ++i) {
                if (n < this.fieldLocs[i] || n >= this.fieldLocs[i] + this.fieldWidths[i]) continue;
                if (this.selection != i) {
                    this.selection = i;
                    this.newSelection = true;
                }
                this.repaint();
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

