/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.SystemColor;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Color color = null;
    private Color dogEarColor = null;
    private Insets insets = null;
    private Dimension size = null;

    public ColorIcon(Color color) {
        this(color, null, new Dimension(16, 16));
    }

    public ColorIcon(Color color, Color color2) {
        this(color, color2, new Dimension(16, 16));
    }

    public ColorIcon(Color color, Dimension dimension) {
        this(color, null, dimension, new Insets(2, 2, 2, 2));
    }

    public ColorIcon(Color color, Color color2, Dimension dimension) {
        this(color, color2, dimension, new Insets(2, 2, 2, 2));
    }

    public ColorIcon(Color color, Dimension dimension, Insets insets) {
        this(color, null, dimension, insets);
    }

    public ColorIcon(Color color, Color color2, Dimension dimension, Insets insets) {
        this.color = color;
        this.dogEarColor = color2;
        this.size = dimension;
        this.insets = insets;
    }

    public int getIconWidth() {
        return this.size.width;
    }

    public int getIconHeight() {
        return this.size.height;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(SystemColor.controlHighlight);
        graphics2D.drawLine(n + this.insets.left, n2 + this.insets.top, n + this.getIconWidth() - this.insets.right - 1, n2 + this.insets.top);
        graphics2D.drawLine(n + this.insets.left, n2 + this.insets.top, n + this.insets.left, n2 + this.getIconHeight() - this.insets.bottom - 1);
        graphics2D.setColor(SystemColor.controlShadow);
        graphics2D.drawLine(n + this.getIconWidth() - this.insets.right - 1, n2 + this.insets.top, n + this.getIconWidth() - this.insets.right - 1, n2 + this.getIconHeight() - this.insets.bottom - 1);
        graphics2D.drawLine(n + this.getIconWidth() - this.insets.right - 1, n2 + this.getIconHeight() - this.insets.bottom - 1, n + this.insets.left, n2 + this.getIconHeight() - this.insets.bottom - 1);
        graphics2D.setColor(this.color);
        graphics2D.fillRect(n + this.insets.left + 1, n2 + this.insets.top + 1, this.getIconWidth() - this.insets.left - this.insets.right - 2, this.getIconHeight() - this.insets.top - this.insets.bottom - 2);
        if (this.dogEarColor != null) {
            graphics2D.setColor(this.dogEarColor);
            Polygon polygon = new Polygon(new int[]{n + this.insets.left + 1, n + this.getIconWidth() - this.insets.right - 3, n + this.insets.left + 1}, new int[]{n2 + this.insets.top + 1, n2 + this.insets.top + 1, n2 + this.getIconHeight() - this.insets.bottom - 3}, 3);
            graphics2D.fill(polygon);
        }
    }

    public void setDogEarColor(Color color) {
        this.dogEarColor = color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

