/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.BaselineReportPeriod;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Period;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.DaysOfWeekEditor;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.baja.util.Lexicon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class BaselineReportPeriodEditor
extends ReportPeriodEditor {
    private ReportPeriodEditor reference = null;
    private boolean persistDuration = false;

    public BaselineReportPeriodEditor(Lexicon lexicon) {
        super(true, lexicon);
    }

    public BaselineReportPeriodEditor(boolean bl, Lexicon lexicon, ReportPeriodEditor reportPeriodEditor, boolean bl2) {
        this.persistDuration = bl2;
        this.reference = reportPeriodEditor;
        reportPeriodEditor.addActionListener(this);
        this.lex = lexicon;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(gridBagLayout);
        Font font = UIManager.getFont("Table.font");
        font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
        this.periodSelector = new XpComboBox();
        this.periodSelector.setFont(font);
        for (int i = 0; i <= 4; ++i) {
            this.periodSelector.addItem(BaselineReportPeriod.getCustomPeriodName(i, this.lex));
        }
        this.periodSelector.addActionListener(this);
        this.add(this.periodSelector);
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.setConstraints(gridBagLayout, 100, 100, 3, 1, 0, 0, this.periodSelector);
        this.startEditor = new DateEditor(this.lex);
        this.startEditor.setAllowFuture(true);
        this.startEditor.setFont(font);
        this.startEditor.addActionListener(this);
        this.add(this.startEditor);
        this.setConstraints(gridBagLayout, 0, 100, 1, 1, 0, 1, this.startEditor);
        JLabel jLabel = new JLabel(this.lex.getText("to"));
        jLabel.setFont(font);
        this.add(jLabel);
        this.setConstraints(gridBagLayout, 0, 100, 1, 1, 1, 1, jLabel);
        this.endEditor = new DateEditor(this.lex);
        this.endEditor.setAllowFuture(true);
        this.endEditor.setFont(font);
        this.endEditor.addActionListener(this);
        this.add(this.endEditor);
        this.setConstraints(gridBagLayout, 100, 100, 1, 1, 2, 1, this.endEditor);
        if (bl) {
            this.gbc.anchor = 10;
            this.gbc.fill = 0;
            this.daysOfWeek = new DaysOfWeekEditor(this.lex);
            this.add(this.daysOfWeek);
            this.setConstraints(gridBagLayout, 100, 100, 3, 1, 0, 2, this.daysOfWeek);
        }
    }

    public Period getValue(boolean bl) {
        int n = this.periodSelector.getSelectedIndex();
        if (n == 0) {
            if (bl) {
                this.validateRange();
            }
            BaselineReportPeriod baselineReportPeriod = new BaselineReportPeriod(this.startEditor.getValue(), this.endEditor.getEndValue(), this.getDaysOfWeek(), this.lex);
            if (this.reference != null) {
                baselineReportPeriod.setReferencePeriod((ReportPeriod)this.reference.getValue(false));
            }
            return baselineReportPeriod;
        }
        if (n == 10 || n == 9) {
            BaselineReportPeriod baselineReportPeriod = new BaselineReportPeriod(n, this.startEditor.getValue(), this.endEditor.getValue(), this.getDaysOfWeek(), this.lex);
            if (this.reference != null) {
                baselineReportPeriod.setReferencePeriod((ReportPeriod)this.reference.getValue(false));
            }
            return baselineReportPeriod;
        }
        BaselineReportPeriod baselineReportPeriod = new BaselineReportPeriod(n, this.startEditor.getValue(), this.endEditor.getEndValue(), this.getDaysOfWeek(), this.lex);
        if (this.reference != null) {
            baselineReportPeriod.setReferencePeriod((ReportPeriod)this.reference.getValue(false));
        }
        return baselineReportPeriod;
    }

    public void setValue(Period period) {
        ((BaselineReportPeriod)period).applyCustomPeriod(System.currentTimeMillis());
        this.startEditor.setValue(period.getStartTime());
        this.endEditor.setValue(period.getEndTime());
        if (this.daysOfWeek != null) {
            this.daysOfWeek.setValue(period.getDaysOfWeek());
        }
        this.periodSelector.setSelectedIndex(((BaselineReportPeriod)period).getCustomPeriod());
    }

    private void adjustEnd(ReportPeriodEditor reportPeriodEditor) {
        long l;
        if (reportPeriodEditor == null) {
            return;
        }
        long l2 = reportPeriodEditor.endEditor.getValue().toSerializedLong() - reportPeriodEditor.startEditor.getValue().toSerializedLong();
        if (l2 < 0L) {
            l2 *= -1L;
        }
        if ((l = this.endEditor.getValue().toSerializedLong() - this.startEditor.getValue().toSerializedLong()) < 0L) {
            this.endEditor.setValue(this.startEditor.getValue());
        } else if (l > l2) {
            this.endEditor.setValue(EasLocalTime.fromSerializedLong(this.startEditor.getValue().toSerializedLong() + l2));
        }
    }

    private void adjustStart(ReportPeriodEditor reportPeriodEditor) {
        long l;
        if (reportPeriodEditor == null) {
            return;
        }
        long l2 = reportPeriodEditor.endEditor.getValue().toSerializedLong() - reportPeriodEditor.startEditor.getValue().toSerializedLong();
        if (l2 < 0L) {
            l2 *= -1L;
        }
        if ((l = this.endEditor.getValue().toSerializedLong() - this.startEditor.getValue().toSerializedLong()) < 0L) {
            this.startEditor.setValue(this.endEditor.getValue());
        } else if (l > l2) {
            this.startEditor.setValue(EasLocalTime.fromSerializedLong(this.endEditor.getValue().toSerializedLong() - l2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.startEditor && this.persistDuration) {
            this.adjustEnd(this.reference);
        } else if (object == this.endEditor && this.persistDuration) {
            this.adjustStart(this.reference);
        } else if (object == this.periodSelector || this.reference != null && object == this.reference) {
            if (this.periodSelector.getSelectedIndex() == 0) {
                if (this.persistDuration) {
                    this.adjustEnd(this.reference);
                }
                return;
            }
            ReportPeriod reportPeriod = (ReportPeriod)this.getValue();
            reportPeriod.applyCustomPeriod(System.currentTimeMillis());
            this.startEditor.setValue(reportPeriod.getStartTime());
            this.endEditor.setValue(reportPeriod.getEndTime());
            if (this.persistDuration || object == this.periodSelector) {
                this.adjustEnd(this.reference);
            }
        }
        if (object instanceof DateEditor) {
            this.periodSelector.setSelectedIndex(0);
            this.startEditor.clearTime();
            this.endEditor.clearTime();
        }
        this.fireActionPerformed();
    }
}

