/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import com.tridium.eas.api.BaselinePeriod;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Period;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.PeriodEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.baja.util.Lexicon;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BaselinePeriodEditor
extends PeriodEditor {
    private PeriodEditor reportPeriodEditor;
    private XpComboBox startCombo;
    private DateEditor startEditor;
    private NumberTextField durationTextField;
    private BaselinePeriod period;
    private boolean triggerCustomPeriodOnEvent = true;

    public BaselinePeriodEditor(PeriodEditor periodEditor, Lexicon lexicon) {
        this(periodEditor, 1, lexicon);
    }

    public BaselinePeriodEditor(PeriodEditor periodEditor, int n, Lexicon lexicon) {
        this.reportPeriodEditor = periodEditor;
        this.period = new BaselinePeriod(periodEditor.getValue(), lexicon);
        this.period.setCustomPeriod(n);
        periodEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaselinePeriodEditor.this.period.setReportPeriod((ReportPeriod)BaselinePeriodEditor.this.reportPeriodEditor.getValue(false));
                BaselinePeriodEditor.this.startEditor.setValue(BaselinePeriodEditor.this.period.getStartTime());
                BaselinePeriodEditor.this.triggerCustomPeriodOnEvent = false;
                BaselinePeriodEditor.this.durationTextField.setText(BaselinePeriodEditor.this.period.getDurationDays());
                BaselinePeriodEditor.this.triggerCustomPeriodOnEvent = true;
                BaselinePeriodEditor.this.fireActionPerformed();
            }
        });
        this.setLayout(new GridBagLayout());
        Font font = UIManager.getFont("Table.font");
        font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        int n2 = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(lexicon.getText("start"));
        jLabel.setFont(font);
        this.add((Component)jLabel, gridBagConstraints);
        this.startCombo = new XpComboBox();
        for (int i = 0; i <= 4; ++i) {
            this.startCombo.addItem(BaselinePeriod.getCustomPeriodName(i, lexicon));
        }
        this.startCombo.setSelectedIndex(n);
        this.startCombo.setFont(font);
        this.startCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaselinePeriodEditor.this.period.setCustomPeriod(BaselinePeriodEditor.this.startCombo.getSelectedIndex());
                if (BaselinePeriodEditor.this.startCombo.getSelectedIndex() != 0) {
                    BaselinePeriodEditor.this.startEditor.setValue(BaselinePeriodEditor.this.period.getStartTime());
                    if (BaselinePeriodEditor.this.startCombo.getSelectedIndex() != 1) {
                        BaselinePeriodEditor.this.triggerCustomPeriodOnEvent = false;
                        BaselinePeriodEditor.this.durationTextField.setText(BaselinePeriodEditor.this.period.getDurationDays());
                        BaselinePeriodEditor.this.triggerCustomPeriodOnEvent = true;
                    }
                }
                BaselinePeriodEditor.this.fireActionPerformed();
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.startCombo, gridBagConstraints);
        gridBagConstraints.gridy = n2++;
        this.startEditor = new DateEditor(lexicon);
        this.startEditor.setAllowFuture(true);
        this.startEditor.setFont(font);
        this.startEditor.setValue(this.period.getStartTime());
        this.startEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaselinePeriodEditor.this.period.setStartDay(BaselinePeriodEditor.this.startEditor.getValue());
                if (BaselinePeriodEditor.this.triggerCustomPeriodOnEvent) {
                    BaselinePeriodEditor.this.startCombo.setSelectedIndex(0);
                    BaselinePeriodEditor.this.startEditor.clearTime();
                }
                BaselinePeriodEditor.this.fireActionPerformed();
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.startEditor, gridBagConstraints);
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = new JLabel(lexicon.getText("duration"));
        jLabel.setFont(font);
        this.add((Component)jLabel, gridBagConstraints);
        this.durationTextField = new NumberTextField(3, true);
        this.durationTextField.setAllowNegative(false);
        this.durationTextField.setFont(font);
        this.durationTextField.setText(1);
        this.period.setDurationDays(1);
        this.durationTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                BaselinePeriodEditor.this.period.setDurationDays(BaselinePeriodEditor.this.durationTextField.getIntValue());
                if (BaselinePeriodEditor.this.triggerCustomPeriodOnEvent && BaselinePeriodEditor.this.startCombo.getSelectedIndex() != 1) {
                    BaselinePeriodEditor.this.startCombo.setSelectedIndex(0);
                    BaselinePeriodEditor.this.startEditor.clearTime();
                }
                BaselinePeriodEditor.this.fireActionPerformed();
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.durationTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel("(" + lexicon.getText("days") + ")");
        jLabel.setFont(font);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        this.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    public Period getValue(boolean bl) {
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        EasLocalTime easLocalTime2 = this.period.getStartTime();
        if (bl && easLocalTime2.isAfter(easLocalTime)) {
            this.startEditor.setValue(easLocalTime);
            this.period.setStartDay(easLocalTime);
        }
        return this.period;
    }

    public void setValue(Period period) {
        this.triggerCustomPeriodOnEvent = false;
        this.period = (BaselinePeriod)period;
        this.startEditor.setValue(this.period.getStartTime());
        this.durationTextField.setText(this.period.getDurationDays());
        this.startCombo.setSelectedIndex(this.period.getCustomPeriod());
        this.triggerCustomPeriodOnEvent = true;
    }
}

