/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
SwingConstants {
    private int orientation;
    private int width;
    private int height;
    private Color foreground;
    private Color background;
    private Color highlight;
    private Color shadow;

    public ArrowIcon(int n) {
        this(n, 11, 11);
    }

    public ArrowIcon(int n, int n2, int n3) {
        this.setOrientation(n);
        this.width = n2;
        this.height = n3;
        this.foreground = null;
        this.background = null;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation");
            }
        }
        this.orientation = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public Color getForeground() {
        if (this.foreground == null) {
            this.foreground = this.getBackground();
        }
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        if (this.background == null) {
            this.background = UIManager.getColor("Panel.background");
        }
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getHighlight() {
        if (this.highlight == null) {
            this.highlight = UIManager.getColor("controlLtHighlight");
        }
        return this.highlight;
    }

    public void setHighlight(Color color) {
        this.highlight = color;
    }

    public Color getShadow() {
        if (this.shadow == null) {
            this.shadow = UIManager.getColor("controlDkShadow");
        }
        return this.shadow;
    }

    public void setShadow(Color color) {
        this.shadow = color;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.background != null) {
            graphics.setColor(this.background);
            graphics.fillRect(n, n2, this.width, this.height);
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        int[] nArray4 = new int[3];
        int n3 = this.width - 1;
        int n4 = this.height - 1;
        int n5 = n3 - 1;
        int n6 = n4 - 1;
        switch (this.orientation) {
            case 1: {
                nArray[0] = n + n3 / 2;
                nArray[1] = n;
                nArray[2] = n + n3;
                nArray2[0] = n2;
                nArray2[1] = nArray2[2] = n2 + n4;
                nArray3[0] = n + n5 / 2;
                nArray3[1] = n;
                nArray3[2] = n + n5;
                nArray4[0] = n2;
                nArray4[1] = nArray4[2] = n2 + n6;
                break;
            }
            case 5: {
                nArray[0] = n + n3 / 2;
                nArray[1] = n;
                nArray[2] = n + n3;
                nArray2[0] = n2 + n4;
                nArray2[1] = nArray2[2] = n2;
                nArray3[0] = n + n5 / 2;
                nArray3[1] = n;
                nArray3[2] = n + n5;
                nArray4[0] = n2 + n6;
                nArray4[1] = nArray4[2] = n2;
                break;
            }
            case 7: {
                nArray[0] = n;
                nArray[1] = nArray[2] = n + n3;
                nArray2[0] = n2 + n4 / 2;
                nArray2[1] = n2;
                nArray2[2] = n2 + n4;
                nArray3[0] = n;
                nArray3[1] = nArray3[2] = n + n5;
                nArray4[0] = n2 + n6 / 2;
                nArray4[1] = n2;
                nArray4[2] = n2 + n6;
                break;
            }
            case 3: {
                nArray[0] = n + n3;
                nArray[1] = nArray[2] = n;
                nArray2[0] = n2 + n4 / 2;
                nArray2[1] = n2;
                nArray2[2] = n2 + n4;
                nArray3[0] = n + n5;
                nArray3[1] = nArray3[2] = n;
                nArray4[0] = n2 + n6 / 2;
                nArray4[1] = n2;
                nArray4[2] = n2 + n6;
            }
        }
        Polygon polygon = new Polygon(nArray, nArray2, 3);
        Polygon polygon2 = new Polygon(nArray3, nArray4, 3);
        graphics2D.translate(1, 1);
        graphics2D.setColor(this.getHighlight());
        graphics2D.fillPolygon(polygon);
        graphics2D.translate(-1, -1);
        graphics2D.setColor(this.getShadow());
        graphics2D.fillPolygon(polygon);
        graphics2D.translate(1, 1);
        graphics2D.setColor(this.getForeground());
        graphics2D.fillPolygon(polygon2);
        graphics2D.translate(-1, -1);
    }
}

