/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports.admin;

import com.tridium.eas.api.EasSession;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class ReportTreeNode
implements TreeNode {
    private EasSession session;
    private ReportTreeNode parent;
    private Vector children;

    public ReportTreeNode(EasSession easSession, ReportTreeNode reportTreeNode) {
        this.session = easSession;
        this.parent = reportTreeNode;
    }

    public EasSession getSession() {
        return this.session;
    }

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public Enumeration children() {
        return this.getChildren().elements();
    }

    public Vector getChildren() {
        if (this.children == null) {
            this.children = this.loadChildren();
        }
        return this.children;
    }

    public boolean removeChild(int n) {
        if (this.children == null) {
            return false;
        }
        this.children.remove(n);
        return true;
    }

    public abstract Vector loadChildren();

    public Vector reloadChildren(Vector vector) {
        this.children = this.loadChildren();
        return this.children;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.getChildren().elementAt(n);
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public int getIndex(TreeNode treeNode) {
        return this.getChildren().indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return false;
    }
}

