/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports.admin;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.ui.NavigationManager;
import com.tridium.eas.ui.reports.admin.ReportNode;
import com.tridium.eas.ui.reports.admin.ReportTreeNode;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;
import javax.baja.util.Lexicon;

public class ReportTemplateNode
extends ReportTreeNode {
    private String id;
    private String name;
    private boolean segregate;
    private int accessType;
    private Lexicon lex;

    public ReportTemplateNode(EasSession easSession, ReportTreeNode reportTreeNode, String string, String string2, boolean bl, int n, Lexicon lexicon) {
        super(easSession, reportTreeNode);
        this.id = string;
        this.name = string2;
        this.segregate = bl;
        this.accessType = n;
        this.lex = lexicon;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSegregated() {
        return this.segregate;
    }

    public void go(NavigationManager navigationManager) {
        if (this.id.equals("whatIfAnalyzer")) {
            navigationManager.open("/cost/" + this.id);
        } else {
            navigationManager.open("/reports/" + this.id);
        }
    }

    public Vector loadChildren() {
        Vector vector = new Vector(10);
        if (this.segregate) {
            ReportTemplateNode reportTemplateNode;
            if (this.accessType == 2 || this.accessType == 3) {
                reportTemplateNode = new ReportTemplateNode(this.getSession(), this, this.id, this.lex != null ? this.lex.getText("private2") : "private", false, 2, this.lex);
                vector.add(reportTemplateNode);
            }
            if (this.accessType == 1 || this.accessType == 3) {
                reportTemplateNode = new ReportTemplateNode(this.getSession(), this, this.id, this.lex != null ? this.lex.getText("public2") : "public", false, 1, this.lex);
                vector.add(reportTemplateNode);
            }
        } else {
            vector = this.loadReportNodes();
        }
        return vector;
    }

    private Vector loadReportNodes() {
        try {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("/eas/savedReports?id=");
            stringBuffer.append(this.id);
            stringBuffer.append("&access=");
            switch (this.accessType) {
                case 1: {
                    stringBuffer.append("public");
                    break;
                }
                case 2: {
                    stringBuffer.append("private");
                    break;
                }
                default: {
                    stringBuffer.append("all");
                }
            }
            String string = this.getSession().getText(stringBuffer.toString());
            if (string == null) {
                return new Vector(0);
            }
            Vector<ReportNode> vector = new Vector<ReportNode>(10);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = string2;
                if (string3.length() == 0) continue;
                while ((string2 = bufferedReader.readLine()) != null && string2.length() != 0) {
                    boolean bl = string2.charAt(0) == '+';
                    vector.add(new ReportNode(this.getSession(), this, string3, string2.substring(1), bl));
                }
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Vector(0);
        }
    }
}

