/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports.admin;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.ReportUtil;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.inputlist.InputListModel;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.admin.ReportAdmin;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.io.DataInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ReportDetailPanel
extends JPanel {
    private ReportAdmin admin;
    private static Hashtable reportMap;
    private String reportId;
    private String reportName;
    private boolean isPublic;
    private Font labelFont;

    public ReportDetailPanel(ReportAdmin reportAdmin) {
        super(false);
        this.admin = reportAdmin;
        Font font = UIManager.getFont("Label.font");
        this.labelFont = new Font(Theme.widget().getTextFont().getName(), 1, font.getSize());
    }

    public void displayDetails(String string, String string2, boolean bl) {
        this.reportId = string;
        this.reportName = string2;
        this.isPublic = bl;
        if (string2 != null) {
            this.displayParameters(string, string2, bl);
        } else {
            this.clear();
        }
    }

    public void displayParameters(String string, String string2, boolean bl) {
        Lexicon lexicon = BEasApplet.lex;
        this.removeAll();
        if (string.equals("whatIfAnalyzer")) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.buildParameterPanel(string, string2), "Center");
        } else {
            String string3 = lexicon.getText("loadParamsError") + " \"" + string2 + "\".";
            ReportParameters reportParameters = ReportParameters.createParametersForId(string, lexicon);
            if (reportParameters == null) {
                System.out.println("Null report parameters");
                this.displayError(string3);
            } else {
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append("/eas/reportCommand/load?reportName=");
                stringBuffer.append(ReportUtil.reportNameToUrlParameter(string2));
                stringBuffer.append("&reportId=");
                stringBuffer.append(string);
                try {
                    DataInputStream dataInputStream = new DataInputStream(this.admin.getSession().get(stringBuffer.toString()));
                    if (!reportParameters.load(this.admin.getSession(), dataInputStream)) {
                        System.out.println("Null report parameters");
                        this.displayError(string3);
                    } else {
                        this.setLayout(new BorderLayout());
                        this.add((Component)this.buildParameterPanel(string, string2, bl, reportParameters), "Center");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.displayError(string3);
                }
            }
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void displayDetails(String string, String string2, String string3) {
        this.reportId = string;
        this.reportName = string2;
        if (string2 != null) {
            this.displayParameters(string, string2, string3);
        } else {
            this.clear();
        }
    }

    public void displayParameters(String string, String string2, String string3) {
        Lexicon lexicon = BEasApplet.lex;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildParameterPanel(string, string2, string3), "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private JComponent buildParameterPanel(String string, String string2, String string3) {
        Lexicon lexicon = BEasApplet.lex;
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(false);
        GridBagManager gridBagManager = new GridBagManager(jPanel2);
        gridBagManager.insets(new Insets(2, 2, 2, 10));
        gridBagManager.anchor(18);
        gridBagManager.fill(0);
        int n = 0;
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("reportType"), new JLabel(lexicon.getText("billReconcile")));
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("meter"), new JLabel(string3));
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("billPeriod"), new JLabel(string2));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JComponent buildParameterPanel(String string, String string2) {
        Lexicon lexicon = BEasApplet.lex;
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(false);
        GridBagManager gridBagManager = new GridBagManager(jPanel2);
        gridBagManager.insets(new Insets(2, 2, 2, 10));
        gridBagManager.anchor(18);
        gridBagManager.fill(0);
        int n = 0;
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("reportType"), new JLabel(lexicon.getText(string)));
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("reportName"), new JLabel(string2));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JComponent buildParameterPanel(String string, String string2, boolean bl, ReportParameters reportParameters) {
        Lexicon lexicon = BEasApplet.lex;
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(false);
        GridBagManager gridBagManager = new GridBagManager(jPanel2);
        gridBagManager.insets(new Insets(2, 2, 2, 10));
        gridBagManager.anchor(18);
        gridBagManager.fill(0);
        int n = 0;
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("reportType"), new JLabel(this.idToTemplateName(string, lexicon)));
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("reportName"), new JLabel(string2));
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("autoRun"), new JLabel("" + reportParameters.isAutoRun()));
        n = this.addDisplayItem(gridBagManager, n, lexicon.getText("reportPeriod"), this.getReportPeriodDisplay(string, reportParameters.getPeriod()));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        InputListModel inputListModel = new InputListModel(lexicon);
        inputListModel.setInputs(reportParameters.getInputs());
        InputList inputList = new InputList(null, inputListModel);
        inputList.setEditable(false);
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)inputList.createScrollPane(), "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder(lexicon.getText("reportInputs")));
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private int addDisplayItem(GridBagManager gridBagManager, int n, String string, JComponent jComponent) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.labelFont);
        gridBagManager.add(0, 0, 1, 1, 0, n, jLabel);
        gridBagManager.add(100, 0, 1, 1, 1, n, jComponent);
        return n + 1;
    }

    private JComponent getReportPeriodDisplay(String string, ReportPeriod reportPeriod) {
        Lexicon lexicon = BEasApplet.lex;
        if (string.equals("aggAnalysis")) {
            return new JLabel(Integer.toString(reportPeriod.getStartTime().getYear()));
        }
        boolean bl = string.equals("avgProfile") || string.equals("entRanking") || string.equals("relContribution");
        ReportPeriodEditor reportPeriodEditor = new ReportPeriodEditor(bl, lexicon);
        reportPeriodEditor.setValue(reportPeriod);
        reportPeriodEditor.setEditable(false);
        return reportPeriodEditor;
    }

    public void displayError(String string) {
        this.removeAll();
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        this.setLayout(new BorderLayout());
        this.add(jLabel);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void clear() {
        this.removeAll();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private String idToTemplateName(String string, Lexicon lexicon) {
        Hashtable hashtable = ReportDetailPanel.getReportMap(this.admin.getSession(), lexicon);
        if (hashtable == null) {
            return string;
        }
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private static synchronized Hashtable getReportMap(EasSession easSession, Lexicon lexicon) {
        if (reportMap == null) {
            try {
                reportMap = new Hashtable(11);
                String string = easSession.getText("/eas/reports/list");
                if (string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        int n = string2.indexOf(58);
                        String string3 = string2.substring(0, n);
                        String string4 = lexicon.getText(string3);
                        reportMap.put(string3, string4);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return reportMap;
    }
}

