/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports.admin;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.ui.NavigationManager;
import com.tridium.eas.ui.reports.admin.ReconciliationNode;
import com.tridium.eas.ui.reports.admin.ReportTreeNode;
import java.util.Vector;
import javax.baja.util.Lexicon;

public class ReconciliationTemplateNode
extends ReportTreeNode {
    private String id;
    private String name;
    private boolean segregate;
    private int accessType;
    private Lexicon lex;

    public ReconciliationTemplateNode(EasSession easSession, ReportTreeNode reportTreeNode, String string, String string2, boolean bl, int n, Lexicon lexicon) {
        super(easSession, reportTreeNode);
        this.id = string;
        this.name = string2;
        this.segregate = bl;
        this.accessType = n;
        this.lex = lexicon;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSegregated() {
        return this.segregate;
    }

    public void go(NavigationManager navigationManager) {
        navigationManager.open("/cost/reconcile");
    }

    public Vector loadChildren() {
        Vector vector = new Vector(10);
        if (this.segregate) {
            Group[] groupArray;
            if (this.accessType == 3 && (groupArray = Site.getGroups(this.getSession())) != null) {
                for (int i = 0; i < groupArray.length; ++i) {
                    Vector vector2 = this.getSession().getMeterExec().getSiteMeters((Site)groupArray[i]);
                    if (vector2 == null) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        try {
                            String string = "meter" + ((Meter)vector2.elementAt(j)).getId();
                            String string2 = ((Meter)vector2.elementAt(j)).getSite() != null ? ((Meter)vector2.elementAt(j)).getSite().getName() + ": " + ((Meter)vector2.elementAt(j)).getName() : ((Meter)vector2.elementAt(j)).getName();
                            ReconciliationTemplateNode reconciliationTemplateNode = new ReconciliationTemplateNode(this.getSession(), this, string, string2, false, this.accessType, this.lex);
                            vector.add(reconciliationTemplateNode);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        } else {
            vector = this.loadReconciliationNodes();
        }
        return vector;
    }

    private Vector loadReconciliationNodes() {
        try {
            String[] stringArray = EasCostClient.retrieveReconciliationReportNames(this.getSession(), this.getId());
            if (stringArray == null) {
                return new Vector(0);
            }
            Vector<ReconciliationNode> vector = new Vector<ReconciliationNode>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(new ReconciliationNode(this.getSession(), this, this.getId(), stringArray[i], this.getName(), this.lex));
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Vector(0);
        }
    }
}

