/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.reports.ReportFilterTree;
import com.tridium.eas.ui.reports.ReportFilterTreeModel;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class TreePopup
extends EasPopupMenu {
    private static final int ADD_TO_REPORT = 0;
    private static final int COPY = 1;
    private EasReport report;
    private ReportFilterTree tree;
    private FilterTreeNode target;
    private JMenuItem toReportItem;
    private Lexicon lex;

    public TreePopup(EasReport easReport, ReportFilterTree reportFilterTree, Lexicon lexicon) {
        this.report = easReport;
        this.tree = reportFilterTree;
        this.lex = lexicon;
        this.toReportItem = new EasPopupMenu.EasPopupMenuItem(this.lex.getText("addToReport"), 0, null);
        this.add(this.toReportItem);
        this.add(new EasPopupMenu.EasPopupMenuItem(this.lex.getText("copy"), 1, null));
    }

    public void arm(FilterTreeNode filterTreeNode) {
        this.target = filterTreeNode;
    }

    protected void processCommand(int n, Object object) {
        switch (n) {
            case 0: {
                this.addToReport();
                break;
            }
            case 1: {
                this.copy();
            }
        }
    }

    private InputItemSet getItemSet() {
        ReportFilterTreeModel reportFilterTreeModel = (ReportFilterTreeModel)this.tree.getModel();
        ReportInputItem[] reportInputItemArray = reportFilterTreeModel.getInputItems(this.target);
        int n = reportInputItemArray == null ? 0 : reportInputItemArray.length;
        String string = null;
        if (n > 1) {
            string = this.target.getNodeText();
        }
        return new InputItemSet(string, reportInputItemArray);
    }

    private void addToReport() {
        InputList inputList = this.report.getInputList();
        int n = inputList.getItemCount();
        InputItemSet inputItemSet = this.getItemSet();
        if (this.report.allowMultipleInputs() || n == 0) {
            if (inputItemSet.getInputItemCount() > 0) {
                this.report.addInputItemSet(inputItemSet, true);
            }
        } else {
            ReportInput reportInput = inputList.getItem(0).getInput();
            if (inputList.getModel().addItemsToInput(reportInput, inputItemSet)) {
                inputList.revalidate();
            } else {
                BUnit bUnit = reportInput.getUnit();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("'");
                stringBuffer.append(inputItemSet.getName());
                stringBuffer.append("' " + this.lex.getText("badUnits") + "\n");
                if (bUnit != null) {
                    stringBuffer.append(this.lex.getText("cannotConvert") + " ");
                    String string = null;
                    string = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                    stringBuffer.append(string + ".");
                } else {
                    stringBuffer.append(this.lex.getText("unitNotCompatible"));
                }
                JOptionPane.showMessageDialog(this, stringBuffer, this.lex.getText("notAdded"), 0);
            }
        }
    }

    private void copy() {
        InputItemSet inputItemSet = this.getItemSet();
        if (inputItemSet.getInputItemCount() > 0) {
            this.report.setClipboard(inputItemSet);
        } else {
            this.report.clearClipboard();
        }
    }
}

