/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.DecimalFormatter;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.DefaultSpectrumConfig;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SpectrumSummaryParameters;
import com.tridium.eas.ui.reports.SpectrumSummarySeries;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.ValueColor;
import com.tridium.eas.ui.widgets.ValueColorEditor;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class SpectrumSummary
extends EasReport {
    public static final String TEMPLATE_ID = "spectrum";
    private Chart chart;
    private Config config;
    private Id seriesId;

    public String getName() {
        return this.lex.getText("spectrumSummary");
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        if (this.chart == null) {
            this.chart = new Chart(this.lex);
            this.chart.setTitle(this.getName());
            this.chart.setChartStatus(this);
        }
        return this.chart;
    }

    public boolean allowMultipleInputs() {
        return false;
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public ReportParameters createEmptyParameters() {
        return new SpectrumSummaryParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        ValueColor[] valueColorArray = this.config.getValueColors();
        return new SpectrumSummaryParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), valueColorArray[0], valueColorArray[1], valueColorArray[2], this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        SpectrumSummaryParameters spectrumSummaryParameters = (SpectrumSummaryParameters)reportParameters;
        this.getInputList().getModel().setInputs(spectrumSummaryParameters.getInputs());
        this.config.setPeriod(spectrumSummaryParameters.getPeriod());
        this.config.setValueColors(spectrumSummaryParameters.getLowValueColor(), spectrumSummaryParameters.getMiddleValueColor(), spectrumSummaryParameters.getHighValueColor());
        this.setDataCleanse(spectrumSummaryParameters.getDataCleanse());
        this.setDataCleanseWindow(spectrumSummaryParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(spectrumSummaryParameters.getDataCleansePercentage());
    }

    public void runReport(ReportParameters reportParameters) {
        double d;
        SpectrumSummaryParameters spectrumSummaryParameters = (SpectrumSummaryParameters)reportParameters;
        int n = spectrumSummaryParameters.getInputCount();
        if (n == 0) {
            return;
        }
        ReportInput reportInput = spectrumSummaryParameters.getInputs()[0];
        SpectrumSummarySeries spectrumSummarySeries = new SpectrumSummarySeries(reportInput, spectrumSummaryParameters);
        spectrumSummarySeries.load();
        double d2 = spectrumSummarySeries.getMin();
        double d3 = spectrumSummarySeries.getMax();
        this.config.setLowDefault(DecimalFormatter.format(d2));
        this.config.setHighDefault(DecimalFormatter.format(d3));
        ValueColor valueColor = spectrumSummaryParameters.getLowValueColor();
        ValueColor valueColor2 = spectrumSummaryParameters.getMiddleValueColor();
        ValueColor valueColor3 = spectrumSummaryParameters.getHighValueColor();
        double d4 = valueColor.isDefault() ? spectrumSummarySeries.getMin() : (double)valueColor.getValue();
        double d5 = d = valueColor3.isDefault() ? spectrumSummarySeries.getMax() : (double)valueColor3.getValue();
        if (d4 > d) {
            d = d4 + 10.0;
            this.config.setValueColors(valueColor, valueColor2, new ValueColor((float)d, valueColor3.getColor()));
        }
        double d6 = (d4 + d) / 2.0;
        this.config.setMiddleDefault(DecimalFormatter.format(d6));
        DefaultSpectrumConfig defaultSpectrumConfig = new DefaultSpectrumConfig(valueColor3.getColor(), (float)d, valueColor2.getColor(), valueColor.getColor(), (float)d4);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(spectrumSummaryParameters.getPeriod().getDateRangeString());
        stringBuffer.append("\n " + this.lex.getText("range") + ": ");
        stringBuffer.append(DecimalFormatter.format(spectrumSummarySeries.getMin())).append(" - ");
        stringBuffer.append(DecimalFormatter.format(spectrumSummarySeries.getMax()));
        BUnit bUnit = spectrumSummarySeries.getValueUnits();
        if (bUnit != null) {
            stringBuffer.append(' ').append(bUnit.toString());
        }
        this.chart.setSubtitle(stringBuffer.toString());
        TimeAxisInfo timeAxisInfo = new TimeAxisInfo(this.lex);
        this.seriesId = this.chart.getModel().setSeries(spectrumSummarySeries, defaultSpectrumConfig, timeAxisInfo, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null && string.equals("colorChanged")) {
            if (this.seriesId != null && this.seriesId.isValid()) {
                DefaultSpectrumConfig defaultSpectrumConfig = (DefaultSpectrumConfig)this.chart.getModel().getChartConfig(this.seriesId);
                ValueColor[] valueColorArray = this.config.getValueColors();
                defaultSpectrumConfig.setLowColor(valueColorArray[0].getColor());
                defaultSpectrumConfig.setMiddleColor(valueColorArray[1].getColor());
                defaultSpectrumConfig.setHighColor(valueColorArray[2].getColor());
                this.chart.getChartArea().forceRepaint();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        book.append(this.chart, pageFormat);
        return book;
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    public class TimeAxisInfo
    extends AxisInfo {
        DateFormat dateFormat = new SimpleDateFormat("d MMM yyyy");
        Lexicon lex;

        public TimeAxisInfo(Lexicon lexicon) {
            this.lex = lexicon;
        }

        public boolean useDefaultTickLabels() {
            return false;
        }

        public boolean useDefaultValueLabels() {
            return false;
        }

        public String getTickLabel(Object object) {
            Date date = null;
            if (object instanceof Date) {
                date = (Date)object;
            } else if (object instanceof Number) {
                date = new Date(((Number)object).longValue());
            }
            if (this.lex != null) {
                return new SimpleDateFormat(this.lex.getText("spectrumTickDateFormat"), new Locale(this.lex.language, "")).format(date);
            }
            return this.dateFormat.format(date);
        }

        public String getValueLabel(Object object) {
            return this.getTickLabel(object);
        }
    }

    private class Config
    extends JComponent {
        private ReportPeriodEditor periodEditor;
        private ValueColorEditor low;
        private ValueColorEditor mid;
        private ValueColorEditor high;

        public Config() {
            SpectrumSummary.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.periodEditor = new ReportPeriodEditor(false, SpectrumSummary.this.lex);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(SpectrumSummary.this.lex.getText("period")));
            this.add(this.periodEditor);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(this.periodEditor, gridBagConstraints);
            JPanel jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(SpectrumSummary.this.lex.getText("valueColors")));
            jPanel.setLayout(new GridLayout(3, 1));
            this.low = new ValueColorEditor(Color.blue, SpectrumSummary.this.lex);
            this.low.setDefaultDisplay(SpectrumSummary.this.lex.getText("undefined"));
            this.low.addActionListener(SpectrumSummary.this);
            jPanel.add(this.low);
            this.mid = new ValueColorEditor(Color.white, SpectrumSummary.this.lex);
            this.mid.setValueEditable(false);
            this.mid.setDefaultDisplay(SpectrumSummary.this.lex.getText("undefined"));
            this.mid.addActionListener(SpectrumSummary.this);
            jPanel.add(this.mid);
            this.high = new ValueColorEditor(Color.red, SpectrumSummary.this.lex);
            this.high.setDefaultDisplay(SpectrumSummary.this.lex.getText("undefined"));
            this.high.addActionListener(SpectrumSummary.this);
            jPanel.add(this.high);
            this.add(jPanel);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            JLabel jLabel = new JLabel("");
            this.add(jLabel);
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public ValueColor[] getValueColors() {
            ValueColor[] valueColorArray = new ValueColor[]{this.low.getValue(), this.mid.getValue(), this.high.getValue()};
            return valueColorArray;
        }

        public void setValueColors(ValueColor valueColor, ValueColor valueColor2, ValueColor valueColor3) {
            this.low.setValue(valueColor);
            this.mid.setValue(valueColor2);
            this.high.setValue(valueColor3);
        }

        public void setLowDefault(String string) {
            this.low.setDefaultDisplay(string);
        }

        public void setMiddleDefault(String string) {
            this.mid.setDefaultDisplay(string);
        }

        public void setHighDefault(String string) {
            this.high.setDefaultDisplay(string);
        }
    }
}

