/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.widgets.GridBagManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SaveReportDialog
extends JDialog
implements ActionListener,
DocumentListener,
WindowListener {
    private Component parent;
    private JTextField reportNameField;
    private JCheckBox publicCheck;
    private JCheckBox autoRunCheck;
    private String reportName;
    private boolean pub;
    private boolean autoRun;
    private JButton okButton;
    private JButton cancelButton;

    public SaveReportDialog(Component component, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Lexicon lexicon) {
        super((Frame)null, lexicon.getText("saveReport"), true);
        this.parent = component;
        this.addWindowListener(this);
        int n = 0;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagManager gridBagManager = new GridBagManager(jComponent);
        gridBagManager.anchor(17);
        gridBagManager.fill(2);
        gridBagManager.add(100, 100, 2, 1, 0, n++, new JLabel(lexicon.getText("enterReportName")));
        int n2 = n++;
        this.reportNameField = new JTextField(20);
        gridBagManager.add(100, 100, 2, 1, 0, n2, this.reportNameField);
        this.reportNameField.getDocument().addDocumentListener(this);
        gridBagManager.fill(0);
        if (bl3) {
            this.publicCheck = new JCheckBox(lexicon.getText("public"));
            gridBagManager.add(100, 100, 1, 1, 0, n, this.publicCheck);
        }
        if (bl4) {
            this.autoRunCheck = new JCheckBox(lexicon.getText("autoRun"));
            gridBagManager.add(100, 100, 1, 1, 1, n, this.autoRunCheck);
        }
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        gridBagManager.fill(2);
        int n3 = ++n;
        ++n;
        gridBagManager.add(100, 100, 2, 1, 0, n3, jPanel);
        this.pack();
        this.getRootPane().setDefaultButton(this.okButton);
        if (string != null) {
            this.reportNameField.setText(string.replace('_', ' '));
        }
        if (bl3) {
            this.publicCheck.setSelected(bl);
        }
        if (bl4) {
            this.autoRunCheck.setSelected(bl2);
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        JComponent jComponent = (JComponent)this.getContentPane();
        Dimension dimension = jComponent.getPreferredSize();
        return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    public void open() {
        int n;
        int n2;
        int n3;
        int n4;
        Cloneable cloneable;
        if (this.parent.isVisible()) {
            cloneable = this.parent.getBounds();
            n4 = cloneable.x;
            n3 = cloneable.y;
            n2 = cloneable.width;
            n = cloneable.height;
        } else {
            n3 = 0;
            n4 = 0;
            cloneable = Toolkit.getDefaultToolkit().getScreenSize();
            n2 = ((Dimension)cloneable).width;
            n = ((Dimension)cloneable).height;
        }
        cloneable = this.getPreferredSize();
        this.setSize(((Dimension)cloneable).width, ((Dimension)cloneable).height);
        this.setLocation(n4 + (n2 - ((Dimension)cloneable).width) / 2, n3 + (n - ((Dimension)cloneable).height) / 2);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCancelled() {
        return this.reportName == null;
    }

    public String getReportName() {
        return this.reportName;
    }

    public boolean isPublic() {
        return this.pub;
    }

    public boolean isAutoRun() {
        return this.autoRun;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.doOk();
        } else {
            this.doCancel();
        }
    }

    public void doOk() {
        this.reportName = this.reportNameField.getText().trim();
        if (this.publicCheck != null) {
            this.pub = this.publicCheck.isSelected();
        }
        if (this.autoRunCheck != null) {
            this.autoRun = this.autoRunCheck.isSelected();
        }
        this.close();
    }

    public void doCancel() {
        this.reportName = null;
        this.close();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        String string = this.reportNameField.getText().trim();
        this.okButton.setEnabled(string.length() > 0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doCancel();
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.reportNameField.requestFocus();
        this.reportNameField.selectAll();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if (this.isModal()) {
            this.toFront();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

