/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.widgets.ColorIcon;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class ReportInputListCellRenderer
extends DefaultListCellRenderer {
    private int maxChars;

    public ReportInputListCellRenderer() {
        this(60);
    }

    public ReportInputListCellRenderer(int n) {
        this.maxChars = n;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object != null && object instanceof ReportInput) {
            ReportInput reportInput = (ReportInput)object;
            if (reportInput.getAggregateParent() == null) {
                jLabel.setIcon(new ColorIcon(reportInput.getColor()));
            } else {
                jLabel.setIcon(new ColorIcon(reportInput.getColor(), reportInput.getAggregateParent().getColor()));
            }
            if (reportInput.getName().length() > this.maxChars) {
                jLabel.setText(reportInput.getName().substring(0, this.maxChars - 3) + "...");
            } else {
                jLabel.setText(reportInput.getName());
            }
        } else if (object != null) {
            if (object.toString().length() > this.maxChars) {
                jLabel.setText(object.toString().substring(0, this.maxChars - 3) + "...");
            } else {
                jLabel.setText(object.toString());
            }
        }
        return jLabel;
    }
}

