/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.ui.reports.MeterInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.reports.SiteInputItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public abstract class ReportInputItem {
    public static final int SITE = 0;
    public static final int SITE_DATA_POINT = 1;
    public static final int METER = 2;

    public abstract int getType();

    public abstract String getText();

    public abstract double getFloorAreaValue();

    public abstract BUnit getFloorAreaUnit();

    public abstract DataPoint getOutdoorAirTempDataPoint();

    public abstract DataPoint getMainGasDataPoint();

    public abstract DataPoint getMainElectricDataPoint();

    public BUnit getUnit() {
        return null;
    }

    public boolean isCompatible(ReportInputItem reportInputItem) {
        if (reportInputItem == this) {
            return true;
        }
        BUnit bUnit = this.getUnit();
        BUnit bUnit2 = reportInputItem.getUnit();
        if (bUnit != null && bUnit2 != null) {
            return bUnit.isConvertible(bUnit2);
        }
        return false;
    }

    public abstract void save(DataOutput var1) throws IOException;

    public abstract boolean load(EasSession var1, DataInput var2) throws IOException, EasException;

    public static ReportInputItem createInputItem(int n, Lexicon lexicon) {
        switch (n) {
            case 0: {
                return new SiteInputItem(lexicon);
            }
            case 1: {
                return new SiteDataPoint(lexicon);
            }
            case 2: {
                return new MeterInputItem(lexicon);
            }
        }
        throw new IllegalArgumentException("Unknown Input Item Type: " + n);
    }
}

