/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.SeriesLabel;
import com.tridium.eas.ui.reports.ValueUnitPair;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.baja.util.Lexicon;

public class PointTrendingTableModel
extends AbstractRowMappedTableModel {
    private ArrayList seriesList = new ArrayList();
    private ArrayList colorList;
    private Lexicon lex;
    public static final int INPUT_COL = 0;
    public static final int MEAN_COL = 1;
    public static final int STD_DEV_COL = 2;
    public static final String SIGMA = "sigma";
    public static final char SQUARED = '\u00b2';
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$SeriesLabel;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$ValueUnitPair;
    static /* synthetic */ Class class$java$lang$Number;

    public PointTrendingTableModel(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public void addSeries(Series series, ValueColors valueColors) {
        this.seriesList.add(new SeriesAndColors(series, valueColors));
        this.fireTableDataChanged();
    }

    public Object getModelValueAt(int n, int n2) {
        int n3 = 0;
        SeriesAndColors seriesAndColors = null;
        Iterator iterator = this.seriesList.iterator();
        while (iterator.hasNext()) {
            SeriesAndColors seriesAndColors2 = (SeriesAndColors)iterator.next();
            if (n < n3 + seriesAndColors2.series.getValueCount()) {
                seriesAndColors = seriesAndColors2;
                break;
            }
            n3 += seriesAndColors2.series.getValueCount();
        }
        if (seriesAndColors == null) {
            return null;
        }
        int n4 = n - n3;
        switch (n2) {
            case 0: {
                return new SimpleSeriesLabel(seriesAndColors.series, n4, seriesAndColors.colors.getValueColor(n4));
            }
            case 1: {
                return new ValueUnitPair(new Double(seriesAndColors.series.getValueMean(n4)), seriesAndColors.series.getValueUnits());
            }
            case 2: {
                return new Double(seriesAndColors.series.getValueStandardDeviation(n4));
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return " ";
            }
            case 1: {
                return this.lex.getText("mean");
            }
            case 2: {
                return this.lex.getText(SIGMA);
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        int n = 0;
        Iterator iterator = this.seriesList.iterator();
        while (iterator.hasNext()) {
            SeriesAndColors seriesAndColors = (SeriesAndColors)iterator.next();
            n += seriesAndColors.series.getValueCount();
        }
        return n;
    }

    public Series getSeries(int n) {
        int n2 = this.convertRowIndexToModel(n);
        int n3 = 0;
        Iterator iterator = this.seriesList.iterator();
        while (iterator.hasNext()) {
            SeriesAndColors seriesAndColors = (SeriesAndColors)iterator.next();
            if (n2 < n3 + seriesAndColors.series.getValueCount()) {
                return seriesAndColors.series;
            }
            n3 += seriesAndColors.series.getValueCount();
        }
        return null;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return class$com$tridium$eas$ui$reports$SeriesLabel == null ? (class$com$tridium$eas$ui$reports$SeriesLabel = PointTrendingTableModel.class$("com.tridium.eas.ui.reports.SeriesLabel")) : class$com$tridium$eas$ui$reports$SeriesLabel;
            }
            case 1: {
                return class$com$tridium$eas$ui$reports$ValueUnitPair == null ? (class$com$tridium$eas$ui$reports$ValueUnitPair = PointTrendingTableModel.class$("com.tridium.eas.ui.reports.ValueUnitPair")) : class$com$tridium$eas$ui$reports$ValueUnitPair;
            }
            case 2: {
                return class$java$lang$Number == null ? (class$java$lang$Number = PointTrendingTableModel.class$("java.lang.Number")) : class$java$lang$Number;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void clear() {
        this.seriesList = new ArrayList();
        this.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SeriesAndColors {
        public Series series;
        public ValueColors colors;

        public SeriesAndColors(Series series, ValueColors valueColors) {
            this.series = series;
            this.colors = valueColors;
        }
    }

    private static class SimpleSeriesLabel
    implements SeriesLabel {
        private Series series;
        private int valueIndex;
        private Color color;

        public SimpleSeriesLabel(Series series, int n, Color color) {
            this.series = series;
            this.valueIndex = n;
            this.color = color;
        }

        public String getName() {
            return this.series.getValueName(this.valueIndex);
        }

        public Color getColor() {
            return this.color;
        }
    }
}

