/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.BaselineReportPeriod;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.function.Population;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartColorCellRenderer;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultLineConfig;
import com.tridium.eas.ui.chart.DefaultScatterConfig;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.Overlay;
import com.tridium.eas.ui.chart.RangeOverlay;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.BivariateSeries;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.InputValueColors;
import com.tridium.eas.ui.reports.InterpolatedScalarTimeSeries;
import com.tridium.eas.ui.reports.InterpolatedTimeSeries;
import com.tridium.eas.ui.reports.LinearRegressionSeries;
import com.tridium.eas.ui.reports.MultistateTimeSeries;
import com.tridium.eas.ui.reports.PointTrendingParameters;
import com.tridium.eas.ui.reports.PointTrendingTable;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportInputListCellRenderer;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.BaselineReportPeriodEditor;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.FixedSizePanel;
import com.tridium.eas.ui.widgets.IntervalEditor;
import com.tridium.eas.ui.widgets.MaxSizePanel;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.eas.util.CompoundUnitUtil;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class PointTrending
extends EasReport
implements EasDataListener {
    public static final String TEMPLATE_ID = "pointTrending";
    private JPanel main;
    private Chart chart;
    private Chart scatterChart;
    private Config config;
    private HashMap timeSeriesByUnit = null;
    private JSplitPane scatterSplitPane;
    private PointTrendingTable detailTable;
    private int scatterSplitLoc = -1;
    private boolean refreshingInputListDisabled = false;
    private static final String RHO = "r";

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText("pointTrendAnalysis");
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        Lexicon lexicon = BEasApplet.lex;
        if (this.main == null) {
            this.main = new JPanel(false);
            this.main.setLayout(new BorderLayout());
            this.chart = new Chart(lexicon);
            this.chart.setTitle(lexicon.getText(TEMPLATE_ID));
            this.chart.setChartStatus(this);
            this.main.add((Component)this.chart, "Center");
        }
        return this.main;
    }

    protected JComponent getReportDetails() {
        Lexicon lexicon = BEasApplet.lex;
        if (this.scatterSplitPane == null) {
            this.detailTable = new PointTrendingTable(lexicon);
            this.scatterChart = new Chart(lexicon);
            this.scatterChart.setChartStatus(this);
            this.scatterSplitPane = new JSplitPane(1, new JScrollPane(this.scatterChart), this.detailTable.getScrollPane());
        }
        return this.scatterSplitPane;
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        ChartModel chartModel = new ChartModel();
        this.chart.setModel(chartModel);
        chartModel.setTitle(this.getName());
        this.getInputList().getModel().addEasDataListener(this);
        this.setRunReportEnabled(false);
        this.lex = BEasApplet.lex;
    }

    protected void startReport() {
        this.setScatterVisible(true);
    }

    protected ReportParameters createEmptyParameters() {
        return new PointTrendingParameters(this.lex);
    }

    protected ReportParameters getReportParameters(boolean bl) {
        return new PointTrendingParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), this.config.getInterval(), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.config.getCorrelationInput1(), this.config.getCorrelationInput2(), this.config.getCorrelation2Lag(), this.config.showRegressionLine(), this.config.getBaselinePeriod(!bl), this.config.getBaselineSourceSeries(), this.config.getBaselineSeries(), this.config.getApplyBaseline(), this.config.getBaselineColor(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    protected void setReportParameters(ReportParameters reportParameters) {
        PointTrendingParameters pointTrendingParameters = (PointTrendingParameters)reportParameters;
        this.getInputList().getModel().setInputs(pointTrendingParameters.getInputs());
        this.config.setPeriod(pointTrendingParameters.getPeriod());
        this.config.setInterval(pointTrendingParameters.getInterval());
        this.config.setNormalization(pointTrendingParameters.getNormalization());
        this.config.setNormalTemperature(pointTrendingParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(pointTrendingParameters.getNormalTemperatureUnit());
        this.config.setCorrelationInput1(pointTrendingParameters.getCorrelationInput1());
        this.config.setCorrelationInput2(pointTrendingParameters.getCorrelationInput2());
        this.config.setCorrelation2Lag(pointTrendingParameters.getCorrelation2Lag());
        this.config.setShowRegressionLine(pointTrendingParameters.showRegressionLine());
        this.config.setBaselinePeriod(pointTrendingParameters.getBaselinePeriod());
        this.config.setBaselineSeries(pointTrendingParameters.getBaselineSource());
        this.config.setBaselineColor(pointTrendingParameters.getBaselineColor());
        this.config.setApplyBaseline(pointTrendingParameters.getApplyBaseline());
        this.setDataCleanse(pointTrendingParameters.getDataCleanse());
        this.setDataCleanseWindow(pointTrendingParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(pointTrendingParameters.getDataCleansePercentage());
    }

    public boolean allowDataPoint(DataPoint dataPoint) {
        return true;
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            this.config.removeInput((ReportInput)dataEditedEvent.getEditedData()[i]);
        }
        this.setRunReportEnabled(this.config.getInterval() > 0 && this.getInputList().getModel().getInputCount() > 0);
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        this.dataChanged(dataEditedEvent);
        this.setRunReportEnabled(this.config.getInterval() > 0 && this.getInputList().getModel().getInputCount() > 0);
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        if (dataEditedEvent.getSource() == this.getInputList().getModel() && !this.refreshingInputListDisabled && dataEditedEvent.getEditedData().length > 0) {
            this.refreshInputListEnabledStates();
        }
    }

    protected void refreshInputListEnabledStates() {
        this.refreshingInputListDisabled = true;
        this.getInputList().getModel().enableAllInputs();
        ReportInput[] reportInputArray = this.getInputList().getModel().getInputs();
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            ReportInputItem[] reportInputItemArray;
            this.config.addInput(reportInputArray[i]);
            if ((this.config.getNormalization() & 4) > 0) {
                reportInputItemArray = reportInputArray[i].getInputItems();
                for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                    if (((SiteDataPoint)reportInputItemArray[n2]).getOutdoorAirTempDataPoint() != null) continue;
                    this.getInputList().getModel().disableInput(i);
                    this.config.removeInput(reportInputArray[i]);
                }
                continue;
            }
            if ((this.config.getNormalization() & 2) <= 0) continue;
            reportInputItemArray = reportInputArray[i].getInputItems();
            for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                try {
                    if (((SiteDataPoint)reportInputItemArray[n2]).getDataPoint().getFloorAreaValue() != 0.0) continue;
                    this.getInputList().getModel().disableInput(i);
                    this.config.removeInput(reportInputArray[i]);
                    continue;
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                    this.getInputList().getModel().disableInput(i);
                    this.config.removeInput(reportInputArray[i]);
                }
            }
        }
        this.refreshingInputListDisabled = false;
    }

    public void runReport(ReportParameters reportParameters) {
        try {
            Object object;
            AxisInfo axisInfo;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ReportInput[] reportInputArray;
            Object object6;
            Lexicon lexicon = BEasApplet.lex;
            PointTrendingParameters pointTrendingParameters = (PointTrendingParameters)reportParameters;
            if (pointTrendingParameters.getInterval() == 0) {
                return;
            }
            ChartModel chartModel = new ChartModel();
            chartModel.setTitle(lexicon.getText(TEMPLATE_ID));
            this.detailTable.clear();
            this.timeSeriesByUnit = new HashMap();
            ReportPeriod reportPeriod = pointTrendingParameters.getPeriod();
            int n = reportPeriod.getDaysOfWeek();
            ReportInput[] reportInputArray2 = pointTrendingParameters.getInputs();
            if (reportInputArray2 == null) {
                return;
            }
            TimeSeries timeSeries = null;
            int n2 = -1;
            TimeSeries timeSeries2 = null;
            int n3 = -1;
            for (int i = 0; i < reportInputArray2.length; ++i) {
                if (!reportInputArray2[i].isEnabled() || pointTrendingParameters.getBaselineSource() != null && reportInputArray2[i].equals(pointTrendingParameters.getBaselineSource()) && !pointTrendingParameters.getApplyBaseline()) continue;
                if (reportInputArray2[i].getUnit() == null || reportInputArray2[i].getUnit().isNull()) {
                    InterpolatedScalarTimeSeries interpolatedScalarTimeSeries = new InterpolatedScalarTimeSeries(pointTrendingParameters.getTimeParameters(), reportInputArray2[i], pointTrendingParameters.isNormalizedByFloorArea(), pointTrendingParameters.isNormalizedByTemperature(), pointTrendingParameters.getNormalTemperature(), pointTrendingParameters.getNormalTemperatureUnit(), n, lexicon, pointTrendingParameters.getDataCleanse(), pointTrendingParameters.getDataCleanseWindow(), pointTrendingParameters.getDataCleansePercentage(), reportInputArray2[i].hasNormalizingPoint(), reportInputArray2[i].getNormalizingPoint());
                    object6 = new InputValueColors(reportInputArray2[i]);
                    chartModel.addSeries(interpolatedScalarTimeSeries, new DefaultLineConfig((ValueColors)object6), null, null);
                    this.detailTable.addSeries(interpolatedScalarTimeSeries, (ValueColors)object6);
                    if (this.config.isCorrelating() && this.config.getCorrelationInput1() == reportInputArray2[i]) {
                        timeSeries = interpolatedScalarTimeSeries;
                        n2 = 0;
                    }
                    if (!this.config.isCorrelating() || this.config.getCorrelationInput2() != reportInputArray2[i]) continue;
                    timeSeries2 = interpolatedScalarTimeSeries;
                    n3 = 0;
                    continue;
                }
                if (reportInputArray2[i].getUnit().equals((Object)BEasService.MULTISTATE)) {
                    MultistateTimeSeries multistateTimeSeries = new MultistateTimeSeries(pointTrendingParameters.getPeriod().getStartTime(), pointTrendingParameters.getPeriod().getEndTime(), reportInputArray2[i], n, lexicon);
                    object6 = new InputValueColors(reportInputArray2[i]);
                    chartModel.addSeries(multistateTimeSeries, new DefaultLineConfig(true, (ValueColors)object6), null, null);
                    this.detailTable.addSeries(multistateTimeSeries, (ValueColors)object6);
                    if (this.config.isCorrelating() && this.config.getCorrelationInput1() == reportInputArray2[i]) {
                        timeSeries = multistateTimeSeries;
                        n2 = 0;
                    }
                    if (!this.config.isCorrelating() || this.config.getCorrelationInput2() != reportInputArray2[i]) continue;
                    timeSeries2 = multistateTimeSeries;
                    n3 = 0;
                    continue;
                }
                int n4 = this.getTimeSeries(reportInputArray2[i].getUnit(), pointTrendingParameters, reportInputArray2[i].hasNormalizingPoint(), reportInputArray2[i].getNormalizingPoint()).addInput(reportInputArray2[i], false, 0);
                if (this.config.isCorrelating() && this.config.getCorrelationInput1() == reportInputArray2[i]) {
                    timeSeries = this.getTimeSeries(reportInputArray2[i].getUnit(), pointTrendingParameters, reportInputArray2[i].hasNormalizingPoint(), reportInputArray2[i].getNormalizingPoint());
                    n2 = n4;
                }
                if (!this.config.isCorrelating() || this.config.getCorrelationInput2() != reportInputArray2[i]) continue;
                timeSeries2 = this.getTimeSeries(reportInputArray2[i].getUnit(), pointTrendingParameters, reportInputArray2[i].hasNormalizingPoint(), reportInputArray2[i].getNormalizingPoint());
                n3 = n4;
            }
            Object object7 = this.timeSeriesByUnit.values().iterator();
            while (object7.hasNext()) {
                InterpolatedTimeSeries interpolatedTimeSeries = (InterpolatedTimeSeries)object7.next();
                object6 = interpolatedTimeSeries.getInputList();
                reportInputArray = new ReportInput[object6.size()];
                reportInputArray = object6.toArray(reportInputArray);
                if (interpolatedTimeSeries.getValueCount() <= 0) continue;
                object5 = new InputValueColors(reportInputArray);
                chartModel.addSeries(interpolatedTimeSeries, new DefaultLineConfig(2, false, (ValueColors)object5), null, null);
                this.detailTable.addSeries(interpolatedTimeSeries, (ValueColors)object5);
            }
            object7 = null;
            Population population = null;
            object6 = null;
            reportInputArray = chartModel.getSeriesIds();
            if (reportInputArray.hasNext() && (object5 = chartModel.getSeries((Id)(object6 = (Id)reportInputArray.next()))) != null) {
                population = ((TimeSeries)object5).getTimestampPopulation();
                object4 = ((Series)object5).getValuePopulations();
                if (object4 != null && ((Population[])object4).length > 0) {
                    object7 = object4[0];
                }
            }
            object5 = this.getInvalidRanges((Population)object7, population).iterator();
            while (object5.hasNext()) {
                object4 = (Population[])object5.next();
                object3 = new RangeOverlay(1, ((RangeBounds)object4).getX1(), Math.min((long)population.getSample(population.getSize() - 1), ((RangeBounds)object4).getX2() + pointTrendingParameters.getIntervalMillis()));
                ((RangeOverlay)object3).setXORColor(new Color(204, 204, 204));
                chartModel.addOverlay((Overlay)object3, (Id)object6);
            }
            object5 = pointTrendingParameters.getBaseline();
            if (object5 != null && ((ReportInput)object5).isEnabled()) {
                Object[] objectArray;
                int n5;
                Object object8;
                object4 = null;
                object3 = null;
                object2 = null;
                axisInfo = new PointTrendingBaselineAxisInfo();
                if (((ReportInput)object5).getUnit() == null || ((ReportInput)object5).getUnit().isNull()) {
                    object8 = new InterpolatedScalarTimeSeries(pointTrendingParameters.getTimeParameters(), (ReportInput)object5, pointTrendingParameters.isNormalizedByFloorArea(), pointTrendingParameters.isNormalizedByTemperature(), pointTrendingParameters.getNormalTemperature(), pointTrendingParameters.getNormalTemperatureUnit(), n, lexicon, pointTrendingParameters.getDataCleanse(), pointTrendingParameters.getDataCleanseWindow(), pointTrendingParameters.getDataCleansePercentage(), ((ReportInput)object5).hasNormalizingPoint(), ((ReportInput)object5).getNormalizingPoint());
                    n5 = ((Series)object8).getRowCount();
                    InterpolatedScalarTimeSeries interpolatedScalarTimeSeries = new InterpolatedScalarTimeSeries(pointTrendingParameters.getBaselineTimeParameters(), (ReportInput)object5, pointTrendingParameters.isNormalizedByFloorArea(), pointTrendingParameters.isNormalizedByTemperature(), pointTrendingParameters.getNormalTemperature(), pointTrendingParameters.getNormalTemperatureUnit(), lexicon, true, n5, pointTrendingParameters.getTimeParameters(), n, pointTrendingParameters.getBaselineTimeParameters(), pointTrendingParameters.getDataCleanse(), pointTrendingParameters.getDataCleanseWindow(), pointTrendingParameters.getDataCleansePercentage(), ((ReportInput)object5).hasNormalizingPoint(), ((ReportInput)object5).getNormalizingPoint());
                    interpolatedScalarTimeSeries.setTimeParameters(pointTrendingParameters.getTimeParameters());
                    object = new InputValueColors((ReportInput)object5);
                    object2 = chartModel.addSeries(interpolatedScalarTimeSeries, new DefaultLineConfig((ValueColors)object), axisInfo, null);
                    this.detailTable.addSeries(interpolatedScalarTimeSeries, (ValueColors)object);
                    if (this.config.isCorrelating() && this.config.isCorrelationInput1Baseline()) {
                        timeSeries = interpolatedScalarTimeSeries;
                        n2 = 0;
                    }
                    if (this.config.isCorrelating() && this.config.isCorrelationInput2Baseline()) {
                        timeSeries2 = interpolatedScalarTimeSeries;
                        n3 = 0;
                    }
                    object3 = ((TimeSeries)interpolatedScalarTimeSeries).getTimestampPopulation();
                    objectArray = interpolatedScalarTimeSeries.getValuePopulations();
                    if (objectArray != null && objectArray.length > 0) {
                        object4 = objectArray[0];
                    }
                } else if (((ReportInput)object5).getUnit().equals((Object)BEasService.MULTISTATE)) {
                    object8 = new MultistateTimeSeries(pointTrendingParameters.getPeriod().getStartTime(), pointTrendingParameters.getPeriod().getEndTime(), (ReportInput)object5, n, lexicon);
                    n5 = ((Series)object8).getRowCount();
                    MultistateTimeSeries multistateTimeSeries = new MultistateTimeSeries(pointTrendingParameters.getBaselinePeriod().getStartTime(), pointTrendingParameters.getBaselinePeriod().getEndTime(), (ReportInput)object5, lexicon, true, n5, pointTrendingParameters.getTimeParameters(), n, true);
                    multistateTimeSeries.setStartTime(pointTrendingParameters.getPeriod().getStartTime());
                    multistateTimeSeries.setEndTime(pointTrendingParameters.getPeriod().getEndTime());
                    object = new InputValueColors((ReportInput)object5);
                    object2 = chartModel.addSeries(multistateTimeSeries, new DefaultLineConfig(true, (ValueColors)object), axisInfo, null);
                    this.detailTable.addSeries(multistateTimeSeries, (ValueColors)object);
                    if (this.config.isCorrelating() && this.config.isCorrelationInput1Baseline()) {
                        timeSeries = multistateTimeSeries;
                        n2 = 0;
                    }
                    if (this.config.isCorrelating() && this.config.isCorrelationInput2Baseline()) {
                        timeSeries2 = multistateTimeSeries;
                        n3 = 0;
                    }
                    object3 = ((TimeSeries)multistateTimeSeries).getTimestampPopulation();
                    objectArray = multistateTimeSeries.getValuePopulations();
                    if (objectArray != null && objectArray.length > 0) {
                        object4 = objectArray[0];
                    }
                } else {
                    object8 = new InterpolatedTimeSeries(pointTrendingParameters.getBaselineTimeParameters(), ((ReportInput)object5).getUnit(), pointTrendingParameters.isNormalizedByFloorArea(), pointTrendingParameters.isNormalizedByTemperature(), pointTrendingParameters.getNormalTemperature(), pointTrendingParameters.getNormalTemperatureUnit(), n, pointTrendingParameters.getBaselineTimeParameters(), lexicon, pointTrendingParameters.getDataCleanse(), pointTrendingParameters.getDataCleanseWindow(), pointTrendingParameters.getDataCleansePercentage(), ((ReportInput)object5).hasNormalizingPoint(), ((ReportInput)object5).getNormalizingPoint());
                    n5 = pointTrendingParameters.getTimeParameters().getLocalTimePopulation().getSize();
                    int n6 = ((InterpolatedTimeSeries)object8).addInput((ReportInput)object5, true, n5);
                    ((InterpolatedTimeSeries)object8).setTimeParameters(pointTrendingParameters.getTimeParameters());
                    if (this.config.isCorrelating() && this.config.isCorrelationInput1Baseline()) {
                        timeSeries = object8;
                        n2 = n6;
                    }
                    if (this.config.isCorrelating() && this.config.isCorrelationInput2Baseline()) {
                        timeSeries2 = object8;
                        n3 = n6;
                    }
                    object = ((InterpolatedTimeSeries)object8).getInputList();
                    objectArray = new ReportInput[object.size()];
                    objectArray = object.toArray(objectArray);
                    if (((InterpolatedTimeSeries)object8).getValueCount() > 0) {
                        InputValueColors inputValueColors = new InputValueColors((ReportInput[])objectArray);
                        object2 = chartModel.addSeries((Series)object8, new DefaultLineConfig(2, false, inputValueColors), axisInfo, null);
                        this.detailTable.addSeries((Series)object8, inputValueColors);
                        object3 = ((TimeSeries)object8).getTimestampPopulation();
                        Population[] populationArray = ((Series)object8).getValuePopulations();
                        if (populationArray != null && populationArray.length > 0) {
                            object4 = populationArray[0];
                        }
                    }
                }
                object8 = this.getInvalidRanges((Population)object4, (Population)object3).iterator();
                while (object8.hasNext()) {
                    RangeBounds rangeBounds = (RangeBounds)object8.next();
                    RangeOverlay rangeOverlay = new RangeOverlay(1, rangeBounds.getX1(), Math.min((long)object3.getSample(object3.getSize() - 1), rangeBounds.getX2() + pointTrendingParameters.getIntervalMillis()));
                    rangeOverlay.setXORColor(new Color(230, 230, 230));
                    chartModel.addOverlay(rangeOverlay, (Id)object2);
                }
            }
            if (this.config.isCorrelating()) {
                object4 = new BivariateSeries(timeSeries, n2, timeSeries2, n3, this.config.getCorrelation2LagRollups(), Color.black, lexicon);
                object3 = new ChartModel();
                object2 = new AxisInfo();
                ((AxisInfo)object2).setTitle(this.config.getCorrelationInput1().getName());
                axisInfo = new AxisInfo();
                axisInfo.setTitle(this.config.getCorrelationInput2().getName());
                ((ChartModel)object3).setSeries((Series)object4, new DefaultScatterConfig(Color.black), (AxisInfo)object2, axisInfo);
                double d = ((BivariateSeries)object4).getCorrelation(0);
                DecimalFormat decimalFormat = new DecimalFormat("#.0000");
                if (this.config.showRegressionLine() && Math.abs(d) > 0.5) {
                    object = ((BivariateSeries)object4).getLinearRegressionSeries(0, Color.darkGray);
                    ((ChartModel)object3).addSeries((Series)object, new DefaultLineConfig(1, false, Color.darkGray), null, null);
                    ((ChartModel)object3).setSubtitle(lexicon.getText(RHO) + " = " + decimalFormat.format(d) + "\n" + lexicon.getText("y") + " = " + new DecimalFormat("#.000").format(((LinearRegressionSeries)object).getRegressionFunction().getSlope()) + lexicon.getText("x") + " " + (((LinearRegressionSeries)object).getRegressionFunction().getOffset() < 0.0 ? "" : "+ ") + new DecimalFormat("0.##").format(((LinearRegressionSeries)object).getRegressionFunction().getOffset()));
                } else {
                    ((ChartModel)object3).setSubtitle(lexicon.getText(RHO) + " = " + decimalFormat.format(d));
                }
                this.scatterChart.setModel((ChartModel)object3);
                this.setScatterVisible(true);
            } else {
                this.setScatterVisible(false);
            }
            object4 = new StringBuffer();
            ((StringBuffer)object4).append(reportPeriod.getDateRangeString());
            if (pointTrendingParameters.getBaseline() != null && pointTrendingParameters.getBaseline().isEnabled()) {
                ((StringBuffer)object4).append("\n(" + lexicon.getText("baseline") + " ");
                ((StringBuffer)object4).append(pointTrendingParameters.getBaselinePeriod().getDateRangeString());
                ((StringBuffer)object4).append(")");
            }
            this.chart.setModel(chartModel);
            this.chart.setSubtitle(((StringBuffer)object4).toString());
            this.detailTable.setTitle(lexicon.getText(TEMPLATE_ID));
            this.detailTable.setSubtitle(((StringBuffer)object4).toString());
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    private InterpolatedTimeSeries getTimeSeries(BUnit bUnit, PointTrendingParameters pointTrendingParameters, boolean bl, DataPoint dataPoint) {
        Lexicon lexicon = BEasApplet.lex;
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        BUnit bUnit2 = bUnit;
        if (bl && dataPoint != null) {
            try {
                bUnit2 = CompoundUnitUtil.make(bUnit2, dataPoint.getUnit());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.timeSeriesByUnit.containsKey(bUnit2)) {
            return (InterpolatedTimeSeries)this.timeSeriesByUnit.get(bUnit2);
        }
        ReportPeriod reportPeriod = pointTrendingParameters.getPeriod();
        int n = reportPeriod.getDaysOfWeek();
        InterpolatedTimeSeries interpolatedTimeSeries = new InterpolatedTimeSeries(pointTrendingParameters.getTimeParameters(), bUnit, pointTrendingParameters.isNormalizedByFloorArea(), pointTrendingParameters.isNormalizedByTemperature(), pointTrendingParameters.getNormalTemperature(), pointTrendingParameters.getNormalTemperatureUnit(), n, lexicon, pointTrendingParameters.getDataCleanse(), pointTrendingParameters.getDataCleanseWindow(), pointTrendingParameters.getDataCleansePercentage(), bl, dataPoint);
        if (bl && dataPoint != null) {
            try {
                this.timeSeriesByUnit.put(CompoundUnitUtil.make(bUnit, dataPoint.getUnit()), interpolatedTimeSeries);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.timeSeriesByUnit.put(bUnit, interpolatedTimeSeries);
            }
        } else {
            this.timeSeriesByUnit.put(bUnit, interpolatedTimeSeries);
        }
        return interpolatedTimeSeries;
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
            this.scatterChart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
            if (this.scatterChart != null) {
                this.scatterChart.setShowGrid(bl);
            }
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    public void setScatterVisible(boolean bl) {
        if (this.scatterChart == null) {
            return;
        }
        if (bl == this.scatterChart.isVisible() && this.scatterSplitLoc != -1) {
            return;
        }
        int n = this.scatterSplitPane.getDividerLocation();
        if (bl) {
            if (this.scatterSplitLoc == -1) {
                this.scatterSplitPane.setDividerLocation(0.4);
                this.scatterSplitLoc = this.scatterSplitPane.getDividerLocation();
            } else {
                this.scatterSplitPane.setDividerLocation(this.scatterSplitLoc);
            }
            this.scatterSplitPane.setDividerSize(4);
        } else {
            if (n != -1) {
                this.scatterSplitLoc = this.scatterSplitPane.getDividerLocation();
            }
            this.scatterSplitPane.setDividerSize(0);
            this.scatterSplitPane.setDividerLocation(0);
        }
        this.scatterChart.setVisible(bl);
        this.repaint();
    }

    protected Collection getInvalidRanges(Population population, Population population2) {
        if (population == null || population2 == null) {
            return new ArrayList(0);
        }
        ArrayList<RangeBounds> arrayList = new ArrayList<RangeBounds>(5);
        try {
            long l = -1L;
            long l2 = -1L;
            for (int i = 0; i < population.getSize(); ++i) {
                if (population.isValid(i)) {
                    if (l > 0L) {
                        arrayList.add(new RangeBounds(l, l2));
                    }
                    l = -1L;
                    l2 = -1L;
                    continue;
                }
                if (l < 0L) {
                    l = (long)population2.getSample(i);
                }
                l2 = (long)population2.getSample(i);
            }
            if (l > 0L) {
                arrayList.add(new RangeBounds(l, l2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.detailTable.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
            if (this.config.isCorrelating()) {
                book.append(this.scatterChart, pageFormat);
            }
        }
        return book;
    }

    private class PointTrendingBaselineAxisInfo
    extends AxisInfo {
        public boolean isShareable() {
            return false;
        }

        public boolean isShareableWith(AxisInfo axisInfo) {
            return false;
        }
    }

    private class Config
    extends JComponent
    implements ActionListener {
        private static final String NO_CORRELATION = "doNotCorrelate";
        private IntervalEditor interval;
        private ReportPeriodEditor periodEditor;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private XpComboBox series1;
        private XpComboBox series2;
        private IntervalEditor correlation2Lag;
        private JCheckBox showRegressionLine;
        private NumberTextField normTemperatureTextBox;
        private UnitComboBox normTemperatureUnitComboBox;
        private JPanel baselinePanel;
        private JToggleButton showBaselineDetails;
        private JLabel baselineSummary;
        private BaselineReportPeriodEditor baselinePeriodEditor;
        private XpComboBox baselineSeries;
        private JRadioButton displayBaseline;
        private JRadioButton displayBoth;
        private XpComboBox baselineColorCombo;

        public Config() {
            Lexicon lexicon = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = n++;
            this.periodEditor = new ReportPeriodEditor(lexicon);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(lexicon.getText("period")));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            this.add((Component)this.periodEditor, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            JPanel jPanel = new JPanel(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            int n2 = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.weightx = 100.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            MaxSizePanel maxSizePanel = new MaxSizePanel(200, 600);
            maxSizePanel.setLayout(new BorderLayout());
            this.showBaselineDetails = new JToggleButton(lexicon.getText("showDetails"));
            this.showBaselineDetails.setFont(font);
            this.showBaselineDetails.addActionListener(this);
            this.baselineSummary = new JLabel("  " + lexicon.getText("noBaseline"));
            this.baselineSummary.setForeground(UIManager.getColor("Table.foreground"));
            this.baselineSummary.setFont(font);
            maxSizePanel.add((Component)this.showBaselineDetails, "West");
            maxSizePanel.add((Component)this.baselineSummary, "Center");
            jPanel.add(maxSizePanel);
            gridBagConstraints2.gridy = n2++;
            gridBagLayout.setConstraints(maxSizePanel, gridBagConstraints2);
            this.baselinePanel = new JPanel(false);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            this.baselinePanel.setLayout(gridBagLayout2);
            int n3 = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.weightx = 100.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            this.baselinePeriodEditor = new BaselineReportPeriodEditor(false, lexicon, this.periodEditor, true);
            BaselineReportPeriod baselineReportPeriod = (BaselineReportPeriod)this.baselinePeriodEditor.getValue(true);
            baselineReportPeriod.setReferencePeriod(this.getPeriod(true));
            this.baselinePeriodEditor.setValue(baselineReportPeriod);
            this.baselinePeriodEditor.setBorder(BorderFactory.createTitledBorder(lexicon.getText("period")));
            this.baselinePanel.add(this.baselinePeriodEditor);
            gridBagConstraints3.gridy = n3++;
            gridBagLayout2.setConstraints(this.baselinePeriodEditor, gridBagConstraints3);
            this.baselineSeries = new XpComboBox();
            this.baselineSeries.addItem(lexicon.getText("noBaseline"));
            this.baselineSeries.setRenderer(new ReportInputListCellRenderer(30));
            this.baselineSeries.addActionListener(this);
            FixedSizePanel fixedSizePanel = new FixedSizePanel(this.baselineSeries);
            this.baselinePanel.add(fixedSizePanel);
            gridBagConstraints3.gridy = n3++;
            gridBagLayout2.setConstraints(fixedSizePanel, gridBagConstraints3);
            JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.gridheight = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new Insets(2, 2, 0, 0);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.fill = 0;
            JPanel jPanel3 = new JPanel(false);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            jPanel3.setLayout(gridBagLayout3);
            int n4 = 0;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints5.weightx = 100.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.gridheight = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.fill = 2;
            JLabel jLabel = new JLabel(lexicon.getText("baselineColor"));
            jLabel.setForeground(UIManager.getColor("Table.foreground"));
            jLabel.setFont(font);
            jPanel3.add(jLabel);
            gridBagConstraints5.gridy = n4++;
            gridBagLayout3.setConstraints(jLabel, gridBagConstraints5);
            this.baselineColorCombo = new XpComboBox();
            this.baselineColorCombo.setFont(font);
            this.baselineColorCombo.setRenderer(new ChartColorCellRenderer());
            int n5 = 0;
            int n6 = 0;
            while (n6 < ChartColors.getColorCount()) {
                this.baselineColorCombo.addItem(new Integer(n6));
                n5 = n6++;
            }
            this.baselineColorCombo.setSelectedIndex(n5);
            jPanel3.add(this.baselineColorCombo);
            gridBagConstraints5.gridy = n4++;
            gridBagLayout3.setConstraints(this.baselineColorCombo, gridBagConstraints5);
            jPanel2.add((Component)jPanel3, gridBagConstraints4);
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.weightx = 100.0;
            gridBagConstraints4.fill = 2;
            JPanel jPanel4 = new JPanel(false);
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            jPanel4.setLayout(gridBagLayout4);
            int n7 = 0;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints6.weightx = 100.0;
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.gridheight = 1;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.anchor = 18;
            gridBagConstraints6.fill = 2;
            this.displayBoth = new JRadioButton(lexicon.getText("displayBoth"), true);
            this.displayBoth.addActionListener(this);
            this.displayBoth.setFont(font);
            jPanel4.add(this.displayBoth);
            gridBagConstraints6.gridy = n7++;
            gridBagLayout4.setConstraints(this.displayBoth, gridBagConstraints6);
            this.displayBaseline = new JRadioButton(lexicon.getText("displayBaseline"), false);
            this.displayBaseline.addActionListener(this);
            this.displayBaseline.setFont(font);
            jPanel4.add(this.displayBaseline);
            gridBagConstraints6.gridy = n7++;
            gridBagLayout4.setConstraints(this.displayBaseline, gridBagConstraints6);
            jPanel4.setBorder(BorderFactory.createEtchedBorder());
            jPanel2.add((Component)jPanel4, gridBagConstraints4);
            this.baselinePanel.add(jPanel2);
            gridBagConstraints3.gridy = n3++;
            gridBagLayout2.setConstraints(jPanel2, gridBagConstraints3);
            this.baselinePanel.setVisible(this.showBaselineDetails.isSelected());
            jPanel.add(this.baselinePanel);
            gridBagConstraints2.gridy = n2++;
            gridBagLayout.setConstraints(this.baselinePanel, gridBagConstraints2);
            jPanel.setBorder(BorderFactory.createTitledBorder(lexicon.getText("baseline")));
            this.add(jPanel);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            this.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            JPanel jPanel5 = new JPanel(false);
            jPanel5.setLayout(new FlowLayout(0, 0, 0));
            this.interval = new IntervalEditor(lexicon);
            this.interval.setStep(900000L);
            this.interval.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.correlation2Lag.setStep(Config.this.interval.getValue());
                    PointTrending.this.setRunReportEnabled(Config.this.getInterval() > 0 && PointTrending.this.getInputList().getModel().getInputCount() > 0);
                }
            });
            jPanel5.add(this.interval);
            jPanel5.setBorder(BorderFactory.createTitledBorder(lexicon.getText("rollupInterval")));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            this.add((Component)jPanel5, gridBagConstraints);
            JPanel jPanel6 = new JPanel(false);
            this.add(jPanel6);
            jPanel6.setLayout(new GridBagLayout());
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PointTrending.this.refreshInputListEnabledStates();
                }
            };
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.weighty = 0.0;
            int n8 = 0;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = n8++;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.weightx = 0.0;
            this.normFloorArea = new JCheckBox(lexicon.getText("floorArea"));
            this.normFloorArea.setFont(font);
            this.normFloorArea.addActionListener(actionListener);
            this.normFloorArea.setSelected(false);
            jPanel6.add((Component)this.normFloorArea, gridBagConstraints7);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = n8++;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.weightx = 0.0;
            this.normWeather = new JCheckBox(lexicon.getText("degreeDay"));
            this.normWeather.setFont(font);
            this.normWeather.addActionListener(actionListener);
            this.normWeather.setSelected(false);
            jPanel6.add((Component)this.normWeather, gridBagConstraints7);
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.weightx = 0.0;
            this.normTemperatureTextBox = new NumberTextField(3);
            this.normTemperatureTextBox.setText(65);
            jPanel6.add((Component)this.normTemperatureTextBox, gridBagConstraints7);
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.weightx = 0.0;
            this.normTemperatureUnitComboBox = new UnitComboBox(UnitDatabase.getDefault().getQuantity(BUnit.getUnit((String)"fahrenheit")), lexicon);
            this.normTemperatureUnitComboBox.setSelectedUnit(BUnit.getUnit((String)"fahrenheit"));
            jPanel6.add((Component)this.normTemperatureUnitComboBox, gridBagConstraints7);
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.weightx = 100.0;
            jPanel6.add(Box.createHorizontalGlue(), gridBagConstraints7);
            jPanel6.setBorder(BorderFactory.createTitledBorder(lexicon.getText("normalization")));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            this.add((Component)jPanel6, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            JPanel jPanel7 = new JPanel(new GridBagLayout(), false);
            jPanel7.setBorder(BorderFactory.createTitledBorder(lexicon.getText("correlation")));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.anchor = 18;
            gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.gridheight = 1;
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.fill = 0;
            jPanel7.add((Component)new JLabel(lexicon.getText("x")), gridBagConstraints8);
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.weightx = 100.0;
            gridBagConstraints8.fill = 2;
            this.series1 = new XpComboBox();
            this.series1.addItem(lexicon.getText("useBaseline"));
            this.series1.addItem(lexicon.getText(NO_CORRELATION));
            this.series1.setSelectedItem(lexicon.getText(NO_CORRELATION));
            this.series1.setRenderer(new ReportInputListCellRenderer(30));
            this.series1.addActionListener(this);
            jPanel7.add((Component)new FixedSizePanel(this.series1), gridBagConstraints8);
            gridBagConstraints8.gridy = 1;
            gridBagConstraints8.gridheight = 1;
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.fill = 0;
            jPanel7.add((Component)new JLabel(lexicon.getText("y")), gridBagConstraints8);
            this.series2 = new XpComboBox();
            this.series2.addItem(lexicon.getText("useBaseline"));
            this.series2.addItem(lexicon.getText(NO_CORRELATION));
            this.series2.setSelectedItem(lexicon.getText(NO_CORRELATION));
            this.series2.setRenderer(new ReportInputListCellRenderer(30));
            this.series2.addActionListener(this);
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.weightx = 100.0;
            gridBagConstraints8.fill = 2;
            jPanel7.add((Component)new FixedSizePanel(this.series2), gridBagConstraints8);
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.gridheight = 1;
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.fill = 0;
            jPanel7.add((Component)new JLabel(lexicon.getText("lag")), gridBagConstraints8);
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridwidth = 1;
            gridBagConstraints8.weightx = 100.0;
            gridBagConstraints8.fill = 2;
            this.correlation2Lag = new IntervalEditor(lexicon);
            jPanel7.add((Component)this.correlation2Lag, gridBagConstraints8);
            gridBagConstraints8.gridy = 3;
            gridBagConstraints8.gridheight = 1;
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.fill = 0;
            this.showRegressionLine = new JCheckBox(lexicon.getText("showRegression") + " |" + lexicon.getText(PointTrending.RHO) + "| > .5?", true);
            jPanel7.add((Component)new FixedSizePanel(this.showRegressionLine), gridBagConstraints8);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            this.add((Component)jPanel7, gridBagConstraints);
            this.setInterval(15);
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public void setShowRegressionLine(boolean bl) {
            this.showRegressionLine.setSelected(bl);
        }

        public boolean showRegressionLine() {
            return this.showRegressionLine.isSelected();
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) > 0);
            this.normWeather.setSelected((n & 4) > 0);
        }

        public int getInterval() {
            return (int)(this.interval.getValue() / 60000L);
        }

        public void setInterval(int n) {
            this.interval.setValue((long)n * 1000L * 60L);
            this.correlation2Lag.setStep(this.interval.getValue());
        }

        public long getIntervalMillis() {
            return this.interval.getValue();
        }

        public void removeInput(ReportInput reportInput) {
            this.baselineSeries.removeItem(reportInput);
            this.series1.removeItem(reportInput);
            this.series2.removeItem(reportInput);
        }

        public void addInput(ReportInput reportInput) {
            if (this.indexOf(this.series1, reportInput) < 0 && !BEasService.MULTISTATE.equals((Object)reportInput.getUnit())) {
                this.series1.addItem(reportInput);
                this.series2.addItem(reportInput);
            }
            if (this.indexOf(this.baselineSeries, reportInput) < 0) {
                this.baselineSeries.addItem(reportInput);
            }
        }

        public int indexOf(XpComboBox xpComboBox, Object object) {
            for (int i = 0; i < xpComboBox.getItemCount(); ++i) {
                if (!xpComboBox.getItemAt(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        public boolean isCorrelating() {
            return this.getCorrelationInput1() != null && this.getCorrelationInput2() != null;
        }

        public boolean isCorrelationInput1Baseline() {
            return this.series1.getSelectedItem() == PointTrending.this.lex.getText("useBaseline");
        }

        public void setCorrelationInput1(ReportInput reportInput) {
            if (reportInput == null) {
                this.series1.setSelectedItem(PointTrending.this.lex.getText(NO_CORRELATION));
            } else {
                this.series1.setSelectedItem(reportInput);
                if (this.series1.getSelectedItem() == PointTrending.this.lex.getText(NO_CORRELATION)) {
                    this.series1.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                }
            }
        }

        public ReportInput getCorrelationInput1() {
            if (this.series1.getSelectedItem() instanceof ReportInput) {
                return (ReportInput)this.series1.getSelectedItem();
            }
            if (this.series1.getSelectedItem() == PointTrending.this.lex.getText("useBaseline")) {
                return this.getBaselineSeries();
            }
            return null;
        }

        public boolean isCorrelationInput2Baseline() {
            return this.series2.getSelectedItem() == PointTrending.this.lex.getText("useBaseline");
        }

        public void setCorrelationInput2(ReportInput reportInput) {
            if (reportInput == null) {
                this.series2.setSelectedItem(PointTrending.this.lex.getText(NO_CORRELATION));
            } else {
                this.series2.setSelectedItem(reportInput);
                if (this.series2.getSelectedItem() == PointTrending.this.lex.getText(NO_CORRELATION)) {
                    this.series2.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                }
            }
        }

        public ReportInput getCorrelationInput2() {
            if (this.series2.getSelectedItem() instanceof ReportInput) {
                return (ReportInput)this.series2.getSelectedItem();
            }
            if (this.series2.getSelectedItem() == PointTrending.this.lex.getText("useBaseline")) {
                return this.getBaselineSeries();
            }
            return null;
        }

        public void setCorrelation2Lag(int n) {
            this.correlation2Lag.setValue(n * 60 * 1000);
        }

        public int getCorrelation2Lag() {
            return (int)(this.correlation2Lag.getValue() / 60000L);
        }

        public int getCorrelation2LagRollups() {
            return (int)(this.correlation2Lag.getValue() / this.interval.getValue());
        }

        public double getNormalTemperature() {
            return this.normTemperatureTextBox.getDoubleValue();
        }

        public void setNormalTemperature(double d) {
            this.normTemperatureTextBox.setText(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.normTemperatureUnitComboBox.getSelectedUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.normTemperatureUnitComboBox.setSelectedUnit(bUnit);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.showBaselineDetails) {
                this.baselinePanel.setVisible(this.showBaselineDetails.isSelected());
                PointTrending.this.getMainSplit().validate();
                if (this.showBaselineDetails.isSelected()) {
                    this.showBaselineDetails.setText(PointTrending.this.lex.getText("hideDetails"));
                } else {
                    this.showBaselineDetails.setText(PointTrending.this.lex.getText("showDetails"));
                }
            } else if (object == this.displayBoth) {
                this.displayBaseline.setSelected(!this.displayBoth.isSelected());
                if (this.getBaselineSourceSeries() != null && this.displayBaseline.isSelected()) {
                    if (this.getBaselineSourceSeries().equals(this.getCorrelationInput1())) {
                        this.series1.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                    }
                    if (this.getBaselineSourceSeries().equals(this.getCorrelationInput2())) {
                        this.series2.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                    }
                    this.series1.removeItem(this.getBaselineSourceSeries());
                    this.series2.removeItem(this.getBaselineSourceSeries());
                } else if (this.displayBoth.isSelected() && !PointTrending.this.refreshingInputListDisabled) {
                    PointTrending.this.refreshInputListEnabledStates();
                }
            } else if (object == this.displayBaseline) {
                this.displayBoth.setSelected(!this.displayBaseline.isSelected());
                if (this.getBaselineSourceSeries() != null && this.displayBaseline.isSelected()) {
                    if (this.getBaselineSourceSeries().equals(this.getCorrelationInput1())) {
                        this.series1.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                    }
                    if (this.getBaselineSourceSeries().equals(this.getCorrelationInput2())) {
                        this.series2.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                    }
                    this.series1.removeItem(this.getBaselineSourceSeries());
                    this.series2.removeItem(this.getBaselineSourceSeries());
                } else if (this.displayBoth.isSelected() && !PointTrending.this.refreshingInputListDisabled) {
                    PointTrending.this.refreshInputListEnabledStates();
                }
            } else if (object == this.baselineSeries) {
                if (this.getBaselineSeries() != null) {
                    this.baselineSummary.setText("  " + this.getBaselineSourceSeries().getName());
                } else {
                    this.baselineSummary.setText("  " + PointTrending.this.lex.getText("noBaseline"));
                }
                if (this.displayBaseline.isSelected()) {
                    if (this.getBaselineSourceSeries() != null && this.getBaselineSourceSeries().equals(this.getCorrelationInput1())) {
                        this.series1.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                    }
                    if (this.getBaselineSourceSeries() != null && this.getBaselineSourceSeries().equals(this.getCorrelationInput2())) {
                        this.series2.setSelectedItem(PointTrending.this.lex.getText("useBaseline"));
                    }
                    PointTrending.this.refreshInputListEnabledStates();
                    if (this.getBaselineSourceSeries() != null) {
                        this.series1.removeItem(this.getBaselineSourceSeries());
                        this.series2.removeItem(this.getBaselineSourceSeries());
                    }
                }
                if (this.series1.getSelectedItem() == PointTrending.this.lex.getText("useBaseline") && this.getBaselineSourceSeries() != null && BEasService.MULTISTATE.equals((Object)this.getBaselineSourceSeries().getUnit())) {
                    this.series1.setSelectedItem(PointTrending.this.lex.getText(NO_CORRELATION));
                }
                if (this.series2.getSelectedItem() == PointTrending.this.lex.getText("useBaseline") && this.getBaselineSourceSeries() != null && BEasService.MULTISTATE.equals((Object)this.getBaselineSourceSeries().getUnit())) {
                    this.series2.setSelectedItem(PointTrending.this.lex.getText(NO_CORRELATION));
                }
            } else if (object == this.series1) {
                if (this.series1.getSelectedItem() == PointTrending.this.lex.getText("useBaseline") && this.getBaselineSourceSeries() != null && BEasService.MULTISTATE.equals((Object)this.getBaselineSourceSeries().getUnit())) {
                    this.series1.setSelectedItem(PointTrending.this.lex.getText(NO_CORRELATION));
                }
            } else if (object == this.series2 && this.series2.getSelectedItem() == PointTrending.this.lex.getText("useBaseline") && this.getBaselineSourceSeries() != null && BEasService.MULTISTATE.equals((Object)this.getBaselineSourceSeries().getUnit())) {
                this.series2.setSelectedItem(PointTrending.this.lex.getText(NO_CORRELATION));
            }
        }

        public BaselineReportPeriod getBaselinePeriod(boolean bl) {
            return (BaselineReportPeriod)this.baselinePeriodEditor.getValue(bl);
        }

        public void setBaselinePeriod(BaselineReportPeriod baselineReportPeriod) {
            if (baselineReportPeriod == null) {
                BaselineReportPeriod baselineReportPeriod2 = new BaselineReportPeriod(EasLocalTime.getCurrentTime(), EasLocalTime.getCurrentTime(), this.getPeriod(true).getDaysOfWeek(), PointTrending.this.lex);
                baselineReportPeriod2.setReferencePeriod(this.getPeriod(true));
                this.baselinePeriodEditor.setValue(baselineReportPeriod2);
            } else {
                this.baselinePeriodEditor.setValue(baselineReportPeriod);
            }
        }

        public void setBaselineSeries(ReportInput reportInput) {
            if (reportInput == null) {
                this.baselineSeries.setSelectedItem(PointTrending.this.lex.getText("noBaseline"));
            } else {
                this.baselineSeries.setSelectedItem(reportInput);
            }
        }

        public ReportInput getBaselineSourceSeries() {
            if (this.baselineSeries.getSelectedItem() instanceof ReportInput) {
                return (ReportInput)this.baselineSeries.getSelectedItem();
            }
            return null;
        }

        public ReportInput getBaselineSeries() {
            if (this.baselineSeries.getSelectedItem() instanceof ReportInput) {
                ReportInput reportInput = ((ReportInput)this.baselineSeries.getSelectedItem()).getCopy();
                reportInput.setName(PointTrending.this.lex.getText("baseline") + ": " + reportInput.getName());
                reportInput.setColor(ChartColors.getColor(this.getBaselineColor()));
                return reportInput;
            }
            return null;
        }

        public void setBaselineColor(int n) {
            this.baselineColorCombo.setSelectedIndex(n);
        }

        public int getBaselineColor() {
            return this.baselineColorCombo.getSelectedIndex();
        }

        public void setApplyBaseline(boolean bl) {
            if (bl) {
                this.displayBoth.setSelected(true);
                this.displayBaseline.setSelected(false);
            } else {
                this.displayBoth.setSelected(false);
                this.displayBaseline.setSelected(true);
            }
        }

        public boolean getApplyBaseline() {
            return this.displayBoth.isSelected();
        }
    }

    private static class RangeBounds {
        private long x1;
        private long x2;

        public RangeBounds(long l, long l2) {
            this.x1 = l;
            this.x2 = l2;
        }

        public long getX1() {
            return this.x1;
        }

        public long getX2() {
            return this.x2;
        }
    }
}

