/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DayOfWeek;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSDataIrregular;
import com.tridium.eas.api.TSDataIrregularRepeating;
import com.tridium.eas.function.Population;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class MultistateTimeSeries
extends TimeSeries {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private TSDataIrregular data = null;
    private TSDataIrregular origData = null;
    private double min;
    private double max;
    private EasLocalTime startTime;
    private EasLocalTime endTime;
    private String axisTitle = null;
    private ReportInput input = null;
    private Lexicon lex;
    private boolean repeat = false;
    private int repeatSize = 0;
    private int incl_wdays = -1;
    private RegularTimeParameters timeParams = null;
    private boolean useBaseline = false;

    public MultistateTimeSeries(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, ReportInput reportInput, Lexicon lexicon) throws EasException {
        this.startTime = easLocalTime;
        this.endTime = easLocalTime2;
        this.input = reportInput;
        this.axisTitle = null;
        this.lex = lexicon;
        this.repeat = false;
        this.repeatSize = 0;
        this.incl_wdays = -1;
        this.useBaseline = false;
        this.setInput(reportInput);
    }

    public MultistateTimeSeries(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, ReportInput reportInput, int n, Lexicon lexicon) throws EasException {
        this.startTime = easLocalTime;
        this.endTime = easLocalTime2;
        this.input = reportInput;
        this.axisTitle = null;
        this.lex = lexicon;
        this.repeat = false;
        this.repeatSize = 0;
        this.incl_wdays = n;
        this.useBaseline = false;
        this.setInput(reportInput);
    }

    public MultistateTimeSeries(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, ReportInput reportInput, Lexicon lexicon, boolean bl, int n, RegularTimeParameters regularTimeParameters) throws EasException {
        this.startTime = easLocalTime;
        this.endTime = easLocalTime2;
        this.input = reportInput;
        this.axisTitle = null;
        this.lex = lexicon;
        this.repeat = bl;
        this.repeatSize = n;
        this.timeParams = regularTimeParameters;
        this.incl_wdays = -1;
        this.useBaseline = false;
        this.setInput(reportInput);
    }

    public MultistateTimeSeries(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, ReportInput reportInput, Lexicon lexicon, boolean bl, int n, RegularTimeParameters regularTimeParameters, int n2, boolean bl2) throws EasException {
        this.startTime = easLocalTime;
        this.endTime = easLocalTime2;
        this.input = reportInput;
        this.axisTitle = null;
        this.lex = lexicon;
        this.repeat = bl;
        this.repeatSize = n;
        this.timeParams = regularTimeParameters;
        this.incl_wdays = n2;
        this.useBaseline = bl2;
        this.setInput(reportInput);
    }

    public String getSeriesName() {
        return " ";
    }

    public int getRowCount() {
        return this.data.getSize();
    }

    public int getValueCount() {
        return 1;
    }

    public double getMin(int n) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                d = Math.min(d, this.getValue(i, n));
                continue;
            }
            bl = true;
            d = this.getValue(i, n);
        }
        return d;
    }

    public double getMax(int n) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                d = Math.max(d, this.getValue(i, n));
                continue;
            }
            bl = true;
            d = this.getValue(i, n);
        }
        return d;
    }

    public double getValue(int n, int n2) {
        return this.data.getDouble(n);
    }

    public int getValueType() {
        return 0;
    }

    public BUnit getValueUnits() {
        return BEasService.MULTISTATE;
    }

    public void setInput(ReportInput reportInput) throws EasException {
        if (!reportInput.isEnabled() || reportInput.isDisaggregated()) {
            return;
        }
        ReportInputItem[] reportInputItemArray = reportInput.getInputItems();
        SiteDataPoint siteDataPoint = (SiteDataPoint)reportInputItemArray[0];
        DataPoint dataPoint = siteDataPoint.getDataPoint();
        this.origData = this.data = dataPoint.getRawData(this.startTime, this.endTime);
        if (this.repeat) {
            this.data = new TSDataIrregularRepeating(this.data.getData(), this.data.getTimeZone(), this.repeatSize, this.timeParams, this.startTime, this.endTime);
        }
    }

    public String getRowName(int n) {
        return "";
    }

    public Color getValueColor(int n) {
        return this.input.getColor();
    }

    public String getValueName(int n) {
        return this.input.getName();
    }

    public void setStartTime(EasLocalTime easLocalTime) {
        this.startTime = easLocalTime;
    }

    public void setEndTime(EasLocalTime easLocalTime) {
        this.endTime = easLocalTime;
    }

    public long getTimestamp(int n) {
        return this.data.getLocalTime(n);
    }

    public long getMinTimestamp() {
        return this.startTime.getTimestamp(BTimeZone.getLocal());
    }

    public long getMaxTimestamp() {
        return this.endTime.getTimestamp(BTimeZone.getLocal());
    }

    private void setAxisTitle() {
        if (this.axisTitle == null) {
            StringBuffer stringBuffer = new StringBuffer(this.lex.getText("time"));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Date date = this.startTime.getDate(BTimeZone.getLocal());
            gregorianCalendar.setTime(date);
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTime(this.endTime.getDate(BTimeZone.getLocal()));
            if (gregorianCalendar.get(1) == gregorianCalendar2.get(1) && gregorianCalendar.get(6) == gregorianCalendar2.get(6)) {
                SimpleDateFormat simpleDateFormat;
                if (this.lex != null) {
                    try {
                        simpleDateFormat = new SimpleDateFormat(" (" + this.lex.getText("timeAxisDateFormat2") + ")", new Locale(this.lex.language, ""));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        simpleDateFormat = new SimpleDateFormat(" (MMMM d, yyyy)", new Locale(this.lex.language, ""));
                    }
                } else {
                    simpleDateFormat = new SimpleDateFormat(" (MMMM d, yyyy)");
                }
                stringBuffer.append(simpleDateFormat.format(date));
            }
            this.axisTitle = stringBuffer.toString();
        }
    }

    public String getAxisTitle() {
        this.setAxisTitle();
        return this.axisTitle;
    }

    public Population getTimestampPopulation() {
        return new Population(){

            public int getSize() {
                return MultistateTimeSeries.this.getRowCount();
            }

            public double getSample(int n) {
                return MultistateTimeSeries.this.getTimestamp(n);
            }

            public BUnit getUnit() {
                return BUnit.getUnit((String)"millisecond");
            }

            public boolean isValid(int n) {
                return true;
            }
        };
    }

    public Population getValuePopulation(int n) {
        if (this.popList == null) {
            this.popList = new ArrayList();
        }
        while (this.popList.size() <= n) {
            this.popList.add(null);
        }
        DoWFilterValuePopulation doWFilterValuePopulation = new DoWFilterValuePopulation(n);
        this.popList.set(n, doWFilterValuePopulation);
        return doWFilterValuePopulation;
    }

    public class DoWFilterValuePopulation
    extends Series.ValuePopulation {
        public DoWFilterValuePopulation(int n) {
            super(n);
        }

        public boolean isValid(int n) {
            long l = MultistateTimeSeries.this.useBaseline ? MultistateTimeSeries.this.origData.getLocalTime(n % MultistateTimeSeries.this.origData.getSize()) : MultistateTimeSeries.this.getTimestamp(n);
            Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
            calendar.setTime(new Date(l));
            DayOfWeek dayOfWeek = new DayOfWeek(MultistateTimeSeries.this.incl_wdays);
            return dayOfWeek.included(calendar);
        }
    }
}

