/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.reports.ReportInputItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class MeterInputItem
extends ReportInputItem {
    private Meter meter;
    private boolean associatedDpLookup = false;
    private DataPoint consumption;
    private DataPoint demand;
    private DataPoint reactiveEnergy;
    private DataPoint apparentEnergy;
    private DataPoint reactivePower;
    private DataPoint apparentPower;
    private Site site;
    private DataPoint mainElectricDataPoint;
    private DataPoint mainGasDataPoint;
    private DataPoint oaTempDataPoint;
    private Lexicon lex;

    public MeterInputItem(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public MeterInputItem(Meter meter, Lexicon lexicon) {
        this.meter = meter;
        this.lex = lexicon;
    }

    public int getType() {
        return 2;
    }

    public BUnit getUnit() {
        return null;
    }

    public String getText() {
        return this.getSiteName() + ": " + this.meter.toString();
    }

    public Meter getMeter() {
        return this.meter;
    }

    protected void setMeter(Meter meter) {
        this.meter = meter;
        this.site = null;
        this.associatedDpLookup = false;
    }

    public Site getSite() {
        if (this.site == null) {
            try {
                this.site = this.meter.getSite();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.site;
    }

    public String getSiteName() {
        Site site = this.getSite();
        if (site == null) {
            return this.lex.getText("unknown");
        }
        return site.getName();
    }

    public double getFloorAreaValue() {
        try {
            return this.meter.getFloorAreaValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0;
        }
    }

    public BUnit getFloorAreaUnit() {
        try {
            return this.meter.getFloorAreaUnit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public DataPoint getConsumptionDataPoint() {
        this.setAssociatedDataPoints();
        return this.consumption;
    }

    public DataPoint getDemandDataPoint() {
        this.setAssociatedDataPoints();
        return this.demand;
    }

    public DataPoint getReactiveEnergyDataPoint() {
        this.setAssociatedDataPoints();
        return this.reactiveEnergy;
    }

    public DataPoint getApparentEnergyDataPoint() {
        this.setAssociatedDataPoints();
        return this.apparentEnergy;
    }

    public DataPoint getReactivePowerDataPoint() {
        this.setAssociatedDataPoints();
        return this.reactivePower;
    }

    public DataPoint getApparentPowerDataPoint() {
        this.setAssociatedDataPoints();
        return this.apparentPower;
    }

    public DataPoint getMainGasDataPoint() {
        this.setAssociatedDataPoints();
        return this.mainGasDataPoint;
    }

    public DataPoint getMainElectricDataPoint() {
        this.setAssociatedDataPoints();
        return this.mainElectricDataPoint;
    }

    public DataPoint getOutdoorAirTempDataPoint() {
        this.setAssociatedDataPoints();
        return this.oaTempDataPoint;
    }

    private void setAssociatedDataPoints() {
        if (!this.associatedDpLookup) {
            this.associatedDpLookup = true;
            try {
                this.consumption = this.meter.getDataPoint(RcSubtype.CONSUMPTION.getCode());
                this.demand = this.meter.getDataPoint(RcSubtype.DEMAND.getCode());
                this.reactiveEnergy = this.meter.getDataPoint(RcSubtype.REACTIVE_ENERGY.getCode());
                this.apparentEnergy = this.meter.getDataPoint(RcSubtype.APPARENT_ENERGY.getCode());
                this.reactivePower = this.meter.getDataPoint(RcSubtype.REACTIVE_POWER.getCode());
                this.apparentPower = this.meter.getDataPoint(RcSubtype.APPARENT_POWER.getCode());
                DataPoint[] dataPointArray = this.getSite().getOwnedDataPoints();
                for (int i = 0; i < dataPointArray.length; ++i) {
                    if (dataPointArray[i].getRcType() == RcType.ELECTRIC.getCode()) {
                        this.mainElectricDataPoint = dataPointArray[i];
                        continue;
                    }
                    if (dataPointArray[i].getRcType() == RcType.GAS.getCode()) {
                        this.mainGasDataPoint = dataPointArray[i];
                        continue;
                    }
                    if (dataPointArray[i].getRcType() != RcType.OUTSIDE_AIR_TEMP.getCode()) continue;
                    this.oaTempDataPoint = dataPointArray[i];
                }
            }
            catch (EasException easException) {
                easException.printStackTrace();
                this.associatedDpLookup = false;
            }
        }
    }

    public boolean isCompatible(ReportInputItem reportInputItem) {
        if (!(reportInputItem instanceof MeterInputItem)) {
            return false;
        }
        try {
            int n = this.getMeter().getRcType();
            int n2 = ((MeterInputItem)reportInputItem).getMeter().getRcType();
            return n == n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void save(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.meter.getId());
    }

    public boolean load(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        long l = dataInput.readLong();
        Meter meter = Meter.get(l, easSession);
        meter.load();
        this.setMeter(meter);
        if (meter == null) {
            throw new EasException(this.lex.getText("deletedMeterLoad"));
        }
        return true;
    }
}

