/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.LoadDurationSeries;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class LoadDurationTableModel
extends AbstractRowMappedTableModel {
    private LoadDurationSeries[] seriesList = null;
    private BUnit[] unitColumns = null;
    private int rowCount = -1;
    private Lexicon lex;
    static /* synthetic */ Class class$java$lang$Number;

    public LoadDurationTableModel(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public void addSeries(LoadDurationSeries loadDurationSeries, ValueColors valueColors) {
        if (this.unitColumns == null) {
            this.unitColumns = new BUnit[1];
            this.unitColumns[0] = loadDurationSeries.getValueUnits();
        } else {
            boolean bl = true;
            for (int i = 0; i < this.unitColumns.length; ++i) {
                if (!this.unitColumns[i].equals((Object)loadDurationSeries.getValueUnits())) continue;
                bl = false;
                break;
            }
            if (bl) {
                BUnit[] bUnitArray = new BUnit[this.unitColumns.length + 1];
                for (int i = 0; i < this.unitColumns.length; ++i) {
                    bUnitArray[i] = this.unitColumns[i];
                }
                bUnitArray[this.unitColumns.length] = loadDurationSeries.getValueUnits();
                this.unitColumns = bUnitArray;
            }
        }
        if (this.seriesList == null) {
            this.seriesList = new LoadDurationSeries[]{loadDurationSeries};
        } else {
            LoadDurationSeries[] loadDurationSeriesArray = new LoadDurationSeries[this.seriesList.length + 1];
            System.arraycopy(this.seriesList, 0, loadDurationSeriesArray, 0, this.seriesList.length);
            loadDurationSeriesArray[this.seriesList.length] = loadDurationSeries;
            this.seriesList = loadDurationSeriesArray;
        }
        this.reset();
    }

    public LoadDurationSeries[] getLoadDurationSeries() {
        return this.seriesList;
    }

    private void reset() {
        this.rowCount = -1;
    }

    public void clear() {
        this.seriesList = null;
        this.unitColumns = null;
        this.rowCount = -1;
    }

    public LoadDurationSeries getLoadDurationSeries(int n) {
        int n2 = n;
        if (this.unitColumns != null) {
            if (n2 < this.unitColumns.length) {
                return null;
            }
            n2 -= this.unitColumns.length;
        }
        if (this.seriesList == null || this.seriesList.length == 0) {
            return null;
        }
        return this.seriesList[n2];
    }

    public int getRowCount() {
        if (this.rowCount == -1) {
            if (this.seriesList == null) {
                return 0;
            }
            this.rowCount = 0;
            int n = this.seriesList == null ? 0 : this.seriesList.length;
            for (int i = 0; i < n; ++i) {
                this.rowCount = Math.max(this.rowCount, this.seriesList[i].getRowCount());
            }
        }
        return this.rowCount;
    }

    public int getColumnCount() {
        int n = 0;
        if (this.unitColumns != null) {
            n += this.unitColumns.length;
        }
        if (this.seriesList != null) {
            n += this.seriesList.length;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    public String getColumnName(int n) {
        int n2 = n;
        if (this.unitColumns != null) {
            if (n2 < this.unitColumns.length) {
                return this.unitColumns[n2].toString();
            }
            n2 -= this.unitColumns.length;
        }
        if (this.seriesList == null || this.seriesList.length == 0) {
            return "";
        }
        return this.seriesList[n2].getInput().getName() + " (" + this.seriesList[n2].getDoubleUnits().toString() + ")";
    }

    public Class getColumnClass(int n) {
        return class$java$lang$Number == null ? (class$java$lang$Number = LoadDurationTableModel.class$("java.lang.Number")) : class$java$lang$Number;
    }

    public Object getModelValueAt(int n, int n2) {
        int n3 = n2;
        if (this.unitColumns != null) {
            if (n3 < this.unitColumns.length) {
                for (int i = 0; i < this.seriesList.length; ++i) {
                    if (!this.seriesList[i].getValueUnits().equals((Object)this.unitColumns[n3])) continue;
                    return new Double(this.seriesList[i].getValue(n, 0));
                }
                System.out.println("Shouldn't ever get here in LoadDurationTableModel.getModelValueAt()");
                return null;
            }
            n3 -= this.unitColumns.length;
        }
        if (this.seriesList == null || this.seriesList.length == 0) {
            return null;
        }
        return new Double(this.seriesList[n3].getDouble(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

