/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.chart.FloatSeries;
import com.tridium.eas.ui.reports.DurationValuePair;
import com.tridium.eas.ui.reports.ReportInput;
import javax.baja.units.BUnit;

public class LoadDurationSeries
extends FloatSeries {
    private DurationValuePair[] data;
    private BUnit units;
    private int interval;
    private ReportInput input;
    private long overallDuration;
    public static final int MINUTES = 0;
    public static final int HOURS = 1;
    public static final int DAYS = 2;
    public static final int PERCENTAGE = 3;
    private static final BUnit MINUTE_UNITS = BUnit.getUnit((String)"minute");
    private static final BUnit HOUR_UNITS = BUnit.getUnit((String)"hour");
    private static final BUnit DAY_UNITS = BUnit.getUnit((String)"day");
    private static final BUnit PERCENTAGE_UNITS = BUnit.getUnit((String)"percent");

    public LoadDurationSeries(DurationValuePair[] durationValuePairArray, ReportInput reportInput, BUnit bUnit, int n, long l) {
        this.interval = n;
        this.data = durationValuePairArray;
        this.input = reportInput;
        this.units = bUnit;
        this.overallDuration = l;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public ReportInput getInput() {
        return this.input;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public String getSeriesName() {
        return "";
    }

    public int getValueType() {
        return 0;
    }

    public BUnit getValueUnits() {
        return this.units;
    }

    public double getValue(int n, int n2) {
        return this.data[n].getValue();
    }

    public double getDouble(int n) {
        double d = this.data[n].getDuration();
        double d2 = 0.0;
        switch (this.interval) {
            case 0: {
                d2 = d / 60000.0;
                break;
            }
            case 1: {
                d2 = d / 3600000.0;
                break;
            }
            case 2: {
                d2 = d / 8.64E7;
                break;
            }
            case 3: {
                d2 = d / (double)this.overallDuration * 100.0;
                break;
            }
            default: {
                d2 = d / 3600000.0;
            }
        }
        return d2;
    }

    public BUnit getDoubleUnits() {
        switch (this.interval) {
            case 0: {
                return MINUTE_UNITS;
            }
            case 1: {
                return HOUR_UNITS;
            }
            case 2: {
                return DAY_UNITS;
            }
            case 3: {
                return PERCENTAGE_UNITS;
            }
        }
        return HOUR_UNITS;
    }

    public double getMinDouble() {
        return this.getDouble(0);
    }

    public double getMaxDouble() {
        if (this.data == null || this.data.length <= 0) {
            return 0.0;
        }
        return this.getDouble(this.data.length - 1);
    }

    public double getMin(int n) {
        if (this.data == null || this.data.length <= 0) {
            return 0.0;
        }
        return this.getValue(this.data.length - 1, n);
    }

    public double getMax(int n) {
        return this.getValue(0, n);
    }
}

