/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DayOfWeek;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TSDataSummaryRepeating;
import com.tridium.eas.function.Population;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class InterpolatedScalarTimeSeries
extends TimeSeries {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private ArrayList dataList = null;
    private BUnit floorAreaUnit = null;
    private double min;
    private double max;
    private RegularTimeParameters timeParms;
    private int normalization;
    private String axisTitle = null;
    private ReportInput input = null;
    private BUnit normalTemperatureUnit = null;
    private boolean dataCleanse = false;
    private int dataCleanseWindow = 4;
    private double dataCleansePercentage = 100.0;
    private boolean dpNormalization = false;
    private DataPoint normalizer = null;
    private double normalTemperature;
    private boolean isNormalizedByFloorArea = false;
    private boolean isNormalizedByTemperature = false;
    private Lexicon lex;
    private boolean repeat = false;
    private int repeatSize = 0;
    private int incl_wdays = -1;
    private RegularTimeParameters overallTimeParams = null;
    private RegularTimeParameters baselineTimeParms = null;
    private boolean useBaseline = false;

    public InterpolatedScalarTimeSeries(RegularTimeParameters regularTimeParameters, ReportInput reportInput, boolean bl, boolean bl2, double d, BUnit bUnit, Lexicon lexicon, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.timeParms = regularTimeParameters;
        this.input = reportInput;
        this.dataList = new ArrayList();
        this.axisTitle = null;
        this.isNormalizedByFloorArea = bl;
        this.isNormalizedByTemperature = bl2;
        this.normalTemperature = d;
        this.normalTemperatureUnit = bUnit;
        this.lex = lexicon;
        this.incl_wdays = -1;
        this.useBaseline = false;
        this.dataCleanse = bl3;
        this.dataCleanseWindow = n;
        this.dataCleansePercentage = d2;
        this.dpNormalization = bl4;
        this.normalizer = dataPoint;
        this.setInput(reportInput);
    }

    public InterpolatedScalarTimeSeries(RegularTimeParameters regularTimeParameters, ReportInput reportInput, boolean bl, boolean bl2, double d, BUnit bUnit, int n, Lexicon lexicon, boolean bl3, int n2, double d2, boolean bl4, DataPoint dataPoint) {
        this.timeParms = regularTimeParameters;
        this.input = reportInput;
        this.dataList = new ArrayList();
        this.axisTitle = null;
        this.isNormalizedByFloorArea = bl;
        this.isNormalizedByTemperature = bl2;
        this.normalTemperature = d;
        this.normalTemperatureUnit = bUnit;
        this.lex = lexicon;
        this.incl_wdays = n;
        this.useBaseline = false;
        this.dataCleanse = bl3;
        this.dataCleanseWindow = n2;
        this.dataCleansePercentage = d2;
        this.dpNormalization = bl4;
        this.normalizer = dataPoint;
        this.setInput(reportInput);
    }

    public InterpolatedScalarTimeSeries(RegularTimeParameters regularTimeParameters, ReportInput reportInput, boolean bl, boolean bl2, double d, BUnit bUnit, Lexicon lexicon, boolean bl3, int n, RegularTimeParameters regularTimeParameters2, boolean bl4, int n2, double d2, boolean bl5, DataPoint dataPoint) {
        this.timeParms = regularTimeParameters;
        this.input = reportInput;
        this.dataList = new ArrayList();
        this.axisTitle = null;
        this.isNormalizedByFloorArea = bl;
        this.isNormalizedByTemperature = bl2;
        this.normalTemperature = d;
        this.normalTemperatureUnit = bUnit;
        this.lex = lexicon;
        this.repeat = bl3;
        this.repeatSize = n;
        this.overallTimeParams = regularTimeParameters2;
        this.incl_wdays = -1;
        this.useBaseline = false;
        this.dataCleanse = bl4;
        this.dataCleanseWindow = n2;
        this.dataCleansePercentage = d2;
        this.dpNormalization = bl5;
        this.normalizer = dataPoint;
        this.setInput(reportInput);
    }

    public InterpolatedScalarTimeSeries(RegularTimeParameters regularTimeParameters, ReportInput reportInput, boolean bl, boolean bl2, double d, BUnit bUnit, Lexicon lexicon, boolean bl3, int n, RegularTimeParameters regularTimeParameters2, int n2, RegularTimeParameters regularTimeParameters3, boolean bl4, int n3, double d2, boolean bl5, DataPoint dataPoint) {
        this.timeParms = regularTimeParameters;
        this.input = reportInput;
        this.dataList = new ArrayList();
        this.axisTitle = null;
        this.isNormalizedByFloorArea = bl;
        this.isNormalizedByTemperature = bl2;
        this.normalTemperature = d;
        this.normalTemperatureUnit = bUnit;
        this.lex = lexicon;
        this.repeat = bl3;
        this.repeatSize = n;
        this.overallTimeParams = regularTimeParameters2;
        this.incl_wdays = n2;
        this.baselineTimeParms = regularTimeParameters3;
        this.useBaseline = true;
        this.dataCleanse = bl4;
        this.dataCleanseWindow = n3;
        this.dataCleansePercentage = d2;
        this.dpNormalization = bl5;
        this.normalizer = dataPoint;
        this.setInput(reportInput);
    }

    public String getSeriesName() {
        return " ";
    }

    public int getRowCount() {
        return this.dataList.size();
    }

    public int getValueCount() {
        return 1;
    }

    public double getMin(int n) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                d = Math.min(d, this.getValue(i, n));
                continue;
            }
            bl = true;
            d = this.getValue(i, n);
        }
        return d;
    }

    public double getMax(int n) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                d = Math.max(d, this.getValue(i, n));
                continue;
            }
            bl = true;
            d = this.getValue(i, n);
        }
        return d;
    }

    public double getValue(int n, int n2) {
        return (Double)this.dataList.get(n);
    }

    public int getValueType() {
        return 0;
    }

    public BUnit getValueUnits() {
        return this.input.getUnit();
    }

    public void setInput(ReportInput reportInput) {
        if (!reportInput.isEnabled() || reportInput.isDisaggregated()) {
            return;
        }
        try {
            this.dataList = new ArrayList();
            ReportInputItem[] reportInputItemArray = reportInput.getInputItems();
            SiteDataPoint siteDataPoint = (SiteDataPoint)reportInputItemArray[0];
            DataPoint dataPoint = siteDataPoint.getDataPoint();
            TSDataSummary tSDataSummary = dataPoint.getDataSummary(this.timeParms.getStartTime(), this.timeParms.getEndTime(), reportInput.getUnit(), this.incl_wdays, 0, this.timeParms.getInterval(), this.isNormalizedByFloorArea, this.isNormalizedByTemperature, this.normalTemperatureUnit, this.normalTemperature, this.dataCleanse, this.dataCleanseWindow, this.dataCleansePercentage, this.dpNormalization, this.normalizer);
            if (this.repeat) {
                tSDataSummary = new TSDataSummaryRepeating(tSDataSummary, this.repeatSize, this.overallTimeParams);
            }
            for (int i = 0; i < tSDataSummary.getSize(); ++i) {
                double d = tSDataSummary.getDataSummary(i).getTotalConsumption();
                this.dataList.add(new Double(d));
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
            this.dataList = new ArrayList();
        }
    }

    public String getRowName(int n) {
        return "";
    }

    public Color getValueColor(int n) {
        return this.input.getColor();
    }

    public String getValueName(int n) {
        return this.input.getName();
    }

    public long getTimestamp(int n) {
        return this.timeParms.getDefaultTime(n);
    }

    public long getMinTimestamp() {
        return this.timeParms.getStartTime().getTimestamp(BTimeZone.getLocal());
    }

    public long getMaxTimestamp() {
        return this.timeParms.getEndTime().getTimestamp(BTimeZone.getLocal());
    }

    public Population getTimestampPopulation() {
        return this.timeParms.getLocalTimePopulation();
    }

    public void setTimeParameters(RegularTimeParameters regularTimeParameters) {
        this.timeParms = regularTimeParameters;
    }

    private void setAxisTitle() {
        if (this.axisTitle == null) {
            StringBuffer stringBuffer = new StringBuffer(this.lex.getText("time"));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Date date = this.timeParms.getStartTime().getDate(BTimeZone.getLocal());
            gregorianCalendar.setTime(date);
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTime(this.timeParms.getEndTime().getDate(BTimeZone.getLocal()));
            if (gregorianCalendar.get(1) == gregorianCalendar2.get(1) && gregorianCalendar.get(6) == gregorianCalendar2.get(6)) {
                SimpleDateFormat simpleDateFormat;
                if (this.lex != null) {
                    try {
                        simpleDateFormat = new SimpleDateFormat(" (" + this.lex.getText("timeAxisDateFormat2") + ")", new Locale(this.lex.language, ""));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        simpleDateFormat = new SimpleDateFormat(" (MMMM d, yyyy)", new Locale(this.lex.language, ""));
                    }
                } else {
                    simpleDateFormat = new SimpleDateFormat(" (MMMM d, yyyy)");
                }
                stringBuffer.append(simpleDateFormat.format(date));
            }
            this.axisTitle = stringBuffer.toString();
        }
    }

    public String getAxisTitle() {
        this.setAxisTitle();
        return this.axisTitle;
    }

    public Population getValuePopulation(int n) {
        if (this.popList == null) {
            this.popList = new ArrayList();
        }
        while (this.popList.size() <= n) {
            this.popList.add(null);
        }
        DoWFilterValuePopulation doWFilterValuePopulation = new DoWFilterValuePopulation(n);
        this.popList.set(n, doWFilterValuePopulation);
        return doWFilterValuePopulation;
    }

    public class DoWFilterValuePopulation
    extends Series.ValuePopulation {
        public DoWFilterValuePopulation(int n) {
            super(n);
        }

        public boolean isValid(int n) {
            RegularTimeParameters regularTimeParameters;
            long l;
            if (InterpolatedScalarTimeSeries.this.useBaseline) {
                l = InterpolatedScalarTimeSeries.this.baselineTimeParms.getLocalTime(n % InterpolatedScalarTimeSeries.this.baselineTimeParms.getLocalNumIntervals());
                regularTimeParameters = InterpolatedScalarTimeSeries.this.baselineTimeParms;
            } else {
                l = InterpolatedScalarTimeSeries.this.getTimestamp(n);
                regularTimeParameters = InterpolatedScalarTimeSeries.this.timeParms;
            }
            Calendar calendar = Calendar.getInstance((TimeZone)regularTimeParameters.getDefaultTimeZone().tzSupport());
            calendar.setTime(new Date(l));
            DayOfWeek dayOfWeek = new DayOfWeek(InterpolatedScalarTimeSeries.this.incl_wdays);
            return dayOfWeek.included(calendar);
        }
    }
}

