/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.ExceptionSummary;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.function.Population;
import com.tridium.eas.ui.DecimalFormatter;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.ChartStatus;
import com.tridium.eas.ui.chart.DefaultLineConfig;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.LineOverlay;
import com.tridium.eas.ui.chart.Overlay;
import com.tridium.eas.ui.chart.PercentTimeSeries;
import com.tridium.eas.ui.chart.PopulationTimeSeries;
import com.tridium.eas.ui.chart.RangeOverlay;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.ExceptionReportDetailTableModel;
import com.tridium.eas.ui.reports.ExceptionReportParameters;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.util.CompoundUnitUtil;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ExceptionReportDetailPanel
extends JComponent {
    private ExceptionReportDetailTableModel tableModel = null;
    private Chart valueChart;
    private Chart differenceChart;
    private ReportInput input;
    private ExceptionReportParameters parms;
    private JSplitPane split;
    private JButton closeButton;
    private ArrayList listeners;
    private ExceptionSummary exceptionSummary;
    private LineOverlay valueTimePointer;
    private LineOverlay differenceTimePointer;
    private ExceptionReportDetailTable detailTable;
    private int splitLoc = -1;
    private CardLayout cards;
    private JPanel cardPanel;
    private JButton switchCardsButton;
    private DataPoint dp;
    private Lexicon lex;
    private static final String VALUE_CARD = "showAll";
    private static final String DIFFERENCE_CARD = "showDifferences";

    public ExceptionReportDetailPanel(ChartStatus chartStatus, ReportInput reportInput, ExceptionReportParameters exceptionReportParameters, ExceptionSummary exceptionSummary, boolean bl, Lexicon lexicon) throws EasException {
        Object object;
        StringBuffer stringBuffer;
        JLabel jLabel;
        this.lex = lexicon;
        this.parms = exceptionReportParameters;
        this.input = reportInput;
        this.listeners = new ArrayList();
        this.exceptionSummary = exceptionSummary;
        this.dp = ((SiteDataPoint)reportInput.getInputItem(0)).getDataPoint();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.cards = new CardLayout();
        this.cardPanel = new JPanel(this.cards, false);
        this.valueChart = new Chart(this.lex);
        this.valueChart.setChartStatus(chartStatus);
        this.valueChart.setShowGrid(bl);
        this.cardPanel.add(this.lex.getText(VALUE_CARD), this.valueChart);
        this.differenceChart = new Chart(this.lex);
        this.differenceChart.setChartStatus(chartStatus);
        this.differenceChart.setShowGrid(bl);
        this.cardPanel.add(this.lex.getText(DIFFERENCE_CARD), this.differenceChart);
        jPanel.add((Component)this.cardPanel, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        Font font = UIManager.getFont("Table.font");
        font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 4, 0, 0);
        if ((exceptionReportParameters.getComparisonMethod() & 0x45) > 0 && (exceptionReportParameters.getComparisonMethod() & 0x8A) > 0) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            jLabel = new JLabel(this.lex.getText("total"));
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            jLabel = new JLabel(this.lex.getText("above"));
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            jLabel = new JLabel(this.lex.getText("below"));
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
        }
        int n2 = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = n2++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        if ((exceptionReportParameters.getComparisonMethod() & 0x45) > 0 && (exceptionReportParameters.getComparisonMethod() & 0x8A) > 0) {
            jLabel = new JLabel(this.lex.getText("totalDifference"));
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            stringBuffer = new StringBuffer(this.convertAndFormat(exceptionSummary.getTotalDiff()));
            stringBuffer.append(" ");
            object = reportInput.getUnit();
            if (reportInput.hasNormalizingPoint()) {
                object = CompoundUnitUtil.make((BUnit)object, reportInput.getNormalizingPoint().getUnit());
            }
            stringBuffer.append(object.toString());
            jLabel = new JLabel(stringBuffer.toString());
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
        } else if ((exceptionReportParameters.getComparisonMethod() & 0x45) > 0) {
            jLabel = new JLabel(this.lex.getText("totalAbove"));
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
        } else if ((exceptionReportParameters.getComparisonMethod() & 0x8A) > 0) {
            jLabel = new JLabel(this.lex.getText("totalBelow"));
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
        }
        if ((exceptionReportParameters.getComparisonMethod() & 0x45) > 0) {
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            stringBuffer = new StringBuffer(this.convertAndFormat(exceptionSummary.getPositiveDiff()));
            stringBuffer.append(" ");
            object = reportInput.getUnit();
            if (reportInput.hasNormalizingPoint()) {
                object = CompoundUnitUtil.make((BUnit)object, reportInput.getNormalizingPoint().getUnit());
            }
            stringBuffer.append(object.toString());
            jLabel = new JLabel(stringBuffer.toString());
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
        }
        if ((exceptionReportParameters.getComparisonMethod() & 0x8A) > 0) {
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            stringBuffer = new StringBuffer(this.convertAndFormat(-1.0 * (exceptionSummary.getTotalDiff() - exceptionSummary.getPositiveDiff())));
            stringBuffer.append(" ");
            object = reportInput.getUnit();
            if (reportInput.hasNormalizingPoint()) {
                object = CompoundUnitUtil.make((BUnit)object, reportInput.getNormalizingPoint().getUnit());
            }
            stringBuffer.append(object.toString());
            jLabel = new JLabel(stringBuffer.toString());
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
        }
        if ((exceptionReportParameters.getComparisonMethod() & 3) > 0) {
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            jLabel = new JLabel(this.lex.getText("range") + " ");
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            stringBuffer = new StringBuffer(this.convertAndFormat(exceptionSummary.getSPC_LowerLimit()));
            stringBuffer.append(" " + this.lex.getText("to") + " ");
            stringBuffer.append(this.convertAndFormat(exceptionSummary.getSPC_UpperLimit()));
            stringBuffer.append(" ");
            object = reportInput.getUnit();
            if (reportInput.hasNormalizingPoint()) {
                object = CompoundUnitUtil.make((BUnit)object, reportInput.getNormalizingPoint().getUnit());
            }
            stringBuffer.append(object.toString());
            jLabel = new JLabel(stringBuffer.toString());
            jLabel.setFont(font);
            jPanel2.add((Component)jLabel, gridBagConstraints);
        }
        try {
            if (this.dp.getRcSubTypeObj() == RcSubtype.CONSUMPTION || this.dp.getRcSubTypeObj() == RcSubtype.REACTIVE_ENERGY || this.dp.getRcSubTypeObj() == RcSubtype.APPARENT_ENERGY) {
                if ((exceptionReportParameters.getComparisonMethod() & 0xC0) == 0) {
                    gridBagConstraints.gridy = n++;
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.anchor = 15;
                    gridBagConstraints.fill = 0;
                    jLabel = new JLabel(this.lex.getText("baseline"));
                    jLabel.setFont(font);
                    jPanel2.add((Component)jLabel, gridBagConstraints);
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.anchor = 15;
                    jLabel = new JLabel(this.lex.getText("observed"));
                    jLabel.setFont(font);
                    jPanel2.add((Component)jLabel, gridBagConstraints);
                }
                gridBagConstraints.gridy = n++;
                n2 = 0;
                gridBagConstraints.gridx = n2++;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jLabel = new JLabel(this.lex.getText("totalConsumption"));
                jLabel.setFont(font);
                jPanel2.add((Component)jLabel, gridBagConstraints);
                if ((exceptionReportParameters.getComparisonMethod() & 0xC0) == 0) {
                    gridBagConstraints.gridx = n2++;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    stringBuffer = new StringBuffer(this.convertAndFormat(exceptionSummary.getTotal() - exceptionSummary.getTotalDiff()));
                    stringBuffer.append(" ");
                    object = reportInput.getUnit();
                    if (reportInput.hasNormalizingPoint()) {
                        object = CompoundUnitUtil.make((BUnit)object, reportInput.getNormalizingPoint().getUnit());
                    }
                    stringBuffer.append(object.toString());
                    jLabel = new JLabel(stringBuffer.toString());
                    jLabel.setFont(font);
                    jPanel2.add((Component)jLabel, gridBagConstraints);
                }
                gridBagConstraints.gridx = n2++;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                stringBuffer = new StringBuffer(this.convertAndFormat(exceptionSummary.getTotal()));
                stringBuffer.append(" ");
                object = reportInput.getUnit();
                if (reportInput.hasNormalizingPoint()) {
                    object = CompoundUnitUtil.make((BUnit)object, reportInput.getNormalizingPoint().getUnit());
                }
                stringBuffer.append(object.toString());
                jLabel = new JLabel(stringBuffer.toString());
                jLabel.setFont(font);
                jPanel2.add((Component)jLabel, gridBagConstraints);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)), gridBagConstraints);
        if ((exceptionReportParameters.getComparisonMethod() & 0xC0) == 0) {
            this.switchCardsButton = new JButton(this.lex.getText(DIFFERENCE_CARD));
            this.switchCardsButton.setAlignmentY(0.5f);
            this.switchCardsButton.setAlignmentX(0.5f);
            this.switchCardsButton.setMargin(new Insets(0, 1, 0, 1));
            this.switchCardsButton.setFont(font);
            this.switchCardsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExceptionReportDetailPanel.this.cards.next(ExceptionReportDetailPanel.this.cardPanel);
                    if (ExceptionReportDetailPanel.this.switchCardsButton.getText().equals(ExceptionReportDetailPanel.this.lex.getText(ExceptionReportDetailPanel.DIFFERENCE_CARD))) {
                        ExceptionReportDetailPanel.this.switchCardsButton.setText(ExceptionReportDetailPanel.this.lex.getText(ExceptionReportDetailPanel.VALUE_CARD));
                    } else {
                        ExceptionReportDetailPanel.this.switchCardsButton.setText(ExceptionReportDetailPanel.this.lex.getText(ExceptionReportDetailPanel.DIFFERENCE_CARD));
                    }
                }
            });
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridheight = n;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridx = 4;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            object = new JPanel(false);
            ((Container)object).setLayout(new BoxLayout((Container)object, 1));
            ((Container)object).add(Box.createVerticalGlue());
            ((Container)object).add(this.switchCardsButton);
            ((Container)object).add(Box.createVerticalGlue());
            jPanel2.add((Component)object, gridBagConstraints);
        }
        jPanel.add((Component)jPanel2, "South");
        object = new ChartModel();
        ChartModel chartModel = new ChartModel();
        this.tableModel = new ExceptionReportDetailTableModel(reportInput, exceptionReportParameters, exceptionSummary, this.lex);
        this.detailTable = new ExceptionReportDetailTable(this.lex);
        this.detailTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ExceptionReportDetailPanel.this.detailTable.getSelectedRow();
                if (n >= 0) {
                    EasLocalTime easLocalTime;
                    Date date;
                    if (ExceptionReportDetailPanel.this.valueTimePointer != null) {
                        date = (Date)ExceptionReportDetailPanel.this.tableModel.getValueAt(n, ExceptionReportDetailPanel.this.tableModel.getColumnIndex(0));
                        easLocalTime = new EasLocalTime(date.getTime(), ((ExceptionReportDetailPanel)ExceptionReportDetailPanel.this).detailTable.timeZone);
                        ExceptionReportDetailPanel.this.valueTimePointer.setLocation(easLocalTime.getTimestamp(BTimeZone.getLocal()));
                    }
                    if (ExceptionReportDetailPanel.this.differenceTimePointer != null) {
                        date = (Date)ExceptionReportDetailPanel.this.tableModel.getValueAt(n, ExceptionReportDetailPanel.this.tableModel.getColumnIndex(0));
                        easLocalTime = new EasLocalTime(date.getTime(), ((ExceptionReportDetailPanel)ExceptionReportDetailPanel.this).detailTable.timeZone);
                        ExceptionReportDetailPanel.this.differenceTimePointer.setLocation(easLocalTime.getTimestamp(BTimeZone.getLocal()));
                    }
                }
                if (ExceptionReportDetailPanel.this.valueTimePointer != null) {
                    ExceptionReportDetailPanel.this.valueTimePointer.setVisible(n >= 0);
                }
                if (ExceptionReportDetailPanel.this.differenceTimePointer != null) {
                    ExceptionReportDetailPanel.this.differenceTimePointer.setVisible(n >= 0);
                }
            }
        });
        this.split = new JSplitPane(0, jPanel, this.detailTable.getScrollPane());
        this.add((Component)this.split, "Center");
        this.retrieveDetailData();
        this.split.setDividerLocation(-1);
        JPanel jPanel3 = new JPanel(new FlowLayout(1), false);
        this.closeButton = new JButton(this.lex.getText("close"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionReportDetailPanel.this.fireActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.closeButton);
        this.add((Component)jPanel3, "South");
    }

    public void paint(Graphics graphics) {
        if (this.split.getDividerLocation() == -1) {
            this.split.setDividerLocation(0.75);
        }
        super.paint(graphics);
    }

    public boolean retrieveDetailData() {
        try {
            Object object;
            Object object2;
            Object object3;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n");
            stringBuffer.append(this.parms.getReportPeriod().getDateRangeString());
            stringBuffer.append("\n(" + this.lex.getText("baseline") + " ");
            stringBuffer.append(this.parms.getBaselinePeriod().getDateRangeString());
            stringBuffer.append(")");
            Population population = this.exceptionSummary.getTimeParameters().getLocalTimePopulation();
            Population population2 = this.input.getUnit() == null || this.input.getUnit().isNull() ? this.exceptionSummary.getObservedPopulation() : this.exceptionSummary.getObservedPopulation(this.input.hasNormalizingPoint() ? CompoundUnitUtil.make(this.input.getUnit(), this.input.getNormalizingPoint().getUnit()) : this.input.getUnit());
            PopulationTimeSeries populationTimeSeries = new PopulationTimeSeries(population, population2, "", this.input.getColor());
            ChartModel chartModel = new ChartModel();
            chartModel.setTitle(this.input.getName());
            chartModel.setSubtitle(stringBuffer.toString());
            ChartModel chartModel2 = null;
            AxisInfo axisInfo = new AxisInfo();
            Id id = null;
            Id id2 = null;
            if ((this.parms.getComparisonMethod() & 0xC0) == 0) {
                double d;
                axisInfo.setTitle(this.getDifferenceTitle());
                object3 = this.input.getUnit() == null || this.input.getUnit().isNull() ? this.exceptionSummary.getBaselinePopulation() : this.exceptionSummary.getBaselinePopulation(this.input.hasNormalizingPoint() ? CompoundUnitUtil.make(this.input.getUnit(), this.input.getNormalizingPoint().getUnit()) : this.input.getUnit());
                object2 = new PopulationTimeSeries(population, (Population)object3, "", Color.lightGray);
                object = (this.parms.getComparisonMethod() & 0xC) > 0 ? new PercentTimeSeries(population, this.exceptionSummary.getDiffPopulation(), "", this.input.getColor()) : new PopulationTimeSeries(population, this.exceptionSummary.getDiffPopulation(), "", this.input.getColor());
                chartModel.addSeries((Series)object2, new DefaultLineConfig(2, false, (ValueColors)object2), null, null);
                id2 = chartModel.addSeries(populationTimeSeries, new DefaultLineConfig(2, false, populationTimeSeries), null, null);
                chartModel2 = new ChartModel();
                chartModel2.setTitle(this.input.getName());
                chartModel2.setSubtitle(stringBuffer.toString());
                id = chartModel2.addSeries((Series)object, new DefaultLineConfig(2, false, (ValueColors)object), new AxisInfo(), axisInfo);
                this.valueTimePointer = new LineOverlay(1, (long)population.getSample(0));
                this.valueTimePointer.setVisible(false);
                this.valueTimePointer.setColor(Color.darkGray);
                this.differenceTimePointer = new LineOverlay(1, (long)population.getSample(0));
                this.differenceTimePointer.setVisible(false);
                this.differenceTimePointer.setColor(Color.darkGray);
                chartModel.addOverlay(this.valueTimePointer, id2);
                chartModel2.addOverlay(this.differenceTimePointer, id);
                if ((this.parms.getComparisonMethod() & 1) > 0) {
                    d = this.input.getUnit().fromNormal(this.dp.getUnit().toNormal(this.exceptionSummary.getSPC_UpperLimit()));
                    chartModel2.addOverlay(new LineOverlay(0, d), id);
                    populationTimeSeries.setRangeMax(d);
                    ((PopulationTimeSeries)object).setRangeMax(d);
                } else if ((this.parms.getComparisonMethod() & 0x40) > 0) {
                    d = this.exceptionSummary.getUpperLimit();
                    chartModel2.addOverlay(new LineOverlay(0, d), id);
                    populationTimeSeries.setRangeMax(d);
                    ((PopulationTimeSeries)object).setRangeMax(d);
                } else if ((this.parms.getComparisonMethod() & 4) > 0) {
                    d = this.exceptionSummary.getUpperLimit() * 100.0;
                    chartModel2.addOverlay(new LineOverlay(0, d), id);
                    populationTimeSeries.setRangeMax(d);
                    ((PopulationTimeSeries)object).setRangeMax(d);
                }
                if ((this.parms.getComparisonMethod() & 2) > 0) {
                    d = this.input.getUnit().fromNormal(this.dp.getUnit().toNormal(this.exceptionSummary.getSPC_LowerLimit()));
                    chartModel2.addOverlay(new LineOverlay(0, d), id);
                    populationTimeSeries.setRangeMin(d);
                    ((PopulationTimeSeries)object).setRangeMin(d);
                } else if ((this.parms.getComparisonMethod() & 0x80) > 0) {
                    d = this.exceptionSummary.getLowerLimit();
                    chartModel2.addOverlay(new LineOverlay(0, d), id);
                    populationTimeSeries.setRangeMin(d);
                    ((PopulationTimeSeries)object).setRangeMin(d);
                } else if ((this.parms.getComparisonMethod() & 8) > 0) {
                    d = this.exceptionSummary.getLowerLimit() * 100.0;
                    chartModel2.addOverlay(new LineOverlay(0, d), id);
                    populationTimeSeries.setRangeMin(d);
                    ((PopulationTimeSeries)object).setRangeMin(d);
                }
                if ((this.parms.getComparisonMethod() & 0x45) > 0 && (this.parms.getComparisonMethod() & 0x8A) > 0) {
                    chartModel2.addOverlay(new LineOverlay(0, 0), id);
                }
            } else {
                double d;
                id2 = chartModel.addSeries(populationTimeSeries, new DefaultLineConfig(2, false, populationTimeSeries), null, null);
                if ((this.parms.getComparisonMethod() & 0x45) > 0) {
                    d = this.input.getUnit().fromNormal(this.dp.getUnit().toNormal(this.exceptionSummary.getUpperLimit()));
                    object = new LineOverlay(0, d);
                    chartModel.addOverlay((Overlay)object, id2);
                    populationTimeSeries.setRangeMax(d);
                }
                if ((this.parms.getComparisonMethod() & 0x8A) > 0) {
                    d = this.input.getUnit().fromNormal(this.dp.getUnit().toNormal(this.exceptionSummary.getLowerLimit()));
                    object = new LineOverlay(0, d);
                    chartModel.addOverlay((Overlay)object, id2);
                    populationTimeSeries.setRangeMin(d);
                }
                this.valueTimePointer = new LineOverlay(1, (long)population.getSample(0));
                this.valueTimePointer.setVisible(false);
                this.valueTimePointer.setColor(Color.darkGray);
                chartModel.addOverlay(this.valueTimePointer, id2);
            }
            if (this.parms.getTemperatureColor() >= 0 && this.dp.getTemperatureDP() != null) {
                object3 = new PopulationTimeSeries(population, this.exceptionSummary.getTemperaturePopulation(), "", ChartColors.getColor(this.parms.getTemperatureColor()));
                chartModel.addSeries((Series)object3, new DefaultLineConfig(2, false, (ValueColors)object3), null, null);
            }
            object3 = this.getInvalidRanges().iterator();
            while (object3.hasNext()) {
                object2 = (RangeBounds)object3.next();
                object = new RangeOverlay(1, ((RangeBounds)object2).getX1(), Math.min((long)population.getSample(population.getSize() - 1), ((RangeBounds)object2).getX2() + this.parms.getRollupIntervalMillis()));
                ((RangeOverlay)object).setXORColor(new Color(204, 204, 204));
                chartModel.addOverlay((Overlay)object, id2);
                if ((this.parms.getComparisonMethod() & 0xC0) != 0) continue;
                chartModel2.addOverlay((Overlay)object, id);
            }
            this.valueChart.setModel(chartModel);
            if ((this.parms.getComparisonMethod() & 0xC0) == 0) {
                this.differenceChart.setModel(chartModel2);
            }
            return this.tableModel.retrieveDetailData();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return false;
        }
    }

    public void setShowGrid(boolean bl) {
        this.valueChart.setShowGrid(bl);
        this.differenceChart.setShowGrid(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        ActionEvent actionEvent2 = new ActionEvent(this, 0, actionEvent.getActionCommand(), actionEvent.getModifiers());
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent2);
        }
    }

    public ReportInput getInput() {
        return this.input;
    }

    public Chart getValueChart() {
        return this.valueChart;
    }

    public Chart getDifferenceChart() {
        return this.differenceChart;
    }

    protected Collection getInvalidRanges() {
        ArrayList<RangeBounds> arrayList = new ArrayList<RangeBounds>(5);
        try {
            Population population = this.exceptionSummary.getObservedPopulation();
            Population population2 = this.exceptionSummary.getBaselinePopulation();
            Population population3 = this.exceptionSummary.getTimeParameters().getLocalTimePopulation();
            long l = -1L;
            long l2 = -1L;
            boolean bl = (this.parms.getComparisonMethod() & 0xC0) == 0;
            for (int i = 0; i < population.getSize(); ++i) {
                if (population.isValid(i) && (!bl || population2.isValid(i % population2.getSize()))) {
                    if (l > 0L) {
                        arrayList.add(new RangeBounds(l, l2));
                    }
                    l = -1L;
                    l2 = -1L;
                    continue;
                }
                if (l < 0L) {
                    l = (long)population3.getSample(i);
                }
                l2 = (long)population3.getSample(i);
            }
            if (l > 0L) {
                arrayList.add(new RangeBounds(l, l2));
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return arrayList;
    }

    public void setDetailsVisible(boolean bl) {
        if (this.split == null) {
            return;
        }
        int n = this.split.getDividerSize();
        int n2 = this.split.getDividerLocation();
        if (!bl) {
            if (n2 != -1) {
                this.splitLoc = this.split.getDividerLocation();
            }
            this.split.setDividerSize(0);
            this.split.setDividerLocation(this.split.getPreferredSize().height);
            this.detailTable.setVisible(false);
        } else {
            if (this.splitLoc == -1) {
                int n3 = 75;
                double d = (double)n3 / 100.0;
                this.split.setDividerLocation(d);
            } else {
                this.split.setDividerLocation(this.splitLoc);
            }
            this.split.setDividerSize(4);
            this.detailTable.setVisible(true);
        }
        this.repaint();
    }

    protected String getDifferenceTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.parms.getComparisonMethod() & 0xC) > 0) {
            stringBuffer.append(this.lex.getText("%") + " ");
        }
        stringBuffer.append(this.lex.getText("baselineDifference"));
        return stringBuffer.toString();
    }

    protected String convertAndFormat(double d) {
        try {
            if (this.input.getUnit() == null || this.input.getUnit().isNull()) {
                return DecimalFormatter.format(d);
            }
            return DecimalFormatter.format(this.input.getUnit().fromNormal(this.dp.getUnit().toNormal(d)));
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return this.lex.getText("error");
        }
    }

    private static class RangeBounds {
        private long x1;
        private long x2;

        public RangeBounds(long l, long l2) {
            this.x1 = l;
            this.x2 = l2;
        }

        public long getX1() {
            return this.x1;
        }

        public long getX2() {
            return this.x2;
        }
    }

    private class ExceptionReportDetailTable
    extends EasReportTable {
        TableCellRenderer dateRenderer;
        TableCellRenderer pctRenderer;
        BTimeZone timeZone;

        public ExceptionReportDetailTable(Lexicon lexicon) {
            super((TableModel)ExceptionReportDetailPanel.this.tableModel, false, lexicon);
            DateFormat dateFormat = null;
            dateFormat = lexicon != null ? DateFormat.getDateTimeInstance(2, 2, new Locale(lexicon.language, "")) : DateFormat.getDateTimeInstance();
            DataPoint dataPoint = ((SiteDataPoint)ExceptionReportDetailPanel.this.input.getInputItem(0)).getDataPoint();
            try {
                this.timeZone = dataPoint.getTimeZone();
                dateFormat.setTimeZone((TimeZone)this.timeZone.tzSupport());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dateRenderer = new EasReportTable.DateRenderer(dateFormat, lexicon);
            this.pctRenderer = new EasReportTable.DoubleRenderer(new DecimalFormat("##0.0%"));
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (ExceptionReportDetailPanel.this.tableModel.getColumnType(this.convertColumnIndexToModel(n2)) == 0) {
                return this.dateRenderer;
            }
            if (ExceptionReportDetailPanel.this.tableModel.getColumnType(this.convertColumnIndexToModel(n2)) == 3 && (ExceptionReportDetailPanel.this.exceptionSummary.getLimitType() & 0xC) > 0) {
                return this.pctRenderer;
            }
            return super.getCellRenderer(n, n2);
        }

        public int getColumnWeight(int n) {
            return ExceptionReportDetailPanel.this.tableModel.getColumnType(this.convertColumnIndexToModel(n)) == 0 ? 100 : 0;
        }
    }
}

