/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.BaselinePeriod;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.ExceptionSummary;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.ChartColorCellRenderer;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.ExceptionReportDetailPanel;
import com.tridium.eas.ui.reports.ExceptionReportParameters;
import com.tridium.eas.ui.reports.ExceptionReportSummaryTableModel;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.BaselinePeriodEditor;
import com.tridium.eas.ui.widgets.ColorIcon;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.DaysOfWeekEditor;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.EasTimeEditor;
import com.tridium.eas.ui.widgets.IntervalEditor;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ExceptionReport
extends EasReport
implements EasDataListener {
    public static final String TEMPLATE_ID = "exception";
    private JTabbedPane tabPane = null;
    private ExceptionReportSummaryTableModel summaryTableModel = null;
    private JButton getDetailButton = null;
    private Config config = null;
    private ExceptionReportSummaryTable summaryTable = null;
    private SummaryTablePopup summaryTablePopup = null;
    private HashMap tabsByInput = null;
    private boolean refreshingInputListDisabled = false;

    public String getName() {
        return this.lex.getText("exceptions");
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        this.lex = BEasApplet.lex;
        if (this.tabPane == null) {
            this.tabPane = new JTabbedPane();
            JPanel jPanel = new JPanel(new BorderLayout(), false);
            JPanel jPanel2 = new JPanel(new FlowLayout(1));
            this.getDetailButton = new JButton(this.lex.getText("getDetails"));
            this.getDetailButton.setEnabled(false);
            this.getDetailButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ExceptionReport.this.getReportInputDetails(ExceptionReport.this.summaryTable.getSelectedReportInput());
                        }
                    });
                }
            });
            jPanel2.add(this.getDetailButton);
            jPanel.add((Component)jPanel2, "South");
            this.summaryTableModel = new ExceptionReportSummaryTableModel(this.lex);
            this.summaryTable = new ExceptionReportSummaryTable(this.summaryTableModel, this.lex);
            this.summaryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    ExceptionReport.this.getDetailButton.setEnabled(!listSelectionModel.isSelectionEmpty());
                }
            });
            this.summaryTablePopup = new SummaryTablePopup();
            this.summaryTable.setPopupHandler(new ListPopupHandler(){

                public void openPopup(Object object, int n, int n2, int n3) {
                    if (!ExceptionReport.this.summaryTable.getSelectionModel().isSelectionEmpty()) {
                        ExceptionReport.this.summaryTablePopup.show((Component)object, n2, n3);
                    }
                }
            });
            this.summaryTable.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && !ExceptionReport.this.summaryTable.getSelectionModel().isSelectionEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ExceptionReport.this.getReportInputDetails(ExceptionReport.this.summaryTable.getSelectedReportInput());
                            }
                        });
                    }
                }
            });
            jPanel.add((Component)this.summaryTable.getScrollPane(), "Center");
            this.tabPane.addTab(this.lex.getText("summary"), new ImageIcon(this.getResourceManager().getIconImage(22)), jPanel);
        }
        return this.tabPane;
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    public void getReportInputDetails(ReportInput reportInput) {
        this.lex = BEasApplet.lex;
        if (reportInput == null) {
            throw new NullPointerException();
        }
        ExceptionReportDetailPanel exceptionReportDetailPanel = (ExceptionReportDetailPanel)this.tabsByInput.get(reportInput);
        if (exceptionReportDetailPanel == null) {
            try {
                exceptionReportDetailPanel = new ExceptionReportDetailPanel(this, reportInput, (ExceptionReportParameters)this.getReportParameters(false), this.summaryTable.getSelectedSummary(), this.toggleGrid.isSelected(), this.lex);
                exceptionReportDetailPanel.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ExceptionReportDetailPanel exceptionReportDetailPanel = (ExceptionReportDetailPanel)actionEvent.getSource();
                        ExceptionReport.this.tabsByInput.remove(exceptionReportDetailPanel.getInput());
                        ExceptionReport.this.tabPane.remove(exceptionReportDetailPanel);
                        ExceptionReport.this.tabPane.setSelectedIndex(0);
                    }
                });
                this.tabsByInput.put(reportInput, exceptionReportDetailPanel);
                this.tabPane.addTab("", new ColorIcon(reportInput.getColor()), exceptionReportDetailPanel);
                if (!this.toggleDetails.isSelected()) {
                    exceptionReportDetailPanel.setDetailsVisible(false);
                }
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        } else {
            exceptionReportDetailPanel.retrieveDetailData();
        }
        this.tabPane.setSelectedComponent(exceptionReportDetailPanel);
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            if (this.tabPane.getSelectedComponent() instanceof ExceptionReportDetailPanel) {
                ((ExceptionReportDetailPanel)this.tabPane.getSelectedComponent()).getValueChart().zoomOut();
                ((ExceptionReportDetailPanel)this.tabPane.getSelectedComponent()).getDifferenceChart().zoomOut();
            }
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            Iterator iterator = this.tabsByInput.values().iterator();
            while (iterator.hasNext()) {
                ((ExceptionReportDetailPanel)iterator.next()).setShowGrid(bl);
            }
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    protected JComponent getApplicationToolBar() {
        return this.getApplicationToolBar(new int[]{17, 18, 28, 19, -1, 20, 21, 22});
    }

    protected void initReport() {
        this.getInputList().getModel().addEasDataListener(this);
        this.tabsByInput = new HashMap();
        this.setRunReportEnabled(false);
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    protected ReportParameters createEmptyParameters() {
        return new ExceptionReportParameters(this.lex);
    }

    protected ReportParameters getReportParameters(boolean bl) {
        return new ExceptionReportParameters(this.getInputList().getModel().getInputs(), this.config.getReportPeriod(!bl), this.config.getBaselinePeriod(!bl), this.config.getRollupIntervalMinutes(), this.config.getLowerLimit(), this.config.getUpperLimit(), this.config.getComparisonMethod(), this.config.getMaxExceptions(), this.config.useTemperatureCorrection(), this.config.getTemperatureColor(), this.config.getDaysOfWeek(), this.config.getStartHour(), this.config.getStartMinute(), this.config.getEndHour(), this.config.getEndMinute(), this.config.getExclusive(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    protected void setReportParameters(ReportParameters reportParameters) {
        ExceptionReportParameters exceptionReportParameters = (ExceptionReportParameters)reportParameters;
        this.getInputList().getModel().setInputs(exceptionReportParameters.getInputs());
        this.config.setReportPeriod(exceptionReportParameters.getReportPeriod());
        this.config.setBaselinePeriod(exceptionReportParameters.getBaselinePeriod());
        this.config.setRollupIntervalMinutes(exceptionReportParameters.getRollupIntervalMinutes());
        this.config.setComparisonMethod(exceptionReportParameters.getComparisonMethod());
        this.config.setLowerLimit(exceptionReportParameters.getLowerLimit());
        this.config.setUpperLimit(exceptionReportParameters.getUpperLimit());
        this.config.setMaxExceptions(exceptionReportParameters.getMaxExceptions());
        this.config.setUseTemperatureCorrection(exceptionReportParameters.useTemperatureCorrection());
        this.config.setTemperatureColor(exceptionReportParameters.getTemperatureColor());
        this.config.setDaysOfWeek(exceptionReportParameters.getDaysOfWeek());
        this.config.setStartHour(exceptionReportParameters.getStartHour());
        this.config.setStartMinute(exceptionReportParameters.getStartMinute());
        this.config.setEndHour(exceptionReportParameters.getEndHour());
        this.config.setEndMinute(exceptionReportParameters.getEndMinute());
        this.config.setExclusive(exceptionReportParameters.getExclusive());
        this.setDataCleanse(exceptionReportParameters.getDataCleanse());
        this.setDataCleanseWindow(exceptionReportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(exceptionReportParameters.getDataCleansePercentage());
    }

    public boolean allowDataPoint(DataPoint dataPoint) {
        return true;
    }

    public boolean allowAggregation() {
        return false;
    }

    public boolean addInput(ReportInput reportInput, boolean bl) {
        this.lex = BEasApplet.lex;
        if (!BEasService.MULTISTATE.equals((Object)reportInput.getUnit())) {
            super.addInput(reportInput, bl);
            return true;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.lex.getText("input") + " '");
            stringBuffer.append(reportInput.getName());
            stringBuffer.append("' " + this.lex.getText("multiStateUnsupported"));
            JOptionPane.showMessageDialog(this, stringBuffer, this.lex.getText("inputNotAdded"), 0);
        }
        return false;
    }

    public void addInputItemSet(InputItemSet inputItemSet, boolean bl) {
        boolean bl2 = bl;
        ReportInputItem[] reportInputItemArray = inputItemSet.getInputItems();
        for (int i = 0; i < reportInputItemArray.length; ++i) {
            bl2 = this.addInput(new ReportInput(null, reportInputItemArray[i].getUnit(), reportInputItemArray[i], this.lex), bl2) && bl2;
        }
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        this.setRunReportEnabled(this.config.getRollupIntervalMinutes() > 0 && this.getInputList().getModel().getInputCount() > 0);
        if (dataEditedEvent.getEditedData().length > 0 && !this.refreshingInputListDisabled) {
            this.refreshInputListEnabledStates();
        }
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        this.setRunReportEnabled(this.config.getRollupIntervalMinutes() > 0 && this.getInputList().getModel().getInputCount() > 0);
        if (dataEditedEvent.getEditedData().length > 0 && !this.refreshingInputListDisabled) {
            this.refreshInputListEnabledStates();
        }
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            ReportInput reportInput = (ReportInput)objectArray[i];
            Component component = (Component)this.tabsByInput.get(objectArray[i]);
            if (component == null) continue;
            this.tabPane.setIconAt(this.tabPane.indexOfComponent(component), new ColorIcon(reportInput.getColor()));
        }
        if (objectArray.length > 0 && !this.refreshingInputListDisabled) {
            this.refreshInputListEnabledStates();
        }
    }

    public void runReport(ReportParameters reportParameters) {
        ExceptionReportParameters exceptionReportParameters = (ExceptionReportParameters)reportParameters;
        if (exceptionReportParameters.getRollupIntervalMinutes() == 0) {
            return;
        }
        Iterator iterator = this.tabsByInput.values().iterator();
        while (iterator.hasNext()) {
            this.tabPane.remove((Component)iterator.next());
        }
        this.tabsByInput.clear();
        this.summaryTableModel.retrieveSummaryData(exceptionReportParameters);
        this.summaryTable.resetSorting();
    }

    public void setDetailsVisible(boolean bl) {
        Iterator iterator = this.tabsByInput.values().iterator();
        while (iterator.hasNext()) {
            ((ExceptionReportDetailPanel)iterator.next()).setDetailsVisible(bl);
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            Iterator<Object> iterator = this.summaryTable.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
            iterator = this.tabsByInput.values().iterator();
            while (iterator.hasNext()) {
                book.append(((ExceptionReportDetailPanel)iterator.next()).getValueChart(), pageFormat);
                book.append(((ExceptionReportDetailPanel)iterator.next()).getDifferenceChart(), pageFormat);
            }
        }
        return book;
    }

    protected void refreshInputListEnabledStates() {
        this.refreshingInputListDisabled = true;
        this.getInputList().getModel().enableAllInputs();
        ReportInput[] reportInputArray = this.getInputList().getModel().getInputs();
        boolean bl = false;
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.config.useTemperatureCorrection()) {
                ReportInputItem[] reportInputItemArray = reportInputArray[i].getInputItems();
                if (((SiteDataPoint)reportInputItemArray[0]).getOutdoorAirTempDataPoint() == null) {
                    this.getInputList().getModel().disableInput(i);
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        this.setRunReportEnabled(bl);
        this.refreshingInputListDisabled = false;
    }

    private static class ComparisonMethodItem {
        private String text;
        private int method;

        public ComparisonMethodItem(String string, int n) {
            this.text = string;
            this.method = n;
        }

        public String toString() {
            return this.text;
        }

        public int getMethod() {
            return this.method;
        }
    }

    private class ExceptionReportSummaryTable
    extends EasReportTable {
        public ExceptionReportSummaryTable(ExceptionReportSummaryTableModel exceptionReportSummaryTableModel, Lexicon lexicon) {
            super((TableModel)exceptionReportSummaryTableModel, false, lexicon);
        }

        public int getColumnWeight(int n) {
            return this.convertColumnIndexToModel(n) == 0 ? 100 : 0;
        }

        public ReportInput getSelectedReportInput() {
            return this.getSelectedRow() < 0 ? null : (ReportInput)this.getValueAt(this.getSelectedRow(), 0);
        }

        public ExceptionSummary getSelectedSummary() {
            return this.getSelectedRow() < 0 ? null : ((ExceptionReportSummaryTableModel)this.getModel()).getSummaryAt(this.getSelectedRow());
        }
    }

    private class SummaryTablePopup
    extends EasPopupMenu {
        public SummaryTablePopup() {
            this.add(new EasPopupMenu.EasPopupMenuItem(ExceptionReport.this.lex.getText("showDetails"), 0, null));
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ExceptionReport.this.getReportInputDetails(ExceptionReport.this.summaryTable.getSelectedReportInput());
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private class Config
    extends JComponent {
        private ReportPeriodEditor periodEditor;
        private BaselinePeriodEditor baselineEditor;
        private IntervalEditor interval;
        private NumberTextField lowerLimitTextBox;
        private NumberTextField maxExceptionsTextBox;
        private JCheckBox useTemperatureCorrectionCheckbox;
        private DaysOfWeekEditor daysOfWeek;
        private EasTimeEditor startTimeEditor;
        private EasTimeEditor endTimeEditor;
        private JCheckBox exclusiveCheckBox;
        private JCheckBox spcCheckBox;
        private JLabel lowerLimitLabel;
        private JLabel upperLimitLabel;
        private NumberTextField upperLimitTextBox;
        private XpComboBox methodComboBox;
        private XpComboBox temperatureColorCombo;
        private JCheckBox upperLimitCheckBox;
        private JCheckBox lowerLimitCheckBox;

        public Config() {
            ExceptionReport.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            this.setLayout(new BoxLayout(this, 1));
            this.periodEditor = new ReportPeriodEditor(false, ExceptionReport.this.lex);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(ExceptionReport.this.lex.getText("reportPeriod")));
            this.add(this.periodEditor);
            JPanel jPanel = new JPanel(new GridBagLayout(), false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 18;
            JPanel jPanel2 = new JPanel(false);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(ExceptionReport.this.lex.getText("rollupInterval")));
            this.interval = new IntervalEditor(ExceptionReport.this.lex);
            this.interval.setFont(font);
            this.interval.setStep(900000L);
            this.interval.setValue(21600000L);
            this.interval.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExceptionReport.this.setRunReportEnabled(Config.this.getRollupIntervalMinutes() > 0 && ExceptionReport.this.getInputList().getModel().getInputs() != null && ExceptionReport.this.getInputList().getModel().getInputs().length > 0);
                }
            });
            jPanel2.add(this.interval);
            jPanel2.add(Box.createVerticalGlue());
            jPanel.add((Component)jPanel2, gridBagConstraints);
            this.baselineEditor = new BaselinePeriodEditor(this.periodEditor, ExceptionReport.this.lex);
            this.baselineEditor.setBorder(BorderFactory.createTitledBorder(ExceptionReport.this.lex.getText("baselinePeriod")));
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)this.baselineEditor, gridBagConstraints);
            this.add(jPanel);
            JPanel jPanel3 = new JPanel(new BorderLayout(), false);
            jPanel3.setBorder(BorderFactory.createTitledBorder(ExceptionReport.this.lex.getText("temperature")));
            JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            JLabel jLabel = new JLabel(ExceptionReport.this.lex.getText("temperatureDataColor"));
            jLabel.setFont(font);
            jPanel4.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.temperatureColorCombo = new XpComboBox();
            this.temperatureColorCombo.setFont(font);
            this.temperatureColorCombo.addItem(new String(" "));
            this.temperatureColorCombo.setRenderer(new ChartColorCellRenderer());
            for (int i = 0; i < ChartColors.getColorCount(); ++i) {
                this.temperatureColorCombo.addItem(new Integer(i));
            }
            this.temperatureColorCombo.setSelectedIndex(0);
            jPanel4.add((Component)this.temperatureColorCombo, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            jPanel4.add(Box.createRigidArea(new Dimension(5, 0)), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.fill = 2;
            this.useTemperatureCorrectionCheckbox = new JCheckBox(ExceptionReport.this.lex.getText("adjustBaseline"));
            this.useTemperatureCorrectionCheckbox.setFont(font);
            this.useTemperatureCorrectionCheckbox.setSelected(false);
            this.useTemperatureCorrectionCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExceptionReport.this.refreshInputListEnabledStates();
                }
            });
            jPanel4.add((Component)this.useTemperatureCorrectionCheckbox, gridBagConstraints);
            jPanel3.add((Component)jPanel4, "Center");
            this.add(jPanel3);
            JPanel jPanel5 = new JPanel(new GridBagLayout(), false);
            jPanel5.setBorder(BorderFactory.createTitledBorder(ExceptionReport.this.lex.getText("comparisonDetails")));
            gridBagConstraints = new GridBagConstraints();
            n = 0;
            gridBagConstraints.insets = new Insets(3, 3, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            this.methodComboBox = new XpComboBox(new ComparisonMethodItem[]{new ComparisonMethodItem(ExceptionReport.this.lex.getText("useBaselinePercentage"), 12), new ComparisonMethodItem(ExceptionReport.this.lex.getText("useRangeValues"), 192), new ComparisonMethodItem(ExceptionReport.this.lex.getText("determineFromBaseline"), 3)});
            this.methodComboBox.setFont(font);
            jPanel5.add((Component)this.methodComboBox, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.lowerLimitLabel = new JLabel(ExceptionReport.this.lex.getText("threshhold") + " " + ExceptionReport.this.lex.getText("%"));
            this.lowerLimitLabel.setFont(font);
            jPanel5.add((Component)this.lowerLimitLabel, gridBagConstraints);
            this.lowerLimitTextBox = new NumberTextField(6, false);
            this.lowerLimitTextBox.setFont(font);
            this.lowerLimitTextBox.setText(15.0f);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            jPanel5.add((Component)this.lowerLimitTextBox, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(3, 3, 0, 1);
            this.upperLimitLabel = new JLabel(ExceptionReport.this.lex.getText("to"));
            this.upperLimitLabel.setFont(font);
            this.upperLimitLabel.setVisible(false);
            jPanel5.add((Component)this.upperLimitLabel, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(3, 3, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            this.upperLimitTextBox = new NumberTextField(6, false);
            this.upperLimitTextBox.setFont(font);
            this.upperLimitTextBox.setVisible(false);
            jPanel5.add((Component)this.upperLimitTextBox, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jLabel = new JLabel(ExceptionReport.this.lex.getText("showViolations"));
            jLabel.setFont(font);
            jPanel5.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.lowerLimitCheckBox = new JCheckBox(ExceptionReport.this.lex.getText("lowerLimit"));
            this.lowerLimitCheckBox.setFont(font);
            this.lowerLimitCheckBox.setSelected(true);
            jPanel5.add((Component)this.lowerLimitCheckBox, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.upperLimitCheckBox = new JCheckBox(ExceptionReport.this.lex.getText("upperLimit"));
            this.upperLimitCheckBox.setFont(font);
            this.upperLimitCheckBox.setSelected(true);
            jPanel5.add((Component)this.upperLimitCheckBox, gridBagConstraints);
            this.setComparisonMethod(12);
            this.upperLimitCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.lowerLimitCheckBox.setSelected(Config.this.lowerLimitCheckBox.isSelected() || !Config.this.upperLimitCheckBox.isSelected());
                    if ((Config.this.getComparisonMethod() & 0x80) > 0) {
                        Config.this.lowerLimitTextBox.setVisible(true);
                        Config.this.upperLimitTextBox.setVisible((Config.this.getComparisonMethod() & 0x40) > 0);
                    }
                }
            });
            this.lowerLimitCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.upperLimitCheckBox.setSelected(Config.this.upperLimitCheckBox.isSelected() || !Config.this.lowerLimitCheckBox.isSelected());
                    if ((Config.this.getComparisonMethod() & 0x40) > 0) {
                        Config.this.upperLimitTextBox.setVisible(true);
                        Config.this.lowerLimitTextBox.setVisible((Config.this.getComparisonMethod() & 0x80) > 0);
                    }
                }
            });
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            jLabel = new JLabel(ExceptionReport.this.lex.getText("includedDays"));
            jLabel.setFont(font);
            jPanel5.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.daysOfWeek = new DaysOfWeekEditor(ExceptionReport.this.lex);
            jPanel5.add((Component)this.daysOfWeek, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            jLabel = new JLabel(ExceptionReport.this.lex.getText("includedTimes"));
            jLabel.setFont(font);
            jPanel5.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            JPanel jPanel6 = new JPanel(new GridBagLayout(), false);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.fill = 0;
            this.startTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, null, null);
            jPanel6.add((Component)this.startTimeEditor, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            jLabel = new JLabel(" " + ExceptionReport.this.lex.getText("to") + " ");
            jLabel.setFont(font);
            jPanel6.add((Component)jLabel, gridBagConstraints2);
            gridBagConstraints2.gridx = 2;
            this.endTimeEditor = new EasTimeEditor(true, 24, 0, 0, 0, null, null);
            jPanel6.add((Component)this.endTimeEditor, gridBagConstraints2);
            gridBagConstraints2.gridx = 3;
            this.exclusiveCheckBox = new JCheckBox(ExceptionReport.this.lex.getText("exclusive"));
            this.exclusiveCheckBox.setSelected(false);
            jPanel6.add((Component)this.exclusiveCheckBox, gridBagConstraints2);
            jPanel5.add((Component)jPanel6, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 18;
            jLabel = new JLabel(ExceptionReport.this.lex.getText("maxExceptions"));
            jLabel.setFont(font);
            jPanel5.add((Component)jLabel, gridBagConstraints);
            this.maxExceptionsTextBox = new NumberTextField(4, true);
            this.maxExceptionsTextBox.setFont(font);
            this.maxExceptionsTextBox.setText(1000);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            this.methodComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if ((Config.this.getComparisonMethod() & 0xC) > 0) {
                        Config.this.lowerLimitLabel.setText(((Config)Config.this).ExceptionReport.this.lex.getText("threshhold") + " " + ((Config)Config.this).ExceptionReport.this.lex.getText("%"));
                        Config.this.lowerLimitTextBox.setText(15.0f);
                        Config.this.upperLimitLabel.setVisible(false);
                        Config.this.upperLimitTextBox.setVisible(false);
                        Config.this.lowerLimitLabel.setVisible(true);
                        Config.this.lowerLimitTextBox.setVisible(true);
                    } else if ((Config.this.getComparisonMethod() & 0xC0) > 0) {
                        Config.this.lowerLimitLabel.setText(((Config)Config.this).ExceptionReport.this.lex.getText("range"));
                        Config.this.upperLimitLabel.setVisible(true);
                        Config.this.upperLimitTextBox.setVisible(true);
                        Config.this.lowerLimitLabel.setVisible(true);
                        Config.this.lowerLimitTextBox.setVisible(true);
                        Config.this.lowerLimitTextBox.setText(0.0f);
                        Config.this.upperLimitTextBox.setText(0.0f);
                    } else if ((Config.this.getComparisonMethod() & 3) > 0) {
                        Config.this.upperLimitLabel.setVisible(false);
                        Config.this.upperLimitTextBox.setVisible(false);
                        Config.this.lowerLimitLabel.setVisible(false);
                        Config.this.lowerLimitTextBox.setVisible(false);
                    }
                    Config.this.upperLimitCheckBox.setSelected(true);
                    Config.this.lowerLimitCheckBox.setSelected(true);
                }
            });
            jPanel5.add((Component)this.maxExceptionsTextBox, gridBagConstraints);
            this.add(jPanel5);
        }

        public ReportPeriod getReportPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setReportPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public BaselinePeriod getBaselinePeriod(boolean bl) {
            return (BaselinePeriod)this.baselineEditor.getValue(bl);
        }

        public void setBaselinePeriod(BaselinePeriod baselinePeriod) {
            if (baselinePeriod != null) {
                this.baselineEditor.setValue(baselinePeriod);
            }
        }

        public int getRollupIntervalMinutes() {
            return (int)(this.interval.getValue() / 60000L);
        }

        public void setRollupIntervalMinutes(int n) {
            this.interval.setValue(n * 1000 * 60);
        }

        public double getLowerLimit() {
            if ((this.getComparisonMethod() & 0xC) > 0) {
                return Math.abs(this.lowerLimitTextBox.getDoubleValue()) / -100.0;
            }
            return this.lowerLimitTextBox.getDoubleValue();
        }

        public void setLowerLimit(double d) {
            if ((this.getComparisonMethod() & 0xC) > 0) {
                this.lowerLimitTextBox.setText(Math.abs(d) * -100.0);
            } else {
                this.lowerLimitTextBox.setText(d);
            }
        }

        public double getUpperLimit() {
            if ((this.getComparisonMethod() & 0xC) > 0) {
                return this.lowerLimitTextBox.getDoubleValue() / 100.0;
            }
            return this.upperLimitTextBox.getDoubleValue();
        }

        public void setUpperLimit(double d) {
            if ((this.getComparisonMethod() & 0xC) > 0) {
                this.lowerLimitTextBox.setText(d * 100.0);
            } else {
                this.upperLimitTextBox.setText(d);
            }
        }

        public int getComparisonMethod() {
            int n = ((ComparisonMethodItem)this.methodComboBox.getSelectedItem()).getMethod();
            if (!this.upperLimitCheckBox.isSelected()) {
                n &= 0xFFFFFFBA;
            }
            if (!this.lowerLimitCheckBox.isSelected()) {
                n &= 0xFFFFFF75;
            }
            return n;
        }

        public void setComparisonMethod(int n) {
            ComboBoxModel comboBoxModel = this.methodComboBox.getModel();
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                if ((((ComparisonMethodItem)comboBoxModel.getElementAt(i)).getMethod() & n) <= 0) continue;
                this.methodComboBox.setSelectedIndex(i);
                break;
            }
            this.upperLimitCheckBox.setSelected((n & 0x45) > 0);
            this.lowerLimitCheckBox.setSelected((n & 0x8A) > 0);
        }

        public int getMaxExceptions() {
            return this.maxExceptionsTextBox.getIntValue();
        }

        public void setMaxExceptions(int n) {
            this.maxExceptionsTextBox.setText(n);
        }

        public boolean useTemperatureCorrection() {
            return this.useTemperatureCorrectionCheckbox.isSelected();
        }

        public void setUseTemperatureCorrection(boolean bl) {
            this.useTemperatureCorrectionCheckbox.setSelected(bl);
        }

        public void setTemperatureColor(int n) {
            this.temperatureColorCombo.setSelectedIndex(n + 1);
        }

        public int getTemperatureColor() {
            return this.temperatureColorCombo.getSelectedIndex() - 1;
        }

        public void setAutoLimits(boolean bl) {
            this.spcCheckBox.setSelected(bl);
        }

        public boolean getAutoLimits() {
            return this.spcCheckBox.isSelected();
        }

        public void setDaysOfWeek(int n) {
            this.daysOfWeek.setValue(n);
        }

        public int getDaysOfWeek() {
            return this.daysOfWeek.getValue();
        }

        public void setStartHour(int n) {
            this.startTimeEditor.setValues(n, this.getStartMinute(), 0, 0);
        }

        public int getStartHour() {
            return this.startTimeEditor.getHour();
        }

        public void setStartMinute(int n) {
            this.startTimeEditor.setValues(this.getStartHour(), n, 0, 0);
        }

        public int getStartMinute() {
            return this.startTimeEditor.getMinute();
        }

        public void setEndHour(int n) {
            this.endTimeEditor.setValues(n, this.getEndMinute(), 0, 0);
        }

        public int getEndHour() {
            return this.endTimeEditor.getHour();
        }

        public void setEndMinute(int n) {
            this.endTimeEditor.setValues(this.getEndHour(), n, 0, 0);
        }

        public int getEndMinute() {
            return this.endTimeEditor.getMinute();
        }

        public void setExclusive(boolean bl) {
            this.exclusiveCheckBox.setSelected(bl);
        }

        public boolean getExclusive() {
            return this.exclusiveCheckBox.isSelected();
        }
    }
}

