/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.DefaultAreaConfig;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.EquipOperationTableModel;
import com.tridium.eas.ui.reports.EquipmentOperationParameters;
import com.tridium.eas.ui.reports.EquipmentOperationSeries;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.widgets.EasTable;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.table.TableModel;

public class EquipmentOperation
extends EasReport {
    public static final String TEMPLATE_ID = "equipOp";
    private ChartPanel chartPanel;
    private EasTable table;
    private Config config;
    static /* synthetic */ Class class$java$lang$String;

    public String getName() {
        return this.lex.getText("equipmentOperation");
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    public boolean allowShowUserObject(Object object) {
        if (!(object instanceof DataPoint)) {
            return !(object instanceof Meter);
        }
        return this.allowDataPoint((DataPoint)object);
    }

    public boolean allowDataPoint(DataPoint dataPoint) {
        try {
            return dataPoint.getSession().getDataPointExec().isMultistate(dataPoint.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected JComponent getReportContent() {
        if (this.chartPanel == null) {
            this.chartPanel = new ChartPanel();
            Chart chart = new Chart(this.lex);
            chart.setTitle(this.getName());
            chart.setChartStatus(this);
            this.chartPanel.add(chart);
        }
        return this.chartPanel;
    }

    protected JComponent getReportDetails() {
        if (this.table == null) {
            this.table = new EasReportTable((TableModel)new EquipOperationTableModel(this.lex), false, this.lex);
            this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = EquipmentOperation.class$("java.lang.String")) : class$java$lang$String, new EasReportTable.RightAlignedRenderer());
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public ReportParameters createEmptyParameters() {
        return new EquipmentOperationParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        return new EquipmentOperationParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        EquipmentOperationParameters equipmentOperationParameters = (EquipmentOperationParameters)reportParameters;
        this.getInputList().getModel().setInputs(equipmentOperationParameters.getInputs());
        this.config.setPeriod(equipmentOperationParameters.getPeriod());
        this.setDataCleanse(equipmentOperationParameters.getDataCleanse());
        this.setDataCleanseWindow(equipmentOperationParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(equipmentOperationParameters.getDataCleansePercentage());
    }

    public void runReport(ReportParameters reportParameters) throws EasException {
        int n;
        EquipmentOperationParameters equipmentOperationParameters = (EquipmentOperationParameters)reportParameters;
        ReportPeriod reportPeriod = equipmentOperationParameters.getPeriod();
        ReportInput[] reportInputArray = equipmentOperationParameters.getInputs();
        int n2 = n = reportInputArray == null ? 0 : reportInputArray.length;
        if (n == 0) {
            return;
        }
        EquipmentOperationSeries[] equipmentOperationSeriesArray = new EquipmentOperationSeries[n];
        for (int i = 0; i < n; ++i) {
            equipmentOperationSeriesArray[i] = new EquipmentOperationSeries(reportInputArray[i], equipmentOperationParameters, this.lex);
            equipmentOperationSeriesArray[i].load();
        }
        String string = reportPeriod.getDateRangeString();
        this.chartPanel.removeAll();
        for (int i = 0; i < n; ++i) {
            Chart chart = new Chart(this.lex);
            if (n == 1) {
                chart.setTitle(this.getName());
                chart.setSubtitle(string);
            } else {
                chart.setSubtitle(reportInputArray[i].getName());
            }
            chart.setBorder(BorderFactory.createEtchedBorder());
            chart.getModel().setSeries(equipmentOperationSeriesArray[i], new DefaultAreaConfig(true, equipmentOperationSeriesArray[i]), null, new EquipOpAxisInfo());
            chart.setChartStatus(this);
            this.chartPanel.add(chart);
        }
        this.chartPanel.validate();
        EquipOperationTableModel equipOperationTableModel = new EquipOperationTableModel(equipmentOperationSeriesArray, this.lex);
        this.table.setModel(equipOperationTableModel);
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chartPanel, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chartPanel.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chartPanel.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Config
    extends JComponent {
        private ReportPeriodEditor periodEditor;

        public Config() {
            EquipmentOperation.this.lex = BEasApplet.lex;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new BorderLayout());
            this.periodEditor = new ReportPeriodEditor(false, EquipmentOperation.this.lex);
            jPanel.add((Component)this.periodEditor, "Center");
            jPanel.add((Component)new Spacer(1, 30), "South");
            jPanel.setBorder(BorderFactory.createTitledBorder(EquipmentOperation.this.lex.getText("period")));
            this.add((Component)jPanel, "Center");
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }
    }

    private class Spacer
    extends JComponent {
        private Dimension prefSize;

        public Spacer(int n, int n2) {
            this.prefSize = new Dimension(n, n2);
        }

        public Dimension getPreferredSize() {
            return this.prefSize;
        }
    }

    public class EquipOpAxisInfo
    extends AxisInfo {
        public boolean useDefaultTickLabels() {
            return false;
        }

        public String getTickLabel(Object object) {
            if (object instanceof Number) {
                if (EquipmentOperation.this.lex != null) {
                    return ((Number)object).intValue() == 0 ? EquipmentOperation.this.lex.getText("off") : EquipmentOperation.this.lex.getText("on");
                }
                return ((Number)object).intValue() == 0 ? "Off" : "On";
            }
            return null;
        }
    }

    private class ChartPanel
    extends JComponent
    implements Printable {
        public void zoomOut() {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!component.isVisible()) continue;
                ((Chart)component).zoomOut();
            }
        }

        public void setShowGrid(boolean bl) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                ((Chart)this.getComponent(i)).setShowGrid(bl);
            }
        }

        public void setSingleDisplay(Chart chart) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component;
                component.setVisible((component = this.getComponent(i)) == chart);
            }
        }

        public void setMultipleDisplay() {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.getComponent(i).setVisible(true);
            }
        }

        public void doLayout() {
            int n;
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            int n4 = this.getComponentCount();
            int n5 = 0;
            for (n = 0; n < n4; ++n) {
                if (!this.getComponent(n).isVisible()) continue;
                ++n5;
            }
            if (n5 == 0) {
                return;
            }
            n = n3 / n5;
            int n6 = 0;
            int n7 = 0;
            for (int i = 0; i < n4; ++i) {
                Component component = this.getComponent(i);
                if (!component.isVisible()) continue;
                if (i != n7 - 1) {
                    component.setBounds(0, n6, n2, n);
                } else {
                    component.setBounds(0, n6, n2, n3 - n6);
                }
                n6 += n;
                ++n7;
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            JWindow jWindow = new JWindow();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jWindow.setBounds(dimension.width + 1, dimension.height + 1, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            ChartPanel chartPanel = new ChartPanel();
            int n2 = this.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Chart chart = new Chart(EquipmentOperation.this.lex);
                chart.getChartArea().setBackground(Color.white);
                chart.setModel(((Chart)this.getComponent(i)).getModel());
                chartPanel.add(chart);
            }
            jWindow.getContentPane().add(chartPanel);
            jWindow.setVisible(true);
            jWindow.print(graphics2D);
            jWindow.setVisible(false);
            return 0;
        }
    }
}

