/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteInputItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class EnterpriseRankingParameters
extends ReportParameters {
    public static final int ORDER_HIGHEST = 0;
    public static final int ORDER_LOWEST = 1;
    private int order = 0;
    private int size = 10;
    private RcType rcType = RcType.ELECTRIC;
    private RcSubtype rcSubtype = RcSubtype.CONSUMPTION;
    private String dpName;

    public EnterpriseRankingParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public EnterpriseRankingParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, int n2, RcType rcType, RcSubtype rcSubtype, String string, int n3, double d, BUnit bUnit, Lexicon lexicon, boolean bl, int n4, double d2) {
        super(reportInputArray, reportPeriod, n3, d, bUnit, false, lexicon, bl, n4, d2);
        this.order = n;
        this.size = n2;
        this.rcType = rcType;
        this.rcSubtype = rcSubtype;
        this.dpName = string;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        Object object;
        ReportInput[] reportInputArray = reportParameters.getInputs();
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        Hashtable<Long, Site> hashtable = new Hashtable<Long, Site>(3);
        for (int i = 0; i < n; ++i) {
            object = reportInputArray[i];
            int n2 = ((ReportInput)object).getInputItemCount();
            boolean bl = true;
            for (int j = 0; j < n2; ++j) {
                ReportInputItem reportInputItem = ((ReportInput)object).getInputItem(j);
                if (!(reportInputItem instanceof SiteInputItem)) continue;
                Site site = ((SiteInputItem)reportInputItem).getSite();
                hashtable.put(new Long(site.getId()), site);
            }
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object = (Site)enumeration.nextElement();
            easReport.addInput(new ReportInput(null, null, new SiteInputItem((Site)object, this.lex), this.lex));
        }
        this.setInputs(easReport.getInputList().getModel().getInputs());
        this.setPeriod(reportParameters.getPeriod());
        this.setNormalization(reportParameters.getNormalization());
        this.setNormalTemperature(reportParameters.getNormalTemperature());
        this.setNormalTemperatureUnit(reportParameters.getNormalTemperatureUnit());
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public int getOrder() {
        return this.order;
    }

    public int getResultSize() {
        return this.size;
    }

    public RcType getRcType() {
        return this.rcType;
    }

    public RcSubtype getRcSubtype() {
        return this.rcSubtype;
    }

    public String getDataPointName() {
        return this.dpName;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        this.order = dataInput.readInt();
        this.size = dataInput.readInt();
        int n = dataInput.readInt();
        this.rcType = n == -1 ? null : RcType.getByCode(n);
        n = dataInput.readInt();
        this.rcSubtype = n == -1 ? null : RcSubtype.getByCode(n);
        this.dpName = dataInput.readUTF();
        if (this.dpName.length() == 0) {
            this.dpName = null;
        }
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.order);
        dataOutput.writeInt(this.size);
        if (this.rcType == null) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(this.rcType.getCode());
        }
        if (this.rcSubtype == null) {
            dataOutput.writeInt(-1);
        } else {
            dataOutput.writeInt(this.rcSubtype.getCode());
        }
        String string = this.dpName == null ? "" : this.dpName;
        dataOutput.writeUTF(string);
    }
}

