/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.DecimalFormatter;
import com.tridium.eas.ui.EasUiUtil;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.SeriesLabel;
import com.tridium.eas.ui.reports.ValuePercentPair;
import com.tridium.eas.ui.reports.ValueUnitPair;
import com.tridium.eas.ui.widgets.ColorIcon;
import com.tridium.eas.ui.widgets.EasTable;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;
import javax.baja.util.Lexicon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class EasReportTable
extends EasTable {
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$SeriesLabel;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$ReportInput;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$ValuePercentPair;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$ValueUnitPair;

    public EasReportTable(TableModel tableModel, boolean bl, Lexicon lexicon) {
        super(tableModel, bl, lexicon);
        EasTable.NoFocusCellRenderer noFocusCellRenderer = new DoubleRenderer();
        this.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = EasReportTable.class$("java.lang.Number")) : class$java$lang$Number, noFocusCellRenderer);
        noFocusCellRenderer = new InputCellRenderer();
        this.setDefaultRenderer(class$com$tridium$eas$ui$reports$SeriesLabel == null ? (class$com$tridium$eas$ui$reports$SeriesLabel = EasReportTable.class$("com.tridium.eas.ui.reports.SeriesLabel")) : class$com$tridium$eas$ui$reports$SeriesLabel, noFocusCellRenderer);
        this.setDefaultRenderer(class$com$tridium$eas$ui$reports$ReportInput == null ? (class$com$tridium$eas$ui$reports$ReportInput = EasReportTable.class$("com.tridium.eas.ui.reports.ReportInput")) : class$com$tridium$eas$ui$reports$ReportInput, noFocusCellRenderer);
        noFocusCellRenderer = new ValuePercentPairRenderer();
        this.setDefaultRenderer(class$com$tridium$eas$ui$reports$ValuePercentPair == null ? (class$com$tridium$eas$ui$reports$ValuePercentPair = EasReportTable.class$("com.tridium.eas.ui.reports.ValuePercentPair")) : class$com$tridium$eas$ui$reports$ValuePercentPair, noFocusCellRenderer);
        noFocusCellRenderer = new ValueUnitPairRenderer(lexicon);
        this.setDefaultRenderer(class$com$tridium$eas$ui$reports$ValueUnitPair == null ? (class$com$tridium$eas$ui$reports$ValueUnitPair = EasReportTable.class$("com.tridium.eas.ui.reports.ValueUnitPair")) : class$com$tridium$eas$ui$reports$ValueUnitPair, noFocusCellRenderer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class InputCellRenderer
    extends EasTable.NoFocusCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof SeriesLabel) {
                SeriesLabel seriesLabel = (SeriesLabel)object;
                jLabel.setText(seriesLabel.getName());
                if (object instanceof ReportInput) {
                    Object object2;
                    if (((ReportInput)seriesLabel).hasNormalizingPoint()) {
                        object2 = BEasApplet.lex;
                        jLabel.setText("* " + jLabel.getText() + ",  " + object2.getText("normalizeBy") + " " + InputCellRenderer.getNormalizerText(((ReportInput)seriesLabel).getNormalizingPoint(), (Lexicon)object2));
                        if (bl) {
                            jLabel.setForeground(EasUiUtil.DP_NORMALIZED_COLOR);
                        } else {
                            jLabel.setForeground(UIManager.getDefaults().getColor("Label.foreground"));
                            jLabel.setBackground(EasUiUtil.DP_NORMALIZED_COLOR);
                        }
                    } else if (!bl) {
                        jLabel.setBackground(Color.white);
                        jLabel.setForeground(UIManager.getDefaults().getColor("Label.foreground"));
                    }
                    object2 = ((ReportInput)seriesLabel).getAggregateParent();
                    if (object2 == null) {
                        jLabel.setIcon(new ColorIcon(seriesLabel.getColor()));
                    } else {
                        jLabel.setIcon(new ColorIcon(seriesLabel.getColor(), ((ReportInput)object2).getColor()));
                    }
                } else {
                    jLabel.setIcon(new ColorIcon(seriesLabel.getColor()));
                }
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }

        private static String getNormalizerText(DataPoint dataPoint, Lexicon lexicon) {
            if (dataPoint == null) {
                return lexicon.getText("noPointSelected");
            }
            String string = dataPoint.getName();
            try {
                string = dataPoint.getDescr();
                if (dataPoint.getMeter() != null) {
                    string = dataPoint.getMeter().getName() + " " + string;
                }
                string = string + " (" + dataPoint.getSite().getName() + ")";
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }
    }

    public static class ValueUnitPairRenderer
    extends RightAlignedRenderer {
        private static DecimalFormat valueFormat = null;
        private static Lexicon lex = null;

        public ValueUnitPairRenderer() {
        }

        public ValueUnitPairRenderer(Lexicon lexicon) {
            lex = lexicon;
        }

        public ValueUnitPairRenderer(DecimalFormat decimalFormat) {
            valueFormat = decimalFormat;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            ValueUnitPair valueUnitPair = (ValueUnitPair)object;
            StringBuffer stringBuffer = valueFormat == null ? new StringBuffer(DecimalFormatter.format(valueUnitPair.getValue().doubleValue())) : new StringBuffer(valueFormat.format(valueUnitPair.getValue().doubleValue()));
            stringBuffer.append(" (");
            if (lex != null) {
                stringBuffer.append(valueUnitPair.getUnit().toString());
            } else {
                stringBuffer.append(valueUnitPair.getUnit().toString());
            }
            stringBuffer.append(")");
            jLabel.setText(stringBuffer.toString());
            return jLabel;
        }
    }

    public static class ValuePercentPairRenderer
    extends RightAlignedRenderer {
        private static DecimalFormat percentFormat = new DecimalFormat(" (##0.0%)");
        private static DecimalFormat valueFormat = null;

        public ValuePercentPairRenderer() {
        }

        public ValuePercentPairRenderer(DecimalFormat decimalFormat) {
            valueFormat = decimalFormat;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            ValuePercentPair valuePercentPair = (ValuePercentPair)object;
            StringBuffer stringBuffer = valueFormat == null ? new StringBuffer(DecimalFormatter.format(valuePercentPair.getValue().doubleValue())) : new StringBuffer(valueFormat.format(valuePercentPair.getValue().doubleValue()));
            stringBuffer.append(percentFormat.format(valuePercentPair.getPercent().doubleValue()));
            jLabel.setText(stringBuffer.toString());
            return jLabel;
        }
    }

    public static class DoubleRenderer
    extends RightAlignedRenderer {
        private DecimalFormat valueFormat;

        public DoubleRenderer() {
        }

        public DoubleRenderer(DecimalFormat decimalFormat) {
            this.valueFormat = decimalFormat;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            if (object == null) {
                jLabel.setText("");
            } else if (this.valueFormat == null) {
                jLabel.setText(DecimalFormatter.format((Number)object));
            } else {
                jLabel.setText(this.valueFormat.format(((Number)object).doubleValue()));
            }
            return jLabel;
        }
    }

    public static class DateRenderer
    extends EasTable.NoFocusCellRenderer {
        DateFormat dateFormat;
        Lexicon lex;

        public DateRenderer() {
        }

        public DateRenderer(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public DateRenderer(DateFormat dateFormat, Lexicon lexicon) {
            this.dateFormat = dateFormat;
            this.lex = lexicon;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object == null) {
                jLabel.setText("");
            } else if (this.dateFormat == null) {
                if (this.lex != null) {
                    jLabel.setText(DateFormat.getDateInstance(2, new Locale(this.lex.language, "")).format((Date)object));
                } else {
                    jLabel.setText(DateFormat.getDateInstance().format((Date)object));
                }
            } else {
                jLabel.setText(this.dateFormat.format((Date)object));
            }
            return jLabel;
        }
    }

    public static class RightAlignedRenderer
    extends EasTable.NoFocusCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            return jLabel;
        }
    }
}

