/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.chart.ChartStatus;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.inputlist.InputListItem;
import com.tridium.eas.ui.inputlist.InputListItemPopup;
import com.tridium.eas.ui.inputlist.InputListModel;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.reports.ReportConst;
import com.tridium.eas.ui.reports.ReportFilterTree;
import com.tridium.eas.ui.reports.ReportFilterTreeModel;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SaveReportDialog;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.reports.TreePopup;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DbObjectValidator;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasToggleButton;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.FilterTreePopupHandler;
import com.tridium.eas.ui.widgets.MaxSizePanel;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public abstract class EasReport
extends EasApplication
implements ActionListener,
FilterTreePopupHandler,
ChartStatus,
ComponentListener,
DbObjectValidator,
ReportConst {
    private JToolBar toolbar;
    private JButton refreshButton;
    private JButton saveButton;
    private JToggleButton hideTree;
    protected JButton runButton;
    private JButton printButton;
    private boolean autoRun = false;
    protected JButton functionButton;
    protected JButton zoomOutButton;
    protected JToggleButton toggleGrid;
    protected JToggleButton toggleDetails;
    private Filter currentFilter;
    private JSplitPane mainSplit;
    private int splitLoc = -1;
    protected ReportFilterTree tree;
    private XpComboBox filterSelection;
    private InputList inputList;
    private TreePanel treePanel;
    private TreePopup treePopup;
    private JComponent details;
    private JSplitPane detailSplit;
    private int detailSplitLoc = -1;
    private String reportName = null;
    private boolean pub = false;
    public String lang;
    public Lexicon lex;
    private static ReportParameters lastParameters;
    private boolean keepParameters = true;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$SiteDataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$StaticGroup;
    static /* synthetic */ Class class$com$tridium$eas$api$DynGroup;
    static /* synthetic */ Class class$com$tridium$eas$api$Site;
    static /* synthetic */ Class class$com$tridium$eas$api$Meter;

    public EasReport() {
        this.addComponentListener(this);
    }

    public final void initApplication(boolean bl) {
        if (bl) {
            this.initReport();
            this.reportName = this.getParameter("reportName", null);
            this.autoRun = false;
            if (this.reportName != null) {
                try {
                    this.autoRun = this.loadReport(this.reportName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void initReport() {
    }

    protected JComponent getApplicationToolBar() {
        return this.getApplicationToolBar(new int[]{17, 18, 28, 19, -1, 20, 21, 22});
    }

    protected JComponent getApplicationToolBar(int[] nArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        block11: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    jToolBar.add(this.refreshButton);
                    continue block11;
                }
                case 18: {
                    this.saveButton = new EasButton((ResourceManager)this, 18, lexicon.getText("saveReport"));
                    this.saveButton.addActionListener(this);
                    jToolBar.add(this.saveButton);
                    continue block11;
                }
                case 19: {
                    this.hideTree = new EasToggleButton(this, 19, lexicon.getText("toggleTree"));
                    this.hideTree.addActionListener(this);
                    jToolBar.add(this.hideTree);
                    continue block11;
                }
                case -1: {
                    jToolBar.addSeparator();
                    continue block11;
                }
                case 20: {
                    this.zoomOutButton = new EasButton((ResourceManager)this, 20, lexicon.getText("zoomOut"));
                    this.zoomOutButton.addActionListener(this);
                    jToolBar.add(this.zoomOutButton);
                    continue block11;
                }
                case 21: {
                    this.toggleGrid = new EasToggleButton(this, 21, lexicon.getText("toggleGrid"));
                    this.toggleGrid.addActionListener(this);
                    jToolBar.add(this.toggleGrid);
                    continue block11;
                }
                case 22: {
                    this.toggleDetails = new EasToggleButton(this, 22, lexicon.getText("toggleTable"));
                    this.toggleDetails.addActionListener(this);
                    jToolBar.add(this.toggleDetails);
                    continue block11;
                }
                case 27: {
                    this.functionButton = new EasButton((ResourceManager)this, 27, lexicon.getText("applyFunction"));
                    this.functionButton.addActionListener(this);
                    jToolBar.add(this.functionButton);
                    continue block11;
                }
                case 28: {
                    this.printButton = new EasButton((ResourceManager)this, 28, lexicon.getText("print"));
                    this.printButton.addActionListener(this);
                    jToolBar.add(this.printButton);
                }
            }
        }
        return jToolBar;
    }

    protected JComponent getApplicationContent() {
        if (this.mainSplit == null) {
            this.lang = this.getParameter("lang", "en");
            Lexicon lexicon = BEasApplet.lex;
            this.mainSplit = new JSplitPane();
            this.mainSplit.setDividerSize(4);
            this.add((Component)this.mainSplit, "Center");
            this.treePanel = new TreePanel();
            this.mainSplit.setLeftComponent(this.treePanel);
            JPanel jPanel = new JPanel(false);
            BorderLayout borderLayout = new BorderLayout();
            jPanel.setLayout(borderLayout);
            JPanel jPanel2 = new JPanel(false);
            jPanel2.setLayout(new FlowLayout());
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            this.runButton = new JButton(lexicon.getText("runReport"));
            this.runButton.addActionListener(this);
            jPanel2.add(this.runButton);
            JPanel jPanel3 = new JPanel(false);
            jPanel3.setLayout(new BorderLayout());
            JPanel jPanel4 = new JPanel(false);
            jPanel4.setLayout(new BorderLayout());
            this.inputList = new InputList(this, new InputListModel(lexicon));
            jPanel4.add((Component)new MaxSizePanel(200, 600, this.inputList.createScrollPane()), "Center");
            JComponent jComponent = this.getReportConfig();
            jPanel4.add((Component)new JScrollPane(jComponent), "South");
            jPanel3.add((Component)jPanel4, "Center");
            jPanel3.add((Component)jPanel2, "South");
            JPanel jPanel5 = new JPanel(false);
            jPanel5.setLayout(new BorderLayout());
            this.details = this.getReportDetails();
            if (this.details == null) {
                jPanel5.add((Component)this.getReportContent(), "Center");
            } else {
                this.detailSplit = new JSplitPane(0);
                this.detailSplit.setDividerSize(4);
                this.detailSplit.setTopComponent(this.getReportContent());
                this.detailSplit.setBottomComponent(this.details);
                jPanel5.add((Component)this.detailSplit, "Center");
            }
            jPanel.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel5, "Center");
            this.mainSplit.setRightComponent(jPanel);
        }
        return this.mainSplit;
    }

    protected JComponent getReportContent() {
        return new JLabel("");
    }

    protected JComponent getReportDetails() {
        return null;
    }

    protected int getInitialDetailsWeight() {
        return 30;
    }

    protected JComponent getReportConfig() {
        return new JLabel("");
    }

    protected abstract ReportParameters createEmptyParameters();

    protected abstract ReportParameters getReportParameters(boolean var1);

    protected void setReportParameters(ReportParameters reportParameters) {
    }

    public abstract void runReport(ReportParameters var1) throws EasException;

    public static double getDegreeDays(double d, long l) {
        System.out.println("WARNING: EasReport.getDegreeDays is unimplemented");
        return d;
    }

    public void setKeepParameters(boolean bl) {
        this.keepParameters = bl;
    }

    protected void startApplication() {
        boolean bl;
        this.keepParameters = true;
        this.saveButton.setEnabled(this.getSession().hasOperatorWrite());
        this.initFilters();
        this.updateFilter();
        this.startReport();
        boolean bl2 = this.getBooleanParameter("tree", true);
        if (this.hideTree != null) {
            this.hideTree.setSelected(!bl2);
        }
        this.setTreeVisible(bl2);
        if (this.toggleDetails != null) {
            this.toggleDetails.setSelected(true);
        }
        this.setDetailsVisible(true);
        boolean bl3 = bl = this.autoRun || this.getBooleanParameter("run", false);
        if (bl && this.validParameters(this.getReportParameters(false))) {
            try {
                this.runReport(this.getReportParameters(false));
            }
            catch (Exception exception) {
                LocalizableRuntimeException localizableRuntimeException;
                Object[] objectArray;
                String string = null;
                string = exception instanceof LocalizableRuntimeException ? ((objectArray = (localizableRuntimeException = (LocalizableRuntimeException)((Object)exception)).getLexiconArguments()) != null ? this.lex.getText(localizableRuntimeException.getLexiconKey(), localizableRuntimeException.getLexiconArguments()) : this.lex.getText(localizableRuntimeException.getLexiconKey())) : exception.getMessage();
                JOptionPane.showMessageDialog(this, string, this.lex.getText("errorOccurred"), 0);
            }
        }
        if (this.reportName == null && lastParameters != null) {
            ReportParameters reportParameters = this.createEmptyParameters();
            if (reportParameters.getClass().equals(lastParameters.getClass())) {
                reportParameters = lastParameters;
            } else {
                reportParameters.load(this, lastParameters);
            }
            reportParameters.lex = BEasApplet.lex;
            this.setReportParameters(reportParameters);
        }
    }

    protected void startReport() {
    }

    protected void stopApplication() {
        lastParameters = this.keepParameters ? this.getReportParameters(true) : null;
        this.stopReport();
    }

    protected void stopReport() {
    }

    public void initFilters() {
        EasSession easSession = this.getSession();
        Lexicon lexicon = BEasApplet.lex;
        this.filterSelection.addItem(new AllSitesFilter(easSession, lexicon));
        this.filterSelection.addItem(new StaticGroupFilter(easSession, lexicon));
        Group[] groupArray = Group.getGroups('D', easSession);
        if (groupArray == null) {
            return;
        }
        int n = groupArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.filterSelection.addItem(new DynamicGroupFilter(easSession, (DynGroup)groupArray[i], lexicon));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.filterSelection.setMaximumRowCount(Math.min(this.filterSelection.getItemCount(), 10));
    }

    public void updateFilter() {
        Filter filter = (Filter)this.filterSelection.getSelectedItem();
        if (filter != this.currentFilter) {
            this.currentFilter = filter;
            ReportFilterTreeModel reportFilterTreeModel = new ReportFilterTreeModel(this, new FilterRootNode(filter, this));
            this.tree.setModel(reportFilterTreeModel);
        }
    }

    public void setTreeVisible(boolean bl) {
        boolean bl2;
        int n = this.mainSplit.getDividerSize();
        int n2 = this.mainSplit.getDividerLocation();
        boolean bl3 = bl2 = n != 0 && n2 == -1;
        if (!bl) {
            this.splitLoc = bl2 ? this.treePanel.getPreferredSize().width : this.mainSplit.getDividerLocation();
            this.mainSplit.setDividerSize(0);
            this.mainSplit.setDividerLocation(0);
            this.treePanel.setVisible(false);
        } else {
            if (bl2) {
                this.mainSplit.setDividerLocation(this.treePanel.getPreferredSize().width);
                return;
            }
            if (this.splitLoc != -1) {
                this.mainSplit.setDividerSize(4);
                this.mainSplit.setDividerLocation(this.splitLoc);
                this.treePanel.setVisible(true);
            }
            this.splitLoc = -1;
        }
    }

    public void setDetailsVisible(boolean bl) {
        if (this.details == null) {
            return;
        }
        int n = this.detailSplit.getDividerSize();
        int n2 = this.detailSplit.getDividerLocation();
        if (!bl) {
            if (n2 != -1) {
                this.detailSplitLoc = this.detailSplit.getDividerLocation();
            }
            this.detailSplit.setDividerSize(0);
            this.detailSplit.setDividerLocation(this.detailSplit.getPreferredSize().height);
            this.details.setVisible(false);
        } else {
            if (this.detailSplitLoc == -1) {
                int n3 = 100 - this.getInitialDetailsWeight();
                double d = (double)n3 / 100.0;
                this.detailSplit.setDividerLocation(d);
            } else {
                this.detailSplit.setDividerLocation(this.detailSplitLoc);
            }
            this.detailSplit.setDividerSize(4);
            this.details.setVisible(true);
        }
        this.repaint();
    }

    protected void setRunReportEnabled(boolean bl) {
        this.runButton.setEnabled(bl);
    }

    protected boolean isRunReportEnabled() {
        return this.runButton.isEnabled();
    }

    public InputList getInputList() {
        return this.inputList;
    }

    protected JSplitPane getMainSplit() {
        return this.mainSplit;
    }

    public void addInputListPopupItems(InputListItemPopup inputListItemPopup) {
    }

    public void popupItemSelected(JMenuItem jMenuItem, InputListItem inputListItem) {
    }

    public Class getInputItemClass() {
        return class$com$tridium$eas$ui$reports$SiteDataPoint == null ? (class$com$tridium$eas$ui$reports$SiteDataPoint = EasReport.class$("com.tridium.eas.ui.reports.SiteDataPoint")) : class$com$tridium$eas$ui$reports$SiteDataPoint;
    }

    public void addInputItemSet(InputItemSet inputItemSet) {
        this.addInputItemSet(inputItemSet, false);
    }

    public void addInputItemSet(InputItemSet inputItemSet, boolean bl) {
        boolean bl2 = bl;
        Vector vector = inputItemSet.getUnitSets();
        int n = vector.size();
        if (!this.allowMultipleInputs()) {
            n = Math.min(1, n);
        }
        for (int i = 0; i < n; ++i) {
            ReportInputItem[] reportInputItemArray = (ReportInputItem[])vector.elementAt(i);
            BUnit bUnit = null;
            try {
                bUnit = reportInputItemArray[0].getUnit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string = reportInputItemArray.length == 1 ? null : inputItemSet.getName();
            Lexicon lexicon = BEasApplet.lex;
            bl2 = this.addInput(new ReportInput(string, bUnit, reportInputItemArray, lexicon), bl2) && bl2;
        }
    }

    public final boolean addInput(ReportInput reportInput) {
        return this.addInput(reportInput, false);
    }

    public boolean addInput(ReportInput reportInput, boolean bl) {
        this.getInputList().getModel().addInput(reportInput);
        return true;
    }

    public void armPopupItems(InputListItem inputListItem, int n) {
    }

    public boolean allowMultipleInputs() {
        return true;
    }

    public boolean allowAggregation() {
        return true;
    }

    public boolean allowDisaggregation() {
        return this.allowMultipleInputs();
    }

    public void disaggregate(ReportInput reportInput, ReportInput[] reportInputArray) {
    }

    public void reaggregate(ReportInput[] reportInputArray) {
    }

    public boolean allowLoadUserObject(Class clazz) {
        return (class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = EasReport.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$StaticGroup == null ? (class$com$tridium$eas$api$StaticGroup = EasReport.class$("com.tridium.eas.api.StaticGroup")) : class$com$tridium$eas$api$StaticGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$DynGroup == null ? (class$com$tridium$eas$api$DynGroup = EasReport.class$("com.tridium.eas.api.DynGroup")) : class$com$tridium$eas$api$DynGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = EasReport.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = EasReport.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz);
    }

    public boolean allowShowUserObject(Object object) {
        if (!(object instanceof DataPoint)) {
            return true;
        }
        return this.allowDataPoint((DataPoint)object);
    }

    public boolean allowDataPoint(DataPoint dataPoint) {
        try {
            BUnit bUnit = dataPoint.getUnit();
            return bUnit != null && !dataPoint.getSession().getDataPointExec().isMultistate(dataPoint.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected boolean validParameters(ReportParameters reportParameters) {
        ReportInput[] reportInputArray = reportParameters.getInputs();
        if (reportInputArray == null) {
            return true;
        }
        for (int i = 0; i < reportInputArray.length; ++i) {
            ReportInputItem[] reportInputItemArray = reportInputArray[i].getInputItems();
            if (reportInputItemArray == null) continue;
            for (int j = 0; j < reportInputItemArray.length; ++j) {
                if (!(reportInputItemArray[j] instanceof SiteDataPoint)) continue;
                try {
                    ((SiteDataPoint)reportInputItemArray[j]).getDataPoint().load(true);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean loadReport(String string) throws IOException {
        Lexicon lexicon = BEasApplet.lex;
        ReportParameters reportParameters = this.createEmptyParameters();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("/eas/reportCommand/load?reportName=");
        stringBuffer.append(string);
        stringBuffer.append("&reportId=");
        stringBuffer.append(this.getId());
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getSession().get(stringBuffer.toString()));
            if (!reportParameters.load(this.getSession(), dataInputStream)) {
                JOptionPane.showMessageDialog(this, lexicon.getText("someParamsFor") + " '" + string.replace('_', ' ') + "' " + lexicon.getText("notAvailable"), lexicon.getText("invalidReport"), 2);
            }
            reportParameters.lex = BEasApplet.lex;
            this.setReportParameters(reportParameters);
            return reportParameters.isAutoRun();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, lexicon.getText("report") + " '" + string.replace('_', ' ') + "' " + lexicon.getText("wasNotFound"), lexicon.getText("invalidReport"), 0);
            return false;
        }
    }

    public void saveReport() throws IOException {
        try {
            Lexicon lexicon = BEasApplet.lex;
            ReportParameters reportParameters = this.getReportParameters(false);
            if (reportParameters == null) {
                return;
            }
            String string = this.getSession().getUserName();
            SaveReportDialog saveReportDialog = new SaveReportDialog(this, this.reportName, this.pub, this.autoRun, this.getSession().hasAdminWrite(), true, lexicon);
            this.restrictInputToComponent(saveReportDialog);
            saveReportDialog.open();
            this.setInputEnabled(true);
            if (saveReportDialog.isCancelled()) {
                return;
            }
            this.reportName = saveReportDialog.getReportName().replace(' ', '_');
            this.pub = saveReportDialog.isPublic();
            reportParameters.setAutoRun(saveReportDialog.isAutoRun());
            this.autoRun = saveReportDialog.isAutoRun();
            String string2 = this.pub ? "" : string;
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("/eas/reportCommand/save?reportName=");
            stringBuffer.append(this.reportName);
            stringBuffer.append("&reportId=");
            stringBuffer.append(this.getId());
            OutputStream outputStream = this.getSession().put(stringBuffer.toString());
            if (outputStream == null) {
                throw new IOException("Could not get output for save.");
            }
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeUTF(string2);
            reportParameters.save(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterSelection) {
            this.updateFilter();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void buttonPressed(JButton jButton) {
        if (jButton == this.runButton) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (!this.validParameters(this.getReportParameters(false))) return;
                this.runReport(this.getReportParameters(false));
                return;
            }
            catch (Exception exception) {
                LocalizableRuntimeException localizableRuntimeException;
                Object[] objectArray;
                this.setCursor(Cursor.getDefaultCursor());
                String string = null;
                string = exception instanceof LocalizableRuntimeException ? ((objectArray = (localizableRuntimeException = (LocalizableRuntimeException)((Object)exception)).getLexiconArguments()) != null ? this.lex.getText(localizableRuntimeException.getLexiconKey(), localizableRuntimeException.getLexiconArguments()) : this.lex.getText(localizableRuntimeException.getLexiconKey())) : exception.getMessage();
                JOptionPane.showMessageDialog(this, string, this.lex.getText("errorOccurred"), 0);
                return;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (jButton == this.saveButton) {
            try {
                this.saveReport();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        } else if (jButton == this.printButton) {
            try {
                this.print();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        } else if (jButton == this.refreshButton) {
            ((FilterTreeModel)this.tree.getModel()).reload();
            return;
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(0);
        Pageable pageable = this.getPageable(pageFormat);
        if (pageable == null || pageable.getNumberOfPages() == 0) {
            printerJob.cancel();
            return;
        }
        try {
            if (printerJob.printDialog()) {
                printerJob.setPageable(pageable);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        return null;
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.hideTree) {
            this.setTreeVisible(!bl);
        }
        if (jToggleButton == this.toggleDetails) {
            this.setDetailsVisible(bl);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void openPopup(FilterTree filterTree, FilterTreeNode filterTreeNode, int n, int n2) {
        if (filterTreeNode == null) {
            return;
        }
        if (this.treePopup == null) {
            Lexicon lexicon = BEasApplet.lex;
            this.treePopup = new TreePopup(this, (ReportFilterTree)filterTree, lexicon);
            this.add(this.treePopup);
        }
        this.treePopup.arm(filterTreeNode);
        this.treePopup.show(filterTree, n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TreePanel
    extends JComponent {
        public TreePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 2, 2));
            EasReport.this.filterSelection = new XpComboBox();
            EasReport.this.filterSelection.addActionListener(EasReport.this);
            jPanel.add(EasReport.this.filterSelection);
            this.add((Component)jPanel, "North");
            EasReport.this.tree = new ReportFilterTree(EasReport.this.getResourceManager());
            EasReport.this.tree.setPopupHandler(EasReport.this);
            this.add((Component)new JScrollPane(EasReport.this.tree), "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            double d = (double)(dimension.width + 30) * 1.2;
            return new Dimension((int)d, dimension.height);
        }
    }
}

