/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportConst;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class CorrelationReportParameters
extends ReportParameters
implements ReportConst {
    public static final int DEFAULT_INTERVAL = 15;
    private int interval = 15;
    private ReportInput corr1;
    private ReportInput corr2;
    private int corr2lag;
    private boolean showRegression = true;
    private boolean customRegression = false;
    private double slope;
    private double offset;
    private boolean customForecast = false;
    private double forecast;
    private boolean xForecast = true;
    private boolean yForecast = false;
    private double granularity = -1.0;
    private boolean xGranularity = true;
    private boolean yGranularity = false;

    public CorrelationReportParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public CorrelationReportParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, int n2, double d, BUnit bUnit, ReportInput reportInput, ReportInput reportInput2, int n3, boolean bl, double d2, double d3, boolean bl2, boolean bl3, double d4, boolean bl4, boolean bl5, double d5, boolean bl6, boolean bl7, Lexicon lexicon, boolean bl8, int n4, double d6) {
        super(reportInputArray, reportPeriod, n2, d, bUnit, false, lexicon, bl8, n4, d6);
        this.interval = n;
        this.corr1 = reportInput;
        this.corr2 = reportInput2;
        this.corr2lag = n3;
        this.customRegression = bl;
        this.slope = d2;
        this.offset = d3;
        this.showRegression = bl2;
        this.customForecast = bl3;
        this.forecast = d4;
        this.xForecast = bl4;
        this.yForecast = bl5;
        this.granularity = d5;
        this.xGranularity = bl6;
        this.yGranularity = bl7;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        ReportPeriod reportPeriod = reportParameters.getPeriod();
        this.setPeriod(new ReportPeriod(reportPeriod.getCustomPeriod(), reportPeriod.getStartTime(), reportPeriod.getEndTime(), 127, this.lex));
        int n = reportParameters.getNormalization();
        if (n == 2 || n == 4) {
            this.setNormalization(n);
        } else {
            this.setNormalization(0);
        }
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public ReportInput getCorrelationInput1() {
        return this.corr1;
    }

    public ReportInput getCorrelationInput2() {
        return this.corr2;
    }

    public boolean showRegressionLine() {
        return this.showRegression;
    }

    public int getCorrelation2Lag() {
        return this.corr2lag;
    }

    public int getInterval() {
        return this.interval;
    }

    public long getIntervalMillis() {
        return (long)this.interval * 60L * 1000L;
    }

    public BTimeZone getTimeZone() {
        if (this.getInputs() == null || this.getInputs().length == 0) {
            return BTimeZone.getLocal();
        }
        try {
            return ((SiteDataPoint)this.getInputs()[0].getInputItem(0)).getDataPoint().getTimeZone();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return BTimeZone.getLocal();
        }
    }

    public RegularTimeParameters getTimeParameters() {
        return new RegularTimeParameters(this.getPeriod().getStartTime(), this.getPeriod().getEndTime(), new TimeInterval(this.getInterval(), 3), this.getTimeZone());
    }

    public boolean getCustomRegression() {
        return this.customRegression;
    }

    public double getSlope() {
        return this.slope;
    }

    public double getOffset() {
        return this.offset;
    }

    public boolean getCustomForecast() {
        return this.customForecast;
    }

    public double getForecast() {
        return this.forecast;
    }

    public boolean getXForecast() {
        return this.xForecast;
    }

    public boolean getYForecast() {
        return this.yForecast;
    }

    public double getGranularity() {
        return this.granularity;
    }

    public boolean getXGranularity() {
        return this.xGranularity;
    }

    public boolean getYGranularity() {
        return this.yGranularity;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        ReportInput[] reportInputArray = this.getInputs();
        this.interval = dataInput.readInt();
        boolean bl = false;
        boolean bl2 = false;
        int n = dataInput.readInt();
        if (n >= 0) {
            this.corr1 = reportInputArray[n];
        }
        if ((n = dataInput.readInt()) >= 0) {
            this.corr2 = reportInputArray[n];
        }
        this.corr2lag = dataInput.readInt();
        this.showRegression = dataInput.readBoolean();
        this.customRegression = dataInput.readBoolean();
        this.slope = dataInput.readDouble();
        this.offset = dataInput.readDouble();
        this.customForecast = dataInput.readBoolean();
        this.forecast = dataInput.readDouble();
        this.xForecast = dataInput.readBoolean();
        this.yForecast = dataInput.readBoolean();
        this.granularity = dataInput.readDouble();
        this.xGranularity = dataInput.readBoolean();
        this.yGranularity = dataInput.readBoolean();
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.interval);
        dataOutput.writeInt(this.getIndexOf(this.corr1));
        dataOutput.writeInt(this.getIndexOf(this.corr2));
        dataOutput.writeInt(this.corr2lag);
        dataOutput.writeBoolean(this.showRegression);
        dataOutput.writeBoolean(this.customRegression);
        dataOutput.writeDouble(this.slope);
        dataOutput.writeDouble(this.offset);
        dataOutput.writeBoolean(this.customForecast);
        dataOutput.writeDouble(this.forecast);
        dataOutput.writeBoolean(this.xForecast);
        dataOutput.writeBoolean(this.yForecast);
        dataOutput.writeDouble(this.granularity);
        dataOutput.writeBoolean(this.xGranularity);
        dataOutput.writeBoolean(this.yGranularity);
    }

    private int getIndexOf(ReportInput reportInput) {
        ReportInput[] reportInputArray = this.getInputs();
        if (reportInputArray != null) {
            for (int i = 0; i < reportInputArray.length; ++i) {
                if (reportInputArray[i] != reportInput) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("Correlation Report\n");
        stringBuffer.append("  Period       : ").append(this.getPeriod()).append("\n");
        stringBuffer.append("  Normalization: ");
        switch (this.getNormalization()) {
            case 0: {
                stringBuffer.append("none");
                break;
            }
            case 1: {
                stringBuffer.append("baseline");
                break;
            }
            case 2: {
                stringBuffer.append("floor area");
                break;
            }
            case 4: {
                stringBuffer.append("weather");
            }
        }
        return stringBuffer.toString();
    }
}

