/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultLineConfig;
import com.tridium.eas.ui.chart.DefaultScatterConfig;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.reports.BivariateSeries;
import com.tridium.eas.ui.reports.CorrelationHeaderCellRenderer;
import com.tridium.eas.ui.reports.CorrelationReportParameters;
import com.tridium.eas.ui.reports.CorrelationReportTableModel;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.InterpolatedScalarTimeSeries;
import com.tridium.eas.ui.reports.InterpolatedTimeSeries;
import com.tridium.eas.ui.reports.LinearRegressionSeries;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportInputListCellRenderer;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasTable;
import com.tridium.eas.ui.widgets.FixedSizePanel;
import com.tridium.eas.ui.widgets.IntervalEditor;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class CorrelationReport
extends EasReport
implements EasDataListener {
    public static final String TEMPLATE_ID = "correlationReport";
    private JPanel main;
    private Chart chart;
    private Config config;
    private EasTable table;
    private boolean refreshingInputListDisabled = false;
    private static final String RHO = "r";

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText(TEMPLATE_ID);
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        Lexicon lexicon = BEasApplet.lex;
        if (this.main == null) {
            this.main = new JPanel(false);
            this.main.setLayout(new BorderLayout());
            this.chart = new Chart(lexicon);
            this.chart.setTitle(lexicon.getText(TEMPLATE_ID));
            this.chart.setChartStatus(this);
            this.main.add((Component)this.chart, "Center");
        }
        return this.main;
    }

    protected JComponent getReportDetails() {
        Lexicon lexicon = BEasApplet.lex;
        if (this.table == null) {
            this.table = new EasReportTable((TableModel)new CorrelationReportTableModel(lexicon), false, lexicon);
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        ChartModel chartModel = new ChartModel();
        this.chart.setModel(chartModel);
        chartModel.setTitle(this.getName());
        this.getInputList().getModel().addEasDataListener(this);
        this.setRunReportEnabled(false);
        this.lex = BEasApplet.lex;
    }

    protected ReportParameters createEmptyParameters() {
        return new CorrelationReportParameters(this.lex);
    }

    protected ReportParameters getReportParameters(boolean bl) {
        return new CorrelationReportParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), this.config.getInterval(), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.config.getCorrelationInput1(), this.config.getCorrelationInput2(), this.config.getCorrelation2Lag(), this.config.getCustomRegression(), this.config.getSlope(), this.config.getOffset(), this.config.showRegressionLine(), this.config.getCustomForecast(), this.config.getForecast(), this.config.getXForecast(), this.config.getYForecast(), this.config.getGranularity(), this.config.getXGranularity(), this.config.getYGranularity(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    protected void setReportParameters(ReportParameters reportParameters) {
        CorrelationReportParameters correlationReportParameters = (CorrelationReportParameters)reportParameters;
        this.getInputList().getModel().setInputs(correlationReportParameters.getInputs());
        this.config.setPeriod(correlationReportParameters.getPeriod());
        this.config.setInterval(correlationReportParameters.getInterval());
        this.config.setNormalization(correlationReportParameters.getNormalization());
        this.config.setNormalTemperature(correlationReportParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(correlationReportParameters.getNormalTemperatureUnit());
        this.config.setCorrelationInput1(correlationReportParameters.getCorrelationInput1());
        this.config.setCorrelationInput2(correlationReportParameters.getCorrelationInput2());
        this.config.setCorrelation2Lag(correlationReportParameters.getCorrelation2Lag());
        this.config.setCustomRegression(correlationReportParameters.getCustomRegression());
        this.config.setSlope(correlationReportParameters.getSlope());
        this.config.setOffset(correlationReportParameters.getOffset());
        this.config.setShowRegressionLine(correlationReportParameters.showRegressionLine());
        this.config.setCustomForecast(correlationReportParameters.getCustomForecast());
        this.config.setForecast(correlationReportParameters.getForecast());
        this.config.setXForecast(correlationReportParameters.getXForecast());
        this.config.setYForecast(correlationReportParameters.getYForecast());
        this.config.setGranularity(correlationReportParameters.getGranularity());
        this.config.setXGranularity(correlationReportParameters.getXGranularity());
        this.config.setYGranularity(correlationReportParameters.getYGranularity());
        this.setDataCleanse(correlationReportParameters.getDataCleanse());
        this.setDataCleanseWindow(correlationReportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(correlationReportParameters.getDataCleansePercentage());
    }

    public boolean allowDataPoint(DataPoint dataPoint) {
        try {
            return !this.getSession().getDataPointExec().isMultistate(dataPoint.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            this.config.removeInput((ReportInput)dataEditedEvent.getEditedData()[i]);
        }
        this.setRunReportEnabled(this.config.getInterval() > 0 && this.config.getCorrelationInput1() != null && this.config.getCorrelationInput2() != null);
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        this.dataChanged(dataEditedEvent);
        this.setRunReportEnabled(this.config.getInterval() > 0 && this.config.getCorrelationInput1() != null && this.config.getCorrelationInput2() != null);
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        if (dataEditedEvent.getSource() == this.getInputList().getModel() && !this.refreshingInputListDisabled && dataEditedEvent.getEditedData().length > 0) {
            this.refreshInputListEnabledStates();
        }
    }

    protected void refreshInputListEnabledStates() {
        this.refreshingInputListDisabled = true;
        this.getInputList().getModel().enableAllInputs();
        ReportInput[] reportInputArray = this.getInputList().getModel().getInputs();
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            ReportInputItem[] reportInputItemArray;
            this.config.addInput(reportInputArray[i]);
            if ((this.config.getNormalization() & 4) > 0) {
                reportInputItemArray = reportInputArray[i].getInputItems();
                for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                    if (((SiteDataPoint)reportInputItemArray[n2]).getOutdoorAirTempDataPoint() != null) continue;
                    this.getInputList().getModel().disableInput(i);
                    this.config.removeInput(reportInputArray[i]);
                }
                continue;
            }
            if ((this.config.getNormalization() & 2) <= 0) continue;
            reportInputItemArray = reportInputArray[i].getInputItems();
            for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                try {
                    if (((SiteDataPoint)reportInputItemArray[n2]).getDataPoint().getFloorAreaValue() != 0.0) continue;
                    this.getInputList().getModel().disableInput(i);
                    this.config.removeInput(reportInputArray[i]);
                    continue;
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                    this.getInputList().getModel().disableInput(i);
                    this.config.removeInput(reportInputArray[i]);
                }
            }
        }
        this.refreshingInputListDisabled = false;
    }

    public void runReport(ReportParameters reportParameters) {
        try {
            Object object;
            Lexicon lexicon = BEasApplet.lex;
            CorrelationReportParameters correlationReportParameters = (CorrelationReportParameters)reportParameters;
            if (correlationReportParameters.getInterval() == 0) {
                return;
            }
            ChartModel chartModel = new ChartModel();
            chartModel.setTitle(lexicon.getText(TEMPLATE_ID));
            ReportPeriod reportPeriod = correlationReportParameters.getPeriod();
            int n = reportPeriod.getDaysOfWeek();
            ReportInput reportInput = correlationReportParameters.getCorrelationInput1();
            ReportInput reportInput2 = correlationReportParameters.getCorrelationInput2();
            if (reportInput == null || reportInput2 == null) {
                return;
            }
            TimeSeries timeSeries = null;
            int n2 = -1;
            TimeSeries timeSeries2 = null;
            int n3 = -1;
            if (reportInput.getUnit() == null || reportInput.getUnit().isNull()) {
                timeSeries = new InterpolatedScalarTimeSeries(correlationReportParameters.getTimeParameters(), reportInput, correlationReportParameters.isNormalizedByFloorArea(), correlationReportParameters.isNormalizedByTemperature(), correlationReportParameters.getNormalTemperature(), correlationReportParameters.getNormalTemperatureUnit(), n, lexicon, correlationReportParameters.getDataCleanse(), correlationReportParameters.getDataCleanseWindow(), correlationReportParameters.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                n2 = 0;
            } else {
                timeSeries = new InterpolatedTimeSeries(correlationReportParameters.getTimeParameters(), reportInput.getUnit(), correlationReportParameters.isNormalizedByFloorArea(), correlationReportParameters.isNormalizedByTemperature(), correlationReportParameters.getNormalTemperature(), correlationReportParameters.getNormalTemperatureUnit(), n, lexicon, correlationReportParameters.getDataCleanse(), correlationReportParameters.getDataCleanseWindow(), correlationReportParameters.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                n2 = ((InterpolatedTimeSeries)timeSeries).addInput(reportInput, false, 0);
            }
            if (reportInput2.getUnit() == null || reportInput2.getUnit().isNull()) {
                timeSeries2 = new InterpolatedScalarTimeSeries(correlationReportParameters.getTimeParameters(), reportInput2, correlationReportParameters.isNormalizedByFloorArea(), correlationReportParameters.isNormalizedByTemperature(), correlationReportParameters.getNormalTemperature(), correlationReportParameters.getNormalTemperatureUnit(), n, lexicon, correlationReportParameters.getDataCleanse(), correlationReportParameters.getDataCleanseWindow(), correlationReportParameters.getDataCleansePercentage(), reportInput2.hasNormalizingPoint(), reportInput2.getNormalizingPoint());
                n3 = 0;
            } else {
                timeSeries2 = new InterpolatedTimeSeries(correlationReportParameters.getTimeParameters(), reportInput2.getUnit(), correlationReportParameters.isNormalizedByFloorArea(), correlationReportParameters.isNormalizedByTemperature(), correlationReportParameters.getNormalTemperature(), correlationReportParameters.getNormalTemperatureUnit(), n, lexicon, correlationReportParameters.getDataCleanse(), correlationReportParameters.getDataCleanseWindow(), correlationReportParameters.getDataCleansePercentage(), reportInput2.hasNormalizingPoint(), reportInput2.getNormalizingPoint());
                n3 = ((InterpolatedTimeSeries)timeSeries2).addInput(reportInput2, false, 0);
            }
            BivariateSeries bivariateSeries = new BivariateSeries(timeSeries, n2, timeSeries2, n3, this.config.getCorrelation2LagRollups(), Color.black, lexicon);
            AxisInfo axisInfo = new AxisInfo();
            axisInfo.setTitle(reportInput.getName());
            AxisInfo axisInfo2 = new AxisInfo();
            axisInfo2.setTitle(reportInput2.getName());
            chartModel.setSeries(bivariateSeries, new DefaultScatterConfig(Color.black), axisInfo, axisInfo2);
            double d = bivariateSeries.getCorrelation(0);
            DecimalFormat decimalFormat = new DecimalFormat("#.0000");
            String string = "";
            CorrelationReportTableModel correlationReportTableModel = (CorrelationReportTableModel)this.table.getModel();
            if (this.config.showRegressionLine()) {
                object = null;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = correlationReportParameters.getGranularity();
                boolean bl = correlationReportParameters.getXGranularity();
                if (correlationReportParameters.getCustomRegression()) {
                    if (correlationReportParameters.getCustomForecast() && correlationReportParameters.getYForecast()) {
                        d2 = (correlationReportParameters.getForecast() - correlationReportParameters.getOffset()) / correlationReportParameters.getSlope();
                        object = bivariateSeries.getLinearRegressionSeries(0, Color.darkGray, correlationReportParameters.getSlope(), correlationReportParameters.getOffset(), correlationReportParameters.getCustomForecast(), d2);
                    } else {
                        object = bivariateSeries.getLinearRegressionSeries(0, Color.darkGray, correlationReportParameters.getSlope(), correlationReportParameters.getOffset(), correlationReportParameters.getCustomForecast(), correlationReportParameters.getForecast());
                    }
                } else {
                    object = bivariateSeries.getLinearRegressionSeries(0, Color.darkGray, correlationReportParameters.getCustomForecast(), correlationReportParameters.getForecast());
                    if (correlationReportParameters.getCustomForecast() && correlationReportParameters.getYForecast()) {
                        d2 = (correlationReportParameters.getForecast() - ((LinearRegressionSeries)object).getRegressionFunction().getOffset()) / ((LinearRegressionSeries)object).getRegressionFunction().getSlope();
                        object = bivariateSeries.getLinearRegressionSeries(0, Color.darkGray, correlationReportParameters.getCustomForecast(), d2);
                    }
                    this.config.setSlope(((LinearRegressionSeries)object).getRegressionFunction().getSlope());
                    this.config.setOffset(((LinearRegressionSeries)object).getRegressionFunction().getOffset());
                }
                chartModel.addSeries((Series)object, new DefaultLineConfig(1, false, Color.darkGray), null, null);
                string = lexicon.getText(RHO) + " = " + decimalFormat.format(d) + "\n" + lexicon.getText("y") + " = " + new DecimalFormat("#.000").format(((LinearRegressionSeries)object).getRegressionFunction().getSlope()) + lexicon.getText("x") + " " + (((LinearRegressionSeries)object).getRegressionFunction().getOffset() < 0.0 ? "" : "+ ") + new DecimalFormat("0.##").format(((LinearRegressionSeries)object).getRegressionFunction().getOffset());
                if (d4 != 0.0) {
                    this.toggleDetails.setEnabled(true);
                    this.setDetailsVisible(true);
                    if (!bl) {
                        d2 = ((Series)object).getMax();
                        d3 = ((Series)object).getMin();
                    } else {
                        d2 = (((Series)object).getMax() - ((LinearRegressionSeries)object).getRegressionFunction().getOffset()) / ((LinearRegressionSeries)object).getRegressionFunction().getSlope();
                        d3 = (((Series)object).getMin() - ((LinearRegressionSeries)object).getRegressionFunction().getOffset()) / ((LinearRegressionSeries)object).getRegressionFunction().getSlope();
                    }
                    if (Double.isNaN(d3) || Double.isNaN(d2)) {
                        correlationReportTableModel.clear();
                    } else {
                        if (d2 < d3) {
                            double d5 = d2;
                            d2 = d3;
                            d3 = d5;
                        }
                        d3 = Math.min(0.0, d3);
                        if (d4 < 0.0) {
                            d4 = Math.abs((d2 - d3) / 50.0);
                            if (d4 > 1.0) {
                                d4 = Math.ceil(d4);
                            }
                            this.config.granularityField.setText(d4);
                        }
                        correlationReportTableModel.setParameters(correlationReportParameters, reportInput, reportInput2, ((LinearRegressionSeries)object).getRegressionFunction().getSlope(), ((LinearRegressionSeries)object).getRegressionFunction().getOffset(), d3, d2, d4, bl);
                        this.table.resetSorting();
                        int n4 = this.table.getModel().getColumnCount();
                        for (int i = 0; i < n4; ++i) {
                            this.table.getColumnModel().getColumn(i).setHeaderRenderer(new CorrelationHeaderCellRenderer());
                        }
                        this.table.getTableHeader().repaint();
                    }
                    this.table.revalidate();
                } else {
                    correlationReportTableModel.clear();
                    this.toggleDetails.setEnabled(false);
                    this.setDetailsVisible(false);
                }
            } else {
                correlationReportTableModel.clear();
                this.toggleDetails.setEnabled(false);
                this.setDetailsVisible(false);
                string = lexicon.getText(RHO) + " = " + decimalFormat.format(d);
            }
            this.chart.setModel(chartModel);
            object = new StringBuffer();
            ((StringBuffer)object).append(reportPeriod.getDateRangeString());
            this.chart.setSubtitle(((StringBuffer)object).toString() + "\n \n" + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    private class Config
    extends JComponent {
        private IntervalEditor interval;
        private ReportPeriodEditor periodEditor;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private XpComboBox series1;
        private XpComboBox series2;
        private IntervalEditor correlation2Lag;
        private JRadioButton showRegressionLine;
        private NumberTextField normTemperatureTextBox;
        private UnitComboBox normTemperatureUnitComboBox;
        private NumberTextField slopeField;
        private NumberTextField offsetField;
        private JRadioButton autoRegression;
        private JRadioButton customRegression;
        private JLabel slopeLabel;
        private JLabel offsetLabel;
        private JRadioButton xForecastButton;
        private JRadioButton yForecastButton;
        private JCheckBox forecastEnable;
        private NumberTextField forecastField;
        private JRadioButton xGranularityButton;
        private JRadioButton yGranularityButton;
        private JCheckBox autoGranularity;
        private JLabel incrementLabel;
        NumberTextField granularityField;

        public Config() {
            Lexicon lexicon = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = n++;
            this.periodEditor = new ReportPeriodEditor(lexicon);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(lexicon.getText("period")));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            this.add((Component)this.periodEditor, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(0, 0, 0));
            this.interval = new IntervalEditor(lexicon);
            this.interval.setStep(900000L);
            this.interval.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.correlation2Lag.setStep(Config.this.interval.getValue());
                    CorrelationReport.this.setRunReportEnabled(Config.this.getInterval() > 0 && CorrelationReport.this.getInputList().getModel().getInputCount() > 0);
                }
            });
            jPanel.add(this.interval);
            jPanel.setBorder(BorderFactory.createTitledBorder(lexicon.getText("rollupInterval")));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            this.add((Component)jPanel, gridBagConstraints);
            JPanel jPanel2 = new JPanel(false);
            this.add(jPanel2);
            jPanel2.setLayout(new GridBagLayout());
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CorrelationReport.this.refreshInputListEnabledStates();
                }
            };
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.weighty = 0.0;
            int n2 = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n2++;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            this.normFloorArea = new JCheckBox(lexicon.getText("floorArea"));
            this.normFloorArea.setFont(font);
            this.normFloorArea.addActionListener(actionListener);
            this.normFloorArea.setSelected(false);
            jPanel2.add((Component)this.normFloorArea, gridBagConstraints2);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = n2++;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.0;
            this.normWeather = new JCheckBox(lexicon.getText("degreeDay"));
            this.normWeather.setFont(font);
            this.normWeather.addActionListener(actionListener);
            this.normWeather.setSelected(false);
            jPanel2.add((Component)this.normWeather, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            this.normTemperatureTextBox = new NumberTextField(3);
            this.normTemperatureTextBox.setText(65);
            jPanel2.add((Component)this.normTemperatureTextBox, gridBagConstraints2);
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            this.normTemperatureUnitComboBox = new UnitComboBox(UnitDatabase.getDefault().getQuantity(BUnit.getUnit((String)"fahrenheit")), lexicon);
            this.normTemperatureUnitComboBox.setSelectedUnit(BUnit.getUnit((String)"fahrenheit"));
            jPanel2.add((Component)this.normTemperatureUnitComboBox, gridBagConstraints2);
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 100.0;
            jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints2);
            jPanel2.setBorder(BorderFactory.createTitledBorder(lexicon.getText("normalization")));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            this.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints.gridy = n++;
            JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
            jPanel3.setBorder(BorderFactory.createTitledBorder(lexicon.getText("correlation")));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.fill = 0;
            jPanel3.add((Component)new JLabel(lexicon.getText("x")), gridBagConstraints3);
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.weightx = 100.0;
            gridBagConstraints3.fill = 2;
            this.series1 = new XpComboBox();
            this.series1.setRenderer(new ReportInputListCellRenderer(30));
            jPanel3.add((Component)new FixedSizePanel(this.series1), gridBagConstraints3);
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.fill = 0;
            jPanel3.add((Component)new JLabel(lexicon.getText("y")), gridBagConstraints3);
            this.series2 = new XpComboBox();
            this.series2.setRenderer(new ReportInputListCellRenderer(30));
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.weightx = 100.0;
            gridBagConstraints3.fill = 2;
            jPanel3.add((Component)new FixedSizePanel(this.series2), gridBagConstraints3);
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.fill = 0;
            jPanel3.add((Component)new JLabel(lexicon.getText("lag")), gridBagConstraints3);
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.weightx = 100.0;
            gridBagConstraints3.fill = 2;
            this.correlation2Lag = new IntervalEditor(lexicon);
            jPanel3.add((Component)this.correlation2Lag, gridBagConstraints3);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            this.add((Component)jPanel3, gridBagConstraints);
            this.setInterval(15);
            gridBagConstraints.gridy = n++;
            JPanel jPanel4 = new JPanel(false);
            jPanel4.setLayout(new GridBagLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(lexicon.getText("linearRegression")));
            this.add((Component)jPanel4, gridBagConstraints);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 18;
            gridBagConstraints4.weighty = 0.0;
            int n3 = 0;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = n3++;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.weightx = 0.0;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.showRegressionLine = new JRadioButton(lexicon.getText("none"));
            this.showRegressionLine.setFont(font);
            this.showRegressionLine.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        Config.this.slopeLabel.setEnabled(false);
                        Config.this.slopeField.setEditable(false);
                        Config.this.offsetLabel.setEnabled(false);
                        Config.this.offsetField.setEditable(false);
                        Config.this.xForecastButton.setEnabled(false);
                        Config.this.yForecastButton.setEnabled(false);
                        Config.this.forecastEnable.setEnabled(false);
                        Config.this.forecastField.setEditable(false);
                        Config.this.xGranularityButton.setEnabled(false);
                        Config.this.yGranularityButton.setEnabled(false);
                        Config.this.incrementLabel.setEnabled(false);
                        Config.this.autoGranularity.setEnabled(false);
                        Config.this.granularityField.setEditable(false);
                    }
                }
            });
            buttonGroup.add(this.showRegressionLine);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 10;
            jPanel4.add((Component)this.showRegressionLine, gridBagConstraints4);
            this.autoRegression = new JRadioButton(lexicon.getText("auto"));
            this.autoRegression.setFont(font);
            this.autoRegression.setSelected(true);
            this.autoRegression.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        Config.this.slopeLabel.setEnabled(false);
                        Config.this.slopeField.setEditable(false);
                        Config.this.offsetLabel.setEnabled(false);
                        Config.this.offsetField.setEditable(false);
                        Config.this.xForecastButton.setEnabled(true);
                        Config.this.yForecastButton.setEnabled(true);
                        Config.this.forecastEnable.setEnabled(true);
                        Config.this.forecastField.setEditable(Config.this.forecastEnable.isSelected());
                        Config.this.xGranularityButton.setEnabled(true);
                        Config.this.yGranularityButton.setEnabled(true);
                        Config.this.incrementLabel.setEnabled(true);
                        Config.this.autoGranularity.setEnabled(true);
                        Config.this.granularityField.setEditable(!Config.this.autoGranularity.isSelected());
                    }
                }
            });
            buttonGroup.add(this.autoRegression);
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 10;
            jPanel4.add((Component)this.autoRegression, gridBagConstraints4);
            this.customRegression = new JRadioButton(lexicon.getText("custom"));
            this.customRegression.setFont(font);
            this.customRegression.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        Config.this.slopeLabel.setEnabled(true);
                        Config.this.slopeField.setEditable(true);
                        Config.this.offsetLabel.setEnabled(true);
                        Config.this.offsetField.setEditable(true);
                        Config.this.xForecastButton.setEnabled(true);
                        Config.this.yForecastButton.setEnabled(true);
                        Config.this.forecastEnable.setEnabled(true);
                        Config.this.forecastField.setEditable(Config.this.forecastEnable.isSelected());
                        Config.this.xGranularityButton.setEnabled(true);
                        Config.this.yGranularityButton.setEnabled(true);
                        Config.this.incrementLabel.setEnabled(true);
                        Config.this.autoGranularity.setEnabled(true);
                        Config.this.granularityField.setEditable(!Config.this.autoGranularity.isSelected());
                    }
                }
            });
            buttonGroup.add(this.customRegression);
            gridBagConstraints4.gridx = 4;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 10;
            jPanel4.add((Component)this.customRegression, gridBagConstraints4);
            gridBagConstraints4.gridy = n3++;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 17;
            this.slopeLabel = new JLabel(lexicon.getText("slope"));
            this.slopeLabel.setEnabled(false);
            jPanel4.add((Component)this.slopeLabel, gridBagConstraints4);
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 10;
            this.slopeField = new NumberTextField(6, 20);
            this.slopeField.setText(0);
            this.slopeField.setEditable(false);
            jPanel4.add((Component)this.slopeField, gridBagConstraints4);
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 13;
            this.offsetLabel = new JLabel(lexicon.getText("offset"));
            this.offsetLabel.setEnabled(false);
            jPanel4.add((Component)this.offsetLabel, gridBagConstraints4);
            gridBagConstraints4.gridx = 4;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 10;
            this.offsetField = new NumberTextField(6, 20);
            this.offsetField.setText(0);
            this.offsetField.setEditable(false);
            jPanel4.add((Component)this.offsetField, gridBagConstraints4);
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            JPanel jPanel5 = new JPanel(false);
            jPanel5.setLayout(new GridBagLayout());
            jPanel5.setBorder(BorderFactory.createTitledBorder(lexicon.getText("forecasting")));
            this.add((Component)jPanel5, gridBagConstraints);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.weighty = 0.0;
            int n4 = 0;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = n4++;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.weightx = 0.0;
            ButtonGroup buttonGroup2 = new ButtonGroup();
            this.xForecastButton = new JRadioButton(lexicon.getText("x"));
            this.xForecastButton.setFont(font);
            this.xForecastButton.setSelected(true);
            buttonGroup2.add(this.xForecastButton);
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.anchor = 10;
            jPanel5.add((Component)this.xForecastButton, gridBagConstraints5);
            this.yForecastButton = new JRadioButton(lexicon.getText("y"));
            this.yForecastButton.setFont(font);
            buttonGroup2.add(this.yForecastButton);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.anchor = 17;
            jPanel5.add((Component)this.yForecastButton, gridBagConstraints5);
            gridBagConstraints5.gridy = n4++;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.anchor = 17;
            this.forecastEnable = new JCheckBox(lexicon.getText("on"));
            this.forecastEnable.setFont(font);
            this.forecastEnable.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.forecastField.setEditable(Config.this.forecastEnable.isSelected());
                }
            });
            this.forecastEnable.setSelected(false);
            jPanel5.add((Component)this.forecastEnable, gridBagConstraints5);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.anchor = 10;
            this.forecastField = new NumberTextField(6, 40);
            this.forecastField.setText(0);
            this.forecastField.setEditable(false);
            jPanel5.add((Component)this.forecastField, gridBagConstraints5);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            JPanel jPanel6 = new JPanel(false);
            jPanel6.setLayout(new GridBagLayout());
            jPanel6.setBorder(BorderFactory.createTitledBorder(lexicon.getText("tableGranularity")));
            this.add((Component)jPanel6, gridBagConstraints);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 18;
            gridBagConstraints6.weighty = 0.0;
            int n5 = 0;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = n5++;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.weightx = 0.0;
            ButtonGroup buttonGroup3 = new ButtonGroup();
            this.xGranularityButton = new JRadioButton(lexicon.getText("x"));
            this.xGranularityButton.setFont(font);
            this.xGranularityButton.setSelected(true);
            buttonGroup3.add(this.xGranularityButton);
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 10;
            jPanel6.add((Component)this.xGranularityButton, gridBagConstraints6);
            this.yGranularityButton = new JRadioButton(lexicon.getText("y"));
            this.yGranularityButton.setFont(font);
            buttonGroup3.add(this.yGranularityButton);
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 17;
            jPanel6.add((Component)this.yGranularityButton, gridBagConstraints6);
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 13;
            this.autoGranularity = new JCheckBox(lexicon.getText("auto"));
            this.autoGranularity.setFont(font);
            this.autoGranularity.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.granularityField.setEditable(!Config.this.autoGranularity.isSelected());
                }
            });
            this.autoGranularity.setSelected(true);
            jPanel6.add((Component)this.autoGranularity, gridBagConstraints6);
            gridBagConstraints6.gridy = n5++;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 17;
            this.incrementLabel = new JLabel(lexicon.getText("increment"));
            jPanel6.add((Component)this.incrementLabel, gridBagConstraints6);
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 10;
            this.granularityField = new NumberTextField(6, 40);
            this.granularityField.setText(20);
            this.granularityField.setAllowNegative(false);
            this.granularityField.setEditable(false);
            jPanel6.add((Component)this.granularityField, gridBagConstraints6);
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public void setShowRegressionLine(boolean bl) {
            this.showRegressionLine.setSelected(!bl);
        }

        public boolean showRegressionLine() {
            return !this.showRegressionLine.isSelected();
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) > 0);
            this.normWeather.setSelected((n & 4) > 0);
        }

        public int getInterval() {
            return (int)(this.interval.getValue() / 60000L);
        }

        public void setInterval(int n) {
            this.interval.setValue((long)n * 1000L * 60L);
            this.correlation2Lag.setStep(this.interval.getValue());
        }

        public long getIntervalMillis() {
            return this.interval.getValue();
        }

        public void removeInput(ReportInput reportInput) {
            this.series1.removeItem(reportInput);
            this.series2.removeItem(reportInput);
        }

        public void addInput(ReportInput reportInput) {
            if (this.indexOf(this.series1, reportInput) < 0) {
                this.series1.addItem(reportInput);
                this.series2.addItem(reportInput);
                if (this.series1.getItemCount() == 2 && this.series1.getSelectedItem() == this.series2.getSelectedItem()) {
                    this.setCorrelationInput2(reportInput);
                }
            }
        }

        public int indexOf(XpComboBox xpComboBox, Object object) {
            for (int i = 0; i < xpComboBox.getItemCount(); ++i) {
                if (!xpComboBox.getItemAt(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        public void setCorrelationInput1(ReportInput reportInput) {
            if (reportInput != null) {
                this.series1.setSelectedItem(reportInput);
            }
        }

        public ReportInput getCorrelationInput1() {
            if (this.series1.getSelectedItem() instanceof ReportInput) {
                return (ReportInput)this.series1.getSelectedItem();
            }
            return null;
        }

        public void setCorrelationInput2(ReportInput reportInput) {
            if (reportInput != null) {
                this.series2.setSelectedItem(reportInput);
            }
        }

        public ReportInput getCorrelationInput2() {
            if (this.series2.getSelectedItem() instanceof ReportInput) {
                return (ReportInput)this.series2.getSelectedItem();
            }
            return null;
        }

        public void setCorrelation2Lag(int n) {
            this.correlation2Lag.setValue(n * 60 * 1000);
        }

        public int getCorrelation2Lag() {
            return (int)(this.correlation2Lag.getValue() / 60000L);
        }

        public int getCorrelation2LagRollups() {
            return (int)(this.correlation2Lag.getValue() / this.interval.getValue());
        }

        public double getNormalTemperature() {
            return this.normTemperatureTextBox.getDoubleValue();
        }

        public void setNormalTemperature(double d) {
            this.normTemperatureTextBox.setText(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.normTemperatureUnitComboBox.getSelectedUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.normTemperatureUnitComboBox.setSelectedUnit(bUnit);
        }

        public double getSlope() {
            return this.slopeField.getDoubleValue();
        }

        public void setSlope(double d) {
            this.slopeField.setText(d);
        }

        public double getOffset() {
            return this.offsetField.getDoubleValue();
        }

        public void setOffset(double d) {
            this.offsetField.setText(d);
        }

        public boolean getCustomRegression() {
            return this.customRegression.isSelected();
        }

        public void setCustomRegression(boolean bl) {
            this.customRegression.setSelected(bl);
        }

        public void setCustomForecast(boolean bl) {
            this.forecastEnable.setSelected(bl);
            this.forecastField.setEditable(bl);
        }

        public boolean getCustomForecast() {
            return this.forecastEnable.isSelected();
        }

        public double getForecast() {
            return this.forecastField.getDoubleValue();
        }

        public void setForecast(double d) {
            this.forecastField.setText(d);
        }

        public void setYForecast(boolean bl) {
            this.yForecastButton.setSelected(bl);
        }

        public boolean getYForecast() {
            return this.yForecastButton.isSelected();
        }

        public void setXForecast(boolean bl) {
            this.xForecastButton.setSelected(bl);
        }

        public boolean getXForecast() {
            return this.xForecastButton.isSelected();
        }

        public double getGranularity() {
            if (this.autoGranularity.isSelected()) {
                return -1.0;
            }
            return this.granularityField.getDoubleValue();
        }

        public void setGranularity(double d) {
            if (d < 0.0) {
                this.autoGranularity.setSelected(true);
                this.granularityField.setEditable(false);
            } else {
                this.autoGranularity.setSelected(false);
                this.granularityField.setEditable(true);
                this.granularityField.setText(d);
            }
        }

        public void setYGranularity(boolean bl) {
            this.yGranularityButton.setSelected(bl);
        }

        public boolean getYGranularity() {
            return this.yGranularityButton.isSelected();
        }

        public void setXGranularity(boolean bl) {
            this.xGranularityButton.setSelected(bl);
        }

        public boolean getXGranularity() {
            return this.xGranularityButton.isSelected();
        }
    }
}

