/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.function.Correlation;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.Subpopulation;
import com.tridium.eas.ui.chart.FloatSeries;
import com.tridium.eas.ui.chart.PopulationTimeSeries;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.LinearRegressionSeries;
import java.awt.Color;
import java.util.ArrayList;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class BivariateSeries
extends FloatSeries
implements ValueColors {
    private Series doubleSeries;
    private ArrayList valueSeriesList;
    private ArrayList valueIndexList;
    private ArrayList valueLagList;
    private int doubleValueIndex;
    private int maxLag;
    private int minLag;
    private Color valueColor;
    private Lexicon lex;

    public BivariateSeries(Series series, int n, Series series2, int n2, Lexicon lexicon) {
        this(series, n, series2, n2, 0, null, lexicon);
    }

    public BivariateSeries(Series series, int n, Series series2, int n2, int n3, Lexicon lexicon) {
        this(series, n, series2, n2, n3, null, lexicon);
    }

    public BivariateSeries(Series series, int n, Series series2, int n2, int n3, Color color, Lexicon lexicon) {
        this.doubleSeries = series;
        this.doubleValueIndex = n;
        this.valueSeriesList = new ArrayList();
        this.valueIndexList = new ArrayList();
        this.valueLagList = new ArrayList();
        this.maxLag = n3;
        this.minLag = n3;
        this.valueColor = color;
        this.lex = lexicon;
        this.addValueSeries(series2, n2, n3);
    }

    public int getRowCount() {
        return this.doubleSeries.getRowCount() - Math.max(this.maxLag, 0) + Math.min(this.minLag, 0);
    }

    public String getSeriesName() {
        return "";
    }

    public int getValueType() {
        return 0;
    }

    public double getCorrelation(int n) {
        if (this.getValueLag(n) == 0) {
            return Correlation.getCorrelation(this.doubleSeries.getValuePopulation(this.doubleValueIndex), this.doubleSeries.getValueMean(this.doubleValueIndex), this.doubleSeries.getValueStandardDeviation(this.doubleValueIndex), this.getValueSeries(n).getValuePopulation(this.getValueIndex(n)), this.getValueSeries(n).getValueMean(this.getValueIndex(n)), this.getValueSeries(n).getValueStandardDeviation(this.getValueIndex(n)));
        }
        if (this.getValueLag(n) > 0) {
            return Correlation.getCorrelation(new Subpopulation(this.doubleSeries.getValuePopulation(this.doubleValueIndex), this.getValueLag(n), this.doubleSeries.getRowCount() - this.getValueLag(n)), new Subpopulation(this.getValueSeries(n).getValuePopulation(this.getValueIndex(n)), 0, this.doubleSeries.getRowCount() - this.getValueLag(n)));
        }
        return Correlation.getCorrelation(new Subpopulation(this.doubleSeries.getValuePopulation(this.doubleValueIndex), 0, this.doubleSeries.getRowCount() + this.getValueLag(n)), new Subpopulation(this.getValueSeries(n).getValuePopulation(this.getValueIndex(n)), -1 * this.getValueLag(n), this.doubleSeries.getRowCount() + this.getValueLag(n)));
    }

    public Series getCorrelatingSeries(int n) {
        TimeSeries timeSeries = (TimeSeries)this.doubleSeries;
        TimeSeries timeSeries2 = (TimeSeries)this.getValueSeries(n);
        if (this.getValueLag(n) == 0) {
            return new PopulationTimeSeries(timeSeries.getTimestampPopulation(), new Population[]{timeSeries.getValuePopulation(this.doubleValueIndex), timeSeries2.getValuePopulation(this.getValueIndex(n))}, new String[]{this.lex.getText("series1"), this.lex.getText("series2")}, new Color[]{Color.red, Color.darkGray}, timeSeries.getValueUnits());
        }
        if (this.getValueLag(n) > 0) {
            return new PopulationTimeSeries((Population)new Subpopulation(timeSeries.getTimestampPopulation(), this.getValueLag(n), timeSeries.getRowCount() - this.getValueLag(n)), new Population[]{new Subpopulation(timeSeries.getValuePopulation(this.doubleValueIndex), this.getValueLag(n), timeSeries.getRowCount() - this.getValueLag(n)), new Subpopulation(timeSeries2.getValuePopulation(this.getValueIndex(n)), 0, timeSeries.getRowCount() - this.getValueLag(n))}, new String[]{this.lex.getText("series1"), this.lex.getText("series2")}, new Color[]{Color.red, Color.darkGray}, timeSeries.getValueUnits());
        }
        return new PopulationTimeSeries((Population)new Subpopulation(timeSeries.getTimestampPopulation(), 0, timeSeries.getRowCount() + this.getValueLag(n)), new Population[]{new Subpopulation(timeSeries.getValuePopulation(this.doubleValueIndex), 0, timeSeries.getRowCount() + this.getValueLag(n)), new Subpopulation(timeSeries2.getValuePopulation(this.getValueIndex(n)), -1 * this.getValueLag(n), timeSeries.getRowCount() + this.getValueLag(n))}, new String[]{this.lex.getText("series1"), this.lex.getText("series2")}, new Color[]{Color.red, Color.darkGray}, timeSeries.getValueUnits());
    }

    public LinearRegressionSeries getLinearRegressionSeries(int n, Color color) {
        return new LinearRegressionSeries(this.doubleSeries, this.getValueSeries(n), this.doubleValueIndex, this.getValueIndex(n), color, this.getValueLag(n), this.lex);
    }

    public LinearRegressionSeries getLinearRegressionSeries(int n) {
        return this.getLinearRegressionSeries(n, this.getValueColor(n));
    }

    public LinearRegressionSeries getLinearRegressionSeries(int n, Color color, boolean bl, double d) {
        return new LinearRegressionSeries(this.doubleSeries, this.getValueSeries(n), this.doubleValueIndex, this.getValueIndex(n), color, this.getValueLag(n), this.lex, bl, d);
    }

    public LinearRegressionSeries getLinearRegressionSeries(int n, Color color, double d, double d2, boolean bl, double d3) {
        return new LinearRegressionSeries(this.doubleSeries, this.getValueSeries(n), this.doubleValueIndex, this.getValueIndex(n), color, this.getValueLag(n), this.lex, d, d2, bl, d3);
    }

    public BUnit getValueUnits() {
        return this.getValueSeries(0).getValueUnits();
    }

    public Color getValueColor(int n) {
        if (this.valueColor == null) {
            Series series = this.getValueSeries(n);
            if (series instanceof ValueColors) {
                return ((ValueColors)((Object)series)).getValueColor(this.getValueIndex(n));
            }
            return Color.lightGray;
        }
        return this.valueColor;
    }

    public boolean isValid(int n, int n2) {
        boolean bl = true;
        boolean bl2 = true;
        if (this.minLag < 0) {
            bl = this.getValueSeries(n2).getValuePopulation(this.getValueIndex(n2)).isValid(n - this.minLag + this.getValueLag(n2));
            bl2 = this.doubleSeries.getValuePopulation(this.doubleValueIndex).isValid(n - this.minLag);
        } else {
            bl = this.getValueSeries(n2).getValuePopulation(this.getValueIndex(n2)).isValid(n + this.maxLag - this.getValueLag(n2));
            bl2 = this.doubleSeries.getValuePopulation(this.doubleValueIndex).isValid(n + this.maxLag);
        }
        return bl && bl2;
    }

    public double getValue(int n, int n2) {
        if (this.minLag < 0) {
            return this.getValueSeries(n2).getValue(n - this.minLag + this.getValueLag(n2), this.getValueIndex(n2));
        }
        return this.getValueSeries(n2).getValue(n + this.maxLag - this.getValueLag(n2), this.getValueIndex(n2));
    }

    public double getDouble(int n) {
        if (this.minLag < 0) {
            return this.doubleSeries.getValue(n - this.minLag, this.doubleValueIndex);
        }
        return this.doubleSeries.getValue(n + this.maxLag, this.doubleValueIndex);
    }

    public BUnit getDoubleUnits() {
        return this.doubleSeries.getValueUnits();
    }

    public double getMinDouble() {
        return this.doubleSeries.getMin(this.doubleValueIndex);
    }

    public double getMaxDouble() {
        return this.doubleSeries.getMax(this.doubleValueIndex);
    }

    public double getMin(int n) {
        return this.getValueSeries(n).getMin(this.getValueIndex(n));
    }

    public double getMax(int n) {
        return this.getValueSeries(n).getMax(this.getValueIndex(n));
    }

    public Series getValueSeries(int n) {
        return (Series)this.valueSeriesList.get(n);
    }

    public int getValueIndex(int n) {
        return (Integer)this.valueIndexList.get(n);
    }

    public int getValueLag(int n) {
        return (Integer)this.valueLagList.get(n);
    }

    public void addValueSeries(Series series, int n, int n2) {
        if (series.getRowCount() != this.doubleSeries.getRowCount()) {
            throw new IllegalArgumentException(this.lex.getText("wrongRowNum"));
        }
        this.valueSeriesList.add(series);
        this.valueIndexList.add(new Integer(n));
        this.valueLagList.add(new Integer(n2));
        this.maxLag = Math.max(this.maxLag, n2);
        this.minLag = Math.min(this.minLag, n2);
    }
}

