/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.BaselineReportPeriod;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class AvgProfileParameters
extends ReportParameters {
    public static final int DEFAULT_INTERVAL = 15;
    public static final int VERSION = 411;
    private int interval = 15;
    private BaselineReportPeriod baselinePeriod = null;
    private ReportInput baselineSource = null;
    private ReportInput baseline = null;
    private boolean applyBaseline = true;
    private int baselineColor = ChartColors.getColorCount() - 1;

    public AvgProfileParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public AvgProfileParameters(ReportInput[] reportInputArray, ReportPeriod reportPeriod, int n, int n2, double d, BUnit bUnit, BaselineReportPeriod baselineReportPeriod, ReportInput reportInput, ReportInput reportInput2, boolean bl, int n3, Lexicon lexicon, boolean bl2, int n4, double d2) {
        super(reportInputArray, reportPeriod, n2, d, bUnit, false, lexicon, bl2, n4, d2);
        this.interval = n;
        this.baselinePeriod = baselineReportPeriod;
        this.baselineSource = reportInput;
        this.baseline = reportInput2;
        this.applyBaseline = bl;
        this.baselineColor = n3;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        this.setPeriod(reportParameters.getPeriod());
        this.setNormalization(reportParameters.getNormalization());
        this.setNormalTemperature(reportParameters.getNormalTemperature());
        this.setNormalTemperatureUnit(reportParameters.getNormalTemperatureUnit());
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public int getInterval() {
        return this.interval;
    }

    public BaselineReportPeriod getBaselinePeriod() {
        return this.baselinePeriod;
    }

    public ReportInput getBaselineSource() {
        return this.baselineSource;
    }

    public ReportInput getBaseline() {
        return this.baseline;
    }

    public boolean getApplyBaseline() {
        return this.applyBaseline;
    }

    public int getBaselineColor() {
        return this.baselineColor;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        int n = dataInput.readInt();
        if (n != 411) {
            this.interval = n;
            this.baselinePeriod = null;
            this.applyBaseline = true;
            this.baselineColor = ChartColors.getColorCount() - 1;
            this.baselineSource = null;
            this.baseline = null;
        } else {
            int n2;
            this.interval = dataInput.readInt();
            this.baselinePeriod = new BaselineReportPeriod(this.lex);
            this.baselinePeriod.load(dataInput);
            this.baselinePeriod.setReferencePeriod(this.getPeriod());
            this.applyBaseline = dataInput.readBoolean();
            this.baselineColor = dataInput.readInt();
            boolean bl = dataInput.readBoolean();
            if (!bl && (n2 = dataInput.readInt()) >= 0) {
                ReportInput[] reportInputArray = this.getInputs();
                this.baselineSource = reportInputArray[n2];
                this.baseline = this.baselineSource.getCopy();
                this.baseline.setName(dataInput.readUTF());
                this.baseline.setColor(ChartColors.getColor(this.getBaselineColor()));
            }
        }
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(411);
        dataOutput.writeInt(this.interval);
        this.baselinePeriod.save(dataOutput);
        dataOutput.writeBoolean(this.applyBaseline);
        dataOutput.writeInt(this.baselineColor);
        if (this.baselineSource == null) {
            dataOutput.writeBoolean(true);
        } else {
            dataOutput.writeBoolean(false);
            dataOutput.writeInt(this.getIndexOf(this.baselineSource));
            dataOutput.writeUTF(this.baseline.getName());
        }
    }

    private int getIndexOf(ReportInput reportInput) {
        ReportInput[] reportInputArray = this.getInputs();
        if (reportInputArray != null) {
            for (int i = 0; i < reportInputArray.length; ++i) {
                if (reportInputArray[i] != reportInput) continue;
                return i;
            }
        }
        return -1;
    }

    public BTimeZone getTimeZone() {
        if (this.getInputs() == null || this.getInputs().length == 0) {
            return BTimeZone.getLocal();
        }
        try {
            return ((SiteDataPoint)this.getInputs()[0].getInputItem(0)).getDataPoint().getTimeZone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BTimeZone.getLocal();
        }
    }
}

