/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.BaselineReportPeriod;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartColorCellRenderer;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultLineConfig;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.AverageProfileSeries;
import com.tridium.eas.ui.reports.AverageProfileTableModel;
import com.tridium.eas.ui.reports.AvgProfileParameters;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportInputListCellRenderer;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.BaselineReportPeriodEditor;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasTable;
import com.tridium.eas.ui.widgets.FixedSizePanel;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.MaxSizePanel;
import com.tridium.eas.ui.widgets.ReportPeriodEditor;
import com.tridium.eas.ui.widgets.TemperatureEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Iterator;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class AverageProfile
extends EasReport
implements EasDataListener {
    public static final String TEMPLATE_ID = "avgProfile";
    private Chart chart;
    private EasTable table;
    private Config config;
    private boolean holdUpdates = false;

    public String getName() {
        return this.lex.getText(TEMPLATE_ID);
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        if (this.chart == null) {
            this.chart = new Chart(this.lex);
            this.chart.setTitle(this.getName());
            this.chart.setChartStatus(this);
        }
        return this.chart;
    }

    protected JComponent getReportDetails() {
        if (this.table == null) {
            this.table = new EasReportTable((TableModel)new AverageProfileTableModel(this.lex), false, this.lex);
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        this.getInputList().getModel().addEasDataListener(this);
        this.setRunReportEnabled(false);
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public ReportParameters createEmptyParameters() {
        return new AvgProfileParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        return new AvgProfileParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(!bl), this.config.getInterval(), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.config.getBaselinePeriod(!bl), this.config.getBaselineSourceSeries(), this.config.getBaselineSeries(), this.config.getApplyBaseline(), this.config.getBaselineColor(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        AvgProfileParameters avgProfileParameters = (AvgProfileParameters)reportParameters;
        this.getInputList().getModel().setInputs(avgProfileParameters.getInputs());
        this.config.setInterval(avgProfileParameters.getInterval());
        this.config.setPeriod(avgProfileParameters.getPeriod());
        this.config.setNormalization(avgProfileParameters.getNormalization());
        this.config.setNormalTemperature(avgProfileParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(avgProfileParameters.getNormalTemperatureUnit());
        this.config.setBaselinePeriod(avgProfileParameters.getBaselinePeriod());
        this.config.setBaselineSeries(avgProfileParameters.getBaselineSource());
        this.config.setBaselineColor(avgProfileParameters.getBaselineColor());
        this.config.setApplyBaseline(avgProfileParameters.getApplyBaseline());
        this.setDataCleanse(avgProfileParameters.getDataCleanse());
        this.setDataCleanseWindow(avgProfileParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(avgProfileParameters.getDataCleansePercentage());
        this.updateEnabledStates();
    }

    public void runReport(ReportParameters reportParameters) {
        Object object;
        Object object2;
        AvgProfileParameters avgProfileParameters = (AvgProfileParameters)reportParameters;
        ReportPeriod reportPeriod = avgProfileParameters.getPeriod();
        ChartModel chartModel = new ChartModel();
        ReportInput[] reportInputArray = avgProfileParameters.getInputs();
        int n = reportInputArray == null ? 0 : reportInputArray.length;
        chartModel.setHoldUpdates(true);
        AverageProfileSeries[] averageProfileSeriesArray = new AverageProfileSeries[n + 1];
        int n2 = 0;
        AvgProfileAxisInfo avgProfileAxisInfo = new AvgProfileAxisInfo(avgProfileParameters);
        for (int i = 0; i < n; ++i) {
            if (!reportInputArray[i].isEnabled() || avgProfileParameters.getBaselineSource() != null && reportInputArray[i].equals(avgProfileParameters.getBaselineSource()) && !avgProfileParameters.getApplyBaseline()) continue;
            object2 = new AverageProfileSeries(reportInputArray[i], avgProfileParameters, this.lex);
            averageProfileSeriesArray[n2] = object2;
            ++n2;
            ((AverageProfileSeries)object2).load();
            object = chartModel.addSeries((Series)object2, new DefaultLineConfig(false, (ValueColors)object2), avgProfileAxisInfo, null);
        }
        if (avgProfileParameters.getBaseline() != null && avgProfileParameters.getBaseline().isEnabled()) {
            AverageProfileSeries averageProfileSeries;
            avgProfileParameters.getBaseline().setColor(ChartColors.getColor(avgProfileParameters.getBaselineColor()));
            averageProfileSeriesArray[n2] = averageProfileSeries = new AverageProfileSeries(avgProfileParameters.getBaseline(), new AvgProfileParameters(avgProfileParameters.getInputs(), avgProfileParameters.getBaselinePeriod(), avgProfileParameters.getInterval(), avgProfileParameters.getNormalization(), avgProfileParameters.getNormalTemperature(), avgProfileParameters.getNormalTemperatureUnit(), avgProfileParameters.getBaselinePeriod(), avgProfileParameters.getBaselineSource(), avgProfileParameters.getBaseline(), avgProfileParameters.getApplyBaseline(), avgProfileParameters.getBaselineColor(), this.lex, avgProfileParameters.getDataCleanse(), avgProfileParameters.getDataCleanseWindow(), avgProfileParameters.getDataCleansePercentage()), this.lex);
            ++n2;
            averageProfileSeries.load();
            object2 = chartModel.addSeries(averageProfileSeries, new DefaultLineConfig(false, averageProfileSeries), avgProfileAxisInfo, null);
        }
        AverageProfileSeries[] averageProfileSeriesArray2 = new AverageProfileSeries[n2];
        System.arraycopy(averageProfileSeriesArray, 0, averageProfileSeriesArray2, 0, n2);
        chartModel.setHoldUpdates(false);
        object2 = null;
        switch (avgProfileParameters.getInterval()) {
            case 15: {
                object2 = this.lex.getText("15minAvgProfile");
                break;
            }
            case 30: {
                object2 = this.lex.getText("30minAvgProfile");
                break;
            }
            case 60: {
                object2 = this.lex.getText("avgHourlyProfile");
            }
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(reportPeriod.getDateRangeString());
        if (avgProfileParameters.getBaseline() != null && avgProfileParameters.getBaseline().isEnabled()) {
            ((StringBuffer)object).append("\n(" + this.lex.getText("baseline") + " ");
            ((StringBuffer)object).append(avgProfileParameters.getBaselinePeriod().getDateRangeString());
            ((StringBuffer)object).append(")");
        }
        chartModel.setTitle((String)object2, ((StringBuffer)object).toString());
        this.chart.setModel(chartModel);
        AverageProfileTableModel averageProfileTableModel = (AverageProfileTableModel)this.table.getModel();
        if (n == 0) {
            averageProfileTableModel.setData(null, null);
        } else {
            averageProfileTableModel.setData(avgProfileParameters, averageProfileSeriesArray2);
        }
        this.table.resetSorting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEnabledStates() {
        ReportInput[] reportInputArray = this;
        synchronized (this) {
            if (this.holdUpdates) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.holdUpdates = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.getInputList().getModel().enableAllInputs();
            reportInputArray = this.getInputList().getModel().getInputs();
            boolean bl = false;
            int n = this.getInputList().getItemCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                ReportInputItem[] reportInputItemArray;
                if ((this.config.getNormalization() & 4) != 0) {
                    reportInputItemArray = reportInputArray[i].getInputItems();
                    for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                        if (((SiteDataPoint)reportInputItemArray[n2]).getOutdoorAirTempDataPoint() == null) {
                            this.getInputList().getModel().disableInput(i);
                            continue;
                        }
                        bl = true;
                    }
                    continue;
                }
                if ((this.config.getNormalization() & 2) > 0) {
                    reportInputItemArray = reportInputArray[i].getInputItems();
                    for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                        try {
                            if (((SiteDataPoint)reportInputItemArray[n2]).getDataPoint().getFloorAreaValue() == 0.0) {
                                this.getInputList().getModel().disableInput(i);
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        catch (EasException easException) {
                            easException.printStackTrace();
                            this.getInputList().getModel().disableInput(i);
                        }
                    }
                    continue;
                }
                bl = true;
            }
            this.setRunReportEnabled(bl);
            this.holdUpdates = false;
            return;
        }
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        this.updateEnabledStates();
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            this.config.removeInput((ReportInput)dataEditedEvent.getEditedData()[i]);
        }
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            this.config.addInput((ReportInput)dataEditedEvent.getEditedData()[i]);
        }
        this.dataChanged(dataEditedEvent);
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        if (this.holdUpdates) {
            return;
        }
        if (dataEditedEvent.getSource() == this.getInputList().getModel() && dataEditedEvent.getEditedData().length > 0) {
            this.updateEnabledStates();
        }
    }

    public void disaggregate(ReportInput reportInput, ReportInput[] reportInputArray) {
        Id id;
        ChartModel chartModel = this.chart.getModel();
        Iterator iterator = chartModel.getSeriesIds();
        AverageProfileSeries averageProfileSeries = null;
        while (iterator.hasNext() && (averageProfileSeries = (AverageProfileSeries)chartModel.getSeries(id = (Id)iterator.next())).getInput() != reportInput) {
            averageProfileSeries = null;
        }
        if (averageProfileSeries == null) {
            return;
        }
        int n = reportInputArray.length;
        chartModel.setHoldUpdates(true);
        ((AverageProfileTableModel)this.table.getModel()).setHoldUpdates(true);
        AvgProfileAxisInfo avgProfileAxisInfo = new AvgProfileAxisInfo(averageProfileSeries.getParameters());
        for (int i = 0; i < n; ++i) {
            TSDataSummary tSDataSummary = averageProfileSeries.getResultForInputItem(reportInputArray[i].getInputItem(0));
            AverageProfileSeries averageProfileSeries2 = new AverageProfileSeries(reportInputArray[i], averageProfileSeries.getParameters(), tSDataSummary, this.lex);
            if (tSDataSummary == null) {
                averageProfileSeries2.load();
            }
            chartModel.addSeries(averageProfileSeries2, new DefaultLineConfig(false, averageProfileSeries2), avgProfileAxisInfo, null);
            ((AverageProfileTableModel)this.table.getModel()).addSeries(averageProfileSeries2);
        }
        chartModel.setHoldUpdates(false);
        ((AverageProfileTableModel)this.table.getModel()).setHoldUpdates(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reaggregate(ReportInput[] reportInputArray) {
        ChartModel chartModel = this.chart.getModel();
        AverageProfileTableModel averageProfileTableModel = (AverageProfileTableModel)this.table.getModel();
        int n = reportInputArray.length;
        ChartModel chartModel2 = chartModel;
        synchronized (chartModel2) {
            chartModel.setHoldUpdates(true);
            averageProfileTableModel.setHoldUpdates(true);
            block3: for (int i = 0; i < n; ++i) {
                Iterator iterator = chartModel.getSeriesIds();
                while (iterator.hasNext()) {
                    Id id = (Id)iterator.next();
                    AverageProfileSeries averageProfileSeries = (AverageProfileSeries)chartModel.getSeries(id);
                    if (averageProfileSeries.getInput() != reportInputArray[i]) continue;
                    averageProfileTableModel.removeSeries(averageProfileSeries);
                    iterator.remove();
                    continue block3;
                }
            }
            chartModel.setHoldUpdates(false);
            averageProfileTableModel.setHoldUpdates(false);
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    private class AvgProfileAxisInfo
    extends AxisInfo {
        private int interval;
        private boolean dstSwitch = false;
        private BTimeZone tz;
        private long startMillis;

        public AvgProfileAxisInfo(AvgProfileParameters avgProfileParameters) {
            this.interval = avgProfileParameters.getInterval();
            this.tz = avgProfileParameters.getTimeZone();
            ReportPeriod reportPeriod = avgProfileParameters.getPeriod();
            this.startMillis = reportPeriod.getStartTimeMillis(this.tz);
            long l = reportPeriod.getEndTimeMillis(this.tz);
            long l2 = l - this.startMillis;
            boolean bl = BAbsTime.make((long)this.startMillis, (BTimeZone)this.tz).inDaylightTime();
            boolean bl2 = BAbsTime.make((long)l, (BTimeZone)this.tz).inDaylightTime();
            if (l2 <= 86400000L && !bl && bl2 || l2 <= 90000000L && bl && !bl2) {
                this.dstSwitch = true;
            }
        }

        public boolean useDefaultTickLabels() {
            return false;
        }

        public boolean useDefaultValueLabels() {
            return false;
        }

        public String getTickLabel(Object object) {
            if (!(object instanceof Number)) {
                return null;
            }
            int n = ((Number)object).intValue();
            int n2 = n * this.interval;
            int n3 = n2 / 60;
            int n4 = n2 % 60;
            if (this.dstSwitch) {
                long l = this.startMillis + (long)n2 * 60L * 1000L;
                BAbsTime bAbsTime = BAbsTime.make((long)l, (BTimeZone)this.tz);
                n3 = bAbsTime.getHour();
                n4 = bAbsTime.getMinute();
            }
            StringBuffer stringBuffer = new StringBuffer(5);
            stringBuffer.append(n3);
            stringBuffer.append(':');
            if (n4 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n4);
            return stringBuffer.toString();
        }

        public String getValueLabel(Object object) {
            return this.getTickLabel(object);
        }

        public String getTitle() {
            return AverageProfile.this.lex.getText("timeOfDay");
        }

        public boolean isShareableWith(AxisInfo axisInfo) {
            if (axisInfo == null) {
                return false;
            }
            return axisInfo instanceof AvgProfileAxisInfo;
        }
    }

    private class Config
    extends JComponent
    implements ActionListener {
        private XpComboBox interval;
        private ReportPeriodEditor periodEditor;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private TemperatureEditor tempEditor;
        private JPanel baselinePanel;
        private JToggleButton showBaselineDetails;
        private JLabel baselineSummary;
        private BaselineReportPeriodEditor baselinePeriodEditor;
        private XpComboBox baselineSeries;
        private JRadioButton displayBaseline;
        private JRadioButton displayBoth;
        private XpComboBox baselineColorCombo;

        public Config() {
            AverageProfile.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(0, 0, 0));
            this.interval = new XpComboBox();
            this.interval.setFont(font);
            this.interval.addItem(AverageProfile.this.lex.getText("15minutes"));
            this.interval.addItem(AverageProfile.this.lex.getText("30minutes"));
            this.interval.addItem(AverageProfile.this.lex.getText("60minutes"));
            JPanel jPanel2 = new JPanel(false);
            jPanel2.setLayout(new FlowLayout(0));
            JLabel jLabel = new JLabel(AverageProfile.this.lex.getText("rollupInterval"));
            jLabel.setForeground(UIManager.getColor("Table.foreground"));
            jLabel.setFont(font);
            jPanel2.add(jLabel);
            jPanel2.add(this.interval);
            jPanel.add(jPanel2);
            jPanel.setBorder(BorderFactory.createTitledBorder(AverageProfile.this.lex.getText("profile")));
            this.add(jPanel);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.periodEditor = new ReportPeriodEditor(AverageProfile.this.lex);
            this.periodEditor.setBorder(BorderFactory.createTitledBorder(AverageProfile.this.lex.getText("period")));
            this.add(this.periodEditor);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(this.periodEditor, gridBagConstraints);
            JPanel jPanel3 = new JPanel(false);
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            jPanel3.setLayout(gridBagLayout2);
            int n2 = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.weightx = 100.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            MaxSizePanel maxSizePanel = new MaxSizePanel(200, 600);
            maxSizePanel.setLayout(new BorderLayout());
            this.showBaselineDetails = new JToggleButton(AverageProfile.this.lex.getText("showDetails"));
            this.showBaselineDetails.setFont(font);
            this.showBaselineDetails.addActionListener(this);
            this.baselineSummary = new JLabel("  " + AverageProfile.this.lex.getText("noBaseline"));
            this.baselineSummary.setForeground(UIManager.getColor("Table.foreground"));
            this.baselineSummary.setFont(font);
            maxSizePanel.add((Component)this.showBaselineDetails, "West");
            maxSizePanel.add((Component)this.baselineSummary, "Center");
            jPanel3.add(maxSizePanel);
            gridBagConstraints2.gridy = n2++;
            gridBagLayout2.setConstraints(maxSizePanel, gridBagConstraints2);
            this.baselinePanel = new JPanel(false);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            this.baselinePanel.setLayout(gridBagLayout3);
            int n3 = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.weightx = 100.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            this.baselinePeriodEditor = new BaselineReportPeriodEditor(false, AverageProfile.this.lex, this.periodEditor, false);
            BaselineReportPeriod baselineReportPeriod = (BaselineReportPeriod)this.baselinePeriodEditor.getValue(true);
            baselineReportPeriod.setReferencePeriod(this.getPeriod(true));
            this.baselinePeriodEditor.setValue(baselineReportPeriod);
            this.baselinePeriodEditor.setBorder(BorderFactory.createTitledBorder(AverageProfile.this.lex.getText("period")));
            this.baselinePanel.add(this.baselinePeriodEditor);
            gridBagConstraints3.gridy = n3++;
            gridBagLayout3.setConstraints(this.baselinePeriodEditor, gridBagConstraints3);
            this.baselineSeries = new XpComboBox();
            this.baselineSeries.addActionListener(this);
            this.baselineSeries.addItem(AverageProfile.this.lex.getText("noBaseline"));
            this.baselineSeries.setRenderer(new ReportInputListCellRenderer(30));
            FixedSizePanel fixedSizePanel = new FixedSizePanel(this.baselineSeries);
            this.baselinePanel.add(fixedSizePanel);
            gridBagConstraints3.gridy = n3++;
            gridBagLayout3.setConstraints(fixedSizePanel, gridBagConstraints3);
            JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.gridheight = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new Insets(2, 2, 0, 0);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.fill = 0;
            JPanel jPanel5 = new JPanel(false);
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            jPanel5.setLayout(gridBagLayout4);
            int n4 = 0;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints5.weightx = 100.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.gridheight = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.fill = 2;
            JLabel jLabel2 = new JLabel(AverageProfile.this.lex.getText("baselineColor"));
            jLabel2.setForeground(UIManager.getColor("Table.foreground"));
            jLabel2.setFont(font);
            jPanel5.add(jLabel2);
            gridBagConstraints5.gridy = n4++;
            gridBagLayout4.setConstraints(jLabel2, gridBagConstraints5);
            this.baselineColorCombo = new XpComboBox();
            this.baselineColorCombo.setFont(font);
            this.baselineColorCombo.setRenderer(new ChartColorCellRenderer());
            int n5 = 0;
            int n6 = 0;
            while (n6 < ChartColors.getColorCount()) {
                this.baselineColorCombo.addItem(new Integer(n6));
                n5 = n6++;
            }
            this.baselineColorCombo.setSelectedIndex(n5);
            jPanel5.add(this.baselineColorCombo);
            gridBagConstraints5.gridy = n4++;
            gridBagLayout4.setConstraints(this.baselineColorCombo, gridBagConstraints5);
            jPanel4.add((Component)jPanel5, gridBagConstraints4);
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.weightx = 100.0;
            gridBagConstraints4.fill = 2;
            JPanel jPanel6 = new JPanel(false);
            GridBagLayout gridBagLayout5 = new GridBagLayout();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            jPanel6.setLayout(gridBagLayout5);
            int n7 = 0;
            gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints6.weightx = 100.0;
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.gridwidth = 1;
            gridBagConstraints6.gridheight = 1;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.anchor = 18;
            gridBagConstraints6.fill = 2;
            this.displayBoth = new JRadioButton(AverageProfile.this.lex.getText("displayBoth"), true);
            this.displayBoth.addActionListener(this);
            this.displayBoth.setFont(font);
            jPanel6.add(this.displayBoth);
            gridBagConstraints6.gridy = n7++;
            gridBagLayout5.setConstraints(this.displayBoth, gridBagConstraints6);
            this.displayBaseline = new JRadioButton(AverageProfile.this.lex.getText("displayBaseline"), false);
            this.displayBaseline.addActionListener(this);
            this.displayBaseline.setFont(font);
            jPanel6.add(this.displayBaseline);
            gridBagConstraints6.gridy = n7++;
            gridBagLayout5.setConstraints(this.displayBaseline, gridBagConstraints6);
            jPanel6.setBorder(BorderFactory.createEtchedBorder());
            jPanel4.add((Component)jPanel6, gridBagConstraints4);
            this.baselinePanel.add(jPanel4);
            gridBagConstraints3.gridy = n3++;
            gridBagLayout3.setConstraints(jPanel4, gridBagConstraints3);
            this.baselinePanel.setVisible(this.showBaselineDetails.isSelected());
            jPanel3.add(this.baselinePanel);
            gridBagConstraints2.gridy = n2++;
            gridBagLayout2.setConstraints(this.baselinePanel, gridBagConstraints2);
            jPanel3.setBorder(BorderFactory.createTitledBorder(AverageProfile.this.lex.getText("baseline")));
            this.add(jPanel3);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            JPanel jPanel7 = new JPanel(false);
            GridBagManager gridBagManager = new GridBagManager(jPanel7);
            gridBagManager.anchor(17);
            this.add(jPanel7);
            this.normFloorArea = new JCheckBox(AverageProfile.this.lex.getText("floorArea"));
            this.normFloorArea.addActionListener(this);
            this.normFloorArea.setFont(font);
            gridBagManager.add(0, 0, 2, 1, 0, 0, this.normFloorArea);
            this.normWeather = new JCheckBox(AverageProfile.this.lex.getText("degreeDay"));
            this.normWeather.addActionListener(this);
            this.normWeather.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, 1, this.normWeather);
            this.tempEditor = new TemperatureEditor(65, BUnit.getUnit((String)"fahrenheit"), AverageProfile.this.lex);
            gridBagManager.add(100, 100, 1, 1, 1, 1, this.tempEditor);
            jPanel7.setBorder(BorderFactory.createTitledBorder(AverageProfile.this.lex.getText("normalization")));
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
            JLabel jLabel3 = new JLabel("");
            this.add(jLabel3);
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        }

        public int getInterval() {
            int n = this.interval.getSelectedIndex();
            switch (n) {
                case 0: {
                    return 15;
                }
                case 1: {
                    return 30;
                }
            }
            return 60;
        }

        public void setInterval(int n) {
            if (n == 15) {
                this.interval.setSelectedIndex(0);
            } else if (n == 30) {
                this.interval.setSelectedIndex(1);
            } else {
                this.interval.setSelectedIndex(2);
            }
        }

        public ReportPeriod getPeriod(boolean bl) {
            return (ReportPeriod)this.periodEditor.getValue(bl);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.periodEditor.setValue(reportPeriod);
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) != 0);
            this.normWeather.setSelected((n & 4) != 0);
        }

        public double getNormalTemperature() {
            return this.tempEditor.getValue();
        }

        public void setNormalTemperature(double d) {
            this.tempEditor.setValue(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.tempEditor.getUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.tempEditor.setUnit(bUnit);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.showBaselineDetails) {
                this.baselinePanel.setVisible(this.showBaselineDetails.isSelected());
                AverageProfile.this.getMainSplit().validate();
                if (this.showBaselineDetails.isSelected()) {
                    this.showBaselineDetails.setText(AverageProfile.this.lex.getText("hideDetails"));
                } else {
                    this.showBaselineDetails.setText(AverageProfile.this.lex.getText("showDetails"));
                }
            } else if (object == this.baselineSeries) {
                ReportInput reportInput = this.getBaselineSeries();
                if (reportInput != null) {
                    this.baselineSummary.setText("  " + this.getBaselineSourceSeries().getName());
                } else {
                    this.baselineSummary.setText("  " + AverageProfile.this.lex.getText("noBaseline"));
                }
            } else if (object == this.displayBoth) {
                this.displayBaseline.setSelected(!this.displayBoth.isSelected());
            } else if (object == this.displayBaseline) {
                this.displayBoth.setSelected(!this.displayBaseline.isSelected());
            } else {
                AverageProfile.this.updateEnabledStates();
            }
        }

        public BaselineReportPeriod getBaselinePeriod(boolean bl) {
            return (BaselineReportPeriod)this.baselinePeriodEditor.getValue(bl);
        }

        public void setBaselinePeriod(BaselineReportPeriod baselineReportPeriod) {
            if (baselineReportPeriod == null) {
                BaselineReportPeriod baselineReportPeriod2 = new BaselineReportPeriod(EasLocalTime.getCurrentTime(), EasLocalTime.getCurrentTime(), this.getPeriod(true).getDaysOfWeek(), AverageProfile.this.lex);
                baselineReportPeriod2.setReferencePeriod(this.getPeriod(true));
                this.baselinePeriodEditor.setValue(baselineReportPeriod2);
            } else {
                this.baselinePeriodEditor.setValue(baselineReportPeriod);
            }
        }

        public void removeInput(ReportInput reportInput) {
            this.baselineSeries.removeItem(reportInput);
        }

        public void addInput(ReportInput reportInput) {
            if (this.indexOf(this.baselineSeries, reportInput) < 0) {
                this.baselineSeries.addItem(reportInput);
            }
        }

        public int indexOf(XpComboBox xpComboBox, Object object) {
            for (int i = 0; i < xpComboBox.getItemCount(); ++i) {
                if (!xpComboBox.getItemAt(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        public void setBaselineSeries(ReportInput reportInput) {
            if (reportInput == null) {
                this.baselineSeries.setSelectedItem(AverageProfile.this.lex.getText("noBaseline"));
            } else {
                this.baselineSeries.setSelectedItem(reportInput);
            }
        }

        public ReportInput getBaselineSourceSeries() {
            if (this.baselineSeries.getSelectedItem() instanceof ReportInput) {
                return (ReportInput)this.baselineSeries.getSelectedItem();
            }
            return null;
        }

        public ReportInput getBaselineSeries() {
            if (this.baselineSeries.getSelectedItem() instanceof ReportInput) {
                ReportInput reportInput = ((ReportInput)this.baselineSeries.getSelectedItem()).getCopy();
                reportInput.setName(AverageProfile.this.lex.getText("baseline") + ": " + reportInput.getName());
                reportInput.setColor(ChartColors.getColor(this.getBaselineColor()));
                return reportInput;
            }
            return null;
        }

        public void setBaselineColor(int n) {
            this.baselineColorCombo.setSelectedIndex(n);
        }

        public int getBaselineColor() {
            return this.baselineColorCombo.getSelectedIndex();
        }

        public void setApplyBaseline(boolean bl) {
            if (bl) {
                this.displayBoth.setSelected(true);
                this.displayBaseline.setSelected(false);
            } else {
                this.displayBoth.setSelected(false);
                this.displayBaseline.setSelected(true);
            }
        }

        public boolean getApplyBaseline() {
            return this.displayBoth.isSelected();
        }
    }
}

