/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.ui.DecimalFormatter;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import com.tridium.eas.ui.reports.AggregationAnalysis;
import com.tridium.eas.ui.reports.ReportInput;
import java.awt.Color;
import java.text.DateFormatSymbols;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class AggregationAnalysisSeries
extends Series
implements ValueColors {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private Lexicon lex;
    private ReportInput input;
    private AggregationAnalysis.MonthData[] months;
    private double[] range;
    private DateFormatSymbols dateSymbols;
    private BUnit consumptionUnit;
    private BUnit demandUnit;
    private int displayValue;

    public AggregationAnalysisSeries(ReportInput reportInput, BUnit bUnit, BUnit bUnit2, AggregationAnalysis.MonthData[] monthDataArray, Lexicon lexicon) {
        this.input = reportInput;
        this.demandUnit = bUnit2;
        this.consumptionUnit = bUnit;
        this.months = monthDataArray;
        this.lex = lexicon;
    }

    public String getSeriesName() {
        return null;
    }

    public void setDisplayValue(int n) {
        this.displayValue = n;
        this.range = null;
    }

    public int getRowCount() {
        if (this.months == null) {
            return 0;
        }
        return this.months.length;
    }

    public String getRowName(int n) {
        return this.getMonthString(n);
    }

    public String getValueName(int n) {
        return this.input.getName();
    }

    public int getValueType() {
        return 0;
    }

    public double getValue(int n, int n2) {
        if (this.months == null) {
            return 0.0;
        }
        switch (this.displayValue) {
            case 0: {
                return this.months[n].consumption;
            }
            case 1: {
                return this.months[n].peakDemand;
            }
            case 2: {
                return this.months[n].minDemand;
            }
            case 3: {
                return this.months[n].loadFactor;
            }
        }
        return 0.0;
    }

    public Color getValueColor(int n) {
        return this.input.getColor();
    }

    public String getValueLabel(int n, int n2) {
        return DecimalFormatter.format(this.getValue(n, n2));
    }

    public double getMin(int n) {
        return this.getMin();
    }

    public double getMax(int n) {
        return this.getMax();
    }

    public double getMin() {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[0];
    }

    public double getMax() {
        if (this.range == null) {
            this.computeRange();
        }
        return this.range[1];
    }

    public double getMinRowTotal() {
        return this.getMin();
    }

    public double getMaxRowTotal() {
        return this.getMax();
    }

    private void computeRange() {
        this.range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            double d = this.getValue(i, 0);
            this.range[0] = Math.min(this.range[0], d);
            this.range[1] = Math.max(this.range[1], d);
        }
    }

    public BUnit getValueUnits() {
        if (this.displayValue == 0) {
            return this.consumptionUnit;
        }
        if (this.displayValue == 3) {
            return null;
        }
        return this.demandUnit;
    }

    public BUnit getConsumptionUnit() {
        return this.consumptionUnit;
    }

    public BUnit getDemandUnit() {
        return this.demandUnit;
    }

    private String getMonthString(int n) {
        if (this.dateSymbols == null) {
            this.dateSymbols = new DateFormatSymbols();
        }
        return this.lex.getText(this.dateSymbols.getShortMonths()[n]);
    }
}

