/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.reports;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DataSummaryElement;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.FuncDataSummary;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.DefaultBarConfig;
import com.tridium.eas.ui.reports.AggAnalysisTableModel;
import com.tridium.eas.ui.reports.AggregationAnalysisParameters;
import com.tridium.eas.ui.reports.AggregationAnalysisSeries;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.MeterInputItem;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasTable;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.TemperatureEditor;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class AggregationAnalysis
extends EasReport
implements EasDataListener {
    public static final String TEMPLATE_ID = "aggAnalysis";
    public static final int TOTAL = 0;
    public static final int PEAK = 1;
    public static final int MIN = 2;
    public static final int LOAD_FACTOR = 3;
    private Chart chart;
    private EasTable table;
    private Config config;
    private boolean holdUpdates = false;
    private AggregationAnalysisSeries series;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$MeterInputItem;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;

    public String getName() {
        return this.lex.getText(TEMPLATE_ID);
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected JComponent getReportContent() {
        if (this.chart == null) {
            this.chart = new Chart(this.lex);
            this.chart.setTitle(this.getName());
            this.chart.setChartStatus(this);
        }
        return this.chart;
    }

    protected JComponent getReportDetails() {
        if (this.table == null) {
            this.table = new EasReportTable((TableModel)new AggAnalysisTableModel(this.lex), false, this.lex);
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        this.getInputList().getModel().addEasDataListener(this);
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public Class getInputItemClass() {
        return class$com$tridium$eas$ui$reports$MeterInputItem == null ? (class$com$tridium$eas$ui$reports$MeterInputItem = AggregationAnalysis.class$("com.tridium.eas.ui.reports.MeterInputItem")) : class$com$tridium$eas$ui$reports$MeterInputItem;
    }

    public ReportParameters createEmptyParameters() {
        return new AggregationAnalysisParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        return new AggregationAnalysisParameters(this.getInputList().getModel().getInputs(), this.config.getPeriod(), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.config.getChartValue(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        AggregationAnalysisParameters aggregationAnalysisParameters = (AggregationAnalysisParameters)reportParameters;
        this.getInputList().getModel().setInputs(aggregationAnalysisParameters.getInputs());
        this.config.setPeriod(aggregationAnalysisParameters.getPeriod());
        this.config.setNormalization(aggregationAnalysisParameters.getNormalization());
        this.config.setNormalTemperature(aggregationAnalysisParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(aggregationAnalysisParameters.getNormalTemperatureUnit());
        this.config.setChartValue(aggregationAnalysisParameters.getChartValue());
        this.setDataCleanse(aggregationAnalysisParameters.getDataCleanse());
        this.setDataCleanseWindow(aggregationAnalysisParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(aggregationAnalysisParameters.getDataCleansePercentage());
    }

    public void runReport(ReportParameters reportParameters) {
        Object object;
        Object object2;
        AggregationAnalysisParameters aggregationAnalysisParameters = (AggregationAnalysisParameters)reportParameters;
        int n = aggregationAnalysisParameters.getInputCount();
        if (n == 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        ReportPeriod reportPeriod = aggregationAnalysisParameters.getPeriod();
        EasLocalTime easLocalTime = reportPeriod.getStartTime();
        EasLocalTime easLocalTime2 = reportPeriod.getEndTime();
        int n2 = easLocalTime.getYear();
        EasLocalTime easLocalTime3 = EasLocalTime.getCurrentTime();
        easLocalTime3 = new EasLocalTime(easLocalTime3.getYear(), easLocalTime3.getMonth(), easLocalTime3.getDay(), 23, 59, 59, 999);
        int n3 = 12;
        if (easLocalTime2.isAfter(easLocalTime3)) {
            easLocalTime2 = easLocalTime3;
            n3 = easLocalTime2.getMonth() + 1;
        }
        MonthData[] monthDataArray = new MonthData[n3];
        for (int i = 0; i < n3; ++i) {
            monthDataArray[i] = new MonthData();
        }
        BUnit bUnit = null;
        BUnit bUnit2 = null;
        ReportInput reportInput = aggregationAnalysisParameters.getInputs()[0];
        int n4 = reportInput.getInputItemCount();
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>(n4);
        ArrayList<DataPoint> arrayList2 = new ArrayList<DataPoint>(n4);
        for (int i = 0; i < n4; ++i) {
            object2 = (MeterInputItem)reportInput.getInputItem(i);
            object = ((MeterInputItem)object2).getConsumptionDataPoint();
            try {
                if (object != null) {
                    ((DataPoint)object).load(true);
                    arrayList.add((DataPoint)object);
                    if (bUnit == null) {
                        bUnit = ((DataPoint)object).getUnit();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = ((MeterInputItem)object2).getDemandDataPoint();
            try {
                if (object == null) continue;
                ((DataPoint)object).load(true);
                arrayList2.add((DataPoint)object);
                if (bUnit2 != null) continue;
                bUnit2 = ((DataPoint)object).getUnit();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        DataPoint[] dataPointArray = arrayList.toArray(new DataPoint[0]);
        object2 = null;
        if (arrayList.size() != 0) {
            try {
                object2 = FuncDataSummary.getResult(dataPointArray, dataPointArray[0].getUnit(), easLocalTime, easLocalTime2, reportPeriod.getDaysOfWeek(), 0, new TimeInterval(1L, 7), aggregationAnalysisParameters.isNormalizedByFloorArea(), dataPointArray[0].getFloorAreaUnit(), aggregationAnalysisParameters.isNormalizedByTemperature(), aggregationAnalysisParameters.getNormalTemperature(), aggregationAnalysisParameters.getNormalTemperatureUnit(), aggregationAnalysisParameters.getDataCleanse(), aggregationAnalysisParameters.getDataCleanseWindow(), aggregationAnalysisParameters.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                bUnit = ((TSDataSummary)object2).getValueUnit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = null;
        if (arrayList2.size() != 0) {
            try {
                dataPointArray = arrayList2.toArray(new DataPoint[0]);
                object = FuncDataSummary.getResult(dataPointArray, dataPointArray[0].getUnit(), easLocalTime, easLocalTime2, reportPeriod.getDaysOfWeek(), 0, new TimeInterval(1L, 7), aggregationAnalysisParameters.isNormalizedByFloorArea(), dataPointArray[0].getFloorAreaUnit(), aggregationAnalysisParameters.isNormalizedByTemperature(), aggregationAnalysisParameters.getNormalTemperature(), aggregationAnalysisParameters.getNormalTemperatureUnit(), aggregationAnalysisParameters.getDataCleanse(), aggregationAnalysisParameters.getDataCleanseWindow(), aggregationAnalysisParameters.getDataCleansePercentage(), reportInput.hasNormalizingPoint(), reportInput.getNormalizingPoint());
                bUnit2 = ((TSDataSummary)object).getValueUnit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n5 = 0;
        if (object2 != null) {
            n5 = Math.min(((TSDataSummary)object2).getSize(), 12);
        }
        for (int i = 0; i < n5; ++i) {
            DataSummaryElement dataSummaryElement = ((TSDataSummary)object2).getDataSummary(i);
            monthDataArray[i].consumption = dataSummaryElement.getTotalConsumption();
            if (object != null) {
                dataSummaryElement = ((TSDataSummary)object).getDataSummary(i);
                monthDataArray[i].peakDemand = dataSummaryElement.getPeakDemand();
                monthDataArray[i].minDemand = dataSummaryElement.getMinDemand();
            }
            if (monthDataArray[i].peakDemand == 0.0) {
                monthDataArray[i].loadFactor = 0.0;
                continue;
            }
            int n6 = ReportPeriod.getDaysInMonth(i, n2);
            int n7 = n6 * 24;
            monthDataArray[i].loadFactor = monthDataArray[i].consumption / (monthDataArray[i].peakDemand * (double)n7);
        }
        this.series = new AggregationAnalysisSeries(reportInput, bUnit, bUnit2, monthDataArray, this.lex);
        this.series.setDisplayValue(this.config.getChartValue());
        AggAnalysisTableModel aggAnalysisTableModel = new AggAnalysisTableModel(this.lex, monthDataArray, bUnit, bUnit2, n2);
        this.setChartSubtitle(this.chart, this.config.getChartValue(), this.series, n2);
        this.chart.getModel().setSeries(this.series, new DefaultBarConfig(this.series, Color.black), null, null);
        this.table.setModel(aggAnalysisTableModel);
    }

    public boolean allowLoadUserObject(Class clazz) {
        if ((class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = AggregationAnalysis.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz)) {
            return false;
        }
        return super.allowLoadUserObject(clazz);
    }

    public boolean allowMultipleInputs() {
        return false;
    }

    public boolean allowDisaggregation() {
        return false;
    }

    private void setChartSubtitle(Chart chart, int n, AggregationAnalysisSeries aggregationAnalysisSeries, int n2) {
        BUnit bUnit = null;
        this.lex = BEasApplet.lex;
        StringBuffer stringBuffer = new StringBuffer(64);
        switch (n) {
            case 0: {
                stringBuffer.append(this.lex.getText("total"));
                bUnit = aggregationAnalysisSeries.getConsumptionUnit();
                break;
            }
            case 1: {
                stringBuffer.append(this.lex.getText("peak"));
                bUnit = aggregationAnalysisSeries.getDemandUnit();
                break;
            }
            case 2: {
                stringBuffer.append(this.lex.getText("minimum"));
                bUnit = aggregationAnalysisSeries.getDemandUnit();
                break;
            }
            case 3: {
                stringBuffer.append(this.lex.getText("loadFactor"));
            }
        }
        if (bUnit != null) {
            stringBuffer.append(' ').append(bUnit.toString());
        }
        stringBuffer.append(' ').append(Integer.toString(n2));
        chart.setSubtitle(stringBuffer.toString());
    }

    public void updateChartValue() {
        if (this.series == null) {
            return;
        }
        int n = this.config.getChartValue();
        this.series.setDisplayValue(n);
        this.chart.rebuild();
        int n2 = this.config.getPeriod().getStartTime().getYear();
        this.setChartSubtitle(this.chart, n, this.series, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEnabledStates() {
        ReportInput[] reportInputArray = this;
        synchronized (this) {
            if (this.holdUpdates) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.holdUpdates = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.getInputList().getModel().enableAllInputs();
            reportInputArray = this.getInputList().getModel().getInputs();
            boolean bl = false;
            int n = this.getInputList().getItemCount();
            for (int i = 0; i < n; ++i) {
                int n2;
                ReportInputItem[] reportInputItemArray;
                if ((this.config.getNormalization() & 4) != 0) {
                    reportInputItemArray = reportInputArray[i].getInputItems();
                    for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                        if (((MeterInputItem)reportInputItemArray[n2]).getOutdoorAirTempDataPoint() == null) {
                            this.getInputList().getModel().disableInput(i);
                            continue;
                        }
                        bl = true;
                    }
                    continue;
                }
                if ((this.config.getNormalization() & 2) > 0) {
                    reportInputItemArray = reportInputArray[i].getInputItems();
                    for (n2 = 0; n2 < reportInputItemArray.length; ++n2) {
                        if (((MeterInputItem)reportInputItemArray[n2]).getFloorAreaValue() == 0.0) {
                            this.getInputList().getModel().disableInput(i);
                            continue;
                        }
                        bl = true;
                    }
                    continue;
                }
                bl = true;
            }
            this.setRunReportEnabled(bl);
            this.holdUpdates = false;
            return;
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        this.updateEnabledStates();
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        this.dataChanged(dataEditedEvent);
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        if (this.holdUpdates) {
            return;
        }
        if (dataEditedEvent.getSource() == this.getInputList().getModel() && dataEditedEvent.getEditedData().length > 0) {
            this.updateEnabledStates();
        }
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Config
    extends JComponent
    implements ActionListener {
        private NumberTextField yearEditor;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private TemperatureEditor tempEditor;
        private JRadioButton chartTotal;
        private JRadioButton chartPeak;
        private JRadioButton chartMin;
        private JRadioButton chartLoadFactor;

        public Config() {
            AggregationAnalysis.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(0, 2, 0));
            this.yearEditor = new NumberTextField(4, true);
            this.yearEditor.setAllowNegative(false);
            EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
            int n2 = easLocalTime.getYear();
            this.yearEditor.setText(String.valueOf(n2));
            jPanel.add(new JLabel(AggregationAnalysis.this.lex.getText("year")));
            jPanel.add(this.yearEditor);
            jPanel.setBorder(BorderFactory.createTitledBorder(AggregationAnalysis.this.lex.getText("period")));
            this.add(jPanel);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            JPanel jPanel2 = new JPanel(false);
            this.add(jPanel2);
            jPanel2.setLayout(new GridLayout(4, 1));
            jPanel2.setBorder(BorderFactory.createTitledBorder(AggregationAnalysis.this.lex.getText("chartValue")));
            this.chartTotal = new JRadioButton(AggregationAnalysis.this.lex.getText("total"));
            this.chartTotal.setFont(font);
            buttonGroup.add(this.chartTotal);
            this.chartTotal.setSelected(true);
            jPanel2.add(this.chartTotal);
            this.chartPeak = new JRadioButton(AggregationAnalysis.this.lex.getText("peak"));
            this.chartPeak.setFont(font);
            buttonGroup.add(this.chartPeak);
            jPanel2.add(this.chartPeak);
            this.chartMin = new JRadioButton(AggregationAnalysis.this.lex.getText("minimum"));
            this.chartMin.setFont(font);
            buttonGroup.add(this.chartMin);
            jPanel2.add(this.chartMin);
            this.chartLoadFactor = new JRadioButton(AggregationAnalysis.this.lex.getText("loadFactor"));
            this.chartLoadFactor.setFont(font);
            buttonGroup.add(this.chartLoadFactor);
            jPanel2.add(this.chartLoadFactor);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.chartTotal.addActionListener(this);
            this.chartPeak.addActionListener(this);
            this.chartMin.addActionListener(this);
            this.chartLoadFactor.addActionListener(this);
            JPanel jPanel3 = new JPanel(false);
            GridBagManager gridBagManager = new GridBagManager(jPanel3);
            gridBagManager.anchor(17);
            this.add(jPanel3);
            this.normFloorArea = new JCheckBox(AggregationAnalysis.this.lex.getText("floorArea"));
            this.normFloorArea.addActionListener(this);
            this.normFloorArea.setFont(font);
            gridBagManager.add(0, 0, 2, 1, 0, 0, this.normFloorArea);
            this.normWeather = new JCheckBox(AggregationAnalysis.this.lex.getText("degreeDay"));
            this.normWeather.addActionListener(this);
            this.normWeather.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, 1, this.normWeather);
            this.tempEditor = new TemperatureEditor(65, BUnit.getUnit((String)"fahrenheit"), AggregationAnalysis.this.lex);
            gridBagManager.add(100, 100, 1, 1, 1, 1, this.tempEditor);
            jPanel3.setBorder(BorderFactory.createTitledBorder(AggregationAnalysis.this.lex.getText("normalization")));
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            JLabel jLabel = new JLabel("");
            this.add(jLabel);
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        }

        public ReportPeriod getPeriod() {
            int n = this.yearEditor.getIntValue();
            EasLocalTime easLocalTime = new EasLocalTime(n, 0, 1);
            EasLocalTime easLocalTime2 = new EasLocalTime(n + 1, 0, 1);
            return new ReportPeriod(easLocalTime, easLocalTime2, 127, AggregationAnalysis.this.lex);
        }

        public void setPeriod(ReportPeriod reportPeriod) {
            this.yearEditor.setText(Integer.toString(reportPeriod.getStartTime().getYear()));
        }

        public int getChartValue() {
            if (this.chartPeak.isSelected()) {
                return 1;
            }
            if (this.chartMin.isSelected()) {
                return 2;
            }
            if (this.chartLoadFactor.isSelected()) {
                return 3;
            }
            return 0;
        }

        public void setChartValue(int n) {
            switch (n) {
                case 0: {
                    this.chartTotal.setSelected(true);
                    break;
                }
                case 1: {
                    this.chartPeak.setSelected(true);
                    break;
                }
                case 2: {
                    this.chartMin.setSelected(true);
                    break;
                }
                case 3: {
                    this.chartLoadFactor.setSelected(true);
                }
            }
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) != 0);
            this.normWeather.setSelected((n & 4) != 0);
        }

        public double getNormalTemperature() {
            return this.tempEditor.getValue();
        }

        public void setNormalTemperature(double d) {
            this.tempEditor.setValue(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.tempEditor.getUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.tempEditor.setUnit(bUnit);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JRadioButton) {
                AggregationAnalysis.this.updateChartValue();
            }
            if (actionEvent.getSource() instanceof JCheckBox) {
                AggregationAnalysis.this.updateEnabledStates();
            }
        }
    }

    public static class MonthData {
        public double consumption = 0.0;
        public double peakDemand = 0.0;
        public double minDemand = 0.0;
        public double loadFactor = 0.0;
    }
}

