/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.partitioning;

import com.tridium.eas.api.EasPartition;
import com.tridium.eas.ui.partitioning.PartitionConfigPanel;
import com.tridium.eas.ui.widgets.CheckMarkIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class PartitioningListCellRenderer
extends DefaultListCellRenderer {
    private Icon partitionIcon = null;
    private Icon userIcon = null;
    private Icon selectedIcon;
    private Icon deselectedIcon;
    private PartitionConfigPanel pcp;
    private static Color defaultSelectionColor = Color.white;

    public PartitioningListCellRenderer(PartitionConfigPanel partitionConfigPanel) {
        this.pcp = partitionConfigPanel;
        this.partitionIcon = new ImageIcon(partitionConfigPanel.getIconImage(41));
        this.userIcon = new ImageIcon(partitionConfigPanel.getIconImage(42));
        this.selectedIcon = new CheckMarkIcon(Color.red, true);
        this.deselectedIcon = new DefaultDeselectedIcon(this.selectedIcon.getIconWidth(), this.selectedIcon.getIconHeight());
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel;
        JComponent jComponent = jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof String) {
            jLabel.setText((String)object);
            jLabel.setIcon(this.userIcon);
            if (this.pcp.objectsForPartitionDirection) {
                JPanel jPanel = new JPanel(new BorderLayout(), false);
                jPanel.setBackground(Color.white);
                JLabel jLabel2 = new JLabel();
                if (bl) {
                    jLabel2.setIcon(this.selectedIcon);
                    jLabel.setBackground(defaultSelectionColor);
                    jLabel.setForeground(Color.black);
                    jPanel.setBackground(defaultSelectionColor);
                } else {
                    jLabel2.setIcon(this.deselectedIcon);
                }
                jPanel.add((Component)jLabel2, "West");
                jPanel.add((Component)jLabel, "Center");
                jComponent = jPanel;
            }
        } else if (object instanceof EasPartition) {
            jLabel.setText(((EasPartition)object).getName());
            jLabel.setIcon(this.partitionIcon);
            if (!this.pcp.objectsForPartitionDirection) {
                JPanel jPanel = new JPanel(new BorderLayout(), false);
                jPanel.setBackground(Color.white);
                JLabel jLabel3 = new JLabel();
                if (bl) {
                    jLabel3.setIcon(this.selectedIcon);
                    jLabel.setBackground(defaultSelectionColor);
                    jLabel.setForeground(Color.black);
                    jPanel.setBackground(defaultSelectionColor);
                } else {
                    jLabel3.setIcon(this.deselectedIcon);
                }
                jPanel.add((Component)jLabel3, "West");
                jPanel.add((Component)jLabel, "Center");
                jComponent = jPanel;
            }
        }
        return jComponent;
    }

    public class DefaultDeselectedIcon
    implements Icon {
        private int width;
        private int height;

        public DefaultDeselectedIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

