/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.partitioning;

import com.tridium.eas.api.EasPartition;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.ui.dbconfig.EasList;
import com.tridium.eas.ui.partitioning.EasPartitionClient;
import com.tridium.eas.ui.partitioning.PartitionConfigPanel;
import com.tridium.eas.ui.partitioning.PartitioningListCellRenderer;
import com.tridium.eas.ui.widgets.SortedListModel;
import com.tridium.eas.ui.widgets.UserObjectComparator;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.ListModel;

public class PartitionList
extends EasList {
    private EasPartition[] partitions;
    private EasSession session = null;

    public PartitionList(PartitionConfigPanel partitionConfigPanel) {
        this.setModel(new SortedListModel(new UserObjectComparator()));
        this.setCellRenderer(new PartitioningListCellRenderer(partitionConfigPanel));
    }

    public void init(EasSession easSession) {
        this.session = easSession;
    }

    public EasSession getSession() {
        return this.session;
    }

    public void refreshData(boolean bl) {
        if (!bl) {
            this.refreshData(this.partitions);
            return;
        }
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        sortedListModel.removeAllElements();
        try {
            this.partitions = EasPartitionClient.retrievePartitions(this.getSession());
            if (this.partitions != null) {
                for (int i = 0; i < this.partitions.length; ++i) {
                    sortedListModel.addElement(this.partitions[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refreshData(EasPartition[] easPartitionArray) {
        this.partitions = easPartitionArray;
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        sortedListModel.removeAllElements();
        try {
            if (easPartitionArray != null) {
                for (int i = 0; i < easPartitionArray.length; ++i) {
                    sortedListModel.addElement(easPartitionArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public EasPartition[] getPartitions() {
        return this.partitions;
    }

    public EasPartition[] getSelectedPartitions() {
        Object[] objectArray = this.getSelectedValues();
        EasPartition[] easPartitionArray = null;
        if (objectArray != null) {
            int n = objectArray.length;
            easPartitionArray = new EasPartition[n];
            for (int i = 0; i < n; ++i) {
                easPartitionArray[i] = (EasPartition)objectArray[i];
            }
        }
        return easPartitionArray;
    }

    public EasPartition getSelectedPartition() {
        return (EasPartition)this.getSelectedValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePartition(String string) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (string == null) {
                return;
            }
            EasPartition easPartition = EasPartitionClient.storePartition(this.getSession(), string);
            if (this.partitions == null) {
                this.partitions = new EasPartition[1];
                this.partitions[0] = easPartition;
            } else {
                boolean bl = false;
                for (int i = 0; i < this.partitions.length; ++i) {
                    if (this.partitions[i].getId() != easPartition.getId()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    EasPartition[] easPartitionArray = new EasPartition[this.partitions.length + 1];
                    for (int i = 0; i < this.partitions.length; ++i) {
                        easPartitionArray[i] = this.partitions[i];
                    }
                    easPartitionArray[this.partitions.length] = easPartition;
                    this.partitions = easPartitionArray;
                }
            }
            this.refreshData(this.partitions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renamePartition(EasPartition easPartition, String string) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (easPartition == null || string == null) {
                return;
            }
            if (this.partitions != null) {
                int n = easPartition.getId();
                for (int i = 0; i < this.partitions.length; ++i) {
                    EasPartition easPartition2;
                    if (this.partitions[i].getId() != n) continue;
                    this.partitions[i] = easPartition2 = EasPartitionClient.renamePartition(this.getSession(), n, string);
                    this.refreshData(this.partitions);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePartition(EasPartition easPartition) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (easPartition == null) {
                return;
            }
            EasPartitionClient.deletePartition(this.getSession(), easPartition);
            if (this.partitions == null || this.partitions.length <= 0) {
                return;
            }
            int n = -1;
            for (int i = 0; i < this.partitions.length; ++i) {
                if (this.partitions[i].getId() != easPartition.getId()) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                EasPartition[] easPartitionArray = new EasPartition[this.partitions.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.partitions.length; ++i) {
                    if (i == n) continue;
                    easPartitionArray[n2] = this.partitions[i];
                    ++n2;
                }
                this.partitions = easPartitionArray;
            }
            this.refreshData(this.partitions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        int n2 = 175;
        if (dimension.width > n2) {
            n2 = dimension.width;
        }
        if (dimension.height > (n = 550)) {
            n = dimension.height;
        }
        return new Dimension(n2, n);
    }

    public void setSelected(int n, boolean bl) {
        if (bl) {
            this.addSelectionInterval(n, n);
        } else {
            this.removeSelectionInterval(n, n);
        }
    }

    public void setSelectedValues(Object[] objectArray) {
        this.clearSelection();
        ListModel listModel = this.getModel();
        int n = listModel.getSize();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                for (int j = 0; j < n; ++j) {
                    Object e = listModel.getElementAt(j);
                    if (!object.equals(e)) continue;
                    this.setSelected(j, true);
                }
            }
        }
    }

    public void selectAll() {
        this.setSelectedValues(this.partitions);
    }
}

