/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.inputlist.InputListItem;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.ClassSelectionModel;
import com.tridium.eas.ui.widgets.DbObjectValidator;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTreeDialog;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.UnitComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputUnitDialog
extends JDialog
implements ActionListener,
DocumentListener,
DbObjectValidator {
    private EasApplication easApplication = null;
    private InputListItem[] items;
    private Component comp;
    private UnitComboBox unitChoice;
    private DataPoint normalizer = null;
    private JCheckBox normalizeCheckBox;
    private JLabel normalizerLabel;
    private JButton pickNormalizerButton;
    private JButton okButton;
    private JButton cancelButton;
    private Lexicon lex;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$StaticGroup;
    static /* synthetic */ Class class$com$tridium$eas$api$DynGroup;
    static /* synthetic */ Class class$com$tridium$eas$api$Site;
    static /* synthetic */ Class class$com$tridium$eas$api$Meter;

    public InputUnitDialog(InputListItem[] inputListItemArray, Lexicon lexicon, Component component, boolean bl, boolean bl2) {
        super((Frame)null, lexicon.getText("multipleInputs"), true);
        this.lex = lexicon;
        this.items = inputListItemArray;
        this.comp = component;
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (InputUnitDialog.this.unitChoice != null) {
                    InputUnitDialog.this.unitChoice.requestFocus();
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                InputUnitDialog.this.doCancel();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                if (InputUnitDialog.this.isModal()) {
                    InputUnitDialog.this.toFront();
                }
            }
        });
        int n = -1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagManager gridBagManager = new GridBagManager(jComponent);
        BUnit bUnit = null;
        if (bl) {
            gridBagManager.anchor(13);
            gridBagManager.add(0, 0, 1, 1, 0, ++n, new JLabel(lexicon.getText("unit")));
            bUnit = inputListItemArray[0].getInput().getUnit();
            this.unitChoice = new UnitComboBox(UnitDatabase.getDefault().getQuantity(bUnit), lexicon);
            gridBagManager.anchor(17);
            gridBagManager.add(0, 100, 1, 1, 1, n, this.unitChoice);
        }
        gridBagManager.anchor(10);
        if (bl2) {
            ++n;
            this.normalizer = null;
            for (int i = 0; i < inputListItemArray.length; ++i) {
                if (!inputListItemArray[i].getInput().hasNormalizingPoint()) continue;
                this.normalizer = inputListItemArray[i].getInput().getNormalizingPoint();
                break;
            }
            this.normalizeCheckBox = new JCheckBox(lexicon.getText("normalizeBy"));
            this.normalizeCheckBox.setSelected(this.normalizer != null);
            this.normalizeCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InputUnitDialog.this.normalizerLabel.setEnabled(InputUnitDialog.this.normalizeCheckBox.isSelected());
                    InputUnitDialog.this.pickNormalizerButton.setEnabled(InputUnitDialog.this.normalizeCheckBox.isSelected());
                }
            });
            gridBagManager.add(0, 100, 1, 1, 0, n, this.normalizeCheckBox);
            this.normalizerLabel = new JLabel(InputUnitDialog.getNormalizerText(this.normalizer, lexicon), 2);
            this.normalizerLabel.setEnabled(this.normalizer != null);
            gridBagManager.fill(2);
            gridBagManager.add(100, 100, 1, 1, 1, n, this.normalizerLabel);
            gridBagManager.fill(0);
            this.pickNormalizerButton = new JButton(lexicon.getText("select"));
            this.pickNormalizerButton.setEnabled(this.normalizer != null);
            this.pickNormalizerButton.addActionListener(this);
            gridBagManager.add(0, 100, 1, 1, 2, n, this.pickNormalizerButton);
        }
        ++n;
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.addActionListener(this);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        gridBagManager.add(100, 100, 3, 1, 0, n, jPanel);
        this.pack();
        this.getRootPane().setDefaultButton(this.okButton);
        if (bUnit != null && this.unitChoice != null) {
            this.unitChoice.setSelectedUnit(bUnit);
        }
    }

    public void open() {
        int n = 0;
        int n2 = 0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        Dimension dimension2 = this.getPreferredSize();
        this.setSize(dimension2.width, dimension2.height);
        this.setLocation(n2 + (n3 - dimension2.width) / 2, n + (n4 - dimension2.height) / 2);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCancelled() {
        return this.items == null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.doOk();
        } else if (object == this.cancelButton) {
            this.doCancel();
        } else if (object == this.pickNormalizerButton) {
            this.doSelectNormalizer();
        }
    }

    public void doOk() {
        int n;
        if (this.unitChoice != null) {
            for (n = 0; n < this.items.length; ++n) {
                this.items[n].getInput().setUnit(this.unitChoice.getSelectedUnit());
            }
        }
        for (n = 0; n < this.items.length; ++n) {
            if (this.normalizeCheckBox != null && this.normalizeCheckBox.isSelected()) {
                this.items[n].getInput().setNormalizingPoint(this.normalizer);
                continue;
            }
            this.items[n].getInput().setNormalizingPoint(null);
        }
        this.close();
    }

    public void doCancel() {
        this.items = null;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doSelectNormalizer() {
        try {
            this.getParentApplication().setInputEnabled(true);
            this.setModal(false);
            this.normalizer = (DataPoint)FilterTreeDialog.getSelection(this.getParentApplication(), this.normalizer, this.lex.getText("select"), this.lex.getText("selectNormalizer"), new FilterRootNode((Filter)new AllSitesFilter(this.getParentApplication().getSession(), this.lex), this), new ClassSelectionModel(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = InputUnitDialog.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint), this.getParentApplication(), this.lex);
            Object var2_1 = null;
            this.getParentApplication().restrictInputToComponent(this);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getParentApplication().restrictInputToComponent(this);
            this.setModal(true);
            throw throwable;
        }
        this.setModal(true);
        this.normalizerLabel.setText(InputUnitDialog.getNormalizerText(this.normalizer, this.lex));
        ((JComponent)this.getContentPane()).revalidate();
        this.repaint();
    }

    private static String getNormalizerText(DataPoint dataPoint, Lexicon lexicon) {
        if (dataPoint == null) {
            return lexicon.getText("noPointSelected");
        }
        String string = dataPoint.getName();
        try {
            string = dataPoint.getDescr();
            if (dataPoint.getMeter() != null) {
                string = dataPoint.getMeter().getName() + " " + string;
            }
            string = string + " (" + dataPoint.getSite().getName() + ")";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private EasApplication getParentApplication() {
        if (this.easApplication != null) {
            return this.easApplication;
        }
        while (true) {
            if (this.comp instanceof EasApplication) {
                this.easApplication = (EasApplication)this.comp;
                return this.easApplication;
            }
            this.comp = this.comp.getParent();
        }
    }

    public boolean allowLoadUserObject(Class clazz) {
        return (class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = InputUnitDialog.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$StaticGroup == null ? (class$com$tridium$eas$api$StaticGroup = InputUnitDialog.class$("com.tridium.eas.api.StaticGroup")) : class$com$tridium$eas$api$StaticGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$DynGroup == null ? (class$com$tridium$eas$api$DynGroup = InputUnitDialog.class$("com.tridium.eas.api.DynGroup")) : class$com$tridium$eas$api$DynGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = InputUnitDialog.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = InputUnitDialog.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz);
    }

    public boolean allowShowUserObject(Object object) {
        if (!(object instanceof DataPoint)) {
            return true;
        }
        try {
            DataPoint dataPoint = (DataPoint)object;
            return !this.getParentApplication().getSession().getDataPointExec().isMultistate(dataPoint.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        this.okButton.setEnabled(this.unitChoice == null || this.unitChoice.getSelectedUnit() != null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

