/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.inputlist.InputListItem;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import java.awt.Container;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class InputListItemPopup
extends EasPopupMenu {
    private static final int REMOVE = 0;
    private static final int PASTE = 1;
    private static final int DISAGGREGATE = 2;
    private static final int REAGGREGATE = 3;
    private static final int CONFIGURE = 4;
    private static final int PASTE_NORMALIZER = 5;
    private static final int REMOVE_NORMALIZER = 6;
    private EasApplication easApplication = null;
    private InputList il;
    private InputListItem item;
    private ReportInputItem subItem;
    private EasPopupMenu.EasPopupMenuItem pasteItem;
    private EasPopupMenu.EasPopupMenuItem pasteNormalizer;
    private EasPopupMenu.EasPopupMenuItem removeNormalizer;
    private EasPopupMenu.EasPopupMenuItem disaggItem;
    private EasPopupMenu.EasPopupMenuItem reaggItem;

    public InputListItemPopup(InputList inputList) {
        this.il = inputList;
        Lexicon lexicon = BEasApplet.lex;
        this.add(new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Remove"), 0, null));
        this.pasteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Paste"), 1, null);
        this.add(this.pasteItem);
        this.addSeparator();
        this.pasteNormalizer = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("pasteAsNormalizer"), 5, null);
        this.add(this.pasteNormalizer);
        this.removeNormalizer = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("removeNormalizer"), 6, null);
        this.add(this.removeNormalizer);
        EasReport easReport = inputList.getReport();
        if (easReport.allowAggregation() && easReport.allowDisaggregation()) {
            this.addSeparator();
            this.disaggItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Disaggregate"), 2, null);
            this.add(this.disaggItem);
            this.reaggItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Reaggregate"), 3, null);
            this.add(this.reaggItem);
        }
        this.addSeparator();
        this.add(new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Configure"), 4, null));
    }

    public void arm(Object[] objectArray) {
        EasReport easReport = this.il.getReport();
        ReportInput reportInput = (ReportInput)objectArray[0];
        this.item = this.il.getItemForInput(reportInput);
        this.subItem = objectArray.length > 1 ? (ReportInputItem)objectArray[1] : null;
        Object object = easReport.getClipboard();
        this.pasteItem.setEnabled(easReport.allowAggregation() && objectArray.length == 1 && object instanceof InputItemSet);
        this.pasteNormalizer.setEnabled(objectArray.length == 1 && object instanceof InputItemSet && this.supportsDataPointNormalization((InputItemSet)object, reportInput));
        this.removeNormalizer.setEnabled(reportInput.hasNormalizingPoint());
        if (this.disaggItem != null) {
            this.disaggItem.setEnabled(!reportInput.isDisaggregated() && reportInput.getInputItemCount() > 1);
            this.reaggItem.setEnabled(reportInput.isDisaggregated());
        }
    }

    private EasApplication getParentApplication() {
        if (this.easApplication != null) {
            return this.easApplication;
        }
        Container container = this.il;
        while (true) {
            if (container instanceof EasApplication) {
                this.easApplication = (EasApplication)container;
                return this.easApplication;
            }
            container = container.getParent();
        }
    }

    private boolean supportsDataPointNormalization(InputItemSet inputItemSet, ReportInput reportInput) {
        ReportInputItem[] reportInputItemArray;
        if (inputItemSet == null || inputItemSet.getInputItemCount() != 1) {
            return false;
        }
        ReportInputItem reportInputItem = inputItemSet.getInputItems()[0];
        if (reportInputItem.getType() == 1) {
            reportInputItemArray = ((SiteDataPoint)reportInputItem).getDataPoint();
            if (reportInputItemArray == null || this.getParentApplication().getSession().getDataPointExec().isMultistate(reportInputItemArray.getName())) {
                return false;
            }
        } else {
            return false;
        }
        reportInputItemArray = reportInput.getInputItems();
        if (reportInputItemArray != null) {
            for (int i = 0; i < reportInputItemArray.length; ++i) {
                if (reportInputItemArray[i].getType() == 1) {
                    DataPoint dataPoint = ((SiteDataPoint)reportInputItemArray[i]).getDataPoint();
                    if (dataPoint == null || this.getParentApplication().getSession().getDataPointExec().isMultistate(dataPoint.getName())) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public void processCommand(int n, Object object) {
        switch (n) {
            case 0: {
                this.remove();
                break;
            }
            case 1: {
                this.paste();
                break;
            }
            case 5: {
                this.pasteNormalizer();
                break;
            }
            case 6: {
                this.removeNormalizer();
                break;
            }
            case 2: {
                this.disaggregate();
                break;
            }
            case 3: {
                this.reaggregate();
                break;
            }
            case 4: {
                this.configure();
            }
        }
    }

    public void itemSelected(JMenuItem jMenuItem) {
        if (jMenuItem instanceof EasPopupMenu.EasPopupMenuItem) {
            return;
        }
        this.il.getReport().popupItemSelected(jMenuItem, this.item);
    }

    private void remove() {
        if (this.subItem == null) {
            this.il.getModel().removeInput(this.item.getInput());
        } else {
            this.item.removeInputItem(this.subItem);
            if (this.item.isEmpty()) {
                this.il.getModel().removeInput(this.item.getInput());
            }
        }
        this.il.revalidate();
        this.il.getSelectionModel().clearSelection();
    }

    private void paste() {
        InputItemSet inputItemSet = (InputItemSet)this.il.getReport().getClipboard();
        if (this.il.getModel().addItemsToInput(this.item.getInput(), inputItemSet)) {
            this.il.revalidate();
        } else {
            Lexicon lexicon = BEasApplet.lex;
            BUnit bUnit = this.item.getInput().getUnit();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("'");
            stringBuffer.append(inputItemSet.getName());
            stringBuffer.append("' " + lexicon.getText("notAddedToReport1") + " ");
            if (bUnit != null) {
                stringBuffer.append(lexicon.getText("notAddedToReport2") + " ");
                String string = null;
                string = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                stringBuffer.append(string + ".");
            } else {
                stringBuffer.append(lexicon.getText("unitNotCompatible"));
            }
            JOptionPane.showMessageDialog(this, stringBuffer, lexicon.getText("notAdded"), 0);
        }
    }

    private void pasteNormalizer() {
        InputItemSet inputItemSet = (InputItemSet)this.il.getReport().getClipboard();
        if (inputItemSet == null || inputItemSet.getInputItemCount() != 1) {
            return;
        }
        ReportInputItem reportInputItem = inputItemSet.getInputItems()[0];
        if (reportInputItem.getType() == 1) {
            DataPoint dataPoint = ((SiteDataPoint)reportInputItem).getDataPoint();
            this.item.getInput().setNormalizingPoint(dataPoint);
            this.il.repaint();
        }
    }

    private void removeNormalizer() {
        this.item.getInput().setNormalizingPoint(null);
        this.il.repaint();
    }

    private void disaggregate() {
        this.il.disaggregate(this.item.getInput());
    }

    private void reaggregate() {
        this.il.reaggregate(this.item.getInput());
    }

    private void configure() {
        this.il.configureItem(this.item);
    }
}

